/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.tip.pc.services.hw.task.tasktype.IAction;
import oracle.tip.pc.services.hw.task.tasktype.IMessages;
import oracle.tip.pc.services.hw.task.tasktype.INotifications;
import oracle.tip.pc.services.hw.task.tasktype.ITaskType;
import oracle.tip.pc.services.hw.task.tasktype.ITaskTypeNode;
import oracle.tip.pc.services.hw.task.tasktype.impl.TaskTypeFactory;
import oracle.tip.pc.services.notification.payload.GenericPayloadType;
import oracle.tip.pc.services.notification.payload.IGenericPayloadType;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.Util;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.NotificationTableModel;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.Table;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.TableModel;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.TaskTypeWizardPage;

public class NotificationPage
extends TaskTypeWizardPage {
    Table mTable = new Table();
    TableModel mTablemodel = null;
    private String[] mColumnNames = null;

    public NotificationPage(TaskFlowWizardContext context, ImageWizardPage iwp) {
        this.setContextAndPage(context, iwp);
        this.mColumnNames = new String[3];
        this.mColumnNames[0] = UIConstant.TASK_TYPE_NOTIFICATION_COLUMN1;
        this.mColumnNames[1] = UIConstant.TASK_TYPE_NOTIFICATION_COLUMN2;
        this.mColumnNames[2] = UIConstant.TASK_TYPE_NOTIFICATION_COLUMN3;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Util.setBorder("", this);
        this.setLayout(new GridBagLayout());
        this.mTablemodel = new NotificationTableModel(this.mColumnNames, 0, this.m_wcontext._ttwcontext, this, this.mTable);
        this.mTable.setModel(this.mTablemodel);
        this.m_wcontext._ttwcontext.setTableModel(this.mTablemodel);
        this.addRow();
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        scrollPane.setAutoscrolls(true);
        MultiLineLabel explanation = new MultiLineLabel(WordWrapper.getTextWrapper(), UIConstant.TASK_TYPE_NOTIFICATION_EXPLANATION);
        this.add((Component)explanation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        JSeparator seperator = new JSeparator();
        seperator.setOpaque(true);
        this.add((Component)seperator, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mTablemodel.addButtonToPanel(this, 2);
        this.add((Component)scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void savePageData() {
        int noOfRows = this.mTablemodel.getRowCount();
        ArrayList<IAction> attrList = null;
        ITaskType taskType = null;
        INotifications parentNode = null;
        HashMap<String, IAction> actionMap = new HashMap<String, IAction>();
        HashMap<String, IMessages> payloadRMap = new HashMap<String, IMessages>();
        boolean nameSpaceAdded = false;
        for (int i = 0; i < noOfRows; ++i) {
            IMessages messages;
            IAction attribute;
            String name = (String)this.mTablemodel.getTableCellValue(i, 0);
            String recipient = (String)this.mTablemodel.getTableCellValue(i, 1);
            String notification = (String)this.mTablemodel.getTableCellValue(i, 2);
            if (name == null || name.trim().equals("") || notification == null || notification.trim().equals("")) continue;
            name = name.trim();
            String keyName = Util.getNotificationActionKey(name);
            notification = notification.trim();
            if (attrList == null && taskType == null && parentNode == null) {
                taskType = this.m_wcontext._ttwcontext.getTaskType();
                parentNode = (INotifications)TaskTypeFactory.getNode((ITaskType)taskType, (ITaskTypeNode)taskType, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"notifications");
                parentNode.setNamespace(null);
                attrList = new ArrayList<IAction>();
            }
            String key = "";
            if (recipient != null && recipient.trim().length() > 0) {
                key = "R";
            }
            if ((attribute = (IAction)actionMap.get(key = key + notification)) == null && (attribute = (IAction)actionMap.get(keyName)) != null) {
                actionMap.put(key, attribute);
            }
            if (attribute == null) {
                attribute = (IAction)TaskTypeFactory.getNode((ITaskType)taskType, (ITaskTypeNode)parentNode, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"action");
                actionMap.put(key, attribute);
                actionMap.put(keyName, attribute);
                attrList.add(attribute);
            }
            if (!attribute.getNames().contains(keyName)) {
                attribute.addName(keyName);
            }
            if ((messages = (IMessages)payloadRMap.get(key)) == null) {
                messages = (IMessages)TaskTypeFactory.getNode((ITaskType)taskType, (ITaskTypeNode)attribute, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"messages");
                payloadRMap.put(key, messages);
                GenericPayloadType element = this.m_wcontext._ttwcontext.getGenericPayload(notification);
                messages.setGenericPayload((IGenericPayloadType)element);
                if (!nameSpaceAdded) {
                    nameSpaceAdded = true;
                    taskType.addNamespaceMapping("ns", element.getRootElement().getNamespaceURI());
                }
                attribute.addMessages(messages);
            }
            if (recipient == null || recipient.trim().length() <= 0) continue;
            String keyRecipient = Util.getRecipientKey(recipient.trim());
            messages.addRecipient(keyRecipient);
        }
        if (parentNode != null) {
            taskType.setNotifications(parentNode);
            if (attrList != null) {
                parentNode.setActions(attrList);
            }
        }
    }

    private void addRow() {
        Object[] obj = new Object[]{BPELStringTranslator.getString("ASSIGNED"), BPELStringTranslator.getString("ASSIGNEES"), ""};
        this.mTablemodel.addRow(obj);
    }
}

