/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.DefaultConclusion;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.Task;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.TaskFlowUITemplate;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.TaskFlowUITemplateParser;
import oracle.tip.pc.services.hw.task.tasktype.IConclusion;
import oracle.tip.pc.services.hw.task.tasktype.IConclusions;
import oracle.tip.pc.services.hw.task.tasktype.ITaskType;
import oracle.tip.pc.services.hw.task.tasktype.ITaskTypeNode;
import oracle.tip.pc.services.hw.task.tasktype.impl.TaskTypeFactory;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.Util;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ConclusionTableModel;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.Table;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.TableModel;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.TaskTypeWizardPage;

public class ConclusionPage
extends TaskTypeWizardPage
implements ActionListener {
    Table mTable = new Table();
    TableModel mTablemodel = null;
    String[] mColumnNames = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private boolean mDefaultConAdded = false;

    public ConclusionPage(TaskFlowWizardContext context, ImageWizardPage iwp) {
        this.setContextAndPage(context, iwp);
        this.mColumnNames = new String[2];
        this.mColumnNames[0] = UIConstant.TASK_TYPE_DEFAULT_ATTRIBUTE_COLUMN1;
        this.mColumnNames[1] = this.m_wcontext._ttwcontext.isResourceSelected() ? UIConstant.TASK_TYPE_DISPLAY_VALUE_ID : UIConstant.TASK_TYPE_DISPLAY_VALUE;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        Util.setBorder("", this);
        this.mTablemodel = new ConclusionTableModel(this.mColumnNames, 0, this.m_wcontext._ttwcontext, this, this.mTable);
        this.mTable.setModel(this.mTablemodel);
        this.mTable.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane(this.mTable);
        scrollPane.setAutoscrolls(true);
        MultiLineLabel explanation = new MultiLineLabel(WordWrapper.getTextWrapper(), UIConstant.TASK_TYPE_CONCLUSION_EXPLANATION);
        this.add((Component)explanation, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        JSeparator seperator = new JSeparator();
        seperator.setOpaque(true);
        this.add((Component)seperator, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mTablemodel.addButtonToPanel(this, 2);
        this.add((Component)scrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void savePageData() {
        int noOfRows = this.mTablemodel.getRowCount();
        ITaskType taskType = null;
        IConclusions parentNode = null;
        for (int i = 0; i < noOfRows; ++i) {
            String name = (String)this.mTablemodel.getTableCellValue(i, 0);
            String value = (String)this.mTablemodel.getTableCellValue(i, 1);
            if (name == null || name.trim().equals("")) continue;
            name = name.trim();
            if (taskType == null && parentNode == null) {
                taskType = this.m_wcontext._ttwcontext.getTaskType();
                parentNode = (IConclusions)TaskTypeFactory.getNode((ITaskType)taskType, (ITaskTypeNode)taskType.getTask(), (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"conclusions");
            }
            IConclusion attribute = (IConclusion)TaskTypeFactory.getNode(taskType, parentNode, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"conclusion");
            attribute.setName(name);
            if (value != null && !value.trim().equals("")) {
                attribute.setDisplayValue(Util.getDisplayValue(this.m_wcontext._ttwcontext, value.trim()));
            }
            parentNode.addConclusion(attribute);
        }
        if (parentNode != null) {
            taskType.getTask().setConclusions(parentNode);
        }
    }

    @Override
    public void wizardValidatePage(WizardEvent param1) {
        this.savePageData();
        this.removeGeneratedPages();
        this.addGeneratedPages(this);
    }

    public void updateColumnNames() {
        TableColumnModel model;
        if (this.m_wcontext._ttwcontext.isResourceSelected() && (model = this.mTable.getColumnModel()) != null) {
            TableColumn column = model.getColumn(1);
            column.setIdentifier(UIConstant.TASK_TYPE_DISPLAY_VALUE_ID);
            this.mTablemodel.fireTableStructureChanged();
        }
    }

    private void addRow(String firstCol, String secondCol) {
        Object[] obj = new Object[]{firstCol, secondCol};
        this.mTablemodel.addRow(obj);
    }

    public void addDefaultConclusions() {
        if (!this.mDefaultConAdded) {
            String uiTemplate = (String)this.m_wcontext._map.get(TaskFlowWizardContext.TASK_FLOW_UI_TEMPLATE_KEY);
            try {
                List list;
                TaskFlowUITemplateParser handler = new TaskFlowUITemplateParser();
                TaskFlowUITemplate tfuiTemplate = handler.parse(uiTemplate);
                Task task = tfuiTemplate.getTask();
                if (task != null && (list = task.getDefaultConclusion()) != null) {
                    int size = list.size();
                    for (int i = 0; i < size; ++i) {
                        DefaultConclusion con = (DefaultConclusion)list.get(i);
                        if (con == null) continue;
                        String name = con.getName();
                        String displayValue = con.getDisplayValue();
                        if (displayValue == null) {
                            displayValue = name;
                        }
                        this.mDefaultConAdded = true;
                        this.addRow(name, displayValue);
                        if (i + 1 != size) continue;
                        this.addRow("", "");
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (!this.mDefaultConAdded) {
                this.addRow();
            }
            this.mDefaultConAdded = true;
        }
    }

    private void addRow() {
        this.addRow(BPELStringTranslator.getString("ACCEPT"), BPELStringTranslator.getString("Accept"));
        this.addRow(BPELStringTranslator.getString("REJECT"), BPELStringTranslator.getString("Reject"));
        this.addRow("", "");
    }
}

