/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.Util;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ButtonTextEditor;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ButtonTextRenderer;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ComboBoxEditor;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ComboBoxRenderer;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.EditorRendererMap;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.Table;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.TableRowEditor;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.TableRowRenderer;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.TaskTypeWizardContext;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class TableModel
extends DefaultTableModel
implements ActionListener,
TableModelListener,
ItemListener,
KeyListener,
DocumentListener,
ListSelectionListener {
    public static final int NOTIFICATION_PAGE = 0;
    public static final int CONCLUSION_PAGE = 1;
    public static final int FLEXFIELD_PAGE = 2;
    public static final int DEFAULT_ATTRIBUTE_PAGE = 3;
    TableRowEditor mRowEditor = null;
    TableRowRenderer mRowRenderer = null;
    Table mTable = null;
    TaskTypeWizardContext mWizardContext = null;
    JButton mBAdd = new JButton(BPELStringTranslator.getString("ADD_BUTTON_TEXT_RES_A"), ImageCache.getIcon("add16"));
    JButton mBRemove = new JButton(BPELStringTranslator.getString("DEL_BUTTON_TEXT_RES_D"), ImageCache.getIcon("delete16"));
    protected JToolBar m_toolBar;
    int noOfColumns = 0;
    int mPageType = -1;
    EditorRendererMap mEditorRendererMap = null;

    public TableModel(String[] column, int row, TaskTypeWizardContext context, Table table, int pageType) {
        super(column, row);
        ResourceUtils.resButton((AbstractButton)this.mBAdd, (String)BPELStringTranslator.getString("ADD_BUTTON_TEXT_RES_A"));
        ResourceUtils.resButton((AbstractButton)this.mBRemove, (String)BPELStringTranslator.getString("DEL_BUTTON_TEXT_RES_D"));
        this.mBRemove.setEnabled(false);
        this.mRowEditor = new TableRowEditor();
        this.mRowRenderer = new TableRowRenderer();
        table.setRowEditorModel(this.mRowEditor);
        table.setRowRendererModel(this.mRowRenderer);
        table.getSelectionModel().addListSelectionListener(this);
        this.mWizardContext = context;
        table.setRowHeight(30);
        this.mTable = table;
        this.noOfColumns = column.length;
        this.mPageType = pageType;
        this.addTableModelListener(this);
        this.mTable.addKeyListener(this);
        this.mEditorRendererMap = new EditorRendererMap(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.mBRemove.setEnabled(this.mTable.getSelectedRow() >= 0);
    }

    public void addButtonToPanel(JPanel panel, int row) {
        this.m_toolBar = new JToolBar();
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.add(this.mBAdd);
        this.m_toolBar.add(this.mBRemove);
        GraphUtils.addComponent((Container)panel, (Component)this.m_toolBar, (int)0, (int)row, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mBAdd.setEnabled(false);
        this.mBAdd.addActionListener(this);
        this.mBRemove.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.mBAdd)) {
            this.addRow();
        } else if (e.getSource().equals(this.mBRemove)) {
            int rowCount;
            int row = this.mTable.getSelectedRow();
            if (row < 0) {
                row = 0;
            }
            if ((rowCount = this.mTable.getSelectedRowCount()) != 1) {
                MultiLineOptionPane.showMessageDialog((Component)this.mWizardContext.getWizard(), (Object)UIConstant.TABLE_ROW_WRONG_SELECTION, (String)UIConstant.TABLE_ROW_ERROR_DIALOG, (int)2);
            } else if (row >= 0) {
                Object value = this.getValueAt(row, 0);
                int inputType = 0;
                if (value != null && !value.toString().trim().equals("") && (inputType = JOptionPane.showConfirmDialog((Component)this.mWizardContext.getWizard(), UIConstant.TABLE_ROW_CONFIRMATION_MESSAGE, UIConstant.TABLE_ROW_CONFIRMATION_DIALOG, 0, 2)) == 0) {
                    this.addValueToRowComboBox(value);
                }
                if (inputType == 0) {
                    this.removeRow(row);
                    if (this.mPageType == 3 && rowCount > 0) {
                        this.fireTableCellUpdated(rowCount - 1, rowCount - 1);
                    }
                }
            }
            if (this.getCanAddRow()) {
                this.mBAdd.setEnabled(true);
            }
        }
    }

    private void addValueToRowComboBox(Object value) {
        List conclusions;
        if (this.mPageType == 3 || this.mPageType == 0 || this.mPageType == 2) {
            this.addValueToRow(value);
        } else if (this.mPageType == 1 && (conclusions = Util.getConclusions()).contains(value)) {
            this.addValueToRow(value);
        }
    }

    private void addValueToRow(Object value) {
        int rows = this.mTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            TableCellEditor editor = this.mTable.getCellEditor(i, 0);
            if (editor instanceof ComboBoxEditor) {
                ComboBoxEditor editorC = (ComboBoxEditor)editor;
                ComboBoxRenderer renderer = (ComboBoxRenderer)editorC.getTableCellRenderer();
                renderer.removeItemListener(this);
                editorC.addItem(value);
                renderer.addItemListener(this);
            }
            this.fireTableRowsUpdated(rows, rows);
        }
    }

    private void addRow() {
        Object[] object = null;
        object = this.mPageType == 0 ? new String[]{"", "", ""} : new String[]{"", ""};
        this.addRow(object);
        this.mBAdd.setEnabled(false);
    }

    private void resetRow(int row) {
        if (this.mPageType == 1) {
            this.resetPreviousRow(row, 0);
        } else if (this.mPageType == 2) {
            this.resetNotificationFlexFieldRow(row, 0);
        } else if (this.mPageType == 0) {
            this.resetNotificationFlexFieldRow(row, 0);
            this.resetNotificationFlexFieldRow(row, 1);
            this.resetNotificationFlexFieldRow(row, 2);
        }
    }

    @Override
    public void addRow(Object[] obj) {
        super.addRow(obj);
        int rowCount = this.getRowCount();
        if (rowCount > 1) {
            this.resetRow(rowCount - 2);
        }
        this.modifyNewRow(rowCount - 1);
    }

    private void modifyNewRow(int row) {
        ArrayList editors = new ArrayList();
        ArrayList renderers = new ArrayList();
        if (this.mPageType == 0) {
            this.addNotificationEditorRenderer(editors, renderers);
        } else if (this.mPageType == 2) {
            this.addFlexFieldEditorRenderer(editors, renderers);
        } else if (this.mPageType == 1) {
            this.addConclusionEditorRenderer(editors, renderers);
        } else {
            this.addDefaultAttributeEditorRenderer(editors, renderers);
        }
        this.mRowEditor.addEditorForRow(row, editors);
        this.mRowRenderer.addRendererForRow(row, renderers);
    }

    private void resetNotificationFlexFieldRow(int row, int col) {
        Object value = this.getTableCellValue(row, col);
        this.mRowEditor.setEditor(row, col, null);
        this.mRowRenderer.setRenderer(row, col, null);
        this.setValueAt(value, row, col);
    }

    private void resetPreviousRow(int row, int col) {
        DefaultCellEditor cellEditor = null;
        DefaultTableCellRenderer cellRenderer = null;
        Object value = this.getTableCellValue(row, col);
        if (value != null) {
            JTextField field = new JTextField((String)value);
            cellEditor = new DefaultCellEditor(field);
            cellRenderer = new DefaultTableCellRenderer();
            cellRenderer.setText((String)value);
        }
        this.mRowEditor.setEditor(row, col, cellEditor);
        this.mRowRenderer.setRenderer(row, col, null);
    }

    private void addNotificationEditorRenderer(List editors, List renderers) {
        ComboBoxRenderer actionRenderer = new ComboBoxRenderer(this.getNotificationActionList());
        ComboBoxEditor actionEditor = new ComboBoxEditor(actionRenderer, this);
        editors.add(actionEditor);
        renderers.add(actionRenderer);
        actionRenderer.addItemListener(this);
        ComboBoxRenderer recipentRenderer = new ComboBoxRenderer(Util.getRecipientList());
        DefaultCellEditor recipentEditor = new DefaultCellEditor(recipentRenderer);
        editors.add(recipentEditor);
        renderers.add(recipentRenderer);
        recipentRenderer.addItemListener(this);
        ButtonTextEditor notEditor = new ButtonTextEditor(this, "Notification");
        ButtonTextRenderer notRenderer = (ButtonTextRenderer)notEditor.getTableCellRenderer();
        editors.add(notEditor);
        renderers.add(notRenderer);
    }

    private List getNotificationActionList() {
        ArrayList allActions = new ArrayList(Util.getNotificationActionList());
        return allActions;
    }

    private List getActualList(List all, int col) {
        int rowsCount = this.getRowCount();
        for (int i = 0; i < rowsCount; ++i) {
            Object obj = this.getValueAt(i, col);
            if (obj == null || obj.toString().trim().equals("")) continue;
            all.remove(obj);
        }
        if (all.size() > 0) {
            all.add(0, "");
        }
        return all;
    }

    private boolean getCanAddNotificationRow(int rows) {
        for (int i = 0; i < rows; ++i) {
            Object value = this.getTableCellValue(i, 0);
            if (value == null || value.toString().trim().equals("")) {
                return false;
            }
            value = this.getTableCellValue(i, 2);
            if (value != null && !value.toString().trim().equals("")) continue;
            return false;
        }
        return true;
    }

    public Object getTableCellValue(int row, int col) {
        Object value = null;
        TableCellEditor obj = this.mTable.getCellEditor(row, col);
        if (obj != null) {
            value = obj.getCellEditorValue();
        }
        if (value == null || ((String)value).equals("")) {
            value = this.getValueAt(row, col);
        }
        return value;
    }

    public boolean getCanAddRow() {
        int rows = this.getRowCount();
        if (this.mPageType != 0) {
            for (int i = 0; i < rows; ++i) {
                Object value = this.getTableCellValue(i, 0);
                if (value == null || value.toString().trim().equals("")) {
                    return false;
                }
                if (this.mPageType != 3 || (value = this.getTableCellValue(i, 1)) != null && !value.toString().trim().equals("")) continue;
                return false;
            }
        } else {
            return this.getCanAddNotificationRow(rows);
        }
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int rows = this.getRowCount();
        if (rows == 0) {
            this.mBAdd.setEnabled(true);
        }
        this.mBRemove.setEnabled(this.mTable.getSelectedRow() >= 0);
        if (this.mPageType == 1) {
            this.mWizardContext.getWizard().getSelectedPage().setCanAdvance(this.getCanAdvance());
        }
    }

    @Override
    public void removeRow(int row) {
        this.mRowEditor.removeEditorForRow(row);
        this.mRowRenderer.removeRendererForRow(row);
        super.removeRow(row);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.mBRemove.setEnabled(this.mTable.getSelectedRow() >= 0);
        if (this.mPageType == 3) {
            this.changeDefaultAttributRendererEditor();
        }
        if (this.mPageType == 0) {
            this.changeRecipientValues();
        }
        if (this.mPageType != 1) {
            this.mBAdd.setEnabled(this.getCanAddRow());
        }
        if (this.mPageType == 1) {
            this.setConclusionDisplayValue();
            this.mBAdd.setEnabled(this.getCanAddRow());
            this.mWizardContext.getWizard().getSelectedPage().setCanAdvance(this.getCanAdvance());
        }
    }

    private void setConclusionDisplayValue() {
        int row = this.mTable.getSelectedRow();
        if (row < 0 && this.mTable.getRowCount() > 0) {
            row = 0;
        }
        if (row >= 0) {
            try {
                String value = (String)this.getTableCellValue(row, 0);
                if (value != null) {
                    value = Util.getConclusionDisplayValue(value);
                    this.mTable.setValueAt(value, row, 1);
                    this.fireTableCellUpdated(row, 1);
                }
            }
            catch (Exception exc) {
                System.out.println(exc.getStackTrace());
            }
        }
    }

    private void changeRecipientValues() {
        int col = this.mTable.getSelectedColumn();
        if (col == 0) {
            int sRow = this.mTable.getSelectedRow();
            if (sRow < 0) {
                sRow = 0;
            }
            int rowCount = this.mTable.getRowCount();
            String sAction = (String)this.getTableCellValue(sRow, 0);
            ArrayList<String> rList = new ArrayList<String>();
            for (int i = 0; i < rowCount; ++i) {
                String action;
                if (i == sRow || (action = (String)this.getTableCellValue(i, 0)) == null || !action.equals(sAction)) continue;
                String recipient = (String)this.getTableCellValue(i, 1);
                rList.add(recipient);
            }
            ArrayList allR = new ArrayList(Util.getRecipientList());
            allR.removeAll(rList);
            TableCellRenderer renderer = this.mTable.getCellRenderer(sRow, 1);
            if (renderer instanceof ComboBoxRenderer) {
                ComboBoxRenderer comboRenderer = (ComboBoxRenderer)renderer;
                comboRenderer.removeItemListener(this);
                ((ComboBoxRenderer)renderer).addItems(allR);
                comboRenderer.addItemListener(this);
                this.fireTableCellUpdated(sRow, 2);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent anEvent) {
        if (anEvent.getKeyChar() == '\n' && this.getCanAddRow()) {
            this.addRow();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    private void enableConclusionPage(KeyEvent anEvent) {
        int columnIndex = this.mTable.getSelectedColumn();
        if (columnIndex == 0) {
            if (anEvent.getKeyChar() != '\t' && anEvent.getKeyChar() != '\n') {
                this.mBAdd.setEnabled(true);
            }
        } else if (!this.getCanAddRow()) {
            this.mBAdd.setEnabled(false);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        TableCellEditor editor;
        return !(col == 1 ? (editor = this.mRowEditor.getEditor(row, 0)) != null && editor.getCellEditorValue().toString().trim().equals("") : col == 0 && (editor = this.mRowEditor.getEditor(row, 0)) == null);
    }

    private List getConclusionList() {
        ArrayList flexString = new ArrayList(Util.getConclusions());
        return this.getActualList(flexString, 0);
    }

    private List getFlexFieldList() {
        ArrayList flexString = new ArrayList(Util.getFlexFieldAttributes());
        return this.getActualList(flexString, 0);
    }

    private void addFlexFieldEditorRenderer(List editors, List renderers) {
        ComboBoxRenderer box = new ComboBoxRenderer(this.getFlexFieldList());
        box.addItemListener(this);
        ComboBoxEditor editor = new ComboBoxEditor(box, this);
        editors.add(editor);
        JTextField field = new JTextField();
        DefaultCellEditor editor1 = new DefaultCellEditor(field);
        editors.add(editor1);
        renderers.add(box);
        renderers.add(null);
    }

    private void addConclusionEditorRenderer(List editors, List renderers) {
        ComboBoxRenderer box = new ComboBoxRenderer(this.getConclusionList());
        box.setEditable(true);
        box.addItemListener(this);
        box.setFocusable(true);
        ComboBoxEditor editor1 = new ComboBoxEditor(box, this);
        editors.add(editor1);
        JTextField field = new JTextField();
        DefaultCellEditor editor = new DefaultCellEditor(field);
        editors.add(editor);
        renderers.add(box);
        renderers.add(null);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.mBAdd.setEnabled(this.getCanAddRow());
        this.mWizardContext.getWizard().getSelectedPage().setCanAdvance(this.getCanAdvance());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.mBAdd.setEnabled(this.getCanAddRow());
        this.mWizardContext.getWizard().getSelectedPage().setCanAdvance(this.getCanAdvance());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.mBAdd.setEnabled(this.getCanAddRow());
        this.mWizardContext.getWizard().getSelectedPage().setCanAdvance(this.getCanAdvance());
    }

    private boolean getCanAdvance() {
        if (this.mPageType == 1) {
            int rows = this.getRowCount();
            for (int i = 0; i < rows; ++i) {
                if (this.isColumnEmpty(i, 0)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isColumnEmpty(int row, int col) {
        Object value = this.getTableCellValue(row, col);
        return value == null || value.toString().trim().equals("");
    }

    private void addDefaultAttributeEditorRenderer(List editors, List renderers) {
        TableCellEditor editor = this.mEditorRendererMap.getTableCellEditor("combobox");
        editors.add(editor);
        editors.add(null);
        TableCellRenderer renderer = this.mEditorRendererMap.getTableCellRenderer("combobox");
        renderers.add(renderer);
        renderers.add(null);
    }

    protected List getDefaultAttributeList() {
        ArrayList actualList = new ArrayList(Util.getTaskDefaultAttributes());
        return this.getActualList(actualList, 0);
    }

    private void changeDefaultAttributRendererEditor() {
        int row = this.mTable.getSelectedRow();
        if (row < 0) {
            row = 0;
        }
        ComboBoxEditor editor = null;
        TableCellEditor edit = this.mTable.getCellEditor(row, 0);
        if (edit instanceof ComboBoxEditor) {
            editor = (ComboBoxEditor)edit;
        }
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            if (value == null || value.toString().trim().equals("")) {
                this.mRowEditor.setEditor(row, 1, null);
                this.mRowRenderer.setRenderer(row, 1, null);
                this.setValueAt("", row, 1);
                return;
            }
            editor.setValueBeforeUpdate(value);
            TableCellEditor editor1 = this.mEditorRendererMap.getTableCellEditor(value.toString().trim());
            this.mRowEditor.setEditor(row, 1, editor1);
            TableCellRenderer renderer = this.mEditorRendererMap.getTableCellRenderer(value.toString().trim());
            this.mRowRenderer.setRenderer(row, 1, renderer);
            this.setValueAt(editor1.getCellEditorValue(), row, 1);
            this.fireTableRowsUpdated(row, row);
        }
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (this.dataVector.size() > row) {
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            rowVector.setElementAt(aValue, column);
            this.fireTableCellUpdated(row, column);
        }
    }

    public List getValues(int column) {
        ArrayList<String> values = new ArrayList<String>();
        int noOfRows = this.getRowCount();
        for (int i = 0; i < noOfRows; ++i) {
            String name = (String)this.getTableCellValue(i, column);
            values.add(name);
        }
        return values;
    }

    public Table getTable() {
        return this.mTable;
    }
}

