/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ComboBoxEditor;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.Table;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.TableModel;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.TaskTypeWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.NotificationPage;

public class NotificationTableModel
extends TableModel {
    private NotificationPage mPage = null;
    private JComboBox mNotificationBox = new JComboBox();
    private List mNotificationList = new ArrayList();
    private String mEmptyString = "      ";

    public NotificationTableModel(String[] column, int row, TaskTypeWizardContext context, NotificationPage page, Table table) {
        super(column, row, context, table, 0);
        this.mPage = page;
        this.mNotificationBox.addItemListener(this);
        this.mNotificationBox.addItem(this.mEmptyString);
    }

    public void addNotification(Object value) {
        this.mNotificationBox.addItem(value);
        this.mNotificationBox.setSelectedItem(value);
        this.mNotificationList.add(value);
        int row = this.getTable().getSelectedRow();
        int column = this.getTable().getSelectedColumn();
        this.fireTableCellUpdated(row, column);
    }

    public JComboBox getNotifications() {
        this.mNotificationBox.setSelectedItem(this.mEmptyString);
        return this.mNotificationBox;
    }

    public List getNotificationList() {
        return this.mNotificationList;
    }

    public void removeAll(JComboBox box) {
        int i;
        int count = box.getItemCount();
        ArrayList<String> items = new ArrayList<String>();
        for (i = 0; i < count; ++i) {
            String value = (String)box.getItemAt(i);
            if (value == null || value.trim().equals("")) continue;
            items.add(value);
        }
        for (i = 0; i < items.size(); ++i) {
            box.removeItem(items.get(i));
        }
    }

    public void addAll(JComboBox box, List list) {
        for (int i = 0; i < list.size(); ++i) {
            String value = (String)list.get(i);
            if (value.trim().equals("")) continue;
            box.addItem(value);
        }
    }

    public void removeNotificationValues(List pList) {
        ArrayList newList = new ArrayList(this.mNotificationList);
        newList.removeAll(pList);
        this.removeAll(this.mNotificationBox);
        this.addAll(this.mNotificationBox, newList);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        TableCellEditor editor;
        if (col == 1 || col == 2) {
            editor = this.mRowEditor.getEditor(row, 0);
            if (!(editor instanceof ComboBoxEditor)) {
                return false;
            }
            if (editor != null && editor.getCellEditorValue().toString().trim().equals("")) {
                return false;
            }
            editor = this.mRowEditor.getEditor(row, col);
            if (editor == null) {
                return false;
            }
        } else if (col == 0) {
            // empty if block
        }
        return (editor = this.mRowEditor.getEditor(row, 0)) instanceof ComboBoxEditor;
    }
}

