/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ButtonTextEditor;

public class DefaultAttributeUserDialog
implements ActionListener,
KeyListener {
    public static final String EXP_STR = "(E)";
    public static final String LITERAL_STR = "(L)";
    private static final String SEP = "(";
    ButtonTextEditor mEditor = null;
    protected JRadioButton mStringButton = null;
    protected JRadioButton mExpressionButton = null;
    protected JTextField mStringField = null;
    protected JTextField mExpressionField = null;
    private JButton mOKButton = null;
    private JButton mCancelButton = null;
    JDialog mDialog = null;

    public DefaultAttributeUserDialog(ButtonTextEditor editor) {
        this.mEditor = editor;
        this.init();
    }

    private void init() {
        this.mOKButton = new JButton(UIConstant.OK_BUTTON);
        this.mCancelButton = new JButton(UIConstant.CANCEL_BUTTON);
        this.mStringButton = new JRadioButton();
        this.mStringButton.setText(UIConstant.LITERAL_RADIO_BUTTON);
        this.mExpressionButton = new JRadioButton();
        this.mExpressionButton.setText(UIConstant.EXPRESSION_RADIO_BUTTON);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mStringButton);
        group.add(this.mExpressionButton);
        this.mStringField = new JTextField();
        this.mExpressionField = new JTextField();
        this.mDialog = new JDialog();
        UIUtil.enableCloseOnEscapeKey((JDialog)this.mDialog);
        this.mDialog.setSize(300, 150);
        Container dialogPanel = this.mDialog.getContentPane();
        dialogPanel.setLayout(new GridBagLayout());
        int row = 0;
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mStringField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, -60, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mStringButton, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mExpressionField, (int)1, (int)(++row), (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, -60, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mExpressionButton, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mOKButton, (int)0, (int)(++row), (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mCancelButton, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mDialog.setLocationRelativeTo((Component)this.mEditor.mModel.mWizardContext.getWizard());
        this.mDialog.setModal(true);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mStringField.addActionListener(this);
        this.mExpressionField.addActionListener(this);
        this.mStringField.addKeyListener(this);
        this.mExpressionField.addKeyListener(this);
        this.mStringButton.addActionListener(this);
        this.mExpressionButton.addActionListener(this);
        this.mStringButton.setSelected(true);
        this.mExpressionField.setEditable(false);
        this.setInitialValues();
    }

    public void showDialog() {
        this.mDialog.show();
    }

    private void setInitialValues() {
        try {
            String object = this.mEditor.getText().trim();
            if (!object.equals("") && object.indexOf(SEP) != -1) {
                boolean expression = false;
                StringTokenizer token = new StringTokenizer(object, SEP);
                String value = token.nextToken();
                if (object.indexOf(EXP_STR) >= 0) {
                    this.mExpressionField.setText(value);
                    this.mExpressionButton.setSelected(true);
                } else {
                    this.mStringField.setText(value);
                    this.mStringButton.setSelected(true);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.mOKButton)) {
            String value = null;
            String type = LITERAL_STR;
            if (this.mStringButton.isSelected()) {
                value = this.mStringField.getText();
            } else {
                type = EXP_STR;
                value = this.mExpressionField.getText();
            }
            if (value.trim().equals("")) {
                MultiLineOptionPane.showMessageDialog((Component)this.mOKButton, (Object)UIConstant.EMPTY_ERROR_MESSAGE, (String)UIConstant.DIALOG_MESSAGE, (int)0);
            } else {
                this.mEditor.setText(value + type);
                this.mDialog.dispose();
            }
        } else if (event.getSource().equals(this.mCancelButton)) {
            this.mDialog.dispose();
        } else if (event.getSource().equals(this.mStringButton)) {
            this.mStringField.setEditable(true);
            this.mExpressionField.setEditable(false);
        } else if (event.getSource().equals(this.mExpressionButton)) {
            this.mStringField.setEditable(false);
            this.mExpressionField.setEditable(true);
        } else if (event.getSource().equals(this.mStringField)) {
            // empty if block
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
        if (event.getSource().equals(this.mStringField)) {
            // empty if block
        }
        if (event.getSource().equals(this.mExpressionField)) {
            // empty if block
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public static void main(String[] args) {
        new DefaultAttributeUserDialog(null);
    }
}

