/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ButtonTextEditor;

public class DefaultAttributeDateDialog
implements ChangeListener,
ActionListener {
    JDialog mDialog = null;
    private JButton mOKButton = null;
    private JButton mCancelButton = null;
    private SpinnerListModel mMonths = null;
    private SpinnerNumberModel mYear = null;
    private SpinnerNumberModel mDate = null;
    ButtonTextEditor mEditor = null;
    private Calendar mCalendar = null;

    public DefaultAttributeDateDialog(ButtonTextEditor text) {
        this.mEditor = text;
        this.init();
    }

    private void init() {
        JSpinner yearS = null;
        JSpinner monthS = null;
        JSpinner dateS = null;
        this.mDialog = new JDialog();
        UIUtil.enableCloseOnEscapeKey((JDialog)this.mDialog);
        this.mDialog.setSize(350, 150);
        Container dialogPanel = this.mDialog.getContentPane();
        dialogPanel.setLayout(new GridBagLayout());
        this.mOKButton = new JButton(UIConstant.OK_BUTTON);
        this.mCancelButton = new JButton(UIConstant.CANCEL_BUTTON);
        dialogPanel.setLayout(new GridBagLayout());
        JLabel label1 = new JLabel(BPELStringTranslator.getString("YEAR_LABEL"));
        JLabel label2 = new JLabel(BPELStringTranslator.getString("MONTH_LABEL"));
        JLabel label3 = new JLabel(BPELStringTranslator.getString("DATE_LABEL"));
        this.mCalendar = Calendar.getInstance();
        int currentYear = this.mCalendar.get(1);
        this.mYear = new SpinnerNumberModel(currentYear, currentYear - 100, currentYear + 100, 1);
        this.mMonths = new SpinnerListModel(this.getMonths());
        int value = this.mMonths.getList().indexOf(this.mMonths.getValue());
        int row = 0;
        GraphUtils.addComponent((Container)dialogPanel, (Component)label1, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        yearS = new JSpinner(this.mYear);
        GraphUtils.addComponent((Container)dialogPanel, (Component)yearS, (int)1, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)label2, (int)2, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        monthS = new JSpinner(this.mMonths);
        GraphUtils.addComponent((Container)dialogPanel, (Component)monthS, (int)3, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 5, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)label3, (int)4, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mDate = new SpinnerNumberModel();
        this.mDate.setMinimum(new Integer(1));
        this.mDate.setStepSize(new Integer(1));
        this.mDate.setValue(new Integer(1));
        this.initDateSpinner();
        dateS = new JSpinner(this.mDate);
        GraphUtils.addComponent((Container)dialogPanel, (Component)dateS, (int)5, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, -30, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mOKButton, (int)3, (int)(++row), (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(30, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mCancelButton, (int)4, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(30, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mDialog.setLocationRelativeTo((Component)this.mEditor.mModel.mWizardContext.getWizard());
        this.mDialog.setModal(true);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mYear.addChangeListener(this);
        this.mMonths.addChangeListener(this);
        this.mDate.addChangeListener(this);
        this.setInitialValues();
    }

    private void setInitialValues() {
        try {
            String object = this.mEditor.getText().trim();
            if (!object.equals("")) {
                SimpleDateFormat format = this.getDateFormat();
                Calendar cal = Calendar.getInstance();
                Date date = format.parse(object);
                cal.setTime(date);
                int year = cal.get(1);
                int dateI = cal.get(5);
                int month = cal.get(2);
                this.mYear.setValue(new Integer(year));
                this.mDate.setValue(new Integer(dateI));
                this.mMonths.setValue(this.mMonths.getList().get(month));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        Object obj = event.getSource();
        if (obj.equals(this.mYear) || obj.equals(this.mMonths)) {
            this.initDateSpinner();
        }
    }

    public void showDialog() {
        this.mDialog.show();
    }

    private String[] getMonths() {
        int lastIndex;
        String[] months = new DateFormatSymbols().getMonths();
        if (months[lastIndex = months.length - 1] == null || months[lastIndex].length() <= 0) {
            String[] monthStrings = new String[lastIndex];
            System.arraycopy(months, 0, monthStrings, 0, lastIndex);
            return monthStrings;
        }
        return months;
    }

    private void initDateSpinner() {
        Object year = this.mYear.getValue();
        Integer intYear = new Integer(year.toString());
        int index = this.mMonths.getList().indexOf(this.mMonths.getValue());
        GregorianCalendar cal = new GregorianCalendar(intYear, index, 1);
        int days = ((Calendar)cal).getActualMaximum(5);
        this.mDate.setMaximum(new Integer(days));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.mOKButton)) {
            String year = this.mYear.getValue().toString().trim();
            int month = this.mMonths.getList().indexOf(this.mMonths.getValue());
            String date = this.mDate.getValue().toString().trim();
            Calendar cl = Calendar.getInstance();
            cl.set(new Integer(year), month, new Integer(date));
            SimpleDateFormat format = this.getDateFormat();
            this.mEditor.setText(format.format(cl.getTime()));
            this.mDialog.dispose();
        } else if (event.getSource().equals(this.mCancelButton)) {
            this.mDialog.dispose();
        }
    }

    private SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat("MMM d, yy");
    }

    public static void main(String[] args) {
        new DefaultAttributeDateDialog(null).showDialog();
    }
}

