/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.ButtonTextRenderer;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.NotificationTableModel;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.table.TableModel;

public class ButtonTextEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
ItemListener {
    protected JButton mButton = null;
    private JTextField mTextField = null;
    private JComboBox mNotification = null;
    protected TableModel mModel = null;
    private ButtonTextRenderer mRenderer = null;
    private String mDialogKey = null;

    public ButtonTextEditor(TableModel model, String dialogKey) {
        this.mModel = model;
        this.mButton = new JButton("...");
        this.mButton.addActionListener(this);
        if (0 == model.mPageType) {
            this.mNotification = ((NotificationTableModel)model).getNotifications();
            this.mNotification.addItemListener(this);
            this.mButton.setText(BPELStringTranslator.getString("NEW"));
            ResourceUtils.resButton((AbstractButton)this.mButton, (String)BPELStringTranslator.getString("NEW"));
        } else {
            this.mTextField = new JTextField();
            this.mTextField.setEditable(false);
            this.mTextField.getDocument().addDocumentListener(this.mModel);
        }
        this.mRenderer = new ButtonTextRenderer(this);
        this.mDialogKey = dialogKey;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int Row, int col) {
        return this.mRenderer;
    }

    public TableCellRenderer getTableCellRenderer() {
        return this.mRenderer;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
    }

    public String getText() {
        return (String)this.getCellEditorValue();
    }

    public void setText(String value) {
        if (this.mTextField != null) {
            this.mTextField.setText(value);
        } else {
            this.mNotification.setSelectedItem(value);
        }
    }

    @Override
    public Object getCellEditorValue() {
        if (this.mTextField != null) {
            return this.mTextField.getText();
        }
        return this.mNotification.getSelectedItem();
    }

    public Component getComponent() {
        if (this.mTextField != null) {
            return this.mTextField;
        }
        return this.mNotification;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.stopCellEditing();
    }
}

