/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.ide.Ide;
import oracle.tip.pc.services.notification.payload.ContentType;
import oracle.tip.pc.services.notification.payload.ContentTypeFactory;
import oracle.tip.pc.services.notification.payload.EmailPayloadType;
import oracle.tip.pc.services.notification.payload.EmailPayloadTypeFactory;
import oracle.tip.pc.services.notification.payload.GenericPayloadType;
import oracle.tip.pc.services.notification.payload.GenericPayloadTypeFactory;
import oracle.tip.pc.services.notification.payload.IContentType;
import oracle.tip.pc.services.notification.payload.IEmailPayloadType;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.DefaultNSMsgs;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.TaskFlowWizardUtil;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.TaskTypeWizardContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Util {
    public static final String ASSIGNEE_USERS = "assgineeUsers";
    public static final String ASSIGNEE_GROUPS = "assgineeGroups";
    public static final String EXPIRATION_DURATION = "expirationDuration";
    public static final String PRIORITY = "priority";
    public static final String OWNER = "owner";
    public static final String CREATOR = "creator";
    public static final String TITLE = "title";
    public static final String IDENTIFCATION_KEY = "identificationKey";
    public static final String COMMENTS = "comments";
    public static final String COMBOBOX = "combobox";
    public static final String NOTIFICATION = "Notification";
    public static final String FLEX_DATE = "flexDate";
    public static final String FLEX_STRING = "flexString";
    public static final String FLEX_LONG = "flexLong";
    public static final String FLEX_DOUBLE = "flexDouble";
    public static final String XSD_NAMESPACE = "xsd";
    public static final String TNS_NAMESPACE = "tns";
    public static final String TNS_NAMESPACE_URI = "http://taskTypes/";
    public static final String XSD_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema";
    public static final String CONCLUSION_FILE_NAME = "TaskConclusion.xml";
    private static List sFlexFields = null;
    private static List sVersionsDefaultAttributes = null;
    private static List sRestrictedAction = null;
    private static List sActionList = null;
    private static List sRecipientList = null;
    private static List sPriorities = null;
    private static List sDefaultAttributes = null;
    private static List sConclusions = null;
    private static Map sConclusionMap = null;
    private static Map sFlexStringMap = null;
    private static Map sVersionAttributeMap = null;
    private static Map sRestrictedActionMap = null;
    private static Map sNotificationActionMap = null;
    private static Map sRecipientMap = null;

    private static void setDisplayValue(Collection displayValues, Map displayValueMap, String key) {
        String displayValue = BPELStringTranslator.getString(key);
        displayValues.add(displayValue);
        displayValueMap.put(displayValue, key);
    }

    public static String getFlexStringKey(String displayValue) {
        if (sFlexStringMap != null) {
            return (String)sFlexStringMap.get(displayValue);
        }
        return null;
    }

    public static List getFlexFieldAttributes() {
        if (sFlexFields == null) {
            sFlexFields = new ArrayList();
            sFlexStringMap = new HashMap();
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexString1");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexString2");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexString3");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexString4");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexLong1");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexLong2");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexDouble1");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexDouble2");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexDate1");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexDate2");
            Util.setDisplayValue(sFlexFields, sFlexStringMap, "flexDate3");
        }
        return sFlexFields;
    }

    public static List getVersionAttributes() {
        if (sVersionsDefaultAttributes == null) {
            sVersionsDefaultAttributes = new ArrayList();
            sVersionAttributeMap = new HashMap(sFlexStringMap);
            Util.setDisplayValue(sVersionsDefaultAttributes, sVersionAttributeMap, COMMENTS);
            Util.setDisplayValue(sVersionsDefaultAttributes, sVersionAttributeMap, "attachments");
            Util.setDisplayValue(sVersionsDefaultAttributes, sVersionAttributeMap, "payload");
        }
        return sVersionsDefaultAttributes;
    }

    public static String getVersionTrackingKey(String displayValue) {
        if (sVersionAttributeMap != null) {
            return (String)sVersionAttributeMap.get(displayValue);
        }
        return null;
    }

    public static List getRestrictedActions() {
        if (sRestrictedAction == null) {
            TreeSet sortedSet = new TreeSet();
            sRestrictedActionMap = new HashMap();
            Util.setDisplayValue(sortedSet, sRestrictedActionMap, "REASSIGNED");
            Util.setDisplayValue(sortedSet, sRestrictedActionMap, "RENEWED");
            Util.setDisplayValue(sortedSet, sRestrictedActionMap, "ESCALATED");
            Util.setDisplayValue(sortedSet, sRestrictedActionMap, "SUSPENDED");
            Util.setDisplayValue(sortedSet, sRestrictedActionMap, "INFO REQUESTED");
            Util.setDisplayValue(sortedSet, sRestrictedActionMap, "AUTO RELEASE");
            sRestrictedAction = new ArrayList(sortedSet);
        }
        return sRestrictedAction;
    }

    public static String getRestrictedActionKey(String displayValue) {
        if (sRestrictedActionMap != null) {
            return (String)sRestrictedActionMap.get(displayValue);
        }
        return null;
    }

    public static List getNotificationActionList() {
        if (sActionList == null) {
            sActionList = new ArrayList();
            sNotificationActionMap = new HashMap();
            Util.setDisplayValue(sActionList, sNotificationActionMap, "ASSIGNED");
            Util.setDisplayValue(sActionList, sNotificationActionMap, "ERRORED");
            Util.setDisplayValue(sActionList, sNotificationActionMap, "EXPIRED");
            Util.setDisplayValue(sActionList, sNotificationActionMap, "SUSPENDED");
            Util.setDisplayValue(sActionList, sNotificationActionMap, "INFO REQUESTED");
            Util.setDisplayValue(sActionList, sNotificationActionMap, "COMPLETED");
            Util.setDisplayValue(sActionList, sNotificationActionMap, "WITHDRAWN");
        }
        return sActionList;
    }

    public static String getNotificationActionKey(String displayValue) {
        if (sNotificationActionMap != null) {
            return (String)sNotificationActionMap.get(displayValue);
        }
        return null;
    }

    public static List getRecipientList() {
        if (sRecipientList == null) {
            sRecipientList = new ArrayList();
            sRecipientMap = new HashMap();
            sRecipientList.add("      ");
            Util.setDisplayValue(sRecipientList, sRecipientMap, "ASSIGNEES");
            Util.setDisplayValue(sRecipientList, sRecipientMap, "CREATOR");
            Util.setDisplayValue(sRecipientList, sRecipientMap, "APPROVERS");
        }
        return sRecipientList;
    }

    public static String getRecipientKey(String displayValue) {
        if (sRecipientMap != null) {
            return (String)sRecipientMap.get(displayValue);
        }
        return null;
    }

    public static List getTaskPriorities() {
        if (sPriorities == null) {
            sPriorities = new ArrayList();
            sPriorities.add("   ");
            sPriorities.add("1");
            sPriorities.add("2");
            sPriorities.add("3");
            sPriorities.add("4");
            sPriorities.add("5");
        }
        return sPriorities;
    }

    public static List getTaskDefaultAttributes() {
        if (sDefaultAttributes == null) {
            sDefaultAttributes = new ArrayList();
            sDefaultAttributes.add(BPELStringTranslator.getString(ASSIGNEE_USERS));
            sDefaultAttributes.add(BPELStringTranslator.getString(ASSIGNEE_GROUPS));
            sDefaultAttributes.add(BPELStringTranslator.getString(EXPIRATION_DURATION));
            sDefaultAttributes.add(BPELStringTranslator.getString(PRIORITY));
            sDefaultAttributes.add(BPELStringTranslator.getString(OWNER));
            sDefaultAttributes.add(BPELStringTranslator.getString(CREATOR));
            sDefaultAttributes.add(BPELStringTranslator.getString(TITLE));
            sDefaultAttributes.add(BPELStringTranslator.getString(IDENTIFCATION_KEY));
            sDefaultAttributes.add(BPELStringTranslator.getString(COMMENTS));
            sDefaultAttributes.addAll(Util.getFlexFieldAttributes());
        }
        return sDefaultAttributes;
    }

    public static void setBorder(String title, JPanel panel) {
    }

    public static String getDisplayValue(TaskTypeWizardContext context, String name) {
        if (context.isResourceSelected()) {
            name = "getMessage(" + name + ")";
        }
        return name;
    }

    public static String getConclusionDisplayValue(String name) {
        String value = (String)sConclusionMap.get(name);
        if (value != null) {
            return value;
        }
        return name;
    }

    public static List getConclusions() {
        if (sConclusions == null) {
            InputStream stream = null;
            try {
                File f = new File(Ide.getSystemDirectory(), CONCLUSION_FILE_NAME);
                if (!f.exists()) {
                    String strFileName = CONCLUSION_FILE_NAME;
                    try {
                        stream = TaskFlowWizardUtil.getClassLoader().getResource("oracle/tip/tools/ide/pm/hw/task/taskflow/TaskConclusion.xml").openStream();
                        f = new File(Ide.getSystemDirectory() + "/" + strFileName);
                        f.createNewFile();
                        TaskFlowWizardUtil.copy(stream, f);
                        stream.close();
                    }
                    catch (Exception e) {
                        System.out.println(e.getStackTrace());
                    }
                }
                stream = new FileInputStream(f);
            }
            catch (Exception exc) {
                System.out.println(exc.getStackTrace());
            }
            if (stream == null) {
                try {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    stream = cl.getResourceAsStream(CONCLUSION_FILE_NAME);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (stream != null) {
                sConclusionMap = Util.getParsedValues(stream);
                sConclusions = new ArrayList(sConclusionMap.keySet());
            } else {
                sConclusions = new ArrayList();
            }
        }
        return sConclusions;
    }

    private static Map getParsedValues(InputStream fileName) {
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(fileName);
            NodeList elements = document.getElementsByTagName("conclusion");
            int size = elements.getLength();
            for (int i = 0; i < size; ++i) {
                Element childElem;
                String attrName;
                Element elem = (Element)elements.item(i);
                String value = attrName = elem.getAttribute("name");
                NodeList childs = elem.getElementsByTagName("displayvalue");
                if (childs.getLength() > 0 && (childElem = (Element)childs.item(0)).hasChildNodes()) {
                    value = childElem.getChildNodes().item(0).getNodeValue();
                }
                values.put(attrName, value);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return values;
    }

    public static void setDefaultEmailNotification(TaskTypeWizardContext context) {
        try {
            String taskVariableName = context.getTaskVar().getName();
            DefaultNSMsgs defaultNSMsgs = new DefaultNSMsgs();
            String subject = defaultNSMsgs.getMessage("EmailPayload", "Subject", taskVariableName);
            String body = defaultNSMsgs.getMessage("EmailPayload", "ContentBody", taskVariableName);
            EmailPayloadType emailPayload = EmailPayloadTypeFactory.createFacade();
            ContentType contentType = ContentTypeFactory.createFacade();
            contentType.setMimeType(TaskFlowWizardUtil.parseLiteralAndXpath("text/html; charset=UTF-8"));
            contentType.setContentBody((Object)TaskFlowWizardUtil.parseLiteralAndXpath(body));
            emailPayload.setSubject(TaskFlowWizardUtil.parseLiteralAndXpath(subject));
            emailPayload.setContent((IContentType)contentType);
            GenericPayloadType genericPayload = GenericPayloadTypeFactory.createFacade();
            genericPayload.setEmailPayload((IEmailPayloadType)emailPayload);
            context.setGenericPayload(BPELStringTranslator.getString("EMAIL"), genericPayload);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void main(String[] args) {
    }
}

