/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.Util;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.TaskTypeWizardContext;

public class ListPanel
extends JPanel
implements ActionListener,
ListDataListener {
    JList mInputList = new JList();
    JList mSelectedList = new JList();
    PushButton mButtonSelectOne = new PushButton();
    PushButton mButtonSelectAll = new PushButton();
    PushButton mButtonRemoveOne = new PushButton();
    PushButton mButtonRemoveAll = new PushButton();
    TaskTypeWizardContext mWizardContext = null;
    BaseWizard mBaseWizard = null;
    ImageWizardPage mImageWizard = null;

    public ListPanel(TaskTypeWizardContext context, BaseWizard wizard) {
        this.mWizardContext = context;
        this.mBaseWizard = wizard;
    }

    public void createListPanel(List values, String inputLabel, String selectLabel) throws Exception {
        Util.setBorder("", this);
        JScrollPane inputScrollPane = new JScrollPane(this.mInputList);
        JScrollPane selectScrollPane = new JScrollPane(this.mSelectedList);
        JPanel buttonPanel = new JPanel();
        Border border = BorderFactory.createLineBorder(Color.BLUE);
        this.setLayout(new GridBagLayout());
        buttonPanel.setLayout(new GridBagLayout());
        JLabel label1 = new JLabel(inputLabel);
        JLabel label3 = new JLabel(selectLabel);
        GraphUtils.addComponent((Container)this, (Component)label1, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)label3, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)inputScrollPane, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)230, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)buttonPanel, (int)1, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this, (Component)selectScrollPane, (int)2, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        this.mButtonSelectOne.setText(">  ");
        this.mButtonSelectAll.setText(">>");
        this.mButtonRemoveOne.setText("<  ");
        this.mButtonRemoveAll.setText("<<");
        int buttonRow = 0;
        GraphUtils.addComponent((Container)buttonPanel, (Component)this.mButtonSelectOne, (int)0, (int)buttonRow, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)buttonPanel, (Component)this.mButtonSelectAll, (int)0, (int)(++buttonRow), (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)buttonPanel, (Component)this.mButtonRemoveOne, (int)0, (int)(++buttonRow), (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)buttonPanel, (Component)this.mButtonRemoveAll, (int)0, (int)(++buttonRow), (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mInputList.setModel(new DefaultListModel());
        this.mSelectedList.setModel(new DefaultListModel());
        this.setVisible(true);
        this.addInputList(values);
        this.mButtonSelectOne.addActionListener((ActionListener)this);
        this.mButtonSelectAll.addActionListener((ActionListener)this);
        this.mButtonRemoveOne.addActionListener((ActionListener)this);
        this.mButtonRemoveAll.addActionListener((ActionListener)this);
        this.mSelectedList.getModel().addListDataListener(this);
        this.mInputList.getModel().addListDataListener(this);
    }

    public void addInputList(List values) {
        DefaultListModel model = (DefaultListModel)this.mInputList.getModel();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(values.get(i));
        }
    }

    public void moveSelectedValues(JList fromList, JList toList) {
        Object[] values = fromList.getSelectedValues();
        if (values.length != 0) {
            int i;
            DefaultListModel model = (DefaultListModel)toList.getModel();
            for (i = 0; i < values.length; ++i) {
                model.addElement(values[i]);
            }
            model = (DefaultListModel)fromList.getModel();
            for (i = 0; i < values.length; ++i) {
                model.removeElement(values[i]);
            }
        }
    }

    public void moveAllValues(JList fromList, JList toList) {
        DefaultListModel model = (DefaultListModel)fromList.getModel();
        Enumeration enum_var = model.elements();
        model = (DefaultListModel)toList.getModel();
        while (enum_var.hasMoreElements()) {
            Object obj = enum_var.nextElement();
            if (model.contains(obj)) continue;
            model.addElement(obj);
        }
        model = (DefaultListModel)fromList.getModel();
        model.removeAllElements();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source.equals(this.mButtonSelectOne)) {
            this.moveSelectedValues(this.mInputList, this.mSelectedList);
        } else if (source.equals(this.mButtonRemoveOne)) {
            this.moveSelectedValues(this.mSelectedList, this.mInputList);
        } else if (source.equals(this.mButtonSelectAll)) {
            this.moveAllValues(this.mInputList, this.mSelectedList);
        } else if (source.equals(this.mButtonRemoveAll)) {
            this.moveAllValues(this.mSelectedList, this.mInputList);
        }
    }

    private void enableDisableButtons() {
        DefaultListModel inputModel = (DefaultListModel)this.mInputList.getModel();
        boolean enableSelect = true;
        if (inputModel.size() == 0) {
            enableSelect = false;
        }
        this.mButtonSelectOne.setEnabled(enableSelect);
        this.mButtonSelectAll.setEnabled(enableSelect);
        DefaultListModel selectModel = (DefaultListModel)this.mSelectedList.getModel();
        boolean enableInput = true;
        if (selectModel.size() == 0) {
            enableInput = false;
        }
        this.mButtonRemoveOne.setEnabled(enableInput);
        this.mButtonRemoveAll.setEnabled(enableInput);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.enableDisableButtons();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.enableDisableButtons();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
    }

    public JList getSelectedList() {
        return this.mSelectedList;
    }
}

