/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.ide.Ide;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.TaskFlowWizardUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DefaultNSMsgs {
    public static final String EMAIL_PAYLOAD = "EmailPayload";
    public static final String VOICE_PAYLOAD = "VoicePayload";
    public static final String FAX_PAYLOAD = "FaxPayload";
    public static final String PAGER_PAYLOAD = "PagerPayload";
    public static final String SMS_PAYLOAD = "SMSPayload";
    public static final String SUBJECT_MESSAGE = "Subject";
    public static final String CONTENTBODY_MESSAGE = "ContentBody";
    private static final String DEFAULT_NS_MSGS_FILE = "DefaultNotification.xml";
    private static final String TASK_VARIABLE_TAG = "__HWFTaskVariable__";
    private Map payloads = new HashMap();

    public DefaultNSMsgs() {
        this.initialize();
    }

    public String getMessage(String channel, String messageName, String taskVariableName) {
        String message;
        Payload payload = (Payload)this.payloads.get(channel);
        if (payload != null && (message = payload.getMessage(messageName)) != null) {
            return message.replaceAll(TASK_VARIABLE_TAG, taskVariableName);
        }
        return null;
    }

    private void initialize() {
        try {
            InputStream stream = null;
            File f = new File(Ide.getSystemDirectory(), DEFAULT_NS_MSGS_FILE);
            if (!f.exists()) {
                String strFileName = DEFAULT_NS_MSGS_FILE;
                try {
                    stream = TaskFlowWizardUtil.getClassLoader().getResource("oracle/tip/tools/ide/pm/hw/task/taskflow/wizard/util/DefaultNotification.xml").openStream();
                    f = new File(Ide.getSystemDirectory() + "/" + strFileName);
                    f.createNewFile();
                    TaskFlowWizardUtil.copy(stream, f);
                    stream.close();
                }
                catch (Exception e) {
                    System.out.println(e.getStackTrace());
                }
            }
            stream = new FileInputStream(f);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            URI uri = f.toURI();
            Document document = builder.parse(new File(uri));
            this.constructStates(document);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void constructStates(Document document) {
        Element root = document.getDocumentElement();
        NodeList stateList = root.getElementsByTagName("channel");
        for (int i = 0; i < stateList.getLength(); ++i) {
            Element node = (Element)stateList.item(i);
            String channelName = node.getAttribute("name");
            Payload payload = new Payload();
            NodeList children = node.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (!(child instanceof Element)) continue;
                String messageName = ((Element)child).getAttribute("name");
                String message = this.getNodeValue((Element)child);
                payload.addMessage(messageName, message);
            }
            this.payloads.put(channelName, payload);
        }
    }

    private String getNodeValue(Node node) {
        node.normalize();
        switch (node.getNodeType()) {
            case 1: {
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int i = 0; i < children.getLength(); ++i) {
                    String value = this.getNodeValue(children.item(i));
                    if (value == null) continue;
                    return value;
                }
                break;
            }
            case 3: {
                if (((Text)node).getData() != null && ((Text)node).getData().trim().length() == 0) break;
                String val = node.getNodeValue();
                if (val == null || "".equals(val.trim())) {
                    return null;
                }
                return val;
            }
            case 4: {
                if (((CDATASection)node).getData() != null && ((CDATASection)node).getData().trim().length() == 0) break;
                return node.getNodeValue();
            }
            case 2: {
                if (((Attr)node).getValue() != null && ((Attr)node).getValue().trim().length() == 0) break;
                return ((Attr)node).getValue();
            }
        }
        return null;
    }

    public static void main(String[] args) {
        DefaultNSMsgs defaultNSMsgs = new DefaultNSMsgs();
        String[] channels = new String[]{EMAIL_PAYLOAD, VOICE_PAYLOAD, FAX_PAYLOAD, PAGER_PAYLOAD, SMS_PAYLOAD};
        String[] messages = new String[]{SUBJECT_MESSAGE, CONTENTBODY_MESSAGE};
        for (int i = 0; i < channels.length; ++i) {
            String channelName = channels[i];
            for (int j = 0; j < messages.length; ++j) {
                String messageName = messages[j];
                System.out.println("Channel: " + channelName + " Message Name: " + messageName);
                System.out.println("\tMessage: " + defaultNSMsgs.getMessage(channelName, messageName, "task"));
            }
        }
    }

    private class Payload {
        Map messages = new HashMap();

        private Payload() {
        }

        void addMessage(String messageName, String message) {
            this.messages.put(messageName, message);
        }

        String getMessage(String messageName) {
            return (String)this.messages.get(messageName);
        }
    }
}

