/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;

public class AssigneeCopyGenerator {
    public static final String IS_GROUP_PARAM_KEY = "areAssigneesGroupsParam";
    public static final String IS_ALIAS_GROUP_PARAM_KEY = "isAliasGroupParam";
    private static final String DEFAULT_GROUP_QUERY = "/task:task/task:assigneeGroups";
    private static final String DEFAULT_USER_QUERY = "/task:task/task:assigneeUsers";
    private static final String COPY = "copy";
    private static final String VARIABLE = "variable";
    private static final String PART = "part";
    private static final String QUERY = "query";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String EXPRESSION = "expression";
    private static final String TEMP_VARIABLE = "oraBPMTemporaryVariable";

    public static List generateCopyConstructsFromXPath(TaskFlowWizardContext ct, String variable, String part, String query, Map parameters, String fromVariable, String fromPart, String fromQuery, String is_group_param_key) throws Exception {
        Object isGroupObj = parameters.get(is_group_param_key);
        boolean isGroup = false;
        if (isGroupObj != null && isGroupObj instanceof Boolean && ((Boolean)isGroupObj).booleanValue()) {
            isGroup = true;
        }
        if (query == null) {
            query = isGroup ? DEFAULT_GROUP_QUERY : DEFAULT_USER_QUERY;
        }
        ArrayList<Copy> copies = new ArrayList<Copy>();
        AssigneeCopyGenerator.clearTaskAssignees(ct, copies);
        copies.add(AssigneeCopyGenerator.getLockDisablingCopy(ct, variable, part, query));
        String fromExpr = AssigneeCopyGenerator.getCopyListExpression(variable, part, query, AssigneeCopyGenerator.getGetNodesExpression(fromVariable, fromPart, fromQuery));
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        BPELXmlModel pmmodel = AssigneeCopyGenerator.getPMModel(ct);
        copy.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        AssigneeCopyGenerator.addFromForExpression(ct, fromExpr, copy);
        AssigneeCopyGenerator.addToForTempVariable(ct, copy);
        copies.add(copy);
        return copies;
    }

    protected static BPELXmlModel getPMModel(TaskFlowWizardContext ct) {
        BPELGraphPane graph = ct._pane;
        JDevBPELEditor editor = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)graph));
        return editor.getPMGui().getXMLModel();
    }

    public static List generateCopyConstructsFromXPath(TaskFlowWizardContext ct, String variable, String part, String query, Map parameters, String fromExpression, String is_group_param_key) throws Exception {
        Object isGroupObj = parameters.get(is_group_param_key);
        boolean isGroup = false;
        if (isGroupObj != null && isGroupObj instanceof Boolean && ((Boolean)isGroupObj).booleanValue()) {
            isGroup = true;
        }
        if (query == null) {
            query = isGroup ? DEFAULT_GROUP_QUERY : DEFAULT_USER_QUERY;
        }
        ArrayList<Copy> copies = new ArrayList<Copy>();
        AssigneeCopyGenerator.clearTaskAssignees(ct, copies);
        copies.add(AssigneeCopyGenerator.getLockDisablingCopy(ct, variable, part, query));
        String fromExpr = AssigneeCopyGenerator.getCopyListExpression(variable, part, query, fromExpression);
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        BPELXmlModel pmmodel = AssigneeCopyGenerator.getPMModel(ct);
        copy.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        AssigneeCopyGenerator.addFromForExpression(ct, fromExpr, copy);
        AssigneeCopyGenerator.addToForTempVariable(ct, copy);
        copies.add(copy);
        return copies;
    }

    public static List generateCopyConstructsFromAlias(TaskFlowWizardContext ct, String variable, String part, String query, Map parameters, String alias, String is_group_param_key) throws Exception {
        Object isGroupObj = parameters.get(is_group_param_key);
        boolean isGroup = false;
        if (isGroupObj != null && isGroupObj instanceof Boolean && ((Boolean)isGroupObj).booleanValue()) {
            System.out.println("***********" + (Boolean)isGroupObj);
            isGroup = true;
        }
        Object isGroupAliasObj = parameters.get(IS_ALIAS_GROUP_PARAM_KEY);
        boolean isGroupAlias = false;
        if (isGroupAliasObj != null && isGroupAliasObj instanceof Boolean && ((Boolean)isGroupAliasObj).booleanValue()) {
            isGroupAlias = true;
        }
        System.out.println("***********   1 " + isGroup);
        if (query == null) {
            query = isGroup ? DEFAULT_GROUP_QUERY : DEFAULT_USER_QUERY;
        }
        System.out.println("***********   2 " + query);
        ArrayList<Copy> copies = new ArrayList<Copy>();
        AssigneeCopyGenerator.clearTaskAssignees(ct, copies);
        copies.add(AssigneeCopyGenerator.getLockDisablingCopy(ct, variable, part, query));
        String fromExpr = AssigneeCopyGenerator.getCopyListExpression(variable, part, query, AssigneeCopyGenerator.getGetAliasExpression(alias, isGroup, isGroupAlias));
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        BPELXmlModel pmmodel = AssigneeCopyGenerator.getPMModel(ct);
        copy.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        AssigneeCopyGenerator.addFromForExpression(ct, fromExpr, copy);
        AssigneeCopyGenerator.addToForTempVariable(ct, copy);
        copies.add(copy);
        return copies;
    }

    public static List generateCopyConstructsFromOID(TaskFlowWizardContext ct, String variable, String part, String query, Map parameters, List entities, String is_group_param_key) throws Exception {
        if (entities == null || entities.size() == 0) {
            return new ArrayList();
        }
        Object isGroupObj = parameters.get(is_group_param_key);
        boolean isGroup = false;
        if (isGroupObj != null && isGroupObj instanceof Boolean && ((Boolean)isGroupObj).booleanValue()) {
            isGroup = true;
        }
        if (query == null) {
            query = isGroup ? DEFAULT_GROUP_QUERY : DEFAULT_USER_QUERY;
        }
        ArrayList<Copy> copies = new ArrayList<Copy>();
        AssigneeCopyGenerator.clearTaskAssignees(ct, copies);
        Copy copy1 = (Copy)BPELParser.createImplementation(Copy.class);
        BPELXmlModel pmmodel = AssigneeCopyGenerator.getPMModel(ct);
        copy1.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        AssigneeCopyGenerator.addFromForExpression(ct, AssigneeCopyGenerator.getStringLiteralExpression((String)entities.get(0)), copy1);
        AssigneeCopyGenerator.addTo(ct, variable, part, query + "[1]", copy1);
        copies.add(copy1);
        for (int i = 1; i < entities.size(); ++i) {
            String fromExpr = AssigneeCopyGenerator.getAppendToListExpression(variable, part, query, AssigneeCopyGenerator.getStringLiteralExpression((String)entities.get(i)));
            Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
            copy.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            AssigneeCopyGenerator.addFromForExpression(ct, fromExpr, copy);
            AssigneeCopyGenerator.addToForTempVariable(ct, copy);
            copies.add(copy);
        }
        return copies;
    }

    private static String getStringLiteralExpression(String value) {
        return "string(" + AssigneeCopyGenerator.getArgument(value) + ")";
    }

    private static String getGetAliasExpression(String alias, boolean isGroup, boolean isGroupAlias) throws Exception {
        if (AssigneeCopyGenerator.isNull(alias)) {
            throw new Exception(BPELStringTranslator.getString("ALIAS_EMPTY_ERROR"));
        }
        if (isGroup) {
            if (isGroupAlias) {
                return "ora:getGroupIdsFromGroupAlias(" + AssigneeCopyGenerator.getArgument(alias) + ")";
            }
            throw new Exception(BPELStringTranslator.getString("USER_ALIAS_ERROR"));
        }
        if (isGroupAlias) {
            return "ora:getUserIdsFromGroupAlias(" + AssigneeCopyGenerator.getArgument(alias) + ")";
        }
        return "ora:getUserAliasId(" + AssigneeCopyGenerator.getArgument(alias) + ")";
    }

    private static String getAppendToListExpression(String variable, String part, String query, String expression) throws Exception {
        if (AssigneeCopyGenerator.isNull(variable)) {
            throw new Exception(BPELStringTranslator.getString("VARIABLE_EMPTY_ERROR"));
        }
        if (AssigneeCopyGenerator.isNull(query)) {
            throw new Exception(BPELStringTranslator.getString("QUERY_EMPTY_ERROR"));
        }
        if (AssigneeCopyGenerator.isNull(expression)) {
            throw new Exception(BPELStringTranslator.getString("QUERY_EMPTY_ERROR"));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ora:appendToList(");
        sb.append(AssigneeCopyGenerator.getArgument(variable));
        if (!AssigneeCopyGenerator.isNull(part)) {
            sb.append(", ");
            sb.append(AssigneeCopyGenerator.getArgument(part));
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            sb.append(", ");
            sb.append(AssigneeCopyGenerator.getArgument(query));
        }
        if (!AssigneeCopyGenerator.isNull(expression)) {
            sb.append(", ");
            sb.append(expression);
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getGetNodesExpression(String variable, String part, String query) throws Exception {
        if (AssigneeCopyGenerator.isNull(variable)) {
            throw new Exception(BPELStringTranslator.getString("VARIABLE_EMPTY_GETNODE_ERROR"));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ora:getNodes(");
        sb.append(AssigneeCopyGenerator.getArgument(variable));
        if (!AssigneeCopyGenerator.isNull(part)) {
            sb.append(", ");
            sb.append(AssigneeCopyGenerator.getArgument(part));
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            sb.append(", ");
            sb.append(AssigneeCopyGenerator.getArgument(query));
        }
        sb.append(")");
        return sb.toString();
    }

    private static String getCopyListExpression(String variable, String part, String query, String expression) throws Exception {
        if (AssigneeCopyGenerator.isNull(variable)) {
            throw new Exception(BPELStringTranslator.getString("VARIABLE_EMPTY_GETNODE_ERROR"));
        }
        if (AssigneeCopyGenerator.isNull(query)) {
            throw new Exception(BPELStringTranslator.getString("QUERY_EMPTY_COPY_ERROR"));
        }
        if (AssigneeCopyGenerator.isNull(expression)) {
            throw new Exception(BPELStringTranslator.getString("QUERY_EMPTY_COPY_ERROR"));
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ora:copyList(");
        sb.append(AssigneeCopyGenerator.getArgument(variable));
        if (!AssigneeCopyGenerator.isNull(part)) {
            sb.append(", ");
            sb.append(AssigneeCopyGenerator.getArgument(part));
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            sb.append(", ");
            sb.append(AssigneeCopyGenerator.getArgument(query));
        }
        if (!AssigneeCopyGenerator.isNull(expression)) {
            sb.append(", ");
            sb.append(expression);
        }
        sb.append(")");
        return sb.toString();
    }

    private static void addFromForExpression(TaskFlowWizardContext m_wcontext, String expression, Copy copy) {
        From from = (From)BPELParser.createImplementation(From.class);
        from.setExpression(expression);
        copy.setFrom(from);
    }

    private static void addToForExpression(TaskFlowWizardContext ct, String expression, Copy copy) {
        To to = (To)BPELParser.createImplementation(To.class);
        to.setQuery(expression);
        copy.setTo(to);
    }

    private static void addToForTempVariable(TaskFlowWizardContext m_wcontext, Copy copy) {
        To to = (To)BPELParser.createImplementation(To.class);
        to.setVariable(TEMP_VARIABLE);
        copy.setTo(to);
    }

    private static Copy addFrom(TaskFlowWizardContext ct, String variable, String part, String query, Copy copy) {
        From from = (From)BPELParser.createImplementation(From.class);
        if (!AssigneeCopyGenerator.isNull(variable)) {
            from.setVariable(variable);
        }
        if (!AssigneeCopyGenerator.isNull(part)) {
            from.setPart(part);
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            from.setQuery(query);
        }
        copy.setFrom(from);
        return copy;
    }

    private static Copy addTo(TaskFlowWizardContext ct, String variable, String part, String query, Copy copy) {
        To to = (To)BPELParser.createImplementation(To.class);
        if (!AssigneeCopyGenerator.isNull(variable)) {
            to.setVariable(variable);
        }
        if (!AssigneeCopyGenerator.isNull(part)) {
            to.setPart(part);
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            to.setQuery(query);
        }
        copy.setTo(to);
        return copy;
    }

    private static Copy getLockDisablingCopy(TaskFlowWizardContext ct, String variable, String part, String query) {
        Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
        BPELXmlModel pmmodel = AssigneeCopyGenerator.getPMModel(ct);
        copy.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
        query = query + "[1]";
        From from = (From)BPELParser.createImplementation(From.class);
        if (!AssigneeCopyGenerator.isNull(variable)) {
            from.setVariable(variable);
        }
        if (!AssigneeCopyGenerator.isNull(part)) {
            from.setPart(part);
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            from.setQuery(query);
        }
        To to = (To)BPELParser.createImplementation(To.class);
        if (!AssigneeCopyGenerator.isNull(variable)) {
            to.setVariable(variable);
        }
        if (!AssigneeCopyGenerator.isNull(part)) {
            to.setPart(part);
        }
        if (!AssigneeCopyGenerator.isNull(query)) {
            to.setQuery(query);
        }
        copy.setFrom(from);
        copy.setTo(to);
        return copy;
    }

    private static boolean isNull(String str) {
        return str == null || "".equals(str.trim());
    }

    private static String getArgument(String str) {
        return '\'' + str + '\'';
    }

    private static void clearTaskAssignees(TaskFlowWizardContext ct, List copies) {
        Boolean continuation = (Boolean)ct._map.get("continueTaskParam");
        if (continuation != null && continuation.booleanValue()) {
            String taskVarName = ct._map.get("taskVariableNameParam").toString();
            Copy copy = (Copy)BPELParser.createImplementation(Copy.class);
            BPELXmlModel pmmodel = AssigneeCopyGenerator.getPMModel(ct);
            copy.createDOMElement(pmmodel.getParserDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
            From from = (From)BPELParser.createImplementation(From.class);
            from.setExpression("ora:clearTaskAssignees(bpws:getVariableData('" + taskVarName + "', '" + "/task:task" + "'))");
            copy.setFrom(from);
            To to = (To)BPELParser.createImplementation(To.class);
            to.setVariable(taskVarName);
            to.setQuery("/task:task");
            copy.setTo(to);
            copies.add(copy);
        }
    }
}

