/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.xml.namespace.QName;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.tip.pc.services.hw.task.taskflow.UserActivityGeneratorFactory;
import oracle.tip.pc.services.hw.task.taskflow.templates.Template;
import oracle.tip.pc.services.hw.task.taskflow.templates.Templates;
import oracle.tip.pc.services.hw.task.tasktype.IDescription;
import oracle.tip.pc.services.hw.task.tasktype.ITask;
import oracle.tip.pc.services.hw.task.tasktype.ITaskType;
import oracle.tip.pc.services.hw.task.tasktype.ITaskTypeNode;
import oracle.tip.pc.services.hw.task.tasktype.impl.TaskTypeFactory;
import oracle.tip.pc.services.hw.task.tasktype.impl.TaskTypeParser;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Process;
import oracle.tip.tools.ide.common.bpelparser.iface.Scope;
import oracle.tip.tools.ide.common.bpelparser.iface.Variable;
import oracle.tip.tools.ide.common.bpelparser.iface.Variables;
import oracle.tip.tools.ide.common.bpelparser.util.BPELModelUtil;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.bpelgraph.model.BPELGraphModel;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.common.TaskFlowConstants;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskDetailsFirstPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskDetailsSecondPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskFlowComboItem;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskFlowWizardPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.TaskFlowWizardUtil;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.ConclusionPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.FlexFieldPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.NotificationPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.RestrictedActionPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.wizard.pages.VersionTrackingPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.util.TaskHelpUtil;

public class TaskFlowSelectionPage
extends TaskFlowWizardPage
implements ActionListener,
DocumentListener,
PopupMenuListener {
    Map attributeMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField scopeNameText = new JTextField();
    private JTextField varNameText = new JTextField();
    private MultiLineLabel m_explanation;
    private MultiLineLabel m_explanation2;
    private boolean bTaskFlowSelected = false;
    private boolean bScopeNameNotEmpty = false;
    private boolean bVarNameNotEmpty = false;
    private JSeparator jSeparator1 = new JSeparator();
    private JLabel lblDescription = new JLabel();
    private JTextArea descriptionTextArea = new JTextArea();
    private Caret caret1 = new DefaultCaret();
    private String generatedVarNamePrefix = "taskVariable";
    private String generatedScopeNamePrefix = "task";
    private boolean m_popupVisible = false;

    public TaskFlowSelectionPage(TaskFlowWizardContext wcontext, ImageWizardPage iwp, Map map) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.attributeMap = new HashMap();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_explanation = new MultiLineLabel(WordWrapper.getTextWrapper(), TaskFlowConstants.WIZARD_PAGE_EXPLANATION_FLOW_SELECTION1);
        this.m_explanation2 = new MultiLineLabel(WordWrapper.getTextWrapper(), TaskFlowConstants.WIZARD_PAGE_EXPLANATION_FLOW_SELECTION2);
        Boolean continuation = (Boolean)this.m_wcontext._map.get("continueTaskParam");
        if (continuation != null && continuation.booleanValue()) {
            this.varNameText = new JTextField();
            this.generateAndSetVarConfigAndScopeNames();
            this.varNameText.setText(this.m_wcontext._map.get("taskVariableNameParam").toString());
            this.varNameText.setEnabled(false);
        } else {
            this.generateAndSetVarConfigAndScopeNames();
            this.varNameText.getDocument().addDocumentListener(this);
        }
        this.varNameText.addActionListener(this);
        this.scopeNameText.addActionListener(this);
        this.scopeNameText.getDocument().addDocumentListener(this);
        this.scopeNameText.setActionCommand("ScopeNameText");
        JLabel label1 = new JLabel(BPELStringTranslator.getString("WORKFLOW_PATTERNS"));
        JLabel scopeNameLbl = new JLabel();
        JLabel varNameLbl = new JLabel();
        JComboBox<TaskFlowComboItem> combo = new JComboBox<TaskFlowComboItem>();
        combo.setActionCommand("TaskFlowCombo");
        combo.addPopupMenuListener(this);
        this.setLayout(this.gridBagLayout1);
        this.descriptionTextArea.setColumns(1);
        this.descriptionTextArea.setCaret(this.caret1);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setBorder(BorderFactory.createLineBorder(Color.lightGray, 1));
        this.descriptionTextArea.setFont(this.varNameText.getFont());
        JScrollPane descriptionScroll = new JScrollPane(this.descriptionTextArea, 20, 30);
        varNameLbl.setText(BPELStringTranslator.getString("VARIABLE_NAME"));
        scopeNameLbl.setText(BPELStringTranslator.getString("WORKFLOW_NAME_2"));
        label1.setText(BPELStringTranslator.getString("WORKFLOW_PATTERNS"));
        combo.setMinimumSize(new Dimension(50, 20));
        Templates templates = UserActivityGeneratorFactory.getTaskFlowTemplates().getTemplates();
        List list = templates.getTemplate();
        Iterator iter = list.iterator();
        this.lblDescription.setText(BPELStringTranslator.getString("DESCRIPTION2"));
        this.jSeparator1.setOpaque(true);
        this.jSeparator1.setBounds(new Rectangle(0, 110, 390, 5));
        while (iter.hasNext()) {
            Template template = (Template)iter.next();
            String description = this.getTranslatedString(template.getDescription());
            String name = template.getDisplay();
            String localizedName = this.getTranslatedString(template.getDisplay());
            String uiTemplate = template.getTaskFlowUITemplate();
            String id = template.getId();
            combo.addItem(new TaskFlowComboItem(id, name, localizedName, uiTemplate, description));
        }
        combo.setSelectedIndex(-1);
        combo.addActionListener(this);
        if (continuation != null && continuation.booleanValue()) {
            URL prjDir = this.m_wcontext.m_bpelProject.getBPELDirectoryURL();
            String fileName = prjDir.getFile() + this.m_wcontext._ttFileName;
            ITaskType taskType = new TaskTypeParser().parse(fileName);
            this.m_wcontext._ttwcontext.setTaskType(taskType);
        } else {
            System.out.println("Saving Task Configuration info data");
            String name = this.m_wcontext._ttFileName;
            String nameSpace = "http://taskTypes/" + name;
            String description = this.descriptionTextArea.getText().trim();
            String resourceFile = "";
            String resourceName = "";
            boolean actionableMessage = true;
            String actionableStr = "NO";
            if (actionableMessage) {
                actionableStr = "YES";
            }
            this.m_wcontext._ttwcontext.setIsResourceSelected(false);
            ITaskType taskType = (ITaskType)TaskTypeFactory.getNode(null, null, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"taskType");
            taskType.setAttribute("name", (Object)name);
            taskType.setAttribute("targetNamespace", (Object)nameSpace);
            taskType.addNamespaceMapping("xsd", "http://www.w3.org/2001/XMLSchema");
            taskType.addNamespaceMapping("tns", nameSpace);
            taskType.setNamespace("http://xmlns.oracle.com/pcbpel/taskservice/tasktype");
            if (description.trim().length() > 0) {
                IDescription desc = (IDescription)TaskTypeFactory.getNode((ITaskType)taskType, (ITaskTypeNode)taskType, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"description");
                desc.setValue(description);
                taskType.setDescription(desc);
            }
            ITask task = (ITask)TaskTypeFactory.getNode((ITaskType)taskType, (ITaskTypeNode)taskType, (String)"http://xmlns.oracle.com/pcbpel/taskservice/tasktype", (String)"task");
            task.setAttribute("actionableNotifications", (Object)actionableStr);
            task.setNamespace("http://xmlns.oracle.com/pcbpel/taskservice/tasktype");
            taskType.setTask(task);
            this.m_wcontext._ttwcontext.setTaskType(taskType);
        }
        this.add((Component)this.m_explanation, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add(combo, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)label1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jSeparator1, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_explanation2, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 10, 5), 0, 0));
        this.add((Component)this.scopeNameText, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)scopeNameLbl, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.varNameText, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)varNameLbl, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.lblDescription, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)descriptionScroll, new GridBagConstraints(2, 7, 1, 1, 0.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)label1, combo, (String)BPELStringTranslator.getString("WORKFLOW_PATTERNS"));
        ResourceUtils.resLabel((JLabel)scopeNameLbl, (Component)this.scopeNameText, (String)BPELStringTranslator.getString("WORKFLOW_NAME_2"));
        ResourceUtils.resLabel((JLabel)varNameLbl, (Component)this.varNameText, (String)BPELStringTranslator.getString("VARIABLE_NAME_V"));
        ResourceUtils.resLabel((JLabel)this.lblDescription, (Component)this.descriptionTextArea, (String)BPELStringTranslator.getString("DESCRIPTION2"));
        this.m_page.setCanAdvance(false);
    }

    private void generateAndSetVarConfigAndScopeNames() {
        this.scopeNameText.getDocument().removeDocumentListener(this);
        Boolean continuation = (Boolean)this.m_wcontext._map.get("continueTaskParam");
        boolean bContinuation = continuation != null && continuation != false;
        int i = 1;
        boolean varNamed = false;
        String generatedVarName = this.generatedVarNamePrefix + i;
        String generatedScopeName = this.generatedScopeNamePrefix + i;
        if (!bContinuation) {
            this.m_wcontext._ttFileName = "taskConfig" + this.getURLEncodedString(generatedScopeName) + ".xml";
        }
        BPELGraphPane pane = this.m_wcontext._pane;
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        Process process = model.getProcess();
        List varList = process.getVariables().getVariables();
        for (Variable var : varList) {
            String name = var.getName();
            if (!name.trim().equals(generatedVarName)) continue;
            generatedVarName = this.generatedVarNamePrefix + ++i;
            generatedScopeName = this.generatedScopeNamePrefix + i;
            if (bContinuation) continue;
            this.m_wcontext._ttFileName = "taskConfig" + this.getURLEncodedString(generatedScopeName) + ".xml";
        }
        if (!bContinuation) {
            this.varNameText.setText(generatedVarName);
        }
        this.scopeNameText.setText(generatedScopeName);
        this.scopeNameText.getDocument().addDocumentListener(this);
    }

    private void updateTaskType() {
        Boolean continuation = (Boolean)this.m_wcontext._map.get("continueTaskParam");
        boolean bContinuation = continuation != null && continuation != false;
        if (!bContinuation) {
            String name = this.m_wcontext._ttFileName;
            String nameSpace = "http://taskTypes/" + name;
            ITaskType taskType = this.m_wcontext._ttwcontext.getTaskType();
            taskType.setAttribute("name", (Object)name);
            taskType.setName(name);
            taskType.setAttribute("targetNamespace", (Object)nameSpace);
            taskType.addNamespaceMapping("tns", nameSpace);
        }
    }

    private void selectionChanged(JComboBox combo) {
        TaskFlowComboItem taskFlowTemplateComboItem = (TaskFlowComboItem)combo.getSelectedItem();
        String uiTemplate = taskFlowTemplateComboItem.getUiTemplate();
        this.descriptionTextArea.setText(taskFlowTemplateComboItem.getDescription());
        String name = taskFlowTemplateComboItem.getTemplateID().replaceAll(" ", "");
        name = name.replace('(', '_');
        this.generatedScopeNamePrefix = name = name.replace(')', '_');
        this.generatedVarNamePrefix = name + "Var";
        this.generateAndSetVarConfigAndScopeNames();
        this.updateTaskType();
        this.bTaskFlowSelected = taskFlowTemplateComboItem.getName() != null && !taskFlowTemplateComboItem.getName().trim().equalsIgnoreCase("");
        this.m_wcontext._map.put(TaskFlowWizardContext.TASK_FLOW_UI_TEMPLATE_KEY, uiTemplate);
        this.m_wcontext._map.put(TaskFlowWizardContext.TASK_FLOW_TEMPLATE_ID, taskFlowTemplateComboItem.getTemplateID());
        this.m_wcontext._map.put(TaskFlowWizardContext.TASK_FLOW_TEMPLATE_NAME, taskFlowTemplateComboItem.getLocalizedName());
        this.m_wcontext._map.put("scopeNameParam", this.scopeNameText.getText());
        this.setTaskVar();
        this.scopeNameText.getDocument().addDocumentListener(this);
        this.checkDoc(null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.scopeNameText.getDocument().removeDocumentListener(this);
        if (e.getSource() instanceof JComboBox && ((JComboBox)e.getSource()).getActionCommand().equalsIgnoreCase("VarNameCombo")) {
            JComboBox varCombo = (JComboBox)e.getSource();
            this.bVarNameNotEmpty = varCombo.getSelectedIndex() > 0;
        }
        if (e.getSource() instanceof JComboBox && ((JComboBox)e.getSource()).getActionCommand().equalsIgnoreCase("TaskFlowCombo") && !this.m_popupVisible) {
            this.selectionChanged((JComboBox)e.getSource());
        }
        this.checkDoc(null);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        this.m_popupVisible = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        this.m_popupVisible = false;
        this.selectionChanged(cb);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
        JComboBox cb = (JComboBox)evt.getSource();
        this.m_popupVisible = false;
    }

    @Override
    public void buildPayload() {
        System.out.println("in TaskFlowSelectionPage buildPayload");
        Boolean continuation = (Boolean)this.m_wcontext._map.get("continueTaskParam");
        this.m_wcontext._map.put("scopeNameParam", this.scopeNameText.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        String tempstr;
        if (e != null && e.getDocument().equals(this.scopeNameText.getDocument())) {
            this.generateAndSetVarName();
        }
        this.bVarNameNotEmpty = (tempstr = this.varNameText.getText()) != null && tempstr.length() > 0;
        String tempstr2 = this.scopeNameText.getText();
        this.bScopeNameNotEmpty = tempstr2 != null && tempstr2.length() > 0;
        this.m_wcontext._map.put("scopeNameParam", this.scopeNameText.getText());
        this.setCanAdvance();
    }

    private String getURLEncodedString(String pToEncode) {
        if (pToEncode == null) {
            return pToEncode;
        }
        String _retVal = pToEncode;
        try {
            _retVal = URLEncoder.encode(pToEncode, "UTF-8").replaceAll("%", "-");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return _retVal;
    }

    private void generateAndSetVarName() {
        Boolean continuation = (Boolean)this.m_wcontext._map.get("continueTaskParam");
        if (continuation != null && continuation.booleanValue()) {
            return;
        }
        String scopeName = this.scopeNameText.getText();
        String varName = scopeName + "Var";
        BPELGraphPane pane = this.m_wcontext._pane;
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        Process process = model.getProcess();
        List varList = process.getVariables().getVariables();
        for (Variable var : varList) {
            String name = var.getName();
            if (!name.trim().equals(varName)) continue;
            varName = scopeName + "Var";
        }
        this.varNameText.setText(varName);
        this.m_wcontext._ttFileName = "taskConfig" + this.getURLEncodedString(scopeName) + ".xml";
        if (this.m_wcontext._ttwcontext != null) {
            ITaskType taskType = this.m_wcontext._ttwcontext.getTaskType();
            taskType.setAttribute("name", (Object)this.m_wcontext._ttFileName);
        }
    }

    private void setCanAdvance() {
        if (this.bVarNameNotEmpty && this.bScopeNameNotEmpty && this.bTaskFlowSelected) {
            this.m_page.setCanAdvance(true);
        } else {
            this.m_page.setCanAdvance(false);
        }
    }

    private void setHelp(ImageWizardPage pWizardPage) {
        TaskHelpUtil.setHelp((WizardPage)pWizardPage);
    }

    private void setHelp(List pListOfWizardPages) {
        if (pListOfWizardPages != null) {
            for (ImageWizardPage _page : pListOfWizardPages) {
                this.setHelp(_page);
            }
        }
    }

    public void setTaskVar() {
        Boolean advanced;
        String taskPrefix;
        String packageLocation;
        String strXSDFileName;
        ArrayList<ImageWizardPage> _listOfImageWizards = new ArrayList<ImageWizardPage>();
        BPELGraphPane pane = this.m_wcontext._pane;
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        Process process = model.getProcess();
        boolean bUserTask20 = false;
        String templateID = (String)this.m_wcontext._map.get(TaskFlowWizardContext.TASK_FLOW_TEMPLATE_ID);
        if (templateID.trim().equalsIgnoreCase("UserTask2.0")) {
            bUserTask20 = true;
        }
        if (bUserTask20) {
            strXSDFileName = "Task.xsd";
            packageLocation = "oracle/tip/pc/services/wsdl/collaxa/" + strXSDFileName.trim();
            taskPrefix = process.addNamespace("http://services.oracle.com/bpel/task", "ctask");
        } else {
            strXSDFileName = "WorkflowTask.xsd";
            packageLocation = "oracle/tip/pc/services/wsdl/" + strXSDFileName.trim();
            taskPrefix = process.addNamespace("http://xmlns.oracle.com/pcbpel/taskservice/task", "task");
        }
        try {
            URL prjDir = URLFileSystem.getParent((URL)this.m_wcontext._project.getURL());
            Project project = Context.newIdeContext().getProject();
            File outputXsdFile = new File(new File(this.m_wcontext.m_bpelProject.getBPELDirectoryURL().getFile()), strXSDFileName);
            if (!outputXsdFile.exists()) {
                InputStream ipXsdFile = TaskFlowWizardUtil.getClassLoader().getResource(packageLocation).openStream();
                outputXsdFile.createNewFile();
                TaskFlowWizardUtil.copy(ipXsdFile, outputXsdFile);
                if (this.m_wcontext._project != null) {
                    URL outputXsdFileURL = URLFactory.newFileURL((File)outputXsdFile);
                    Node xsdNode = NodeFactory.findOrCreate(XMLSourceNode.class, (URL)outputXsdFileURL);
                    this.m_wcontext._project.add((Element)xsdNode, true);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getStackTrace());
        }
        String prevVarName = (String)this.m_wcontext._map.get("taskVariableNameParam");
        if (prevVarName != null && !prevVarName.trim().equals("")) {
            Variables vars = process.getVariables();
            List lst = vars.getVariables();
            for (Variable v : lst) {
                String name = v.getName();
                if (name == null || !name.equals(prevVarName.trim())) continue;
                process.getVariables().deleteVariable(v);
                break;
            }
        }
        String curVarName = this.varNameText.getText();
        this.m_wcontext._map.put("taskVariableNameParam", curVarName);
        Variable v = (Variable)BPELParser.createImplementation(Variable.class);
        if (curVarName != null && !curVarName.trim().equals("")) {
            if (bUserTask20) {
                String taskPrefixCollaxa = process.addNamespace("http://services.oracle.com/bpel/task", "ctask");
                QName qName = new QName("http://services.oracle.com/bpel/task", "task", taskPrefixCollaxa);
                v.setName(this.m_wcontext._map.get("taskVariableNameParam").toString());
                v.setElement(qName);
            } else {
                QName qName = new QName("http://xmlns.oracle.com/pcbpel/taskservice/task", "task", "task");
                v.setName(curVarName);
                v.setElement(qName);
            }
            this.m_wcontext._ttwcontext.setTaskVar(v);
        }
        process.getVariables().addVariable(v);
        this.removePages();
        Boolean continuation = (Boolean)this.m_wcontext._map.get("continueTaskParam");
        if (continuation == null) {
            continuation = new Boolean(false);
        }
        if ((advanced = (Boolean)this.m_wcontext._map.get(UIConstant.TASK_TYPE_ADVANCED_OPTION)) == null) {
            advanced = new Boolean(false);
        }
        if (!bUserTask20) {
            TaskFlowSelectionPage taskFlowSelectionPage = this;
            ImageWizardPage iwptf1 = new ImageWizardPage(null, taskFlowSelectionPage.m_wcontext._getImage(), TaskFlowConstants.WIZARD_PAGE_TITLE_TASK_DETAILS_FIRST);
            TaskDetailsFirstPage tdf = new TaskDetailsFirstPage(this.m_wcontext, iwptf1, this.m_wcontext._map);
            _listOfImageWizards.add(iwptf1);
            if (!continuation.booleanValue()) {
                if (advanced.booleanValue()) {
                    TaskFlowSelectionPage taskFlowSelectionPage2 = this;
                    ImageWizardPage iwptf2 = new ImageWizardPage(null, taskFlowSelectionPage2.m_wcontext._getImage(), TaskFlowConstants.WIZARD_PAGE_TITLE_TASK_DETAILS_SECOND);
                    TaskDetailsSecondPage tds = new TaskDetailsSecondPage(this.m_wcontext, iwptf2, this.m_wcontext._map);
                    _listOfImageWizards.add(iwptf2);
                }
                TaskFlowSelectionPage taskFlowSelectionPage3 = this;
                ImageWizardPage iwpg3 = new ImageWizardPage(null, taskFlowSelectionPage3.m_wcontext._getImage(), UIConstant.TASK_TYPE_CONCLUSION_PAGE);
                ConclusionPage cpage = new ConclusionPage(this.m_wcontext, iwpg3);
                _listOfImageWizards.add(iwpg3);
                TaskFlowSelectionPage taskFlowSelectionPage4 = this;
                ImageWizardPage iwpg4 = new ImageWizardPage(null, taskFlowSelectionPage4.m_wcontext._getImage(), UIConstant.TASK_TYPE_NOTIFICATION_PAGE);
                NotificationPage npage = new NotificationPage(this.m_wcontext, iwpg4);
                _listOfImageWizards.add(iwpg4);
                if (advanced.booleanValue()) {
                    TaskFlowSelectionPage taskFlowSelectionPage5 = this;
                    ImageWizardPage iwpg5 = new ImageWizardPage(null, taskFlowSelectionPage5.m_wcontext._getImage(), UIConstant.TASK_TYPE_FLEXFIELD_PAGE);
                    FlexFieldPage fpage = new FlexFieldPage(this.m_wcontext, iwpg5);
                    _listOfImageWizards.add(iwpg5);
                    TaskFlowSelectionPage taskFlowSelectionPage6 = this;
                    ImageWizardPage iwpg6 = new ImageWizardPage(null, taskFlowSelectionPage6.m_wcontext._getImage(), UIConstant.TASK_TYPE_RESTRICTED_ACTION_PAGE);
                    RestrictedActionPage rpage = new RestrictedActionPage(this.m_wcontext, iwpg6);
                    _listOfImageWizards.add(iwpg6);
                    TaskFlowSelectionPage taskFlowSelectionPage7 = this;
                    ImageWizardPage iwpg7 = new ImageWizardPage(null, taskFlowSelectionPage7.m_wcontext._getImage(), UIConstant.TASK_TYPE_VERSION_TRACKING_PAGE);
                    VersionTrackingPage vpage = new VersionTrackingPage(this.m_wcontext, iwpg7);
                    _listOfImageWizards.add(iwpg7);
                }
            }
        }
        this.addGeneratedPages(this);
        this.setHelp(_listOfImageWizards);
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        this.setTaskVar();
        String scopeName = this.scopeNameText.getText();
        if (this.checkScopeExists(scopeName)) {
            MultiLineOptionPane.showMessageDialog((Component)this, (Object)BPELStringTranslator.formatString("SCOPE_NAME_EXISTS_MESSAGE", scopeName));
            ((Cancelable)event).cancel();
            return;
        }
    }

    protected boolean checkVarExists(String varName) {
        BPELGraphPane pane = this.m_wcontext._pane;
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        Process process = model.getProcess();
        List varList = process.getVariables().getVariables();
        for (Variable var : varList) {
            String name = var.getName();
            if (!name.trim().equals(varName)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkScopeExists(String scopeName) {
        BPELGraphPane pane = this.m_wcontext._pane;
        BPELGraphModel model = (BPELGraphModel)pane.getModel();
        Process process = model.getProcess();
        for (Activity a : BPELModelUtil.getAllActivities((Scope)process)) {
            String curSopeName;
            if (!(a instanceof Scope) || !(curSopeName = a.getName()).trim().equalsIgnoreCase(scopeName)) continue;
            return true;
        }
        return false;
    }
}

