/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.tip.pc.services.hw.task.tasktype.ITask;
import oracle.tip.pc.services.hw.task.tasktype.ITaskType;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.jdev.JDevHelper;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskFlowWizardPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.TaskFlowWizardUtil;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.tasktype.common.UIConstant;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class TaskDetailsSecondPage
extends TaskFlowWizardPage
implements ActionListener,
ItemListener,
DocumentListener {
    Map attributeMap;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JTextField expirationDurationTxt = new JTextField();
    private MultiLineLabel m_explanation2;
    private JLabel lblPriority = new JLabel();
    private JComboBox priorityTxt = new JComboBox();
    private JTextField jspUrlTxt = new JTextField();
    private boolean m_isPreviewMode = false;
    String previewProperty = System.getProperty("preview_mode");
    private JCheckBox mCResourceBox = new JCheckBox();
    private JTextField mAResourceLocation = new JTextField();
    private JButton mBResourceBrowse = new JButton(ImageCache.getIcon("jdev_folder"));
    private JLabel mLResourceLocation = new JLabel();
    private JLabel jLabel1 = new JLabel();
    private JScrollPane m_idXPathScrollPane;
    private XPathEditorPane m_idXPathBuilder;
    private JScrollPane m_taskOwnerXPathScrollPane;
    private XPathEditorPane m_taskOwnerXPathBuilder;
    private String m_separator = " - ";
    private JButton m_ownerExpBuilderBtn;
    private JButton m_IDExpBuilderBtn;

    public TaskDetailsSecondPage(TaskFlowWizardContext wcontext, ImageWizardPage iwp, Map map) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.attributeMap = new HashMap();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.createExpBuilderBtn();
        if (this.previewProperty != null) {
            this.m_isPreviewMode = Boolean.valueOf(this.previewProperty);
        }
        JLabel lblIDKey = new JLabel();
        JLabel lblOwner = new JLabel();
        this.priorityTxt.addItem("1" + this.m_separator + BPELStringTranslator.getString("PRIORITY_HIGHEST"));
        this.priorityTxt.addItem("2" + this.m_separator + BPELStringTranslator.getString("PRIORITY_HIGH"));
        this.priorityTxt.addItem("3" + this.m_separator + BPELStringTranslator.getString("PRIORITY_NORMAL"));
        this.priorityTxt.addItem("4" + this.m_separator + BPELStringTranslator.getString("PRIORITY_LOW"));
        this.priorityTxt.addItem("5" + this.m_separator + BPELStringTranslator.getString("PRIORITY_LOWEST"));
        this.priorityTxt.setSelectedIndex(2);
        this.m_explanation2 = new MultiLineLabel(WordWrapper.getTextWrapper(), BPELStringTranslator.getString("SPECIFY_OPTIONAL_TASK_DETAILS"));
        this.setLayout(this.gridBagLayout1);
        this.jLabel1.setText(BPELStringTranslator.getString("JSP_URL_TASK_DISPLAY"));
        String initXPath = "";
        BPELXmlModel mainModel = this.m_wcontext._pane.getBPELXmlModel();
        VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_wcontext._renderer.getNode().getParentNode().getUserObject());
        this.m_taskOwnerXPathBuilder = new XPathEditorPane();
        this.m_taskOwnerXPathBuilder.initializeEditorPane((VariableDataCallBack)dataCallBack, initXPath, this.getNSResolver(), true, false);
        this.m_taskOwnerXPathScrollPane = new JScrollPane((Component)this.m_taskOwnerXPathBuilder, 21, 31);
        this.m_taskOwnerXPathBuilder.setEditable(true);
        ResourceUtils.resLabel((JLabel)lblOwner, (Component)this.m_taskOwnerXPathBuilder, (String)BPELStringTranslator.getString("TASK_OWNER"));
        JToolBar tbOwner = new JToolBar();
        tbOwner.setFloatable(false);
        tbOwner.add(this.m_ownerExpBuilderBtn);
        JPanel ownerPanel = new JPanel(new GridBagLayout());
        ownerPanel.add((Component)lblOwner, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        ownerPanel.add((Component)this.m_taskOwnerXPathScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        ownerPanel.add((Component)tbOwner, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)ownerPanel, new GridBagConstraints(0, 3, 7, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_idXPathBuilder = new XPathEditorPane();
        this.m_idXPathBuilder.initializeEditorPane((VariableDataCallBack)dataCallBack, initXPath, this.getNSResolver(), true, true);
        this.m_idXPathScrollPane = new JScrollPane((Component)this.m_idXPathBuilder, 21, 31);
        this.m_idXPathBuilder.setEditable(true);
        JToolBar tbID = new JToolBar();
        tbID.setFloatable(false);
        tbID.add(this.m_IDExpBuilderBtn);
        ResourceUtils.resLabel((JLabel)lblIDKey, (Component)this.m_idXPathBuilder, (String)BPELStringTranslator.getString("TASK_IDENTIFICATION_KEY"));
        JPanel idPanel = new JPanel(new GridBagLayout());
        idPanel.add((Component)lblIDKey, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        idPanel.add((Component)this.m_idXPathScrollPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        idPanel.add((Component)tbID, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)idPanel, new GridBagConstraints(0, 4, 7, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.mLResourceLocation, (Component)this.mAResourceLocation, (String)UIConstant.TASK_TYPE_RESOURCE_LOCATION);
        ResourceUtils.resLabel((JLabel)this.jLabel1, (Component)this.jspUrlTxt, (String)BPELStringTranslator.getString("JSP_URL_TASK_DISPLAY"));
        ResourceUtils.resLabel((JLabel)this.lblPriority, (Component)this.priorityTxt, (String)BPELStringTranslator.getString("TASK_PRIORITY"));
        this.add((Component)this.lblPriority, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.priorityTxt, new GridBagConstraints(1, 2, 6, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.mAResourceLocation, new GridBagConstraints(1, 6, 5, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.mBResourceBrowse.setContentAreaFilled(false);
        this.add((Component)this.mBResourceBrowse, new GridBagConstraints(6, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jLabel1, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jspUrlTxt, new GridBagConstraints(1, 5, 6, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.mLResourceLocation.setText(BPELStringTranslator.getString("RESOURCE_BUNDLE_LOC"));
        this.add((Component)this.mLResourceLocation, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 0), 0, 0));
        Component lBox = Box.createGlue();
        this.gridBagLayout1.setConstraints(lBox, new GridBagConstraints(0, 7, 0, 0, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(lBox);
        this.mAResourceLocation.setVisible(this.m_isPreviewMode);
        this.mBResourceBrowse.setVisible(this.m_isPreviewMode);
        this.mLResourceLocation.setVisible(this.m_isPreviewMode);
        this.jLabel1.setVisible(this.m_isPreviewMode);
        this.jspUrlTxt.setVisible(this.m_isPreviewMode);
        this.mCResourceBox.setText(UIConstant.TASK_TYPE_RESOURCE_CHECKBOX);
        this.mCResourceBox.setSelected(false);
        this.mBResourceBrowse.addActionListener(this);
        this.mCResourceBox.addItemListener(this);
        this.mAResourceLocation.getDocument().addDocumentListener(this);
        this.m_page.setCanAdvance(true);
    }

    private void createExpBuilderBtn() {
        this.m_IDExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_IDExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_IDExpBuilderBtn.addActionListener(this);
        this.m_ownerExpBuilderBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
        this.m_ownerExpBuilderBtn.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
        this.m_ownerExpBuilderBtn.addActionListener(this);
    }

    private void setResourceComponentVisible(boolean visible) {
        Object inset = null;
        this.mAResourceLocation.setVisible(visible);
        this.mBResourceBrowse.setVisible(visible);
        this.mLResourceLocation.setVisible(visible);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_IDExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_idXPathBuilder, true);
        } else if (e.getSource() == this.m_ownerExpBuilderBtn) {
            this.invokeGraphicalXPathBuilder(this.m_taskOwnerXPathBuilder, false);
        }
        if (e.getSource() == this.mBResourceBrowse) {
            URLChooser chooser = JDevHelper.getURLChooser();
            chooser.setSelectionScope(0);
            chooser.clearChooseableURLFilters();
            chooser.addChooseableURLFilter((URLFilter)new WildcardURLFilter("*.properties"));
            int ret = chooser.showOpenDialog((Component)this);
            if (ret == 0) {
                URL url = chooser.getSelectedURL();
                this.mAResourceLocation.setText(url.getPath());
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getSource().equals(this.mCResourceBox)) {
            this.setResourceComponentVisible(this.mCResourceBox.isSelected());
        }
        this.setCanAdvance();
    }

    @Override
    public void wizardValidatePage(WizardEvent event) {
        block4: {
            if (!this.m_isPreviewMode) {
                return;
            }
            String urlStr = this.jspUrlTxt.getText().trim();
            if (!urlStr.equals("")) {
                try {
                    URL url = new URL(urlStr);
                    url.getContent();
                }
                catch (Exception exc) {
                    int option = JOptionPane.showConfirmDialog(this, BPELStringTranslator.formatString("INVALID_URL", urlStr), null, 2, 2);
                    if (option != 2) break block4;
                    ((Cancelable)event).cancel();
                    return;
                }
            }
        }
    }

    @Override
    public void buildPayload() {
        System.out.println("in TaskDetailsSecondPage buildPayload");
        try {
            String owner;
            ITaskType taskType = this.m_wcontext._ttwcontext.getTaskType();
            ITask parentNode = taskType.getTask();
            if (this.m_isPreviewMode) {
                String resourceFile;
                String worklistJSP = this.jspUrlTxt.getText().trim();
                if (!worklistJSP.equals("")) {
                    parentNode.setJsp(worklistJSP);
                }
                if (!(resourceFile = this.mAResourceLocation.getText().trim()).equals("")) {
                    taskType.setAttribute("resourceBundleLocation", (Object)resourceFile);
                    URL prjDir = URLFileSystem.getParent((URL)this.m_wcontext._project.getURL());
                    File inputFile = new File(resourceFile);
                    String ipFileName = inputFile.getName();
                    InputStream ipFile = inputFile.toURL().openStream();
                    File outputFile = new File(new File(this.m_wcontext.m_bpelProject.getBPELDirectoryURL().getFile()), ipFileName);
                    outputFile.createNewFile();
                    TaskFlowWizardUtil.copy(ipFile, outputFile);
                }
            }
            if (!(owner = this.m_taskOwnerXPathBuilder.getText().trim()).equals("")) {
                this.addCopyRule("/task:task/task:owner", owner);
            }
            this.m_wcontext._ttwcontext.setIsResourceSelected(this.mCResourceBox.isSelected());
            String str = this.priorityTxt.getSelectedItem().toString();
            if (!str.equals("")) {
                this.addCopyRule("/task:task/task:priority", "number('" + str.substring(0, 1) + "')");
            }
            if (!(str = this.m_idXPathBuilder.getText()).equals("")) {
                this.addCopyRule("/task:task/task:identificationKey", TaskFlowWizardUtil.parseLiteralAndXpath(str));
            }
        }
        catch (Exception e) {
            System.out.println("in TaskDetailsSecondPage");
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        this.setCanAdvance();
    }

    private void setCanAdvance() {
        boolean canAdvance = true;
        if (this.mCResourceBox.isSelected() && this.mAResourceLocation.getText().trim().equals("")) {
            canAdvance = false;
        }
        this.m_page.setCanAdvance(canAdvance);
    }
}

