/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.ide.Ide;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.Attribute;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.Choice;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.Group;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.Option;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.TaskFlowUITemplateNode;
import oracle.tip.pc.services.hw.task.tasktype.ITaskType;
import oracle.tip.tools.ide.common.bpelparser.BPELParser;
import oracle.tip.tools.ide.common.bpelparser.iface.Activity;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.bpelparser.iface.From;
import oracle.tip.tools.ide.common.bpelparser.iface.To;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.xpath.editor.XPathEditorPane;
import oracle.tip.tools.ide.common.xpath.editor.util.VariableDataCallBack;
import oracle.tip.tools.ide.pm.addin.model.BPELXmlModel;
import oracle.tip.tools.ide.pm.addin.view.JDevBPELEditor;
import oracle.tip.tools.ide.pm.bpelgraph.editors.VariableDataCallBackImpl;
import oracle.tip.tools.ide.pm.bpelgraph.views.BPELGraphPane;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.MinMaxNumberTextField;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskFlowWizardPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.TaskFlowWizardUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class GroupPage
extends TaskFlowWizardPage
implements ActionListener,
DocumentListener,
ListSelectionListener {
    Group group;
    Map attributeMap;
    ButtonGroup bgroup;
    private List validateComponents = new ArrayList();

    public GroupPage(TaskFlowWizardContext wcontext, ImageWizardPage iwp, Group group, Map map) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.group = group;
            this.attributeMap = new HashMap();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static BPELXmlModel getPMModel(TaskFlowWizardContext ct) {
        BPELGraphPane graph = ct._pane;
        JDevBPELEditor editor = (JDevBPELEditor)SwingUtilities.getAncestorOfClass(JDevBPELEditor.class, (Component)((Object)graph));
        return editor.getPMGui().getXMLModel();
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        List attributes = this.group.getAttributes();
        List options = this.group.getChoices();
        JLabel explanation = new JLabel(this.getTranslatedString(this.group.getDisplay()));
        this.add((Component)explanation, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        JSeparator seperator = new JSeparator();
        seperator.setOpaque(true);
        this.add((Component)seperator, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.5, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        int y = 2;
        for (int i = 0; i < attributes.size(); ++i) {
            Object component;
            Attribute attribute = (Attribute)attributes.get(i);
            String id = attribute.getId();
            MultiLineLabel label = new MultiLineLabel(WordWrapper.getTextWrapper(), this.getTranslatedString(attribute.getText()));
            JButton button = null;
            int hSize = 0;
            if (attribute.getFieldLength() != null) {
                hSize = Integer.parseInt(attribute.getFieldLength());
            }
            if (attribute.hasDefault() && attribute.getMaxOccurs() != null && !attribute.getMaxOccurs().equalsIgnoreCase("unbounded")) {
                List list = this.getDefaultValues(attribute);
                component = new JComboBox();
                BasicComboBoxEditor comboEditor = new BasicComboBoxEditor();
                comboEditor.setItem("");
                ((JComboBox)component).setEditor(comboEditor);
                ((JComboBox)component).setEditable(true);
                Iterator iter = list.iterator();
                ((JComboBox)component).addItem("");
                while (iter.hasNext()) {
                    String listItem = (String)iter.next();
                    ((JComboBox)component).addItem(listItem);
                }
            } else if (attribute.hasDefault() && attribute.getMaxOccurs() != null && attribute.getMaxOccurs().equalsIgnoreCase("unbounded")) {
                List list = this.getDefaultValues(attribute);
                String[] strArray = list.toArray(new String[1]);
                JList<String> jList = new JList<String>(strArray);
                if (strArray.length >= 4) {
                    jList.setVisibleRowCount(4);
                } else {
                    jList.setVisibleRowCount(strArray.length);
                }
                JScrollPane optionPane = new JScrollPane(jList);
                component = optionPane;
                optionPane.setPreferredSize(jList.getPreferredScrollableViewportSize());
                optionPane.setMinimumSize(jList.getPreferredScrollableViewportSize());
                optionPane.setMaximumSize(jList.getPreferredScrollableViewportSize());
            } else if (attribute.getType().equalsIgnoreCase("int")) {
                component = hSize == 0 ? new NumberTextField() : new NumberTextField(hSize);
            } else if (attribute.getType().equalsIgnoreCase("float")) {
                MinMaxNumberTextField ntf = null;
                ntf = hSize == 0 ? new MinMaxNumberTextField() : new MinMaxNumberTextField(hSize);
                ntf.setDecimal(true);
                Double min = null;
                Double max = null;
                if (attribute.getMaxValue() != null) {
                    max = Double.valueOf(attribute.getMaxValue());
                }
                if (attribute.getMinValue() != null) {
                    min = Double.valueOf(attribute.getMinValue());
                }
                ntf.setMinMax(min, max);
                ntf.setSelectionStart(0);
                ntf.setSelectionEnd(0);
                component = ntf;
            } else if (attribute.getType().equalsIgnoreCase("boolean")) {
                component = new JCheckBox();
                ((JCheckBox)component).addActionListener(this);
                ((JCheckBox)component).setActionCommand(attribute.getId());
            } else if (attribute.getType().equalsIgnoreCase("expression")) {
                XPathEditorPane m_fromXPathBuilder = new XPathEditorPane();
                BPELXmlModel mainModel = this.m_wcontext._pane.getBPELXmlModel();
                VariableDataCallBackImpl dataCallBack = new VariableDataCallBackImpl(mainModel, (Activity)this.m_wcontext._renderer.getNode().getParentNode().getUserObject());
                String initXPath = (String)this.m_wcontext._map.get(id);
                m_fromXPathBuilder.initializeEditorPane((VariableDataCallBack)dataCallBack, initXPath, this.getNSResolver(), true, false);
                component = new JScrollPane((Component)m_fromXPathBuilder, 20, 30);
                m_fromXPathBuilder.setEditable(true);
                if (attribute.getMinOccurs().equals("1")) {
                    this.setMandatory((JComponent)m_fromXPathBuilder);
                }
                button = UIHelper.createModelerButton((Icon)ImageCache.getIcon("expressionbuilder"));
                button.setToolTipText(BPELStringTranslator.getString("XPATH_EXPRESSSION_BUILDER", "XPath Expression Builder"));
                button.addActionListener(this);
                button.setActionCommand(id);
            } else {
                component = new JTextField();
                if (this.m_wcontext._map.get(id) != null) {
                    ((JTextField)component).setText(this.m_wcontext._map.get(id).toString());
                }
            }
            if (attribute.getMinOccurs() != null && attribute.getMinOccurs().equals("1") && !attribute.getType().equalsIgnoreCase("boolean") && !attribute.getType().equalsIgnoreCase("expression")) {
                this.setMandatory((JComponent)component);
                this.m_page.setCanAdvance(false);
            }
            this.attributeMap.put(id, component);
            int height = 1;
            double yWeight = 0.1;
            if (i == attributes.size() - 1 && options.size() == 0) {
                yWeight = 1.0;
            }
            if (!(component instanceof JCheckBox)) {
                GraphUtils.addComponent((Container)this, (Component)label, (int)0, (int)y, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)yWeight);
                double xWeight = 2.0;
                int resize = 2;
                if (component instanceof JScrollPane && ((JScrollPane)component).getViewport().getComponent(0) instanceof XPathEditorPane) {
                    xWeight = 10.0;
                    height = 3;
                    resize = 1;
                    yWeight = 1.0;
                }
                GraphUtils.addComponent((Container)this, (Component)component, (int)1, (int)y, (int)1, (int)height, (int)18, (int)resize, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)xWeight, (double)yWeight);
            } else {
                GraphUtils.addComponent((Container)this, (Component)component, (int)0, (int)y, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.1);
                GraphUtils.addComponent((Container)this, (Component)label, (int)1, (int)y, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)0, (double)2.0, (double)yWeight);
            }
            if (button != null) {
                JToolBar tbTitle = new JToolBar();
                tbTitle.setFloatable(false);
                tbTitle.add(button);
                GraphUtils.addComponent((Container)this, (Component)tbTitle, (int)2, (int)y, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
            }
            y = y + height + 2;
        }
        AbstractButton firstButton = null;
        for (int i = 0; i < options.size(); ++i) {
            Choice choice = (Choice)options.get(i);
            List optionList = choice.getOptions();
            this.bgroup = new ButtonGroup();
            JSeparator choiceSeperator = new JSeparator();
            this.add((Component)choiceSeperator, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.5, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            JLabel choiceExplanation = new JLabel(this.getTranslatedString(choice.getDisplay()));
            this.add((Component)choiceExplanation, new GridBagConstraints(0, y++, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
            for (int j = 0; j < optionList.size(); ++j) {
                Option option = (Option)optionList.get(j);
                String display = this.getTranslatedString(option.getDisplay());
                String id = option.getId();
                JRadioButton button = new JRadioButton(display);
                this.attributeMap.put(id, button);
                if (firstButton == null) {
                    firstButton = button;
                }
                button.setActionCommand(id);
                button.setSelected(false);
                button.addActionListener(this);
                this.bgroup.add(button);
                GraphUtils.addComponent((Container)this, (Component)button, (int)0, (int)y, (int)1, (int)1, (int)18, (int)0, (Insets)new Insets(0, 0, 0, 0), (int)0, (int)0, (double)1.0, (double)0.1);
                ++y;
            }
            if (firstButton == null) continue;
            firstButton.setSelected(true);
        }
        List items = this.group.getSuccessors(this.m_wcontext._map);
        TaskFlowUITemplateNode elem = (TaskFlowUITemplateNode)items.get(0);
        this.m_wcontext._taskFlowWizUtil.addNextPage(elem, this);
    }

    private void setMandatory(JComponent component) {
        boolean add = true;
        if (component instanceof JComboBox) {
            KeyStrokeListener keyListner = new KeyStrokeListener();
            ((JComboBox)component).getEditor().getEditorComponent().addKeyListener(keyListner);
            ((JComboBox)component).addActionListener(this);
        } else if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(this);
        } else if (component instanceof JList) {
            ((JList)component).addListSelectionListener(this);
        } else if (component instanceof NumberTextField) {
            ((NumberTextField)component).getDocument().addDocumentListener(this);
        } else {
            add = false;
        }
        if (add) {
            this.validateComponents.add(component);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.validateDoc();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.validateDoc();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.validateDoc();
    }

    private void checkDoc(DocumentEvent e) {
        this.validateDoc();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.validateDoc();
    }

    public void validateDoc() {
        boolean canAdvance = true;
        for (int i = 0; i < this.validateComponents.size(); ++i) {
            JComponent component = (JComponent)this.validateComponents.get(i);
            if (component instanceof JComboBox) {
                String val = (String)((BasicComboBoxEditor)((JComboBox)component).getEditor()).getItem();
                ((JComboBox)component).setSelectedItem(val);
                if (!((String)((JComboBox)component).getSelectedItem()).equals("")) continue;
                canAdvance = false;
                continue;
            }
            if (component instanceof JList && ((JList)component).getSelectedIndex() == -1) {
                canAdvance = false;
                continue;
            }
            if ((component instanceof JTextField || component instanceof NumberTextField) && ((JTextField)component).getText().trim().equals("")) {
                canAdvance = false;
                continue;
            }
            if (!(component instanceof MinMaxNumberTextField)) continue;
            MinMaxNumberTextField ntf = (MinMaxNumberTextField)((Object)component);
            if (ntf.getText().trim().equals("")) {
                canAdvance = false;
                continue;
            }
            String str = ((NumberTextField)component).getText().trim();
            double val = Double.parseDouble(str);
            if (val < ntf.getMin()) {
                canAdvance = false;
            }
            if (!(val > ntf.getMax())) continue;
            canAdvance = false;
        }
        this.m_page.setCanAdvance(canAdvance);
    }

    private List getDefaultValues(Attribute attribute) {
        HashMap<String, ITaskType> map = new HashMap<String, ITaskType>();
        map.put("TASKTYPE", this.m_wcontext._ttwcontext.getTaskType());
        InputStream inputStream = null;
        try {
            File f = new File(Ide.getSystemDirectory(), "defaultUserTitles.xml");
            if (!f.exists()) {
                try {
                    inputStream = TaskFlowWizardUtil.getClassLoader().getResource("oracle/tip/pc/services/xml/defaultUserTitles.xml").openStream();
                    f = new File(Ide.getSystemDirectory() + "/" + "defaultUserTitles.xml");
                    f.createNewFile();
                    TaskFlowWizardUtil.copy(inputStream, f);
                    inputStream.close();
                }
                catch (Exception e) {
                    System.out.println(e.getStackTrace());
                }
            }
            inputStream = new FileInputStream(f);
        }
        catch (Exception exc) {
            System.out.println(exc.getStackTrace());
        }
        List list = attribute.getDefault(map, inputStream);
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            String componentId = ((JButton)e.getSource()).getActionCommand();
            JScrollPane expScrollpane = (JScrollPane)this.attributeMap.get(componentId);
            XPathEditorPane xpathEditorPane = (XPathEditorPane)expScrollpane.getViewport().getComponent(0);
            this.invokeGraphicalXPathBuilder(xpathEditorPane, false);
        } else {
            this.validateDoc();
        }
    }

    private void createPagesForType(JCheckBox checkBox) {
        if (checkBox.isSelected()) {
            this.m_wcontext._map.put(checkBox.getActionCommand(), Boolean.TRUE);
        } else {
            this.m_wcontext._map.put(checkBox.getActionCommand(), Boolean.FALSE);
        }
        List items = this.group.getSuccessors(this.m_wcontext._map);
        TaskFlowUITemplateNode elem = (TaskFlowUITemplateNode)items.get(0);
        this.m_wcontext._taskFlowWizUtil.addNextPage(elem, this);
    }

    @Override
    public void buildPayload() {
        for (String id : this.attributeMap.keySet()) {
            Object[] array;
            JList jlist;
            ArrayList value;
            JComponent comp = (JComponent)this.attributeMap.get(id);
            if (comp instanceof JComboBox) {
                System.out.println("put - " + id + " - " + ((JComboBox)comp).getSelectedItem().toString());
                value = (String)((JComboBox)comp).getSelectedItem();
            } else if (comp instanceof JTextField) {
                System.out.println("put - " + id + " - " + ((JTextField)comp).getText());
                value = ((JTextField)comp).getText();
            } else if (comp instanceof JCheckBox) {
                value = new Boolean(((JCheckBox)comp).isSelected());
                System.out.println("put - " + id + " - " + value);
            } else if (comp instanceof JScrollPane) {
                if (((JScrollPane)comp).getViewport().getComponent(0) instanceof XPathEditorPane) {
                    XPathEditorPane xpathEditor = (XPathEditorPane)((JScrollPane)comp).getViewport().getComponent(0);
                    value = xpathEditor.getText();
                } else if (((JScrollPane)comp).getViewport().getComponent(0) instanceof JList) {
                    jlist = (JList)((JScrollPane)comp).getViewport().getComponent(0);
                    value = new ArrayList();
                    array = jlist.getSelectedValues();
                    for (int i = 0; i < array.length; ++i) {
                        ((List)value).add(array[i]);
                    }
                } else {
                    value = "";
                }
            } else if (comp instanceof NumberTextField) {
                value = ((NumberTextField)comp).getText();
                System.out.println("put - " + id + " - " + value);
            } else if (comp instanceof JList) {
                jlist = (JList)comp;
                value = new ArrayList();
                array = jlist.getSelectedValues();
                for (int i = 0; i < array.length; ++i) {
                    if (array[i].toString().trim().equals("")) continue;
                    ((List)value).add(array[i]);
                }
            } else if (comp instanceof JRadioButton) {
                JRadioButton button = (JRadioButton)comp;
                value = "" + button.isSelected();
            } else {
                value = "";
            }
            if (id.startsWith(TaskFlowWizardContext.COPY_RULE_PREFIX)) {
                String toQuery = id.substring(TaskFlowWizardContext.COPY_RULE_PREFIX.length() + 1);
                Copy copyModel = (Copy)BPELParser.createImplementation(Copy.class);
                copyModel.createDOMElement(GroupPage.getPMModel(this.m_wcontext).getDocument(), "http://schemas.xmlsoap.org/ws/2003/03/business-process/", true);
                From fromModel = (From)BPELParser.createImplementation(From.class);
                To toModel = (To)BPELParser.createImplementation(To.class);
                fromModel.setExpression((String)((Object)value));
                toModel.setQuery(toQuery);
                String taskVarName = this.m_wcontext._map.get("taskVariableNameParam").toString();
                toModel.setVariable(taskVarName);
                copyModel.setFrom(fromModel);
                copyModel.setTo(toModel);
                this.m_wcontext._assign.addCopyRule(copyModel);
                continue;
            }
            if (comp instanceof NumberTextField && value instanceof String) {
                if (((String)((Object)value)).trim().equals("")) continue;
                if (!((NumberTextField)comp).isDecimal()) {
                    this.m_wcontext._map.put(id, new Integer((String)((Object)value)));
                    continue;
                }
                this.m_wcontext._map.put(id, new Double((String)((Object)value)));
                continue;
            }
            this.m_wcontext._map.put(id, value);
        }
    }

    class KeyStrokeListener
    implements KeyListener {
        KeyStrokeListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            GroupPage.this.validateDoc();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            GroupPage.this.validateDoc();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            GroupPage.this.validateDoc();
        }
    }
}

