/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.ide.util.ResourceUtils;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.AssigneesStatic;
import oracle.tip.pc.services.hw.task.taskflow.uitemplate.TaskFlowUITemplateNode;
import oracle.tip.tools.ide.common.bpelparser.iface.Copy;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.TaskFlowWizardContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.common.TaskFlowConstants;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.pages.TaskFlowWizardPage;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.AssigneeCopyGenerator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.util.SimpleTokenizer;

public class AssigneesStaticPage
extends TaskFlowWizardPage
implements ActionListener,
DocumentListener {
    AssigneesStatic assignees;
    Map attributeMap;
    protected JRadioButton m_aliasBtn;
    protected JRadioButton m_oidUserBtn;
    protected ButtonGroup m_bGroup;
    protected JButton m_browseOIDUserBtn;
    protected JTextField m_aliasText;
    protected JTextField m_OIDUserText;
    protected MultiLineLabel m_explanation;
    private JCheckBox groupCheck;
    protected JLabel m_lblOID;
    protected JLabel m_lblAlias;
    private static String GROUP_ACTION_CMD = "group";
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public AssigneesStaticPage(TaskFlowWizardContext wcontext, ImageWizardPage iwp, AssigneesStatic assignees, Map map) {
        try {
            this.setContextAndPage(wcontext, iwp);
            this.assignees = assignees;
            this.attributeMap = new HashMap();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        this.m_lblAlias = new JLabel();
        this.m_lblOID = new JLabel();
        this.groupCheck = new JCheckBox();
        this.m_explanation = new MultiLineLabel(WordWrapper.getTextWrapper(), TaskFlowConstants.WIZARD_PAGE_EXPLANATION_ASSIGNNES);
        this.m_aliasBtn = new JRadioButton();
        this.m_oidUserBtn = new JRadioButton();
        this.m_aliasBtn.addActionListener(this);
        this.m_oidUserBtn.addActionListener(this);
        this.m_browseOIDUserBtn = new JButton(new ImageIcon(UIHelper.loadImage((String)"images/flashlight14.png", UIHelper.class)));
        this.m_browseOIDUserBtn.addActionListener(this);
        this.m_aliasText = new JTextField();
        this.m_OIDUserText = new JTextField();
        this.add((Component)this.m_explanation, new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        JSeparator seperator = new JSeparator();
        seperator.setOpaque(true);
        this.add((Component)seperator, new GridBagConstraints(0, 1, 4, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        ResourceUtils.resLabel((JLabel)this.m_lblOID, (Component)this.m_OIDUserText, (String)BPELStringTranslator.getString("USERS"));
        ResourceUtils.resLabel((JLabel)this.m_lblAlias, (Component)this.m_aliasText, (String)BPELStringTranslator.getString("USER_ALIAS"));
        this.groupCheck.setText(BPELStringTranslator.getString("ASSIGN_TO_GROUP"));
        this.groupCheck.setActionCommand(GROUP_ACTION_CMD);
        this.groupCheck.addActionListener(this);
        JSeparator seperator2 = new JSeparator();
        seperator.setOpaque(true);
        this.m_OIDUserText.getDocument().addDocumentListener(this);
        this.m_aliasText.getDocument().addDocumentListener(this);
        this.add((Component)this.groupCheck, new GridBagConstraints(0, 2, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.m_aliasText, new GridBagConstraints(2, 6, 3, 1, 1.0, 1.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_lblAlias, new GridBagConstraints(2, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_aliasBtn, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 5), 0, 0));
        this.add((Component)this.m_OIDUserText, new GridBagConstraints(2, 4, 1, 1, 10.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_browseOIDUserBtn, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.m_oidUserBtn, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 5, 5), 0, 0));
        this.add((Component)this.m_lblOID, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.m_bGroup = new ButtonGroup();
        this.m_bGroup.add(this.m_aliasBtn);
        this.m_bGroup.add(this.m_oidUserBtn);
        this.m_oidUserBtn.setSelected(true);
        this.updateButtons();
        List items = this.assignees.getSuccessors(this.m_wcontext._map);
        TaskFlowUITemplateNode elem = (TaskFlowUITemplateNode)items.get(0);
        this.m_wcontext._taskFlowWizUtil.addNextPage(elem, this);
        this.setCanAdvance();
    }

    @Override
    public void buildPayload() {
        System.out.println("in buildPayload");
        String taskVarName = this.assignees.getVariable();
        String assigneeVarName = this.assignees.getVariable().trim();
        String assigneePart = this.assignees.getPart();
        String assigneeQuery = this.assignees.getQuery();
        try {
            if (this.groupCheck.isSelected()) {
                this.m_wcontext._map.put("areAssigneesGroupsParam", Boolean.TRUE);
            } else {
                this.m_wcontext._map.put("areAssigneesGroupsParam", Boolean.FALSE);
            }
            if (this.m_oidUserBtn.isSelected()) {
                ArrayList<String> entities = new ArrayList<String>();
                String semicolonSeperatedOIDs = "";
                semicolonSeperatedOIDs = this.m_OIDUserText.getText();
                SimpleTokenizer tokenizer = new SimpleTokenizer(semicolonSeperatedOIDs, ',');
                boolean hasTokens = true;
                while (hasTokens) {
                    try {
                        String token = tokenizer.nextToken().trim();
                        if (token == null || token.equals("")) continue;
                        entities.add(token);
                    }
                    catch (NoSuchElementException e) {
                        hasTokens = false;
                    }
                }
                List copies = assigneeVarName != null && !assigneeVarName.equals("") ? AssigneeCopyGenerator.generateCopyConstructsFromOID(this.m_wcontext, assigneeVarName, assigneePart, assigneeQuery, this.m_wcontext._map, entities, "areAssigneesGroupsParam") : AssigneeCopyGenerator.generateCopyConstructsFromOID(this.m_wcontext, taskVarName, null, null, this.m_wcontext._map, entities, "areAssigneesGroupsParam");
                for (Copy copyModel : copies) {
                    this.m_wcontext._assign.addCopyRule(copyModel);
                }
            } else if (this.m_aliasBtn.isSelected()) {
                List copies = assigneeVarName != null && !assigneeVarName.equals("") ? AssigneeCopyGenerator.generateCopyConstructsFromAlias(this.m_wcontext, assigneeVarName, assigneePart, assigneeQuery, this.m_wcontext._map, this.m_aliasText.getText(), "areAssigneesGroupsParam") : AssigneeCopyGenerator.generateCopyConstructsFromAlias(this.m_wcontext, taskVarName, null, null, this.m_wcontext._map, this.m_aliasText.getText(), "areAssigneesGroupsParam");
                for (Copy copyModel : copies) {
                    this.m_wcontext._assign.addCopyRule(copyModel);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception in AsigneesStaitc Page");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        LookupDialog dialog;
        boolean success;
        if (e.getSource().equals(this.m_browseOIDUserBtn) && (success = (dialog = !this.groupCheck.isSelected() ? new LookupDialog(0, this) : new LookupDialog(1, this)).showDialog())) {
            this.m_OIDUserText.setText(dialog.getSelectedPrinciple());
            this.m_oidUserBtn.setSelected(true);
        }
        if (e.getSource() instanceof JCheckBox && ((JCheckBox)e.getSource()).getActionCommand().equalsIgnoreCase(GROUP_ACTION_CMD)) {
            if (((JCheckBox)e.getSource()).isSelected()) {
                ResourceUtils.resLabel((JLabel)this.m_lblOID, (Component)this.m_OIDUserText, (String)BPELStringTranslator.getString("GROUP"));
                ResourceUtils.resLabel((JLabel)this.m_lblAlias, (Component)this.m_aliasText, (String)BPELStringTranslator.getString("GROUP_ALIAS"));
            } else {
                ResourceUtils.resLabel((JLabel)this.m_lblOID, (Component)this.m_OIDUserText, (String)BPELStringTranslator.getString("USERS"));
                ResourceUtils.resLabel((JLabel)this.m_lblAlias, (Component)this.m_aliasText, (String)BPELStringTranslator.getString("USER_ALIAS"));
            }
        }
        if (e.getSource() instanceof JRadioButton) {
            this.updateButtons();
        }
    }

    protected void updateButtons() {
        if (this.m_oidUserBtn.isSelected()) {
            this.m_aliasText.setEnabled(false);
            this.m_lblAlias.setEnabled(false);
            this.m_browseOIDUserBtn.setEnabled(true);
            this.m_OIDUserText.setEnabled(true);
            this.m_lblOID.setEnabled(true);
        } else if (this.m_aliasBtn.isSelected()) {
            this.m_aliasText.setEnabled(true);
            this.m_lblAlias.setEnabled(true);
            this.m_browseOIDUserBtn.setEnabled(false);
            this.m_OIDUserText.setEnabled(false);
            this.m_lblOID.setEnabled(false);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        this.setCanAdvance();
    }

    private void setCanAdvance() {
        boolean canAdvance = true;
        if (this.m_aliasBtn.isSelected() && this.m_aliasText.getText().trim().equals("")) {
            canAdvance = false;
        } else if (this.m_oidUserBtn.isSelected() && this.m_OIDUserText.getText().trim().equals("")) {
            canAdvance = false;
        }
        this.m_page.setCanAdvance(canAdvance);
    }
}

