/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.naming.InitialContext;
import javax.swing.JComboBox;
import oracle.bpel.services.common.ServiceFactory;
import oracle.bpel.services.identity.client.IdentityConfigServiceSOAPClient;
import oracle.bpel.services.identity.client.IdentityServiceSOAPClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.IWorkflowServiceClientConstants;
import oracle.bpel.services.workflow.client.WorkflowServiceClientContext;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.metadata.config.model.FlexfieldAttributeLabelType;
import oracle.bpel.services.workflow.metadata.config.model.ObjectFactory;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.runtimeconfig.IRuntimeConfigService;
import oracle.bpel.services.workflow.runtimeconfig.model.AttributeLabelType;
import oracle.bpel.services.workflow.runtimeconfig.model.LabelUsagesImpl;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.Presentation;
import oracle.rc.asadapter.connection.PresentationType;
import oracle.rc.asadapter.http.HttpConnectionManager;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.config.BPMIdentityConfigService;
import oracle.tip.tools.ide.fabric.asbrowser.ASBrowserHelper;
import oracle.tip.tools.ide.fabric.asbrowser.SOAServerObject;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.ConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;

public class LookupUtil {
    private static final String USER_NAME = BPELStringTranslator.getString("USER_NAME");
    private static final String FIRST_NAME = BPELStringTranslator.getString("FIRST_NAME");
    private static final String LAST_NAME = BPELStringTranslator.getString("LAST_NAME");
    private static final String EMAIL = BPELStringTranslator.getString("EMAIL");
    private static final String CELL_NO = BPELStringTranslator.getString("CELL_NO");
    private static final String HOME_NO = BPELStringTranslator.getString("HOME_NO");
    private static final String WORK_NO = BPELStringTranslator.getString("WORK_NO");
    private static final String MANAGER = BPELStringTranslator.getString("MANAGER");
    private static final String TITLE = BPELStringTranslator.getString("TITLE");
    private static final String GROUP_NAME = BPELStringTranslator.getString("GROUP_NAME");

    public static BPMIdentityService getIdentityServiceInstance(LookupConnectionNode connection, String realmName) {
        IdentityServiceSOAPClient srvSOAPClient = null;
        String SOAP_END_POINT_ROOT = LookupUtil.getSoapEndPoint(connection);
        if (SOAP_END_POINT_ROOT == null) {
            return null;
        }
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, SOAP_END_POINT_ROOT);
        WorkflowServiceClientContext m_clientContext = new WorkflowServiceClientContext(properties, null);
        srvSOAPClient = ServiceFactory.getIdentityServiceSOAPClientInstance((String)realmName, (WorkflowServiceClientContext)m_clientContext);
        return srvSOAPClient;
    }

    private static String getSoapEndPoint(LookupConnectionNode connection) {
        HostInfo hi = LookupUtil.getHostInfo(connection);
        if (hi == null) {
            return null;
        }
        if (hi.getHttpPort() == -1) {
            return null;
        }
        if (hi.getName() == null) {
            return null;
        }
        return hi.toString();
    }

    private static HostInfo getAdminServerInfo(AppServerConnection conn) {
        HostInfo hi = null;
        try {
            List l = ASBrowserHelper.listSOAServers((AppServerConnection)conn);
            for (SOAServerObject soa : l) {
                if (soa == null || !soa.isServerRunning() || soa.getHttpURL() == null) continue;
                hi = new HostInfo();
                hi.setName(soa.getHostName());
                hi.setHttpPort(soa.getPort());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HostInfo getHostInfo(LookupConnectionNode connection) {
        Presentation pres;
        AppServerConnection conn;
        HostInfo hi;
        block10: {
            HostInfo hostInfo;
            block9: {
                if (connection == null) {
                    return null;
                }
                hi = null;
                ConnectionNode node = connection.getConnNode();
                conn = null;
                pres = null;
                try {
                    AppServer selAppServ = AppServerManager.getInstance().getAppServer(node.getName());
                    conn = selAppServ.getConnection();
                    hi = LookupUtil.getAdminServerInfo(conn);
                    if (hi != null) {
                        hostInfo = hi;
                        if (pres == null) return hostInfo;
                        break block9;
                    }
                    pres = conn.getPresentation(PresentationType.HTTP);
                    HttpConnectionManager httpMgr = (HttpConnectionManager)pres.get();
                    String hostName = httpMgr.getHostname();
                    int port = httpMgr.getHttpPort();
                    hi = new HostInfo();
                    hi.setName(hostName);
                    hi.setHttpPort(port);
                    if (pres == null) return hi;
                    break block10;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    return hi;
                }
            }
            conn.releasePresentation(pres);
            return hostInfo;
        }
        conn.releasePresentation(pres);
        return hi;
        finally {
            if (pres != null) {
                conn.releasePresentation(pres);
            }
        }
    }

    private static WorkflowServiceClientContext toWorkflowServiceClientContext(LookupConnectionNode connection) {
        String SOAP_END_POINT_ROOT = LookupUtil.getSoapEndPoint(connection);
        if (SOAP_END_POINT_ROOT == null) {
            return null;
        }
        HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.MODE, "dynamic");
        properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, SOAP_END_POINT_ROOT);
        WorkflowServiceClientContext wscc = new WorkflowServiceClientContext(properties, null);
        return wscc;
    }

    public static BPMIdentityConfigService getIdentityConfigServiceInstance(LookupConnectionNode connection) {
        WorkflowServiceClientContext wscc = LookupUtil.toWorkflowServiceClientContext(connection);
        IdentityConfigServiceSOAPClient lCfgSrvSOAPClient = ServiceFactory.getIdentityConfigServiceSOAPClientInstance((WorkflowServiceClientContext)wscc);
        return lCfgSrvSOAPClient;
    }

    public static void addserachBy(JComboBox box, int lookupType) {
        if (lookupType == 0) {
            box.addItem(USER_NAME);
            box.addItem(FIRST_NAME);
            box.addItem(LAST_NAME);
            box.addItem(EMAIL);
            box.addItem(CELL_NO);
            box.addItem(HOME_NO);
            box.addItem(WORK_NO);
            box.addItem(MANAGER);
            box.addItem(TITLE);
        } else {
            box.addItem(GROUP_NAME);
        }
    }

    public static String getIdentityAttribute(String name) {
        if (name.equals(USER_NAME) || name.equals(GROUP_NAME)) {
            return "name";
        }
        if (name.equals(FIRST_NAME)) {
            return "firstName";
        }
        if (name.equals(LAST_NAME)) {
            return "lastName";
        }
        if (name.equals(EMAIL)) {
            return "email";
        }
        if (name.equals(CELL_NO)) {
            return "mobile";
        }
        if (name.equals(WORK_NO)) {
            return "workNumber";
        }
        if (name.equals(HOME_NO)) {
            return "homePhone";
        }
        if (name.equals(MANAGER)) {
            return "manager";
        }
        if (name.equals(TITLE)) {
            return "title";
        }
        return null;
    }

    public static List searchUser(Object connection, String attName, String value, String realmName) throws Exception {
        BPMIdentityService isc = LookupUtil.getIdentityServiceInstance((LookupConnectionNode)connection, realmName);
        return isc.searchUsers(attName, value);
    }

    public static List getRealms(LookupConnectionNode pNode) {
        ArrayList<String> l = new ArrayList<String>();
        BPMIdentityConfigService service = LookupUtil.getIdentityConfigServiceInstance(pNode);
        try {
            Set supportedRealms = service.getSupportedRealmNames();
            String defaultRealm = service.getDefaultRealmName();
            supportedRealms.remove(defaultRealm);
            l.addAll(supportedRealms);
            l.add(defaultRealm);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    public static InitialContext getInitialContext(LookupConnectionNode connection) {
        ConnectionNode node = connection.getConnNode();
        AppServer selAppServ = AppServerManager.getInstance().getAppServer(node.getName());
        AppServerConnection conn = selAppServ.getConnection();
        Presentation pres = conn.getPresentation(PresentationType.JNDI);
        InitialContext initialContext = (InitialContext)pres.get();
        return initialContext;
    }

    private static IWorkflowServiceClient getWorkflowClient(LookupConnectionNode connection) {
        IWorkflowServiceClient result = null;
        try {
            String SOAP_END_POINT_ROOT = LookupUtil.getSoapEndPoint(connection);
            HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String> properties = new HashMap<IWorkflowServiceClientConstants.CONNECTION_PROPERTY, String>();
            properties.put(IWorkflowServiceClientConstants.CONNECTION_PROPERTY.SOAP_END_POINT_ROOT, SOAP_END_POINT_ROOT);
            IWorkflowServiceClient serviceClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)"SOAP", properties, null);
            return serviceClient;
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }

    public static List<FlexfieldAttributeLabelType> listProtectedAttributeLabels(LookupConnectionNode connection) {
        return LookupUtil.listAttributeLabels(connection, "Protected");
    }

    public static List<FlexfieldAttributeLabelType> listAttributeLabels(LookupConnectionNode connection, String type) {
        ArrayList<FlexfieldAttributeLabelType> result = new ArrayList<FlexfieldAttributeLabelType>();
        try {
            IWorkflowServiceClient svcClient = LookupUtil.getWorkflowClient(connection);
            IRuntimeConfigService runtimeSvc = svcClient.getRuntimeConfigService();
            ITaskQueryService taskQSvc = svcClient.getTaskQueryService();
            if (taskQSvc != null) {
                Weblogic10Descriptor descriptor = connection.getConnNode().getConnectionDescriptor();
                IWorkflowContext wfContext = taskQSvc.authenticate(descriptor.getUserName(), descriptor.getPassword().toCharArray(), null);
                List usagesList = runtimeSvc.getAttributeLabelUsages(wfContext, type).getAttributeLabelUsages();
                ObjectFactory factory = new ObjectFactory();
                for (LabelUsagesImpl usages : usagesList) {
                    AttributeLabelType label = usages.getLabel();
                    FlexfieldAttributeLabelType newLabel = factory.createFlexfieldAttributeLabelType();
                    newLabel.setLabelName(label.getLabelName());
                    newLabel.setFlexfield(label.getTaskAttribute());
                    newLabel.setDescription(label.getDescription());
                    result.add(newLabel);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static class HostInfo {
        private String name = null;
        private int httpPort = -1;
        private boolean useSSL = false;

        HostInfo() {
        }

        private void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        private void setHttpPort(int httpPort) {
            this.httpPort = httpPort;
        }

        public int getHttpPort() {
            return this.httpPort;
        }

        public String toString() {
            String protocol = this.useSSL ? "https:" : "http:";
            return protocol + "//" + this.name + ":" + this.httpPort;
        }
    }
}

