/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMPrincipal;
import oracle.tip.pc.services.identity.BPMUser;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupPrinciple;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupUtil;

public class LookupUser
implements LookupPrinciple {
    private HashMap mUserConnMap = new HashMap();

    private Map getUserMap(LookupConnectionNode connection) {
        HashMap userMap = (HashMap)this.mUserConnMap.get(connection.toString());
        if (userMap == null) {
            userMap = new HashMap();
            this.mUserConnMap.put(connection.toString(), userMap);
        }
        return userMap;
    }

    @Override
    public String[] searchPrinciple(LookupConnectionNode connection, String attName, String value, String realmName) throws Exception {
        Map userMap = this.getUserMap(connection);
        BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
        List users = null;
        users = "manager".equals(attName) ? service.getReportees(value, 1) : service.searchUsers(attName, value);
        if (users == null) {
            users = new ArrayList();
        }
        int size = users.size();
        Object[] str = new String[size];
        for (int i = 0; i < size; ++i) {
            BPMUser user = (BPMUser)users.get(i);
            String key = user.getName();
            userMap.put(key, user);
            str[i] = key;
        }
        Arrays.sort(str);
        return str;
    }

    @Override
    public String getDetailInfo(LookupConnectionNode connection, String name, String realmName) throws Exception {
        if (name == null || name.trim().equals("")) {
            return "";
        }
        Map userMap = this.getUserMap(connection);
        BPMUser user = (BPMUser)userMap.get(name);
        if (user == null) {
            try {
                BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
                user = service.lookupUser(name);
                if (user != null) {
                    userMap.put(user.getName(), user);
                }
            }
            catch (BPMIdentityException e) {
                return null;
            }
        }
        String userInfo = this.getUserInfo(user);
        return userInfo;
    }

    private String getUserInfo(BPMUser user) {
        if (user == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        String sep = " :  ";
        String firstName = null;
        try {
            firstName = user.getFirstName();
        }
        catch (Exception e) {
            firstName = "";
        }
        if (firstName == null) {
            firstName = "";
        }
        String middleName = null;
        try {
            middleName = user.getMiddleName();
        }
        catch (Exception e) {
            middleName = "";
        }
        if (middleName == null) {
            middleName = "";
        }
        String lastName = null;
        try {
            lastName = user.getLastName();
        }
        catch (Exception e) {
            lastName = "";
        }
        if (lastName == null) {
            lastName = "";
        }
        Object[] args = new String[]{firstName, middleName, lastName};
        buffer.append(BPELStringTranslator.formatString("FULL_NAME", args)).append("\n");
        String guid = user.getName();
        if (guid == null) {
            guid = "";
        }
        buffer.append(BPELStringTranslator.formatString("GUID", guid)).append("\n");
        String title = null;
        try {
            title = user.getTitle();
        }
        catch (Exception e) {
            title = "";
        }
        if (title == null) {
            title = "";
        }
        buffer.append(BPELStringTranslator.formatString("USER_TITLE", title)).append("\n");
        String manager = null;
        try {
            manager = user.getManagerName();
        }
        catch (Exception e) {
            manager = "";
        }
        if (manager == null) {
            manager = "";
        }
        buffer.append(BPELStringTranslator.formatString("MANAGER2", manager)).append("\n");
        String email = null;
        try {
            email = user.getEmail();
        }
        catch (Exception e) {
            email = "";
        }
        if (email == null) {
            email = "";
        }
        buffer.append(BPELStringTranslator.formatString("EMAIL_MSG", email)).append("\n");
        String workPhone = null;
        try {
            workPhone = user.getWorkPhone();
        }
        catch (Exception e) {
            workPhone = "";
        }
        if (workPhone == null) {
            workPhone = "";
        }
        buffer.append(BPELStringTranslator.formatString("WORK_PHONE", workPhone)).append("\n");
        String cellPhone = null;
        try {
            cellPhone = user.getMobile();
        }
        catch (Exception e) {
            cellPhone = "";
        }
        if (cellPhone == null) {
            cellPhone = "";
        }
        buffer.append(BPELStringTranslator.formatString("CELL_PHONE", cellPhone)).append("\n");
        String country = null;
        try {
            country = user.getCountry();
        }
        catch (Exception e) {
            country = "";
        }
        if (country == null) {
            country = "";
        }
        buffer.append(BPELStringTranslator.formatString("COUNTRY", country)).append("\n");
        return buffer.toString();
    }

    @Override
    public String[] getReportees(LookupConnectionNode connection, String name, String realmName) throws Exception {
        Map userMap = this.getUserMap(connection);
        BPMUser user = (BPMUser)userMap.get(name);
        if (user != null) {
            name = user.getName();
        }
        BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
        List reportees = service.getReportees(name, 1);
        String[] str = null;
        int size = reportees.size();
        if (reportees != null) {
            str = new String[size];
            for (int i = 0; i < size; ++i) {
                BPMPrincipal pr = (BPMPrincipal)reportees.get(i);
                str[i] = pr.getName();
            }
        } else {
            str = new String[]{};
        }
        return str;
    }

    @Override
    public String[] getHierarchy(LookupConnectionNode connection, String name, String realmName) throws Exception {
        BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
        List chain = service.getManagementChain(name, null, null, -1);
        int size = chain.size();
        if (size == 0) {
            String[] hierarchy = new String[]{};
            return hierarchy;
        }
        String[] hirearchy = new String[size + 1];
        hirearchy[0] = name;
        for (int i = 0; i < chain.size(); ++i) {
            BPMPrincipal pr = (BPMPrincipal)chain.get(i);
            hirearchy[i + 1] = pr.getName();
        }
        return hirearchy;
    }

    @Override
    public void removeCache() {
        this.mUserConnMap.clear();
    }

    @Override
    public String[] getMembers(LookupConnectionNode connection, String name, String realmName) throws Exception {
        return null;
    }

    private BPMUser getUser(LookupConnectionNode connection, String userId) {
        Map userMap = this.getUserMap(connection);
        BPMUser user = (BPMUser)userMap.get(userId);
        return user;
    }

    @Override
    public String getEmailId(LookupConnectionNode connection, String userId) {
        BPMUser user = this.getUser(connection, userId);
        try {
            if (user != null) {
                return user.getEmail();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPager(LookupConnectionNode connection, String userId) {
        BPMUser user = this.getUser(connection, userId);
        try {
            if (user != null) {
                return user.getPager();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getFax(LookupConnectionNode connection, String userId) {
        BPMUser user = this.getUser(connection, userId);
        try {
            if (user != null) {
                return user.getFax();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPhone(LookupConnectionNode connection, String userId) {
        BPMUser user = this.getUser(connection, userId);
        try {
            if (user != null) {
                return user.getWorkPhone();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getIM(LookupConnectionNode connection, String userId) {
        BPMUser user = this.getUser(connection, userId);
        try {
            String imAddress;
            if (user != null && (imAddress = (String)user.getAttribute("im")) != null) {
                return imAddress;
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }
}

