/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.tip.pc.services.identity.BPMGroup;
import oracle.tip.pc.services.identity.BPMIdentityException;
import oracle.tip.pc.services.identity.BPMIdentityService;
import oracle.tip.pc.services.identity.BPMPrincipal;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupPrinciple;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupUtil;

public class LookupGroup
implements LookupPrinciple {
    private HashMap mGroupConnMap = new HashMap();

    private Map getGroupMap(LookupConnectionNode connection) {
        HashMap groupMap = (HashMap)this.mGroupConnMap.get(connection.toString());
        if (groupMap == null) {
            groupMap = new HashMap();
            this.mGroupConnMap.put(connection.toString(), groupMap);
        }
        return groupMap;
    }

    @Override
    public String[] searchPrinciple(LookupConnectionNode connection, String attName, String value, String realmName) throws Exception {
        Map groupMap = this.getGroupMap(connection);
        BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
        List groups = service.searchGroups(attName, value);
        int size = groups.size();
        Object[] str = new String[size];
        for (int i = 0; i < size; ++i) {
            BPMGroup group = (BPMGroup)groups.get(i);
            String key = group.getName();
            groupMap.put(key, group);
            str[i] = key;
        }
        Arrays.sort(str);
        return str;
    }

    @Override
    public String getDetailInfo(LookupConnectionNode connection, String name, String realmName) throws Exception {
        if (name == null || name.trim().equals("")) {
            return "";
        }
        Map groupMap = this.getGroupMap(connection);
        BPMGroup group = (BPMGroup)groupMap.get(name);
        if (group == null) {
            try {
                BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
                group = service.lookupGroup(name);
                if (group != null) {
                    groupMap.put(group.getName(), group);
                }
            }
            catch (BPMIdentityException ex) {
                return null;
            }
        }
        String groupInfo = this.getGroupInfo(group);
        return groupInfo;
    }

    private String getGroupInfo(BPMGroup group) {
        if (group == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        String sep = " :  ";
        String fullName = null;
        try {
            fullName = group.getFullName();
        }
        catch (Exception e) {
            fullName = "";
        }
        if (fullName == null) {
            fullName = "";
        }
        buffer.append(BPELStringTranslator.formatString("FULL_NAME2", fullName)).append("\n");
        String guid = group.getName();
        if (guid == null) {
            guid = "";
        }
        buffer.append(BPELStringTranslator.formatString("GUID", guid)).append("\n");
        String description = null;
        try {
            description = group.getDescription();
        }
        catch (Exception ex) {
            description = "";
        }
        if (description == null) {
            description = "";
        }
        buffer.append(BPELStringTranslator.formatString("DESCRIPTION_MSG", description)).append("\n");
        String email = null;
        try {
            email = group.getEmail();
        }
        catch (Exception ex) {
            email = "";
        }
        if (email == null) {
            email = "";
        }
        buffer.append(BPELStringTranslator.formatString("EMAIL_MSG", email)).append("\n");
        return buffer.toString();
    }

    @Override
    public String[] getMembers(LookupConnectionNode connection, String name, String realmName) throws Exception {
        Map groupMap = this.getGroupMap(connection);
        BPMIdentityService service = LookupUtil.getIdentityServiceInstance(connection, realmName);
        List grantees = service.getParticipants(name, false);
        int size = grantees.size();
        String[] members = new String[size];
        for (int i = 0; i < size; ++i) {
            BPMPrincipal pr = (BPMPrincipal)grantees.get(i);
            members[i] = pr.getName();
        }
        return members;
    }

    @Override
    public String[] getReportees(LookupConnectionNode connection, String name, String realmName) throws Exception {
        return null;
    }

    @Override
    public String[] getHierarchy(LookupConnectionNode connection, String name, String realmName) throws Exception {
        return null;
    }

    @Override
    public void removeCache() {
        this.mGroupConnMap.clear();
    }

    private BPMGroup getGroup(LookupConnectionNode connection, String groupId) {
        Map groupMap = this.getGroupMap(connection);
        BPMGroup group = (BPMGroup)groupMap.get(groupId);
        return group;
    }

    @Override
    public String getEmailId(LookupConnectionNode connection, String groupId) {
        BPMGroup group = this.getGroup(connection, groupId);
        try {
            if (group != null) {
                return group.getEmail();
            }
            return "";
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public String getPager(LookupConnectionNode connection, String userId) {
        return "";
    }

    @Override
    public String getFax(LookupConnectionNode connection, String userId) {
        return "";
    }

    @Override
    public String getPhone(LookupConnectionNode connection, String userId) {
        return "";
    }

    @Override
    public String getIM(LookupConnectionNode connection, String userId) {
        return "";
    }
}

