/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.server.connection.AppServer;
import oracle.jdeveloper.server.connection.AppServerManager;
import oracle.rc.asadapter.connection.AppServerConnection;
import oracle.rc.asadapter.connection.AppServerProvider;
import oracle.rc.asadapter.connection.ConnectionDescriptor;
import oracle.rc.asadapter.weblogic.connection.Weblogic10Descriptor;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.UIUtil;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.ConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionRenderer;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConstant;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDetailDialog;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupGroup;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupPrinciple;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupUser;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupUtil;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;
import org.apache.soap.SOAPException;

public class LookupDialog
implements ActionListener,
ItemListener {
    private static final String HELP_TOPIC = "bpmjdev_ident_lookup";
    public static final int USER_LOOKUP = 0;
    public static final int GROUP_LOOKUP = 1;
    private static final int LEFT_MARGIN = 5;
    private static final int RIGHT_MARGIN = 5;
    private JDialog mDialog = null;
    private static final int DIALOG_HEIGHT = 590;
    private static final int DIALOG_WIDTH = 610;
    int BAR_SEP_WIDTH = 10;
    int BAR_SEP_HEIGHT = 0;
    private JTextField mPatternTextField = null;
    private JComboBox mPatternComboBox = null;
    private JButton mLookupButton = null;
    private JComboBox mConnectionComboBox = null;
    private JButton mConnectionButton = null;
    private JScrollPane mScrollPane = null;
    private JButton mBackButton = null;
    private JButton mForwardButton = null;
    private JButton mHButton = null;
    private JButton mRButton = null;
    private JButton mSButton = null;
    private JButton mMButton = null;
    private JButton mSearchDButton = null;
    private JList mList = new JList();
    private JButton mSRButton = null;
    private JButton mSelectDButton = null;
    private JButton mOKButton = null;
    private JButton mCancelButton = null;
    private JButton mHelpButton = null;
    private JComboBox mRealmBox = null;
    private LookupPrinciple mLookupPrinciple = null;
    private List mComponents = new ArrayList();
    private int mCurrentIndex = 0;
    private String mSelectedPrinciple = null;
    private int mLookupType = -1;
    private boolean mIsMainWizard = true;
    private int mMouseDClick = 0;
    private Thread mRealmRunnable = null;
    private boolean mResult = true;
    private String mEmailAddress = null;
    private String mPhoneNumber = null;
    private String mFaxNumber = null;
    private String mPagerNumber = null;
    private String mIMId = null;
    public static int DEFAULT_LOOKUP = 0;
    public static int EMAIL_LOOKUP = 1;
    public static int VOICE_LOOKUP = 2;
    public static int FAX_LOOKUP = 3;
    public static int PAGER_LOOKUP = 4;
    public static int IM_LOOKUP = 5;
    public int mLooupDialogType = DEFAULT_LOOKUP;
    private JRadioButton mUserRButton = null;
    private JRadioButton mGroupRButton = null;
    private int mTopMargin = 0;
    private int mPatternRow = 0;
    private int mSearchRow = 0;
    private JPanel mSearchPanel = null;
    private JLabel mPatternLabel = null;
    private static final String HTML_BODY = "BODY";
    private static final String HTML_TITLE = "TITLE";
    private static final String HTML_GREATER = "&gt;";
    private static final String HTML_LESS = "&lt;";
    private static final String HTML_AMP = "&amp;";
    private static final String HTML_QUOT = "&quot;";
    private static final int MAX_ERRORLINE_OPTIONPANE = 10;
    private LookupConnectionNode mCurrentNode = null;
    private Object mRealmLock = new Object();

    public LookupDialog(int lookupType, Component comp) {
        this(lookupType, comp, DEFAULT_LOOKUP);
    }

    public LookupDialog(int lookupType, Component comp, int dialogType) {
        this.mLookupPrinciple = lookupType == 0 ? new LookupUser() : new LookupGroup();
        this.mLookupType = lookupType;
        this.mLooupDialogType = dialogType;
        this.init(comp);
    }

    public LookupDialog(Component comp, LookupConnectionNode lookup) {
        this.mLookupType = 0;
        this.mLookupPrinciple = new LookupUser();
        this.mIsMainWizard = false;
        this.mCurrentNode = lookup;
        this.init(comp);
    }

    private void init(Component comp) {
        this.mDialog = comp == null ? new JDialog() : new JDialog(GraphUtils.getFrame((Component)comp));
        UIUtil.enableCloseOnEscapeKey((JDialog)this.mDialog);
        this.mRealmBox = new JComboBox();
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        this.mRealmBox.setModel(model);
        this.mRealmBox.addItemListener(new LocalRealmItemListener());
        this.mDialog.setModal(true);
        this.mDialog.setSize(610, 590);
        this.mDialog.setTitle(LookupConstant.LOOKUP_DIALOG);
        Container dialogPanel = this.mDialog.getContentPane();
        dialogPanel.setLayout(new GridBagLayout());
        int row = 0;
        if (this.mIsMainWizard) {
            if (this.mLooupDialogType == EMAIL_LOOKUP) {
                this.addUserGroupRadioButton(row, dialogPanel);
                ++row;
            }
            this.addConnectionRow(row, dialogPanel);
            this.addRealmRow(++row, dialogPanel);
            this.mPatternRow = ++row;
            this.addPatternRow(row, dialogPanel);
            ++row;
        }
        this.mSearchRow = row;
        this.addSearchUserPanel(row, dialogPanel);
        ++row;
        if (this.mIsMainWizard) {
            this.addSelectedUserPanel(row, dialogPanel);
            ++row;
        }
        this.addOKCancelButton(row, dialogPanel);
        this.registerF1Listener();
    }

    protected void registerF1Listener() {
        AbstractAction f1Action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent pEvent) {
                LookupDialog.this.processHelpEvent();
            }
        };
        JRootPane rootPane = this.mDialog.getRootPane();
        KeyStroke f1 = KeyStroke.getKeyStroke(112, 0, false);
        rootPane.getInputMap(2).put(f1, "F1_KEY");
        rootPane.getActionMap().put("F1_KEY", f1Action);
    }

    private void addRealmRow(int row, Container dialogPanel) {
        JLabel label = new JLabel(BPELStringTranslator.getString("LOOKUP_REALM"));
        ResourceUtils.resLabel((JLabel)label, (Component)this.mRealmBox, (String)BPELStringTranslator.getString("LOOKUP_REALM"));
        GraphUtils.addComponent((Container)dialogPanel, (Component)label, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mRealmBox, (int)1, (int)row, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    private void addPatternRow(int row, Container dialogPanel) {
        this.mPatternLabel = new JLabel(LookupConstant.PATTERN);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mPatternLabel, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mPatternTextField = new JTextField("*");
        ResourceUtils.resLabel((JLabel)this.mPatternLabel, (Component)this.mPatternTextField, (String)LookupConstant.PATTERN);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mPatternTextField, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.mPatternComboBox = new JComboBox();
        this.mPatternComboBox.setAutoscrolls(true);
        LookupUtil.addserachBy(this.mPatternComboBox, this.mLookupType);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mPatternComboBox, (int)2, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 0), (int)0, (int)0, (double)1.0, (double)0.0);
        this.mLookupButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("application/bpel/document_view.png"));
        this.mLookupButton.setToolTipText(LookupConstant.LOOKUP_BUTTON);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mLookupButton, (int)3, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mLookupButton.addActionListener(this);
    }

    private void addUserGroupRadioButton(int row, Container dialogPanel) {
        this.mUserRButton = new JRadioButton(LookupConstant.USER);
        this.mUserRButton.setSelected(true);
        this.mGroupRButton = new JRadioButton(LookupConstant.GROUP);
        ButtonGroup group = new ButtonGroup();
        group.add(this.mUserRButton);
        group.add(this.mGroupRButton);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mUserRButton, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(15, 50, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mGroupRButton, (int)1, (int)row, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(15, 0, 0, 0), (int)1, (int)1, (double)0.0, (double)0.0);
        this.mUserRButton.addItemListener(this);
        this.mGroupRButton.addItemListener(this);
    }

    private void addConnectionRow(int row, Container dialogPanel) {
        JLabel connLbl = new JLabel(LookupConstant.CONNECTION);
        GraphUtils.addComponent((Container)dialogPanel, (Component)connLbl, (int)0, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 10, 0, 0), (int)0, (int)0, (double)0.0, (double)0.0);
        this.mConnectionComboBox = new JComboBox();
        this.mConnectionComboBox.setRenderer(new LookupConnectionRenderer());
        ResourceUtils.resLabel((JLabel)connLbl, (Component)this.mConnectionComboBox, (String)LookupConstant.CONNECTION);
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mConnectionComboBox, (int)1, (int)row, (int)2, (int)1, (int)17, (int)2, (Insets)new Insets(10, 5, 0, 0), (int)1, (int)1, (double)1.0, (double)0.0);
        this.mConnectionButton = UIHelper.createModelerButton((Icon)ImageCache.getIcon("add16"));
        this.mConnectionButton.setToolTipText(BPELStringTranslator.getString("EDITOR_EXP_MENU_CREATE"));
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mConnectionButton, (int)3, (int)row, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(10, 5, 0, 10), (int)0, (int)0, (double)0.0, (double)0.0);
        this.initConnectionList();
        this.mConnectionButton.addActionListener(this);
        this.mConnectionComboBox.addItemListener(this);
    }

    private void initConnectionList() {
        this.mConnectionComboBox.removeItemListener(this);
        this.mConnectionComboBox.removeAllItems();
        ArrayList<ConnectionNode> connections = new ArrayList<ConnectionNode>();
        List appServers = AppServerManager.getInstance().list();
        for (String name : appServers) {
            AppServer ap = AppServerManager.getInstance().getAppServer(name);
            AppServerConnection connection = ap.getConnection();
            Platform p = ap.getPlatform();
            PlatformType ptype = p.getType();
            if (!PlatformType.WEBLOGIC.equals((Object)ptype)) continue;
            Weblogic10Descriptor desc = (Weblogic10Descriptor)ConnectionDescriptor.newInstance(Weblogic10Descriptor.class, (AppServerProvider)connection.getAppServerProvider());
            ConnectionNode newConnNode = new ConnectionNode(name, desc, true);
            connections.add(newConnNode);
        }
        int size = connections.size();
        for (int i = size - 1; i >= 0; --i) {
            ConnectionNode node = (ConnectionNode)connections.get(i);
            LookupConnectionNode lcn = new LookupConnectionNode(node);
            if (((DefaultComboBoxModel)this.mConnectionComboBox.getModel()).getIndexOf(lcn) != -1) continue;
            this.mConnectionComboBox.addItem(lcn);
            this.mConnectionComboBox.setSelectedItem(lcn);
        }
        this.populateRealms();
        this.mConnectionComboBox.addItemListener(this);
    }

    private void addOKCancelButton(int row, Container dialogPanel) {
        boolean bottomMargin = false;
        this.mOKButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mOKButton, (String)LookupConstant.OK);
        this.mCancelButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mCancelButton, (String)LookupConstant.CANCEL);
        this.mHelpButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mHelpButton, (String)LookupConstant.HELP);
        ArrayList<Component> lc = new ArrayList<Component>();
        JPanel btnPnl = new JPanel();
        BoxLayout bl = new BoxLayout(btnPnl, 2);
        btnPnl.setLayout(bl);
        Component c1 = Box.createHorizontalStrut(10);
        lc.add(c1);
        btnPnl.add(c1);
        btnPnl.add(this.mHelpButton);
        lc.add(this.mHelpButton);
        Component glue = Box.createHorizontalGlue();
        btnPnl.add(glue);
        btnPnl.add(this.mOKButton);
        Component c2 = Box.createHorizontalStrut(5);
        lc.add(c2);
        btnPnl.add(c2);
        lc.add(this.mOKButton);
        if (this.mIsMainWizard) {
            btnPnl.add(this.mCancelButton);
            lc.add(this.mCancelButton);
        }
        List<JComponent> l = Arrays.asList(this.mHelpButton, this.mOKButton, this.mCancelButton);
        UIUtil.equatePreferredWidths(l);
        for (Component component : lc) {
            component.setMaximumSize(component.getPreferredSize());
        }
        GraphUtils.addComponent((Container)dialogPanel, (Component)btnPnl, (int)0, (int)row, (int)0, (int)1, (int)21, (int)2, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.mOKButton.addActionListener(this);
        if (this.mIsMainWizard) {
            this.mCancelButton.addActionListener(this);
        }
        this.mHelpButton.addActionListener(this);
    }

    private void addSearchUserPanel(int row, Container dialogPanel) {
        this.mSearchPanel = new JPanel();
        this.setSearchBorder(this.mSearchPanel);
        this.mSearchPanel.setLayout(new GridBagLayout());
        int columnUse = 1;
        if (this.mIsMainWizard) {
            columnUse = 4;
        }
        GraphUtils.addComponent((Container)dialogPanel, (Component)this.mSearchPanel, (int)0, (int)row, (int)4, (int)1, (int)17, (int)1, (Insets)new Insets(10, 10, 10, 10), (int)1, (int)1, (double)1.0, (double)1.0);
        this.mScrollPane = new JScrollPane(new JList());
        int columns = 5;
        if (this.mIsMainWizard && this.mLookupType == 0) {
            columns = 6;
        }
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mScrollPane, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 10, 5, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        JPanel btnPnl = this.createSearchUserButtonPanel2();
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)btnPnl, (int)0, (int)1, (int)1, (int)1, (int)12, (int)0, (Insets)new Insets(0, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
    }

    private JPanel createSearchUserButtonPanel2() {
        this.mBackButton = new JButton("<<");
        this.mForwardButton = new JButton(">>");
        if (this.mLookupType == 0) {
            this.mHButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.mHButton, (String)LookupConstant.HIERARCHY);
            this.mRButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.mRButton, (String)LookupConstant.REPORTEES);
        }
        this.mSearchDButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mSearchDButton, (String)LookupConstant.SEARCHDETAILS);
        this.mSButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mSButton, (String)LookupConstant.SELECT);
        if (this.mLookupType == 1) {
            this.mMButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.mMButton, (String)LookupConstant.MEMBERS);
        }
        if (this.mLookupType == 0) {
            this.mHButton.addActionListener(this);
            this.mRButton.addActionListener(this);
        }
        if (this.mLookupType == 1) {
            this.mMButton.addActionListener(this);
        }
        this.mSearchDButton.addActionListener(this);
        if (this.mIsMainWizard) {
            this.mSButton.addActionListener(this);
        }
        this.mBackButton.addActionListener(this);
        this.mForwardButton.addActionListener(this);
        this.mBackButton.setEnabled(false);
        this.mForwardButton.setEnabled(false);
        ArrayList<JButton> buttonLst = new ArrayList<JButton>();
        if (this.mIsMainWizard) {
            buttonLst.add(this.mSButton);
        }
        if (this.mLookupType == 0) {
            buttonLst.add(this.mHButton);
            buttonLst.add(this.mRButton);
        }
        if (this.mLookupType == 1) {
            buttonLst.add(this.mMButton);
        }
        buttonLst.add(this.mSearchDButton);
        buttonLst.add(this.mBackButton);
        buttonLst.add(this.mForwardButton);
        JPanel btnPnl = new JPanel(new GridLayout(1, buttonLst.size(), 5, 0));
        for (JButton button : buttonLst) {
            btnPnl.add(button);
        }
        return btnPnl;
    }

    private void addSearchButtonPanel(JPanel panel, int row) {
        this.mBackButton = new JButton("   <<   ");
        this.mForwardButton = new JButton("   >>   ");
        if (this.mLookupType == 0) {
            this.mHButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.mHButton, (String)LookupConstant.HIERARCHY);
            this.mRButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.mRButton, (String)LookupConstant.REPORTEES);
        }
        this.mSearchDButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mSearchDButton, (String)LookupConstant.SEARCHDETAILS);
        this.mSButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mSButton, (String)LookupConstant.SELECT);
        if (this.mLookupType == 1) {
            this.mMButton = new JButton();
            ResourceUtils.resButton((AbstractButton)this.mMButton, (String)LookupConstant.MEMBERS);
        }
        int col = 0;
        if (this.mIsMainWizard) {
            GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mSButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        }
        if (this.mLookupType == 0) {
            GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mHButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
            GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mRButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        }
        if (this.mLookupType == 1) {
            GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mMButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        }
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mSearchDButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mBackButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)this.mSearchPanel, (Component)this.mForwardButton, (int)col++, (int)row, (int)1, (int)1, (int)13, (int)2, (Insets)new Insets(0, 0, 0, 0), (int)1, (int)1, (double)1.0, (double)1.0);
        if (this.mLookupType == 0) {
            this.mHButton.addActionListener(this);
            this.mRButton.addActionListener(this);
        }
        if (this.mLookupType == 1) {
            this.mMButton.addActionListener(this);
        }
        this.mSearchDButton.addActionListener(this);
        if (this.mIsMainWizard) {
            this.mSButton.addActionListener(this);
        }
        this.mBackButton.addActionListener(this);
        this.mForwardButton.addActionListener(this);
        this.mBackButton.setEnabled(false);
        this.mForwardButton.setEnabled(false);
    }

    private void addSelectedUserPanel(int row, Container dialogPanel) {
        this.mSRButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mSRButton, (String)LookupConstant.REMOVE);
        this.mSelectDButton = new JButton();
        ResourceUtils.resButton((AbstractButton)this.mSelectDButton, (String)LookupConstant.SELECTDETAILS);
        JPanel searchPanel = new JPanel();
        this.setSelectBorder(searchPanel);
        searchPanel.setLayout(new GridBagLayout());
        GraphUtils.addComponent((Container)dialogPanel, (Component)searchPanel, (int)0, (int)row, (int)4, (int)1, (int)17, (int)1, (Insets)new Insets(0, 10, 10, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        JPanel btnPnl = new JPanel(new GridLayout(1, 2, 5, 0));
        btnPnl.add(this.mSRButton);
        btnPnl.add(this.mSelectDButton);
        boolean panelRow = false;
        JScrollPane scrollPaneList = new JScrollPane(this.mList);
        boolean bottomSMargin = false;
        GraphUtils.addComponent((Container)searchPanel, (Component)scrollPaneList, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 10, 0, 10), (int)0, (int)0, (double)1.0, (double)1.0);
        GraphUtils.addComponent((Container)searchPanel, (Component)btnPnl, (int)0, (int)1, (int)1, (int)1, (int)12, (int)0, (Insets)new Insets(5, 0, 10, 10), (int)0, (int)0, (double)1.0, (double)0.0);
        this.mList.setModel(new DefaultListModel());
        this.addMouseListenerAdapter(this.mList);
        this.mSRButton.addActionListener(this);
        this.mSelectDButton.addActionListener(this);
    }

    private void addMouseListenerAdapter(Component comp) {
        comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object source = e.getSource();
                if (source.equals(LookupDialog.this.mList)) {
                    LookupDialog.this.displaySelectDetails();
                } else {
                    LookupDialog.this.displaySearchDetails(source);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LookupDialog.this.mMouseDClick = 0;
            }
        });
    }

    private void displaySelectDetails() {
        if (this.mMouseDClick == 1) {
            this.mMouseDClick = 0;
            this.displayListDialog(this.mList);
        } else {
            ++this.mMouseDClick;
        }
    }

    private void displaySearchDetails(Object source) {
        if (this.mMouseDClick == 1) {
            this.mMouseDClick = 0;
            if (source instanceof JList) {
                this.displayListDialog((JList)source);
            } else {
                this.displayTreeDialog((JTree)source);
            }
        } else {
            ++this.mMouseDClick;
        }
    }

    private void setSearchBorder(JPanel panel) {
        if (this.mLookupType == 0) {
            panel.setBorder(BorderFactory.createTitledBorder(LookupConstant.SEARCH_USER));
        } else {
            panel.setBorder(BorderFactory.createTitledBorder(LookupConstant.SEARCH_GROUP));
        }
    }

    private void setSelectBorder(JPanel panel) {
        if (this.mLookupType == 0) {
            panel.setBorder(BorderFactory.createTitledBorder(LookupConstant.SELECTED_USER));
        } else {
            panel.setBorder(BorderFactory.createTitledBorder(LookupConstant.SELECTED_GROUP));
        }
    }

    private void addComponentListener() {
        this.mDialog.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension dim = LookupDialog.this.mDialog.getSize();
                if (dim.getHeight() < 590.0 || dim.getWidth() < 610.0) {
                    LookupDialog.this.mDialog.setSize(610, 590);
                }
            }
        });
    }

    public void setSelectedPrinciple() {
        DefaultListModel model = (DefaultListModel)this.mList.getModel();
        LookupConnectionNode connNode = null;
        connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            String userId = (String)model.getElementAt(i);
            if (i == 0) {
                this.mSelectedPrinciple = userId;
                this.mEmailAddress = this.mLookupPrinciple.getEmailId(connNode, userId);
                this.mPhoneNumber = this.mLookupPrinciple.getPhone(connNode, userId);
                this.mFaxNumber = this.mLookupPrinciple.getFax(connNode, userId);
                this.mPagerNumber = this.mLookupPrinciple.getPager(connNode, userId);
                this.mIMId = this.mLookupPrinciple.getIM(connNode, userId);
                continue;
            }
            this.mSelectedPrinciple = this.mSelectedPrinciple + "," + userId;
            this.mEmailAddress = this.mEmailAddress + "," + this.mLookupPrinciple.getEmailId(connNode, userId);
            this.mPhoneNumber = this.mPhoneNumber + "," + this.mLookupPrinciple.getPhone(connNode, userId);
            this.mFaxNumber = this.mFaxNumber + "," + this.mLookupPrinciple.getFax(connNode, userId);
            this.mPagerNumber = this.mPagerNumber + "," + this.mLookupPrinciple.getPager(connNode, userId);
            this.mIMId = this.mIMId + "," + this.mLookupPrinciple.getIM(connNode, userId);
        }
    }

    public String getSelectedPrinciple() {
        return this.mSelectedPrinciple;
    }

    public boolean showDialog() {
        this.mResult = true;
        try {
            UIHelper.centerInScreen((Component)this.mDialog);
            this.mDialog.setVisible(true);
        }
        catch (Exception exc) {
            this.mResult = false;
        }
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        this.mDialog.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Object source = event.getSource();
            if (source.equals(this.mLookupButton)) {
                this.processLookupEvent();
            } else if (source.equals(this.mRButton)) {
                this.processReporteesEvent();
            } else if (source.equals(this.mHButton)) {
                this.processHierarchyEvent();
            } else if (source.equals(this.mSButton)) {
                this.processSelectEvent();
            } else if (source.equals(this.mBackButton)) {
                this.processBackEvent();
            } else if (source.equals(this.mForwardButton)) {
                this.processForwadrEvent();
            } else if (source.equals(this.mConnectionButton)) {
                this.processConnectionEvent();
            } else if (source.equals(this.mCancelButton)) {
                this.processCancelEvent();
            } else if (source.equals(this.mOKButton)) {
                this.processOKEvent();
            } else if (source.equals(this.mSRButton)) {
                this.processRemoveEvent();
            } else if (source.equals(this.mSearchDButton) || source.equals(this.mSelectDButton)) {
                this.processDetailsEvent(source);
            } else if (source.equals(this.mMButton)) {
                this.processMemberEvent();
            } else if (this.mHelpButton.equals(source)) {
                this.processHelpEvent();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mDialog.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void processHelpEvent() {
        HelpSystem.showHelp(this.mDialog, HELP_TOPIC);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processDetailsEvent(Object source) {
        if (source.equals(this.mSearchDButton)) {
            Component comp = this.mScrollPane.getViewport().getComponents()[0];
            String[] name = this.getSelectedValue(comp);
            if (name == null) return;
            if (comp instanceof JList) {
                this.displayListDialog((JList)comp);
                return;
            } else {
                this.displayTreeDialog((JTree)comp);
            }
            return;
        } else {
            String[] name = this.getJListSelectedValue(this.mList);
            if (name != null) {
                this.displayListDialog(this.mList);
                return;
            } else {
                MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.SELECTION_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                return;
            }
        }
    }

    private void processOKEvent() {
        if (this.mIsMainWizard) {
            this.setSelectedPrinciple();
        }
        this.mDialog.dispose();
    }

    private void processCancelEvent() {
        this.mDialog.dispose();
        this.mResult = false;
    }

    private void processConnectionEvent() {
        AppServer ap = AppServerManager.getInstance().runNewAppServerWizardDialog(PlatformRegistry.getPlatforms((PlatformType)PlatformType.WEBLOGIC));
        if (ap != null) {
            this.initConnectionList();
        }
    }

    private void processBackEvent() {
        int size = this.mComponents.size();
        --this.mCurrentIndex;
        if (this.mCurrentIndex == 0) {
            this.mBackButton.setEnabled(false);
        }
        Component comp = (Component)this.mComponents.get(this.mCurrentIndex);
        this.mScrollPane.setViewportView(comp);
        this.mForwardButton.setEnabled(true);
    }

    private void processForwadrEvent() {
        int size = this.mComponents.size();
        ++this.mCurrentIndex;
        if (this.mCurrentIndex == size - 1) {
            this.mForwardButton.setEnabled(false);
        }
        Component comp = (Component)this.mComponents.get(this.mCurrentIndex);
        this.mScrollPane.setViewportView(comp);
        this.mBackButton.setEnabled(true);
    }

    private String[] getJListSelectedValue(JList listComp) {
        Object[] values = listComp.getSelectedValues();
        if (values == null) {
            return null;
        }
        String[] strValues = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            strValues[i] = (String)values[i];
        }
        return strValues;
    }

    private void enableButtons(LookupPrinciple principle) {
        if (principle instanceof LookupUser) {
            this.mSButton.setEnabled(false);
            this.mHButton.setEnabled(true);
            this.mRButton.setEnabled(true);
            this.mMButton.setEnabled(false);
        } else {
            this.mSButton.setEnabled(true);
            this.mHButton.setEnabled(false);
            this.mRButton.setEnabled(false);
            this.mMButton.setEnabled(true);
        }
    }

    private String[] getJTreeSelectedValue(JTree treeComp) {
        String[] selectedValue = null;
        TreePath[] values = treeComp.getSelectionPaths();
        if (values == null) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.SELECTION_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
            return null;
        }
        selectedValue = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            TreePath treePath = values[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getPathComponent(treePath.getPathCount() - 1);
            selectedValue[i] = (String)node.getUserObject();
        }
        return selectedValue;
    }

    private void processRemoveEvent() {
        String[] selectedValue = this.getJListSelectedValue(this.mList);
        if (selectedValue == null || selectedValue.length == 0) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.SELECTION_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
            return;
        }
        if (selectedValue != null) {
            String strValue = "";
            for (int i = 0; i < selectedValue.length; ++i) {
                strValue = i == 0 ? selectedValue[i] : strValue + "," + selectedValue[i];
            }
            int input = JOptionPane.showConfirmDialog(this.mDialog, BPELStringTranslator.formatString("REMOVE_DIALOG_MESSAGE", strValue), null, 0);
            if (input == 0) {
                DefaultListModel model = (DefaultListModel)this.mList.getModel();
                for (int i = 0; i < selectedValue.length; ++i) {
                    model.removeElement(selectedValue[i]);
                }
            }
        }
    }

    private void processSelectEvent() {
        Component comp = this.mScrollPane.getViewport().getComponents()[0];
        String[] selectedValue = this.getSelectedValue(comp);
        if (selectedValue == null) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.mList.getModel();
        int size = model.getSize();
        ArrayList<String> existingUsers = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String userName = (String)model.getElementAt(i);
            existingUsers.add(userName);
        }
        size = selectedValue.length;
        boolean invalidUser = false;
        String invalidUserNames = null;
        for (int i = 0; i < size; ++i) {
            String value = selectedValue[i];
            if (this.isIdInvalid(value)) {
                if (invalidUserNames == null) {
                    invalidUserNames = value;
                    continue;
                }
                invalidUserNames = invalidUserNames + ", " + value;
                continue;
            }
            if (existingUsers.contains(value)) continue;
            model.addElement(value);
        }
        if (invalidUserNames != null) {
            this.showInvalidUserMessage(invalidUserNames);
        }
    }

    private boolean isIdInvalid(String value) {
        String fax;
        LookupConnectionNode connNode = null;
        connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem();
        if (this.mLooupDialogType == EMAIL_LOOKUP) {
            String emailId = this.mLookupPrinciple.getEmailId(connNode, value);
            if (emailId == null || emailId.trim().length() == 0 || emailId.indexOf("@") == -1) {
                return true;
            }
        } else if (this.mLooupDialogType == PAGER_LOOKUP) {
            String pager = this.mLookupPrinciple.getPager(connNode, value);
            if (pager == null || pager.trim().length() == 0) {
                return true;
            }
        } else if (this.mLooupDialogType == VOICE_LOOKUP) {
            String phone = this.mLookupPrinciple.getPhone(connNode, value);
            if (phone == null || phone.trim().length() == 0) {
                return true;
            }
        } else if (this.mLooupDialogType == FAX_LOOKUP) {
            String fax2 = this.mLookupPrinciple.getFax(connNode, value);
            if (fax2 == null || fax2.trim().length() == 0) {
                return true;
            }
        } else if (this.mLooupDialogType == IM_LOOKUP && ((fax = this.mLookupPrinciple.getIM(connNode, value)) == null || fax.trim().length() == 0)) {
            return true;
        }
        return false;
    }

    private void showInvalidUserMessage(String invalidUserNames) {
        String errorMessage = "";
        String title = "";
        if (this.mLooupDialogType == EMAIL_LOOKUP) {
            errorMessage = this.mLookupType == 0 ? BPELStringTranslator.getString("EMAIL_NOT_AVAILABLE_USER_ERROR") : BPELStringTranslator.getString("EMAIL_NOT_AVAILABLE_GROUP_ERROR");
            title = BPELStringTranslator.getString("EMAIL_NOT_AVAILABLE_TITLE");
        } else if (this.mLooupDialogType == PAGER_LOOKUP) {
            errorMessage = BPELStringTranslator.getString("PAGER_NOT_AVAILABLE_USER_ERROR");
            title = BPELStringTranslator.getString("PAGER_NOT_AVAILABLE_TITLE");
        } else if (this.mLooupDialogType == FAX_LOOKUP) {
            errorMessage = BPELStringTranslator.getString("FAX_NOT_AVAILABLE_USER_ERROR");
            title = BPELStringTranslator.getString("FAX_NOT_AVAILABLE_TITLE");
        } else if (this.mLooupDialogType == IM_LOOKUP) {
            errorMessage = BPELStringTranslator.getString("IM_NOT_AVAILABLE_USER_ERROR");
            title = BPELStringTranslator.getString("IM_NOT_AVAILABLE_TITLE");
        } else if (this.mLooupDialogType == VOICE_LOOKUP) {
            errorMessage = BPELStringTranslator.getString("PHONE_NOT_AVAILABLE_USER_ERROR");
            title = BPELStringTranslator.getString("PHONE_NOT_AVAILABLE_TITLE");
        }
        errorMessage = errorMessage + "\n" + invalidUserNames;
        MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)errorMessage, (String)title, (int)2);
    }

    private String[] getSelectedValue(Component comp) {
        if (comp instanceof JList) {
            JList listComp = (JList)comp;
            return this.getJListSelectedValue(listComp);
        }
        return this.getJTreeSelectedValue((JTree)comp);
    }

    private void processReporteesEvent() {
        Component comp = this.mScrollPane.getViewport().getComponents()[0];
        String[] selectedValues = this.getSelectedValue(comp);
        String selectedValue = null;
        if (selectedValues == null) {
            return;
        }
        if (selectedValues.length != 1) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.SELECTION_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
            return;
        }
        selectedValue = selectedValues[0];
        if (selectedValue != null) {
            try {
                LookupConnectionNode connNode = null;
                connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : this.mCurrentNode;
                if (connNode == null) {
                    MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.CONN_ERROR_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                    return;
                }
                String[] values = this.mLookupPrinciple.getReportees(connNode, selectedValue, this.getSelectedRealm());
                String errorMessage = LookupConstant.NO_REPORTEES_MESSAGE + selectedValue;
                if (comp instanceof JList) {
                    this.addNewJListValues(values, errorMessage);
                } else {
                    this.addNewJTreeValues(values, errorMessage, (JTree)comp);
                }
            }
            catch (Exception exc) {
                this.showErrorMessage(exc);
            }
        }
    }

    private void addNewJTreeValues(String[] values, String errorMessage, JTree treeComp) {
        if (values == null || values.length == 0) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)errorMessage, (String)LookupConstant.LOOKUP_ERROR);
            return;
        }
        TreePath[] treePaths = treeComp.getSelectionPaths();
        TreePath treePath = treePaths[0];
        int treeRow = treePath.getPathCount();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treePath.getPathComponent(treeRow - 1);
        int index = parent.getChildCount();
        DefaultTreeModel model = (DefaultTreeModel)treeComp.getModel();
        for (int i = 0; i < values.length; ++i) {
            boolean exist = false;
            Enumeration<TreeNode> enum_var = parent.children();
            while (enum_var.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)enum_var.nextElement();
                String childName = (String)childNode.getUserObject();
                if (!childName.equals(values[i])) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            model.insertNodeInto(new DefaultMutableTreeNode(values[i]), parent, index);
        }
        try {
            treeComp.expandRow(treeComp.getSelectionRows()[0]);
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    private void processLookupEvent() {
        String pattern = this.mPatternTextField.getText().trim();
        if (pattern.length() == 0) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.PATTERN_NOT_SPECIFIED, (String)LookupConstant.LOOKUP_ERROR);
            return;
        }
        LookupConnectionNode connNode = null;
        connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem();
        if (connNode == null) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.CONN_ERROR_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
            return;
        }
        String sIdentityAttribute = this.mPatternComboBox.getSelectedItem().toString().trim();
        String attrName = LookupUtil.getIdentityAttribute(sIdentityAttribute);
        try {
            String[] values = this.mLookupPrinciple.searchPrinciple(connNode, attrName, pattern, this.getSelectedRealm());
            String errorMessage = BPELStringTranslator.formatString("NO_VALUES_FOR_PATTERN", pattern);
            this.addNewJListValues(values, errorMessage);
        }
        catch (Exception exc) {
            this.showErrorMessage(exc);
        }
    }

    private void processMemberEvent() {
        String selectedValue = null;
        Component comp = this.mScrollPane.getViewport().getComponents()[0];
        if (comp instanceof JList) {
            JList listComp = (JList)comp;
            String[] selectedValues = this.getJListSelectedValue(listComp);
            if (selectedValues == null || selectedValues.length != 1) {
                MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.SELECTION_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                return;
            }
            selectedValue = selectedValues[0];
        }
        if (selectedValue != null) {
            try {
                LookupConnectionNode connNode = null;
                connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem();
                if (connNode == null) {
                    MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.CONN_ERROR_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                    return;
                }
                String[] values = this.mLookupPrinciple.getMembers(connNode, selectedValue, this.getSelectedRealm());
                String errorMessage = LookupConstant.NO_REPORTEES_MESSAGE + selectedValue;
                if (values.length == 0) {
                    MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)errorMessage, (String)LookupConstant.LOOKUP_ERROR);
                    return;
                }
                LookupDialog subDialog = new LookupDialog(this.mDialog, connNode);
                JList list = new JList();
                DefaultListModel<String> model = new DefaultListModel<String>();
                for (int i = 0; i < values.length; ++i) {
                    model.addElement(values[i]);
                }
                list.setModel(model);
                subDialog.addMouseListenerAdapter(list);
                subDialog.mScrollPane.setViewportView(list);
                subDialog.addComponent(list);
                subDialog.showDialog();
            }
            catch (Exception exc) {
                this.showErrorMessage(exc);
            }
        }
    }

    private void processHierarchyEvent() {
        String selectedValue = null;
        Component comp = this.mScrollPane.getViewport().getComponents()[0];
        if (comp instanceof JList) {
            JList listComp = (JList)comp;
            String[] selectedValues = this.getJListSelectedValue(listComp);
            if (selectedValues == null || selectedValues.length != 1) {
                MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.SELECTION_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                return;
            }
            selectedValue = selectedValues[0];
        }
        if (selectedValue != null) {
            try {
                LookupConnectionNode connNode = null;
                connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : this.mCurrentNode;
                if (connNode == null) {
                    MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.CONN_ERROR_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                    return;
                }
                String[] values = this.mLookupPrinciple.getHierarchy(connNode, selectedValue, this.getSelectedRealm());
                String errorMessage = LookupConstant.NO_REPORTEES_MESSAGE + selectedValue;
                this.addNewTreeValues(values, errorMessage);
            }
            catch (Exception exc) {
                this.showErrorMessage(exc);
            }
        }
    }

    private void addNewTreeValues(String[] values, String errorMessage) {
        if (values.length == 0) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)errorMessage, (String)LookupConstant.LOOKUP_ERROR);
            return;
        }
        JTree tree = new JTree();
        this.addComponent(tree);
        DefaultMutableTreeNode parentNode = null;
        DefaultMutableTreeNode rootNode = null;
        for (int i = values.length - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(values[i]);
            if (parentNode != null) {
                parentNode.add(node);
            } else {
                rootNode = node;
            }
            parentNode = node;
        }
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        tree.setModel(model);
        for (int i = 0; i < values.length; ++i) {
            tree.expandRow(i);
        }
        this.addMouseListenerAdapter(tree);
        this.mScrollPane.setViewportView(tree);
    }

    private void addNewJListValues(String[] values, String errorMessage) {
        if (values.length == 0) {
            MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)errorMessage, (String)LookupConstant.LOOKUP_ERROR, (int)0);
            return;
        }
        JList list = new JList();
        DefaultListModel<String> model = new DefaultListModel<String>();
        for (int i = 0; i < values.length; ++i) {
            model.addElement(values[i]);
        }
        list.setModel(model);
        this.addMouseListenerAdapter(list);
        this.mScrollPane.setViewportView(list);
        this.addComponent(list);
    }

    private void addComponent(Component comp) {
        int size = this.mComponents.size();
        ArrayList removeComponent = new ArrayList();
        for (int i = this.mCurrentIndex + 1; i < size; ++i) {
            removeComponent.add(this.mComponents.get(i));
        }
        this.mComponents.removeAll(removeComponent);
        this.mComponents.add(comp);
        size = this.mComponents.size();
        this.mCurrentIndex = size - 1;
        this.mForwardButton.setEnabled(false);
        if (this.mCurrentIndex != 0) {
            this.mBackButton.setEnabled(true);
        } else {
            this.mBackButton.setEnabled(false);
        }
    }

    public void displayListDialog(JList list) {
        String[] name = this.getJListSelectedValue(list);
        if (name != null & name.length == 1) {
            this.displayDetailInfo(list, name[0], this.getSelectedRealm());
        }
    }

    public void displayTreeDialog(JTree tree) {
        String[] name = this.getJTreeSelectedValue(tree);
        if (name != null && name.length == 1) {
            this.displayDetailInfo(tree, name[0], this.getSelectedRealm());
        }
    }

    public String getSelectedRealm() {
        String realm = (String)this.mRealmBox.getSelectedItem();
        return realm;
    }

    private void displayDetailInfo(Component comp, String userName, String realmName) {
        String detailInfo = "";
        try {
            LookupConnectionNode connNode = null;
            connNode = this.mIsMainWizard ? (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem() : this.mCurrentNode;
            if (connNode == null) {
                MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)LookupConstant.CONN_ERROR_MESSAGE, (String)LookupConstant.LOOKUP_ERROR);
                return;
            }
            detailInfo = this.mLookupPrinciple.getDetailInfo(connNode, userName, realmName);
        }
        catch (Exception exc) {
            return;
        }
        String title = userName + BPELStringTranslator.getString("LOOKUP_DETAIL_INFROMATION");
        LookupDetailDialog.showDialog(this.mDialog, detailInfo, title);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.mUserRButton) || source.equals(this.mGroupRButton)) {
            Container dialogC = this.mDialog.getContentPane();
            dialogC.remove(this.mPatternLabel);
            dialogC.remove(this.mPatternTextField);
            dialogC.remove(this.mPatternComboBox);
            dialogC.remove(this.mLookupButton);
            dialogC.remove(this.mSearchPanel);
            if (source.equals(this.mUserRButton)) {
                this.mLookupType = 0;
                this.mLookupPrinciple = new LookupUser();
            } else {
                this.mLookupType = 1;
                this.mLookupPrinciple = new LookupGroup();
            }
            this.addSearchUserPanel(this.mSearchRow, this.mDialog.getContentPane());
            this.addPatternRow(this.mPatternRow, this.mDialog.getContentPane());
            this.mDialog.show();
        } else {
            this.mComponents.clear();
            this.mCurrentIndex = 0;
            this.mScrollPane.setViewportView(new JList());
            DefaultListModel model = (DefaultListModel)this.mList.getModel();
            model.removeAllElements();
            this.mBackButton.setEnabled(false);
            this.mForwardButton.setEnabled(false);
            this.mLookupPrinciple.removeCache();
            if (e.getStateChange() == 1) {
                this.populateRealms();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateRealms() {
        Object object = this.mRealmLock;
        synchronized (object) {
            if (this.mRealmRunnable != null) {
                this.mRealmRunnable.interrupt();
            }
        }
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List l;
                DefaultComboBoxModel model;
                block5: {
                    LookupConnectionNode node;
                    block4: {
                        model = (DefaultComboBoxModel)LookupDialog.this.mRealmBox.getModel();
                        try {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    LookupDialog.this.mDialog.setCursor(Cursor.getPredefinedCursor(3));
                                    model.removeAllElements();
                                }
                            });
                            node = (LookupConnectionNode)LookupDialog.this.mConnectionComboBox.getSelectedItem();
                            if (node != null) break block4;
                        }
                        catch (Throwable throwable) {
                            Runnable rend = new Runnable(){

                                @Override
                                public void run() {
                                    LookupDialog.this.mDialog.setCursor(Cursor.getDefaultCursor());
                                }
                            };
                            SwingUtilities.invokeLater(rend);
                            throw throwable;
                        }
                        Runnable rend = new /* invalid duplicate definition of identical inner class */;
                        SwingUtilities.invokeLater(rend);
                        return;
                    }
                    l = LookupUtil.getRealms(node);
                    if (!Thread.currentThread().isInterrupted()) break block5;
                    Runnable rend = new /* invalid duplicate definition of identical inner class */;
                    SwingUtilities.invokeLater(rend);
                    return;
                }
                Runnable r1 = new Runnable(){

                    @Override
                    public void run() {
                        model.removeAllElements();
                        for (String name : l) {
                            model.addElement(name);
                        }
                    }
                };
                SwingUtilities.invokeLater(r1);
                Runnable rend = new /* invalid duplicate definition of identical inner class */;
                SwingUtilities.invokeLater(rend);
            }
        };
        this.mRealmRunnable = new Thread(r);
        this.mRealmRunnable.start();
    }

    private JPanel prepareBusyPanel() {
        JPanel panel = new JPanel();
        BoxLayout bl = new BoxLayout(panel, 1);
        panel.setLayout(bl);
        JProgressBar progress = new JProgressBar();
        progress.setIndeterminate(true);
        panel.add(progress);
        return panel;
    }

    public String getEmailAddress() {
        return this.mEmailAddress;
    }

    public String getPhoneNumber() {
        return this.mPhoneNumber;
    }

    public String getFaxNumber() {
        return this.mFaxNumber;
    }

    public String getPagerNumber() {
        return this.mPagerNumber;
    }

    public String getIMId() {
        return this.mIMId;
    }

    private void showErrorMessage(Exception exc) {
        String message = exc.getMessage();
        String title = BPELStringTranslator.getString("LOOKUP_DIALOG_TITLE", "");
        if (exc instanceof SOAPException) {
            String htmlMessage = this.getSoapMessage(message, HTML_BODY);
            if (htmlMessage == null) {
                htmlMessage = this.getSoapMessage(message, HTML_TITLE);
            }
            if (htmlMessage != null) {
                message = BPELStringTranslator.getString("LOOKUP_SERVER-EXCEPTION") + "\n" + htmlMessage;
            }
        }
        if (message == null) {
            message = exc.getMessage();
        }
        if (message != null && (message.indexOf("Connection refused") != -1 || message.indexOf("java.net.SocketTimeoutException") != -1 || message.indexOf("java.net.ConnectException") != -1)) {
            LookupConnectionNode connNode = (LookupConnectionNode)this.mConnectionComboBox.getSelectedItem();
            String server = "";
            if (connNode != null) {
                LookupUtil.HostInfo hi = LookupUtil.getHostInfo(connNode);
                server = server + hi.getName() + ":" + hi.getHttpPort();
            }
            message = BPELStringTranslator.formatString("LOOKUP_SERVER_ERROR", server) + "\n" + BPELStringTranslator.formatString("LOOKUP_SERVER_ERROR_ROOT_CAUSE", message);
        } else {
            message = BPELStringTranslator.getString("LOOKUP_SERVER-GENERIC_EXCEPTION");
            message = BPELStringTranslator.formatString("LOOKUP_SERVER_ERROR_ROOT_CAUSE", message);
        }
        MultiLineOptionPane.showMessageDialog((Component)this.mDialog, (Object)this.getErrorMessage(message), (String)title, (int)0);
    }

    private String getErrorMessage(String message) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            message = message.replaceAll(HTML_QUOT, "\"");
            message = message.replaceAll(HTML_LESS, "<");
            message = message.replaceAll(HTML_GREATER, ">");
            message = message.replaceAll(HTML_AMP, "&");
            int index0 = 0;
            int index1 = 0;
            while (true) {
                int index2 = message.indexOf("\n", index0);
                int index3 = message.indexOf(" ", index0 + 100);
                if (index2 == -1 && index3 == -1) break;
                index1 = Math.min(index2 == -1 ? Integer.MAX_VALUE : index2, index3 == -1 ? Integer.MAX_VALUE : index3);
                arrayList.add(message.substring(index0, index1));
                index0 = index1 + 1;
            }
            arrayList.add(message.substring(index0));
            String returnMessage = "";
            int size = arrayList.size();
            for (int i = 0; i < 10 && i < size; ++i) {
                returnMessage = i == 0 ? (String)arrayList.get(i) : returnMessage + "\n" + arrayList.get(i);
            }
            return returnMessage;
        }
        catch (Exception exception) {
            return message;
        }
    }

    private String getSoapMessage(String message, String tag) {
        try {
            String mess;
            StringBuffer messageBuffer = new StringBuffer();
            int index = message.indexOf(tag);
            int lastIndex = message.lastIndexOf(tag);
            if (index >= 0 && lastIndex >= 0) {
                String messageAfterBody = message.substring(index + tag.length(), lastIndex);
                this.appendMessage(messageAfterBody, messageBuffer);
            }
            if ((mess = messageBuffer.toString().trim()).length() == 0) {
                return null;
            }
            return mess;
        }
        catch (Throwable th) {
            return null;
        }
    }

    private void appendMessage(String message, StringBuffer messageBuffer) {
        if (message == null || message.length() == 0) {
            return;
        }
        int gtIndex = message.indexOf(HTML_GREATER);
        int ltIndex = message.indexOf(HTML_LESS);
        if (gtIndex >= 0 && ltIndex >= 0) {
            String m1 = message.substring(gtIndex + HTML_GREATER.length(), ltIndex);
            messageBuffer.append(" " + m1);
            if (ltIndex + HTML_LESS.length() < message.length()) {
                this.appendMessage(message.substring(ltIndex + HTML_LESS.length()), messageBuffer);
            }
        }
    }

    public class LocalRealmItemListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent pEvent) {
            LookupDialog.this.mScrollPane.setViewportView(new JList());
            LookupDialog.this.mBackButton.setEnabled(false);
            LookupDialog.this.mForwardButton.setEnabled(false);
            DefaultListModel model = (DefaultListModel)LookupDialog.this.mList.getModel();
            model.removeAllElements();
            LookupDialog.this.mLookupPrinciple.removeCache();
        }
    }
}

