/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.bpel.services.workflow.metadata.config.model.FlexfieldAttributeLabelType;
import oracle.tip.tools.ide.common.services.connections.Connection;
import oracle.tip.tools.ide.common.services.lookup.EmailLookupContext;
import oracle.tip.tools.ide.common.services.lookup.FlexLookupContext;
import oracle.tip.tools.ide.common.services.lookup.GroupLookupContext;
import oracle.tip.tools.ide.common.services.lookup.LookupContext;
import oracle.tip.tools.ide.common.services.lookup.LookupDataProvider;
import oracle.tip.tools.ide.common.services.lookup.LookupResult;
import oracle.tip.tools.ide.common.services.lookup.UserLookupContext;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.ConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupConnectionNode;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupDialog;
import oracle.tip.tools.ide.pm.modules.humanworkflow.task.taskflow.wizard.lookup.LookupUtil;

public class LookupDataProviderImpl
implements LookupDataProvider {
    private static final String COMMA = ",";

    public LookupResult getResult(LookupContext pContext) {
        if (pContext instanceof UserLookupContext) {
            return this.handleUsers((UserLookupContext)pContext);
        }
        if (pContext instanceof GroupLookupContext) {
            return this.handleGroups((GroupLookupContext)pContext);
        }
        if (pContext instanceof FlexLookupContext) {
            return this.handleFlex((FlexLookupContext)pContext);
        }
        if (pContext instanceof EmailLookupContext) {
            return this.handleEmail((EmailLookupContext)pContext);
        }
        return new LookupResult();
    }

    private LookupResult handleUsers(UserLookupContext pContext) {
        LookupResult lookupResult = new LookupResult();
        int result = 200;
        List<Object> l = pContext.getData();
        LookupDialog dialog = new LookupDialog(0, pContext.getComponent());
        if (dialog.showDialog()) {
            result = 100;
            l = this.convertCommaStringToList(dialog.getSelectedPrinciple());
            String realm = dialog.getSelectedRealm();
            lookupResult.setProperty((Object)"realm.value", (Object)realm);
        } else {
            l = new ArrayList();
        }
        lookupResult.setData(l);
        lookupResult.setResult(result);
        return lookupResult;
    }

    private LookupResult handleGroups(GroupLookupContext pContext) {
        LookupResult lookupResult = new LookupResult();
        int result = 200;
        List<Object> l = pContext.getData();
        LookupDialog dialog = new LookupDialog(1, pContext.getComponent());
        if (dialog.showDialog()) {
            result = 100;
            l = this.convertCommaStringToList(dialog.getSelectedPrinciple());
            String realm = dialog.getSelectedRealm();
            lookupResult.setProperty((Object)"realm.value", (Object)realm);
        } else {
            l = new ArrayList();
        }
        lookupResult.setData(l);
        lookupResult.setResult(result);
        return lookupResult;
    }

    private LookupResult handleEmail(EmailLookupContext pContext) {
        LookupResult lookupResult = new LookupResult();
        int result = 200;
        List<Object> l = pContext.getData();
        LookupDialog dialog = new LookupDialog(0, pContext.getComponent(), LookupDialog.EMAIL_LOOKUP);
        if (dialog.showDialog()) {
            result = 100;
            l = this.convertCommaStringToList(dialog.getEmailAddress());
        } else {
            l = new ArrayList();
        }
        lookupResult.setData(l);
        lookupResult.setResult(result);
        return lookupResult;
    }

    private LookupResult handleFlex(FlexLookupContext pContext) {
        LookupResult lookupResult = new LookupResult();
        Connection c = pContext.getConnection();
        ConnectionNode cNode = new ConnectionNode(c.getName(), c.getDescriptor());
        LookupConnectionNode connectionNode = new LookupConnectionNode(cNode);
        List<FlexfieldAttributeLabelType> attributes = LookupUtil.listProtectedAttributeLabels(connectionNode);
        Iterator<FlexfieldAttributeLabelType> iter = attributes.iterator();
        ArrayList<FlexfieldAttributeLabelType> list = new ArrayList<FlexfieldAttributeLabelType>();
        while (iter.hasNext()) {
            FlexfieldAttributeLabelType itemToAdd = iter.next();
            list.add(itemToAdd);
        }
        lookupResult.setData(list);
        return lookupResult;
    }

    private List<String> convertCommaStringToList(String pData) {
        ArrayList<String> l = new ArrayList<String>();
        if (pData == null) {
            return l;
        }
        String[] strings = pData.split(COMMA);
        if (strings == null) {
            return l;
        }
        for (int i = 0; i < strings.length; ++i) {
            l.add(strings[i]);
        }
        return l;
    }

    private String convertListToCommaString(List<String> pList) {
        String str = "";
        if (pList == null) {
            return str;
        }
        Iterator<String> iter = pList.iterator();
        while (iter.hasNext()) {
            str = str + iter.next();
            if (!iter.hasNext()) continue;
            str = str + COMMA;
        }
        return str;
    }
}

