/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.help;

import java.awt.Component;
import java.awt.Window;
import java.io.InputStream;
import java.util.Properties;
import javax.swing.JComponent;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;

public final class HelpSystem {
    public static final String PM_HELP_ROOT_TOPIC = "bpmjdev_default_page";
    public static Properties m_helpProp;

    public static void gotoOracleHelpSystem(String id) {
        oracle.ide.help.HelpSystem.getHelpSystem().goTo(id);
    }

    public static String getHelpTopicId(String className) {
        if (m_helpProp == null) {
            try {
                InputStream pmhelp = HelpSystem.getClassLoader().getResource("oracle/tip/tools/ide/pm/modules/help/helpids.properties").openStream();
                m_helpProp = new Properties();
                m_helpProp.load(pmhelp);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        String topicId = null;
        if (m_helpProp != null) {
            topicId = m_helpProp.getProperty(className);
        }
        return topicId != null ? topicId : PM_HELP_ROOT_TOPIC;
    }

    public static void showHelp(Component component, String topicId) {
        oracle.ide.help.HelpSystem.getHelpSystem().goTo(topicId);
    }

    public static void showHelp(String topicId) {
        oracle.ide.help.HelpSystem.getHelpSystem().goTo(topicId);
    }

    public static void showHelp(Window clientWindow, Component component, String topicId) {
        oracle.ide.help.HelpSystem help = oracle.ide.help.HelpSystem.getHelpSystem();
        help.registerClientWindow(clientWindow);
        help.goTo(topicId);
        help.unregisterClientWindow(clientWindow);
    }

    private static ClassLoader getClassLoader() {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        return classLoader;
    }

    public static void setHelp(WizardPage page) {
        Component c = ((ImageWizardPage)page).getInteractiveArea();
        if (c instanceof JComponent) {
            String topicId = HelpSystem.getHelpTopicId(c.getClass().getName());
            topicId = topicId != null ? topicId.trim() : "";
            oracle.ide.help.HelpSystem.getHelpSystem().registerTopic((JComponent)page.getContent(), topicId);
        }
    }
}

