/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.ImportSchema;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.wsdl.WizardWSDLFactory;

public class WsdlUtil {
    public static final String WSDL_CHARSET = "UTF-8";
    public static final String INPUT_NAMESPACE_PREFIX = "inp1";
    public static final String THIS_NAMESPACE_PREFIX = "tns";
    public static final String OUTPUT_NAMESPACE_PREFIX = "out1";
    public static final String FAULT_NAMESPACE_PREFIX = "flt1";
    public static final String CALLBACK_NAMESPACE_PREFIX = "cb1";
    public static final String WSDL_REQUEST_MESSAGE_SUFFIX = "request";
    public static final String WSDL_REPLY_MESSAGE_SUFFIX = "reply";
    public static final String WSDL_FAULT_MESSAGE_SUFFIX = "fault";
    public static final String WSDL_CALLBACK_MESSAGE_SUFFIX = "callback";
    public static final String GENERIC_MESSAGE_SUFFIX = "Message";
    public static WSDLFactory s_wsdl_factory = null;
    private static final Boolean m_lock = new Boolean(true);

    public static boolean writeWSDL(Project project, Frame frame, String wsdl_path, String cleanServiceName, String namespace1, String operationName, QName portt_qname, String requestSchemaPath, QName requestElemQname, String replySchemaPath, QName replyElemQname, String faultSchemaPath, QName faultElemQname, String callbackOperationName, QName callbackPortt_qname, String callbackSchemaPath, QName callbackElemQname) {
        Definition def1 = null;
        try {
            WsdlUtil.createWSDLFactory();
            def1 = s_wsdl_factory.newDefinition();
            WizardWSDLFactory m_extention_factory = null;
            m_extention_factory = new WizardWSDLFactory();
            def1.setExtensionRegistry(m_extention_factory.newPopulatedExtensionRegistry());
            ExtensionRegistry _extReg = def1.getExtensionRegistry();
            def1.setTargetNamespace(namespace1);
            def1.addNamespace(THIS_NAMESPACE_PREFIX, namespace1);
            def1.setQName(new QName(namespace1, cleanServiceName));
            PortType portt = def1.createPortType();
            portt.setQName(portt_qname);
            portt.setUndefined(false);
            def1.addPortType(portt);
            Operation oper1 = def1.createOperation();
            oper1.setName(operationName);
            oper1.setUndefined(false);
            portt.addOperation(oper1);
            Message msg1 = WsdlUtil.addSchemaMessage2Wsdl(def1, _extReg, namespace1, WSDL_REQUEST_MESSAGE_SUFFIX, INPUT_NAMESPACE_PREFIX, requestSchemaPath, requestElemQname);
            Input input1 = def1.createInput();
            input1.setMessage(msg1);
            oper1.setInput(input1);
            if (replySchemaPath != null) {
                Message msg2 = WsdlUtil.addSchemaMessage2Wsdl(def1, _extReg, namespace1, WSDL_REPLY_MESSAGE_SUFFIX, OUTPUT_NAMESPACE_PREFIX, replySchemaPath, replyElemQname);
                Output output1 = def1.createOutput();
                output1.setMessage(msg2);
                oper1.setOutput(output1);
            }
            if (faultSchemaPath != null) {
                Message msg3 = WsdlUtil.addSchemaMessage2Wsdl(def1, _extReg, namespace1, WSDL_FAULT_MESSAGE_SUFFIX, FAULT_NAMESPACE_PREFIX, faultSchemaPath, faultElemQname);
                Fault fault1 = def1.createFault();
                fault1.setMessage(msg3);
                fault1.setName(operationName + WSDL_FAULT_MESSAGE_SUFFIX);
                oper1.addFault(fault1);
            }
            if (callbackSchemaPath != null && callbackSchemaPath.length() > 0) {
                PortType cportt = def1.createPortType();
                cportt.setQName(callbackPortt_qname);
                cportt.setUndefined(false);
                def1.addPortType(cportt);
                Operation coper1 = def1.createOperation();
                coper1.setName(callbackOperationName);
                coper1.setUndefined(false);
                cportt.addOperation(coper1);
                Message msg4 = WsdlUtil.addSchemaMessage2Wsdl(def1, _extReg, namespace1, WSDL_CALLBACK_MESSAGE_SUFFIX, CALLBACK_NAMESPACE_PREFIX, callbackSchemaPath, callbackElemQname);
                Input cinput1 = def1.createInput();
                cinput1.setMessage(msg4);
                coper1.setInput(cinput1);
            }
            WsdlUtil.writeWSDLFile(project, frame, def1, wsdl_path);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
            String errMsg = rbundle.getString("EU_WSDL_FILE_ERROR");
            String errMsgTitle = rbundle.getString("EU_WSDL_FILE_ERROR_TITLE");
            MessageFormat errMsgformat = new MessageFormat(errMsg);
            Object[] obj = new Object[]{wsdl_path, ex.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog((Component)frame, (Object)errMsgformat.format(obj), (String)errMsgTitle, (int)0);
            return false;
        }
    }

    public static Message addSchemaMessage2Wsdl(Definition def1, ExtensionRegistry _extReg, String namespace1, String msgNameSuffix, String nsPrefix, String requestSchemaPath, QName inElemQname) throws WSDLException {
        QName requestElemQname = inElemQname;
        String elname = requestElemQname.getLocalPart();
        String elnamespace = requestElemQname.getNamespaceURI();
        if (elnamespace != null && elnamespace.length() > 0) {
            def1.addNamespace(nsPrefix, elnamespace);
        } else {
            def1.addNamespace(null, null);
        }
        String tempstr = requestSchemaPath;
        if (tempstr.toLowerCase().endsWith("xsd")) {
            Types types1 = def1.getTypes();
            if (types1 == null) {
                types1 = def1.createTypes();
                def1.setTypes(types1);
            }
            ImportSchema impschema = (ImportSchema)_extReg.createExtension(ImportSchema.PARENT_CLASS, ImportSchema.FIELD_ELEMENT_TYPE);
            impschema.setNamespace(elnamespace);
            impschema.setLocation(tempstr);
            types1.addExtensibilityElement((ExtensibilityElement)impschema);
        } else if (tempstr.toLowerCase().endsWith("wsdl")) {
            Import imp = def1.createImport();
            imp.setLocationURI(tempstr);
            imp.setNamespaceURI(elnamespace);
            def1.addImport(imp);
        }
        Message msg1 = def1.createMessage();
        msg1.setQName(new QName(namespace1, msgNameSuffix + GENERIC_MESSAGE_SUFFIX));
        msg1.setUndefined(false);
        Part part1 = def1.createPart();
        part1.setName(msgNameSuffix);
        part1.setElementName(requestElemQname);
        msg1.addPart(part1);
        def1.addMessage(msg1);
        return msg1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWSDLFile(Project project, Frame frame, Definition def1, String wsdl_path) throws Exception {
        WSDLWriter wsdlWriter = s_wsdl_factory.newWSDLWriter();
        File file = null;
        FileOutputStream outStream = null;
        OutputStreamWriter osw = null;
        try {
            URL writeUrl = URLFactory.newURL((String)wsdl_path);
            String filestr = writeUrl.getFile();
            file = new File(filestr);
            outStream = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)outStream, WSDL_CHARSET);
            osw.write("<?xml version= '1.0' encoding= 'UTF-8' ?>\n");
            wsdlWriter.writeWSDL(def1, (Writer)osw);
            try {
                osw.close();
                outStream.close();
                outStream = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            CommonScaUtils.addFileToProject((Project)project, (URL)writeUrl, BPELWSDLNode.class);
        }
        catch (FileNotFoundException fne) {
            fne.printStackTrace();
            ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
            MessageFormat msgformat = new MessageFormat(rbundle.getString("EU_WSDL_FILE_WRITE_ERROR"));
            Object[] obj = new Object[]{wsdl_path, fne.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog((Component)frame, (Object)msgformat.format(obj), (String)rbundle.getString("EU_WSDL_FILE_WRITE_ERROR_TITLE"), (int)0);
        }
        catch (WSDLException wse) {
            wse.printStackTrace();
            ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
            MessageFormat msgformat = new MessageFormat(rbundle.getString("EU_WSDL_FILE_WRITE_ERROR"));
            Object[] obj = new Object[]{wsdl_path, wse.getLocalizedMessage()};
            MultiLineOptionPane.showMessageDialog((Component)frame, (Object)msgformat.format(obj), (String)rbundle.getString("EU_WSDL_FILE_WRITE_ERROR_TITLE"), (int)0);
        }
        finally {
            if (outStream != null) {
                try {
                    osw.close();
                    outStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDLFactory createWSDLFactory() throws WSDLException {
        if (s_wsdl_factory != null) {
            return s_wsdl_factory;
        }
        Boolean bl = m_lock;
        synchronized (bl) {
            System.setProperty("javax.wsdl.factory.WSDLFactory", "oracle.j2ee.ws.wsdl.factory.WSDLFactoryImpl");
            s_wsdl_factory = WSDLFactory.newInstance();
            return s_wsdl_factory;
        }
    }

    public static String getCleanName(String displayName) {
        return displayName.replaceAll("[\\x2e\\s\\n\\r!\"#$%&'()*+,-./:;<=>?@[\\\\]^_`{|}~]", "_");
    }

    public static void addFileToProject(Frame frame, Project project, URL furl) {
    }
}

