/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.SCAController;
import oracle.tip.tools.ide.fabric.api.SCAControllerImpl;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.common.CommonUtils;
import oracle.tip.tools.ide.fabric.common.ScaCommonDialog;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilder;
import oracle.tip.tools.ide.fabric.model.SCAWSDLManager;
import oracle.tip.tools.ide.fabric.resource.SCAResourceLookup;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.CommonSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.FocusRequester;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.WsdlUtil;

public class WsdlCreatePanel
extends JPanel
implements DocumentListener,
FocusListener,
ActionListener,
MouseListener {
    public static final String WSDL_SUFFIX = ".wsdl";
    public static final String WSDL_DEFAULT_OPERATION_NAME = "execute";
    public static final String WSDL_PORTTYPE_SUFFIX = "_ptt";
    public static final String WSDL_DEFAULT_PORTTYPE_NAME = "execute_ptt";
    public static final String WSDL_DEFAULT_CALLBACK_OPERATION_NAME = "callback";
    public static final String WSDL_DEFAULT_CALLBACK_PORTTYPE_NAME = "callback_ptt";
    public static EmptyBorder s_emptyBorder = new EmptyBorder(2, 2, 2, 2);
    public static EtchedBorder s_etchedBorder = new EtchedBorder();
    JEWTDialog m_currdiag;
    Frame m_parentFrame;
    ResourceBundle m_bundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
    String m_scaDir;
    Context m_project_context = null;
    Project m_project;
    SCAController m_scon;
    SCAProject m_scaproj;
    String m_serviceName;
    String m_wsdlName;
    String m_defaultNamespacePrefix;
    String m_wsdl_relpath;
    QName m_porttypeQname;
    QName m_callbackPorttypeQname = null;
    public Definition m_wdef = null;
    String m_last_wsdlloc = "";
    boolean m_wsdlHasError = false;
    boolean m_portHasError = true;
    String m_lastWsdlName;
    public static Point s_last_dialog_loc = null;
    public static Dimension s_last_dialog_size = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel introPrompt = new JLabel();
    private CommonSchemaPanel m_requestSchemaPanel;
    private CommonSchemaPanel m_replySchemaPanel;
    private CommonSchemaPanel m_faultSchemaPanel;
    private CommonSchemaPanel m_callbackSchemaPanel;
    ToolBar btnPnl = new ToolBar();
    private JTabbedPane m_tabpane = new JTabbedPane(1);
    private JLabel operationLB = new JLabel();
    private NCNameField operationName = new NCNameField();
    private JLabel portnameLB = new JLabel();
    private NCNameField portName = new NCNameField();
    private JLabel callbackOperationLB = new JLabel();
    private NCNameField callbackOperationName = new NCNameField();
    private JLabel callbackPortnameLB = new JLabel();
    private NCNameField callbackPortname = new NCNameField();
    private JLabel namespaceLB = new JLabel();
    private JTextField namespaceFLD = new JTextField();
    private JLabel wsdlNameLB = new JLabel();
    private NCNameField wsdlNameFLD = new NCNameField();
    private JLabel dummy1 = new JLabel();
    private JLabel dummy2 = new JLabel();
    private JLabel dummy3 = new JLabel();
    public static boolean MAIN_DEBUG = false;

    public WsdlCreatePanel(Frame parentFrame, Context project_context, JEWTDialog curdiag, String serviceName, String defaultNamespacePrefix) throws Exception {
        this.m_parentFrame = parentFrame;
        this.m_project_context = project_context;
        this.m_currdiag = curdiag;
        this.m_serviceName = WsdlUtil.getCleanName(serviceName);
        this.m_defaultNamespacePrefix = defaultNamespacePrefix;
        try {
            if (!MAIN_DEBUG) {
                this.m_project = this.m_project_context.getProject();
                this.m_scon = SCAControllerImpl.getController((Project)this.m_project);
                this.m_scaproj = SCAProject.getSCAProject((Project)this.m_project);
                this.m_scaDir = SCAProject.getScaDirectoryPath((Project)this.m_project);
            } else {
                this.m_scaDir = "c:\\tmp";
            }
            this.jbInit();
            if (!MAIN_DEBUG) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_med_createservicewsdl_html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void jbInit() throws Exception {
        String snprompt = this.m_bundle.getString("WC_INTRO_PROMPT");
        String requestTabText = this.m_bundle.getString("WC_REQUEST_TAB");
        String replyTabText = this.m_bundle.getString("WC_REPLY_TAB");
        String faultTabText = this.m_bundle.getString("WC_FAULT_TAB");
        String callbackTabText = this.m_bundle.getString("WC_CALLBACK_TAB");
        String operationText = this.m_bundle.getString("WC_OPERATION_NAME");
        String operationNameTip = this.m_bundle.getString("WC_OPERATION_NAME_TIP");
        String portnameText = this.m_bundle.getString("WC_PORTTYPE_NAME");
        String portNameTip = this.m_bundle.getString("WC_PORTNAME_TIP");
        String namespaceText = this.m_bundle.getString("WC_NAMESPACE");
        String namespaceTip = this.m_bundle.getString("WC_NAMESPACE_TIP");
        String wsdlNameText = this.m_bundle.getString("WC_SERVICE");
        String wsdlNameTip = this.m_bundle.getString("WC_SERVICE_TIP");
        this.setLayout(this.gridBagLayout1);
        this.introPrompt.setText(snprompt);
        this.m_requestSchemaPanel = new CommonSchemaPanel(this.m_project, this.m_scaDir, this.m_bundle, this.m_parentFrame, null, null, false, null, this, false, false, null);
        this.m_requestSchemaPanel.setName("m_requestSchemaPanel");
        this.m_replySchemaPanel = new CommonSchemaPanel(this.m_project, this.m_scaDir, this.m_bundle, this.m_parentFrame, null, null, false, null, this, false, false, null);
        this.m_replySchemaPanel.setName("m_replySchemaPanel");
        this.m_faultSchemaPanel = new CommonSchemaPanel(this.m_project, this.m_scaDir, this.m_bundle, this.m_parentFrame, null, null, false, null, this, false, false, null);
        this.m_faultSchemaPanel.setName("m_faultSchemaPanel");
        this.m_callbackSchemaPanel = new CommonSchemaPanel(this.m_project, this.m_scaDir, this.m_bundle, this.m_parentFrame, null, null, false, null, this, false, false, null);
        this.m_callbackSchemaPanel.setName("m_callbackSchemaPanel");
        this.m_tabpane.add(requestTabText, this.m_requestSchemaPanel);
        this.m_tabpane.add(replyTabText, this.m_replySchemaPanel);
        this.m_tabpane.add(faultTabText, this.m_faultSchemaPanel);
        this.m_tabpane.add(callbackTabText, this.m_callbackSchemaPanel);
        this.m_tabpane.setName("m_tabpane");
        this.operationLB.setText(StringUtils.stripMnemonic((String)operationText));
        this.operationLB.setLabelFor((Component)this.operationName);
        this.operationLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)operationText));
        this.operationName.setText(WSDL_DEFAULT_OPERATION_NAME);
        this.operationName.setToolTipText(operationNameTip);
        this.operationName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)operationText));
        this.operationName.getAccessibleContext().setAccessibleDescription(operationNameTip);
        this.operationName.setName("operationName");
        this.operationName.addFocusListener((FocusListener)this);
        this.portnameLB.setText(StringUtils.stripMnemonic((String)portnameText));
        this.portnameLB.setLabelFor((Component)this.portName);
        this.portnameLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)portnameText));
        this.portName.setText(WSDL_DEFAULT_PORTTYPE_NAME);
        this.portName.setToolTipText(portNameTip);
        this.portName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)portnameText));
        this.portName.getAccessibleContext().setAccessibleDescription(portNameTip);
        this.portName.setName("portName");
        this.portName.addFocusListener((FocusListener)this);
        this.callbackOperationLB.setText(StringUtils.stripMnemonic((String)operationText));
        this.callbackOperationLB.setLabelFor((Component)this.callbackOperationName);
        this.callbackOperationLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)operationText));
        this.callbackOperationName.setText(WSDL_DEFAULT_CALLBACK_OPERATION_NAME);
        this.callbackOperationName.setToolTipText(operationNameTip);
        this.callbackOperationName.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)operationText));
        this.callbackOperationName.getAccessibleContext().setAccessibleDescription(operationNameTip);
        this.callbackOperationName.setName("callbackOperationName");
        this.callbackOperationName.addFocusListener((FocusListener)this);
        this.callbackPortnameLB.setText(StringUtils.stripMnemonic((String)portnameText));
        this.callbackPortnameLB.setLabelFor((Component)this.callbackPortname);
        this.callbackPortnameLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)portnameText));
        this.callbackPortname.setText(WSDL_DEFAULT_CALLBACK_PORTTYPE_NAME);
        this.callbackPortname.setToolTipText(portNameTip);
        this.callbackPortname.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)portnameText));
        this.callbackPortname.getAccessibleContext().setAccessibleDescription(portNameTip);
        this.callbackPortname.setName("callbackPortname");
        this.callbackPortname.addFocusListener((FocusListener)this);
        this.namespaceLB.setText(StringUtils.stripMnemonic((String)namespaceText));
        this.namespaceLB.setLabelFor(this.namespaceFLD);
        this.namespaceLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)namespaceText));
        this.namespaceFLD.setText("");
        this.namespaceFLD.setToolTipText(namespaceTip);
        this.namespaceFLD.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)namespaceText));
        this.namespaceFLD.getAccessibleContext().setAccessibleDescription(namespaceTip);
        this.namespaceFLD.setName("namespaceFLD");
        this.wsdlNameLB.setText(StringUtils.stripMnemonic((String)wsdlNameText));
        this.wsdlNameLB.setLabelFor((Component)this.wsdlNameFLD);
        this.wsdlNameLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)wsdlNameText));
        this.wsdlNameFLD.setToolTipText(wsdlNameTip);
        this.wsdlNameFLD.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)wsdlNameText));
        this.wsdlNameFLD.getAccessibleContext().setAccessibleDescription(wsdlNameTip);
        this.wsdlNameFLD.getDocument().addDocumentListener(this);
        this.wsdlNameFLD.setName("wsdlNameFLD");
        this.wsdlNameFLD.setMaximumCharacterLength(248);
        this.add((Component)this.introPrompt, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 10, 0), 0, 0));
        int leftpad = 5;
        int toppad = 10;
        this.add((Component)this.m_tabpane, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 18, 2, new Insets(toppad, 0, 0, 0), 0, 0));
        this.m_requestSchemaPanel.add((Component)this.operationLB, new GridBagConstraints(0, this.m_requestSchemaPanel.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_requestSchemaPanel.m_vertical_pad, this.m_requestSchemaPanel.m_leftpad, this.m_requestSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_requestSchemaPanel.add((Component)this.operationName, new GridBagConstraints(1, this.m_requestSchemaPanel.m_nextRow, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_requestSchemaPanel.m_vertical_pad, this.m_requestSchemaPanel.m_fieldsep, this.m_requestSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_requestSchemaPanel.add((Component)this.portnameLB, new GridBagConstraints(0, this.m_requestSchemaPanel.m_nextRow + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_requestSchemaPanel.m_vertical_pad, this.m_requestSchemaPanel.m_leftpad, this.m_requestSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_requestSchemaPanel.add((Component)this.portName, new GridBagConstraints(1, this.m_requestSchemaPanel.m_nextRow + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_requestSchemaPanel.m_vertical_pad, this.m_requestSchemaPanel.m_fieldsep, this.m_requestSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_callbackSchemaPanel.add((Component)this.callbackOperationLB, new GridBagConstraints(0, this.m_callbackSchemaPanel.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_callbackSchemaPanel.m_vertical_pad, this.m_callbackSchemaPanel.m_leftpad, this.m_callbackSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_callbackSchemaPanel.add((Component)this.callbackOperationName, new GridBagConstraints(1, this.m_callbackSchemaPanel.m_nextRow, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_callbackSchemaPanel.m_vertical_pad, this.m_callbackSchemaPanel.m_fieldsep, this.m_callbackSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_callbackSchemaPanel.add((Component)this.callbackPortnameLB, new GridBagConstraints(0, this.m_callbackSchemaPanel.m_nextRow + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_callbackSchemaPanel.m_vertical_pad, this.m_callbackSchemaPanel.m_leftpad, this.m_callbackSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.m_callbackSchemaPanel.add((Component)this.callbackPortname, new GridBagConstraints(1, this.m_callbackSchemaPanel.m_nextRow + 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_callbackSchemaPanel.m_vertical_pad, this.m_callbackSchemaPanel.m_fieldsep, this.m_callbackSchemaPanel.m_vertical_pad, 0), 0, 0));
        this.add((Component)this.namespaceLB, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(20, leftpad, 0, 6), 0, 0));
        this.add((Component)this.namespaceFLD, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(20, 0, 0, leftpad), 0, 0));
        this.add((Component)this.wsdlNameLB, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(this.m_requestSchemaPanel.m_vertical_pad, leftpad, 0, 6), 0, 0));
        this.add((Component)this.wsdlNameFLD, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(this.m_requestSchemaPanel.m_vertical_pad, 0, toppad, leftpad), 0, 0));
        this.add((Component)this.dummy1, new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_replySchemaPanel.add((Component)this.dummy2, new GridBagConstraints(0, this.m_replySchemaPanel.m_nextRow, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_faultSchemaPanel.add((Component)this.dummy3, new GridBagConstraints(0, this.m_faultSchemaPanel.m_nextRow, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.m_requestSchemaPanel.schemaLoc.requestFocus();
        this.m_requestSchemaPanel.setServiceName(this.m_serviceName);
        this.m_replySchemaPanel.setServiceName(this.m_serviceName);
        this.m_faultSchemaPanel.setServiceName(this.m_serviceName);
        this.m_callbackSchemaPanel.setServiceName(this.m_serviceName);
        this.namespaceFLD.setText(WsdlCreatePanel.getDefaultNamespace(this.m_project_context, this.m_defaultNamespacePrefix, this.m_serviceName));
        this.m_lastWsdlName = this.m_serviceName + WSDL_SUFFIX;
        this.wsdlNameFLD.setText(this.m_lastWsdlName);
        this.m_requestSchemaPanel.setSchemaLocationText("xsd/singleString.xsd");
        this.m_requestSchemaPanel.addSchemaElement(SCAProject.SINGLE_STRING_ELEMENT_QNAME);
        this.m_currdiag.setOKButtonEnabled(true);
    }

    public static String getDefaultNamespace(Context context, String namespacePrefix, String namespaceSuffix) {
        if (!MAIN_DEBUG) {
            return namespacePrefix + CommonScaUtils.getEncodedName((String)WsdlCreatePanel.getApplicationShortName(context)) + "/" + CommonScaUtils.getEncodedName((String)WsdlCreatePanel.getProjectShortName(context)) + "/" + CommonScaUtils.getEncodedName((String)namespaceSuffix);
        }
        return namespacePrefix + namespaceSuffix;
    }

    public static String getProjectShortName(Context context) {
        Project jproject = context.getProject();
        String projectName = jproject.toString();
        projectName = projectName.substring(0, projectName.lastIndexOf("."));
        return projectName;
    }

    public static String getApplicationShortName(Context context) {
        Workspace work1 = context.getWorkspace();
        String appName = work1.getShortLabel();
        appName = appName.substring(0, appName.lastIndexOf("."));
        return appName;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        JButton button;
        Object object = e.getSource();
        if (object instanceof JButton && (button = (JButton)object).isEnabled()) {
            button.setBorder(s_etchedBorder);
            button.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        Object object = e.getSource();
        if (object instanceof JButton) {
            JButton button = (JButton)object;
            button.setBorder(s_emptyBorder);
            button.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src.equals(this.callbackOperationName)) {
            this.checkXmlName((JTextField)this.callbackOperationName);
        } else if (src.equals(this.operationName)) {
            this.checkXmlName((JTextField)this.operationName);
        } else if (src.equals(this.portName)) {
            this.checkXmlName((JTextField)this.portName);
        } else if (src.equals(this.callbackPortname)) {
            this.checkXmlName((JTextField)this.callbackPortname);
        }
    }

    private void checkXmlName(JTextField field) {
        if (!SCAControllerImpl.isNameValidForXml((String)field.getText().trim())) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)SCAResourceLookup.getString((String)"CM_NAME_FIELD_ERROR"), (String)SCAResourceLookup.getString((String)"CM_NAME_FIELD_ERROR_TITLE"), (int)0);
            new FocusRequester(field);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.checkDoc(e);
    }

    private void checkDoc(DocumentEvent e) {
        if (this.m_replySchemaPanel.checkPanel()) {
            this.m_faultSchemaPanel.setEnabledAll(true);
        } else {
            this.m_faultSchemaPanel.setEnabledAll(false);
        }
        if (!this.m_requestSchemaPanel.checkPanel()) {
            this.m_currdiag.setOKButtonEnabled(false);
            return;
        }
        String wsdlName = this.wsdlNameFLD.getText().trim();
        if (wsdlName.length() == 0) {
            this.m_currdiag.setOKButtonEnabled(false);
            return;
        }
        if (!wsdlName.equals(this.m_lastWsdlName) && wsdlName.indexOf(WSDL_SUFFIX) > 0) {
            String wsdlPref;
            String lastNameSpace = this.namespaceFLD.getText().trim();
            if (lastNameSpace.endsWith(wsdlPref = this.m_lastWsdlName.substring(0, this.m_lastWsdlName.indexOf(WSDL_SUFFIX)))) {
                String wsdlPref2 = wsdlName.substring(0, wsdlName.indexOf(WSDL_SUFFIX));
                lastNameSpace = lastNameSpace.substring(0, lastNameSpace.lastIndexOf(wsdlPref)) + wsdlPref2;
                this.namespaceFLD.setText(lastNameSpace);
            }
            this.m_lastWsdlName = wsdlName;
        }
        this.m_currdiag.setOKButtonEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
    }

    public boolean generateWsdlFromSchema() {
        String cpName;
        String copName;
        String pName;
        String opName;
        String wsdlNameIn = this.wsdlNameFLD.getText();
        if (wsdlNameIn.endsWith(WSDL_SUFFIX)) {
            this.m_serviceName = wsdlNameIn.substring(0, wsdlNameIn.indexOf(WSDL_SUFFIX));
        } else {
            this.m_serviceName = wsdlNameIn;
            wsdlNameIn = wsdlNameIn + WSDL_SUFFIX;
        }
        this.m_wsdlName = this.m_serviceName + WSDL_SUFFIX;
        if (!SCAControllerImpl.isNameValidForXml((String)this.m_serviceName)) {
            MessageFormat msgformat = new MessageFormat(this.m_bundle.getString("WC_INVALID_WSDL_NAME_ERROR"));
            Object[] obj = new Object[]{wsdlNameIn};
            MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)msgformat.format(obj), (String)this.m_bundle.getString("WC_INVALID_WSDL_NAME_ERROR_TITLE"), (int)0);
            return false;
        }
        String wsdlPath = null;
        if (!MAIN_DEBUG) {
            Project project = this.m_project_context.getProject();
            wsdlPath = SCAProject.getScaWSDLFilePath((Project)project, (String)this.m_wsdlName);
        } else {
            wsdlPath = "c:\\tmp" + File.separatorChar + this.m_wsdlName;
        }
        if (!WsdlCreatePanel.isWsdlFileNew(this.m_project, this.m_parentFrame, wsdlPath, this.m_serviceName)) {
            return false;
        }
        QName elemQname = (QName)this.m_requestSchemaPanel.elementCB.getSelectedItem();
        String xsdLoc = this.m_requestSchemaPanel.schemaLoc.getText().trim();
        if (xsdLoc.equals("xsd/singleString.xsd") && !MAIN_DEBUG) {
            this.m_scaproj.copyDefaultSchemaWhenUsed();
        }
        if (!this.checkElementNamespace(xsdLoc, elemQname, this.m_requestSchemaPanel.schemaLoc)) {
            return false;
        }
        QName replyElemQname = null;
        String replyXsdLoc = this.m_replySchemaPanel.schemaLoc.getText().trim();
        QName faultElemQname = null;
        String faultXsdLoc = null;
        if (replyXsdLoc.length() == 0) {
            replyXsdLoc = null;
        } else {
            replyElemQname = (QName)this.m_replySchemaPanel.elementCB.getSelectedItem();
            if (!this.checkElementNamespace(replyXsdLoc, replyElemQname, this.m_replySchemaPanel.schemaLoc)) {
                return false;
            }
            faultXsdLoc = this.m_faultSchemaPanel.schemaLoc.getText().trim();
            if (faultXsdLoc.length() == 0) {
                faultXsdLoc = null;
            } else {
                faultElemQname = (QName)this.m_faultSchemaPanel.elementCB.getSelectedItem();
                if (!this.checkElementNamespace(faultXsdLoc, faultElemQname, this.m_faultSchemaPanel.schemaLoc)) {
                    return false;
                }
            }
        }
        QName callbackElemQname = (QName)this.m_callbackSchemaPanel.elementCB.getSelectedItem();
        String callbackXsdLoc = this.m_callbackSchemaPanel.schemaLoc.getText().trim();
        if (callbackXsdLoc.length() > 0 && !this.checkElementNamespace(xsdLoc, callbackElemQname, this.m_callbackSchemaPanel.schemaLoc)) {
            return false;
        }
        String namespace1 = this.namespaceFLD.getText().trim();
        if (namespace1.length() == 0 || namespace1.equals(this.m_defaultNamespacePrefix)) {
            namespace1 = WsdlCreatePanel.getDefaultNamespace(this.m_project_context, this.m_defaultNamespacePrefix, this.m_serviceName);
        }
        if ((opName = this.operationName.getText().trim()).length() == 0) {
            opName = WSDL_DEFAULT_OPERATION_NAME;
        }
        if ((pName = this.portName.getText().trim()).length() == 0) {
            pName = WSDL_DEFAULT_PORTTYPE_NAME;
        }
        if ((copName = this.callbackOperationName.getText().trim()).length() == 0) {
            copName = WSDL_DEFAULT_CALLBACK_OPERATION_NAME;
        }
        if ((cpName = this.callbackPortname.getText().trim()).length() == 0) {
            cpName = WSDL_DEFAULT_CALLBACK_PORTTYPE_NAME;
        }
        this.m_porttypeQname = new QName(namespace1, pName);
        if (callbackXsdLoc != null && callbackXsdLoc.length() > 0) {
            this.m_callbackPorttypeQname = new QName(namespace1, cpName);
        }
        WsdlUtil.writeWSDL(this.m_project, this.m_parentFrame, wsdlPath, this.m_serviceName, namespace1, opName, this.m_porttypeQname, xsdLoc, elemQname, replyXsdLoc, replyElemQname, faultXsdLoc, faultElemQname, copName, this.m_callbackPorttypeQname, callbackXsdLoc, callbackElemQname);
        WsdlCreatePanel.loadWsdl(this.m_project, this.m_parentFrame, wsdlPath);
        return true;
    }

    public static boolean isWsdlFileNew(Project project, Frame frame, String filepath, String currentServiceName) {
        File testfile = new File(filepath);
        if (testfile.exists()) {
            if (!WsdlCreatePanel.okToReplaceWsdl(frame, SCAControllerImpl.getController((Project)project), URLFactory.newURL((String)filepath), currentServiceName)) {
                return false;
            }
            ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
            MessageFormat msgformat = new MessageFormat(rbundle.getString("WC_WSDL_ALREADY_EXISTS_ERROR"));
            Object[] obj = new Object[]{filepath};
            int ret = JOptionPane.showOptionDialog(frame, msgformat.format(obj), rbundle.getString("WC_WSDL_ALREADY_EXISTS_TITLE"), 0, 3, null, null, null);
            if (ret == 1) {
                return false;
            }
            if (ret == 0) {
                // empty if block
            }
        }
        return true;
    }

    public static boolean okToReplaceWsdl(Frame frame, SCAController scon, URL wsdlUrl, String currentServiceName) {
        List wsdlUsages = scon.getWsdlUsages(wsdlUrl);
        if (wsdlUsages == null || wsdlUsages.size() == 0) {
            return true;
        }
        if (wsdlUsages.size() == 1 && ((String)wsdlUsages.get(0)).equals(currentServiceName)) {
            return true;
        }
        String ustr = "";
        for (String use1 : wsdlUsages) {
            ustr = ustr + "\n  " + use1;
        }
        ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
        MessageFormat msgformat = new MessageFormat(rbundle.getString("WC_WSDL_IS_IN_USE_ERROR"));
        Object[] obj = new Object[]{wsdlUrl.getFile(), ustr};
        MultiLineOptionPane.showMessageDialog((Component)frame, (Object)msgformat.format(obj), (String)rbundle.getString("WC_WSDL_ALREADY_EXISTS_TITLE"), (int)0);
        return false;
    }

    public static Definition loadWsdl(Project project, Frame frame, String filepath) {
        SCAComposite scaComposite = null;
        SCAWSDLManager wsdlMgr = null;
        URL wsdlUrl = URLFactory.newURL((String)filepath);
        Definition wdef = null;
        try {
            scaComposite = SCAModelBuilder.getSCAModelBuilder((Project)project).getSCAComposite();
            wsdlMgr = scaComposite.getWSDLManager();
            wdef = wsdlMgr.reloadWSDL(wsdlUrl);
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        if (scaComposite == null) {
            throw new RuntimeException("SCAModelBuilder.getSCAModelBuilder(_project).getSCAComposite() returns NULL");
        }
        return wdef;
    }

    private boolean checkElementNamespace(String xsdLoc, QName elemQname, JTextField schemaField) {
        return CommonUtils.checkElementNamespace((Frame)this.m_parentFrame, (String)xsdLoc, (QName)elemQname, (JTextField)schemaField);
    }

    public WsdlInfo getWsdlInfo() {
        return new WsdlInfo(this.m_wsdlName, this.m_porttypeQname, this.m_callbackPorttypeQname);
    }

    public static WsdlCreatePanel displayDialog(Frame parentFrame, Context context, String serviceNameIn, String defaultNamespacePrefix) {
        WsdlCreatePanel wsdlCreatePanel = null;
        try {
            if (MAIN_DEBUG) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ResourceBundle rbundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
        String titleText = rbundle.getString("WC_DIALOG_TITLE");
        ScaCommonDialog diag1 = new ScaCommonDialog(parentFrame, titleText, 7, null);
        diag1.setResizable(true);
        if (s_last_dialog_size != null) {
            diag1.setPreferredSize(s_last_dialog_size);
        } else {
            diag1.setPreferredSize(500, 380);
        }
        try {
            wsdlCreatePanel = new WsdlCreatePanel(parentFrame, context, (JEWTDialog)diag1, serviceNameIn, defaultNamespacePrefix);
        }
        catch (Exception exp) {
            return null;
        }
        diag1.setContent((Component)wsdlCreatePanel);
        diag1.setCancelButtonText(rbundle.getString("WC_CANCEL_BUTTON"));
        while (true) {
            boolean validated = false;
            boolean ok = false;
            ok = diag1.runDialog();
            if (!ok) break;
            validated = wsdlCreatePanel.generateWsdlFromSchema();
            if (validated) {
                return wsdlCreatePanel;
            }
            new FocusRequester((Component)wsdlCreatePanel.wsdlNameFLD);
        }
        return null;
    }

    public static void main(String[] args) {
        MAIN_DEBUG = true;
        AdapterWizardContext.IS_STANDALONE_TESTING = true;
        String serviceName = "testA";
        Frame tframe = new Frame();
        WsdlCreatePanel wsdlCreatePanel = null;
        String defaultNamespacePrefix = "http://oracle.com/sca/testing/";
        try {
            wsdlCreatePanel = WsdlCreatePanel.displayDialog(tframe, null, serviceName, defaultNamespacePrefix);
            if (wsdlCreatePanel != null) {
                WsdlInfo wsdlInfo = wsdlCreatePanel.getWsdlInfo();
                String testx = "";
            }
        }
        catch (Exception wex) {
            wex.printStackTrace();
        }
        System.exit(0);
    }
}

