/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.javatools.util.BundleLoader;
import oracle.tip.tools.ide.common.graph.GraphUtils;
import oracle.tip.tools.ide.common.resourcepicker.ResourcePickerDialog;
import oracle.tip.tools.ide.common.resourcepicker.appserver.explorer.ResourcePaletteAppServerAdapater;
import oracle.tip.tools.ide.common.resourcepicker.uddi.ResourcePaletteUDDIAdapter;
import oracle.tip.tools.ide.common.resourcepicker.uddi.UDDIService;
import oracle.tip.tools.ide.common.resourcepicker.uddi.UDDIServiceOptionPicker;
import oracle.tip.tools.ide.common.resourcepicker.wsil.explorer.ResourcePaletteWSILAdapater;
import oracle.tip.tools.ide.common.sca.CommonScaUtils;
import oracle.tip.tools.ide.common.ui.ToolBar;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.BPELWSDLNode;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.common.utils.URLUtil;
import oracle.tip.tools.ide.fabric.addin.SCAProject;
import oracle.tip.tools.ide.fabric.api.WsdlInfo;
import oracle.tip.tools.ide.fabric.model.SCAComposite;
import oracle.tip.tools.ide.fabric.model.SCAInterface;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilder;
import oracle.tip.tools.ide.fabric.model.SCAModelBuilderException;
import oracle.tip.tools.ide.fabric.model.SCAService;
import oracle.tip.tools.ide.fabric.model.SCAWSDLManager;
import oracle.tip.tools.ide.fabric.model.SCAWSDLManagerClient;
import oracle.tip.tools.ide.fabric.resource.SCAResourceLookup;
import oracle.tip.tools.ide.fabric.scabrowser.ExternalServiceChooserDialog;
import oracle.tip.tools.ide.fabric.scabrowser.ExternalServicesViewerContext;
import oracle.tip.tools.ide.pm.i18n.BPELStringTranslator;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardContext;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.CommonSchemaPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.techAdapterWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.OperationDisplay;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.PortTypeDisplay;
import oracle.tip.tools.ide.pm.modules.bizintegration.wsdlcreate.WsdlCreatePanel;
import oracle.tip.tools.ide.pm.resources.images.ImageCache;

public class CommonWsdlSelectionPanel
extends JPanel
implements FocusListener,
ActionListener,
SCAWSDLManagerClient {
    public int m_firstRow = 3;
    public int m_nextRow;
    public int m_toppad = 0;
    public int m_leftpad = 0;
    public int m_rowsep = 6;
    public int m_fieldsep = 5;
    public int m_indent = 0;
    public boolean m_showCallbacks = true;
    public boolean m_showOperationPicker = false;
    public String m_operationName = null;
    public String m_callbackOperationName = null;
    public boolean m_serviceBrowserCurrentCompositeOK = false;
    public boolean m_doReload = false;
    Frame m_parentFrame;
    ResourceBundle m_bundle;
    String m_dirPath;
    URL m_projURL;
    SCAProject m_scaproj = null;
    URL m_wsdlDirURL;
    Context m_project_context = null;
    Project m_project;
    String m_routingMediatorXMLPath;
    boolean m_isUpdateMode = false;
    WsdlInfo m_wsdlInfo = null;
    String m_serviceName;
    String m_defaultNamespace;
    DocumentListener m_doclis;
    SCAWSDLManager m_wsdlMgr = null;
    String m_wsdl_relpath;
    QName m_porttypeQname;
    QName m_callbackPorttypeQname = null;
    public Definition m_wdef = null;
    String m_wsdlAbsolutePath;
    String m_last_wsdlloc = "";
    boolean m_wsdlHasError = false;
    boolean m_portHasError = true;
    WsdlInfo m_newWsdlInfo = null;
    boolean m_initializationComplete = false;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    public JLabel m_wsdlLB = new JLabel();
    public JTextField m_wsdlLoc = new JTextField();
    ToolBar btnPnl = new ToolBar();
    public JButton m_importWSDLBtn;
    public JButton m_importSCAServiceBtn;
    public JButton m_genWSDLBtn;
    public JLabel portLB = new JLabel();
    public JComboBox m_portCB = new JComboBox();
    public JLabel operationLB = new JLabel();
    public JComboBox m_operationCB = new JComboBox();
    public JLabel m_callbackPortLB = new JLabel();
    public JComboBox m_callbackPortCB = new JComboBox();
    public JLabel m_callbackOperationLB = new JLabel();
    public JComboBox m_callbackOperationCB = new JComboBox();
    ButtonGroup rbgroup = new ButtonGroup();
    private JLabel dummy1 = new JLabel();
    public String m_noCallback;
    public String m_notSpecified;
    String m_jcaFile = null;
    SCAService m_scaService = null;
    private UDDIService m_uddiService = null;
    private boolean m_showUDDIRegistry = false;
    private String m_resourcePickerResourceProvider = "FILE_PROVIDER_SELECTED";
    public static boolean MAIN_DEBUG = false;

    public CommonWsdlSelectionPanel(Frame parentFrame, Context jcontext, Project jdevProject, WsdlInfo wsdlInfo, String serviceName, String defaultNamespace, DocumentListener doclis) throws Exception {
        this.m_parentFrame = parentFrame;
        this.m_project_context = jcontext;
        this.m_project = jdevProject;
        if (!MAIN_DEBUG) {
            CommonScaUtils.fixContextForProject((Context)this.m_project_context, (Project)this.m_project);
        }
        this.m_wsdlInfo = wsdlInfo;
        if (this.m_wsdlInfo != null) {
            this.m_isUpdateMode = true;
        }
        this.m_serviceName = serviceName;
        this.m_defaultNamespace = defaultNamespace;
        this.m_doclis = doclis;
        this.m_bundle = BundleLoader.getBundle((String)techAdapterWizard.RESOURCE_BUNDLE);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void jbInit() throws Exception {
        if (!MAIN_DEBUG) {
            this.m_dirPath = SCAProject.getScaDirectoryPath((Project)this.m_project);
            this.m_scaproj = SCAProject.getSCAProject((Project)this.m_project);
            this.m_projURL = this.m_scaproj.getSCARoot();
            this.m_wsdlDirURL = this.m_scaproj.getWSDLRoot();
        } else {
            this.m_dirPath = "c:\\tmp";
        }
        String wsdllocText = this.m_bundle.getString("WC_WSDL_FILE_PROMPT");
        String wsdltip = this.m_bundle.getString("WC_WSDL_FILE_TIP");
        String portText = this.m_bundle.getString("WC_PORTTYPE_PROMPT");
        String portTip = this.m_bundle.getString("WC_PORTTYPE_TIP");
        String callbackPortText = this.m_bundle.getString("WC_CALLBACK_PORTTYPE_PROMPT");
        String callbackPortTip = this.m_bundle.getString("WC_CALLBACK_PORTTYPE_TIP");
        String operationText = this.m_bundle.getString("WC_OPERATION_PROMPT");
        String operationTip = this.m_bundle.getString("WC_OPERATION_TIP");
        String callbackOperationText = this.m_bundle.getString("WC_CALLBACK_OPERATION_PROMPT");
        String callbackOperationTip = this.m_bundle.getString("WC_CALLBACK_OPERATION_TIP");
        this.m_noCallback = this.m_bundle.getString("WC_NO_CALLBACK_PORTTYPE");
        this.m_notSpecified = this.m_bundle.getString("WC_NOT_SPECIFIED");
        String browseWsdltip = this.m_bundle.getString("WC_BROWSE_WSDL_TIP");
        String genWsdltip = this.m_bundle.getString("WC_GENERATE_WSDL_TIP");
        this.setLayout(this.gridBagLayout1);
        this.m_wsdlLB.setText(StringUtils.stripMnemonic((String)wsdllocText));
        this.m_wsdlLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)wsdllocText));
        this.m_wsdlLB.setLabelFor(this.m_wsdlLoc);
        this.m_wsdlLoc.setToolTipText(wsdltip);
        this.m_wsdlLoc.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)wsdllocText));
        this.m_wsdlLoc.getAccessibleContext().setAccessibleDescription(wsdltip);
        this.m_wsdlLoc.addFocusListener(this);
        this.m_wsdlLoc.setName("m_wsdlLoc");
        this.m_wsdlLoc.getDocument().addDocumentListener(this.m_doclis);
        this.m_importWSDLBtn = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/importwsdl16.png", UIHelper.class)));
        this.m_importWSDLBtn.setToolTipText(browseWsdltip);
        this.m_importWSDLBtn.addActionListener(this);
        this.m_importWSDLBtn.setName("m_importWSDLBtn");
        this.btnPnl.add((Component)this.m_importWSDLBtn);
        this.m_importSCAServiceBtn = UIHelper.createModelerButton((Icon)ImageCache.getIcon("application/bpel/service_explorer16.png"));
        this.m_importSCAServiceBtn.setToolTipText(BPELStringTranslator.getString("SCA_SERVICE_EXPLORER_TIP"));
        this.m_importSCAServiceBtn.addActionListener(this);
        this.btnPnl.add((Component)this.m_importSCAServiceBtn);
        this.m_importSCAServiceBtn.setVisible(false);
        this.m_genWSDLBtn = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)"images/gear.gif", UIHelper.class)));
        this.m_genWSDLBtn.setToolTipText(genWsdltip);
        this.m_genWSDLBtn.addActionListener(this);
        this.m_genWSDLBtn.setName("m_genWSDLBtn");
        this.btnPnl.add((Component)this.m_genWSDLBtn);
        this.portLB.setText(StringUtils.stripMnemonic((String)portText));
        this.portLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)portText));
        this.portLB.setLabelFor(this.m_portCB);
        this.m_portCB.setToolTipText(portTip);
        this.m_portCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)portText));
        this.m_portCB.getAccessibleContext().setAccessibleDescription(portTip);
        this.m_portCB.setPreferredSize(new Dimension(250, 20));
        this.m_portCB.addActionListener(this);
        this.m_portCB.setName("m_portCB");
        this.operationLB.setText(StringUtils.stripMnemonic((String)operationText));
        this.operationLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)operationText));
        this.operationLB.setLabelFor(this.m_operationCB);
        this.m_operationCB.setToolTipText(operationTip);
        this.m_operationCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)operationText));
        this.m_operationCB.getAccessibleContext().setAccessibleDescription(operationTip);
        this.m_operationCB.setPreferredSize(new Dimension(250, 20));
        this.m_operationCB.addActionListener(this);
        this.m_operationCB.setName("m_operationCB");
        this.m_callbackPortLB.setText(StringUtils.stripMnemonic((String)callbackPortText));
        this.m_callbackPortLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)callbackPortText));
        this.m_callbackPortLB.setLabelFor(this.m_callbackPortCB);
        this.m_callbackPortCB.setToolTipText(callbackPortTip);
        this.m_callbackPortCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)callbackPortText));
        this.m_callbackPortCB.getAccessibleContext().setAccessibleDescription(callbackPortTip);
        this.m_callbackPortCB.setPreferredSize(new Dimension(250, 20));
        this.m_callbackPortCB.addActionListener(this);
        this.m_callbackPortCB.setName("m_callbackPortCB");
        this.m_callbackOperationLB.setText(StringUtils.stripMnemonic((String)callbackOperationText));
        this.m_callbackOperationLB.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)callbackOperationText));
        this.m_callbackOperationLB.setLabelFor(this.m_callbackOperationCB);
        this.m_callbackOperationCB.setToolTipText(callbackOperationTip);
        this.m_callbackOperationCB.getAccessibleContext().setAccessibleName(StringUtils.stripMnemonic((String)callbackOperationText));
        this.m_callbackOperationCB.getAccessibleContext().setAccessibleDescription(callbackOperationTip);
        this.m_callbackOperationCB.setPreferredSize(new Dimension(250, 20));
        this.m_callbackOperationCB.addActionListener(this);
        this.m_callbackOperationCB.setName("m_callbackOperationCB");
    }

    public void initLayout() {
        CommonWsdlSelectionPanel container = this;
        this.m_nextRow = this.m_firstRow;
        container.add((Component)this.m_wsdlLB, new GridBagConstraints(0, this.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_toppad, this.m_indent + this.m_leftpad, 0, 0), 0, 0));
        container.add((Component)this.m_wsdlLoc, new GridBagConstraints(1, this.m_nextRow, 1, 1, 1.0, 0.0, 17, 2, new Insets(this.m_toppad, this.m_fieldsep, 0, 0), 0, 0));
        container.add((Component)this.btnPnl, new GridBagConstraints(2, this.m_nextRow++, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_toppad, this.m_fieldsep, 0, this.m_indent), 0, 0));
        container.add((Component)this.portLB, new GridBagConstraints(0, this.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_rowsep, this.m_indent + this.m_leftpad, 0, 0), 0, 0));
        container.add((Component)this.m_portCB, new GridBagConstraints(1, this.m_nextRow++, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.m_rowsep, this.m_fieldsep, 0, 0), 0, 0));
        if (this.m_showOperationPicker) {
            container.add((Component)this.operationLB, new GridBagConstraints(0, this.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_rowsep, this.m_indent + this.m_leftpad, 0, 0), 0, 0));
            container.add((Component)this.m_operationCB, new GridBagConstraints(1, this.m_nextRow++, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.m_rowsep, this.m_fieldsep, 0, 0), 0, 0));
        }
        if (this.m_showCallbacks) {
            container.add((Component)this.m_callbackPortLB, new GridBagConstraints(0, this.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_rowsep + 4, this.m_indent + this.m_leftpad, 0, 0), 0, 0));
            container.add((Component)this.m_callbackPortCB, new GridBagConstraints(1, this.m_nextRow++, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.m_rowsep + 4, this.m_fieldsep, 0, 0), 0, 0));
            if (this.m_showOperationPicker) {
                container.add((Component)this.m_callbackOperationLB, new GridBagConstraints(0, this.m_nextRow, 1, 1, 0.0, 0.0, 17, 0, new Insets(this.m_rowsep + 4, this.m_indent + this.m_leftpad, 0, 0), 0, 0));
                container.add((Component)this.m_callbackOperationCB, new GridBagConstraints(1, this.m_nextRow++, 1, 1, 0.0, 0.0, 17, 2, new Insets(this.m_rowsep + 4, this.m_fieldsep, 0, 0), 0, 0));
            }
        }
        container.add((Component)this.dummy1, new GridBagConstraints(0, this.m_nextRow + 20, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_isUpdateMode && this.m_wsdlInfo != null) {
            this.m_newWsdlInfo = this.m_wsdlInfo;
            this.m_wsdlLoc.setText(this.m_wsdlInfo.getWsdlLocation());
            this.checkNewWSDL();
        }
        this.m_initializationComplete = true;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    public void setUDDIRegistryVisible(boolean value) {
        this.m_showUDDIRegistry = value;
    }

    public void setServiceBrowserVisible(boolean value) {
        this.m_importSCAServiceBtn.setVisible(value);
    }

    public void setWsdlGenerationVisible(boolean value) {
        this.m_genWSDLBtn.setVisible(value);
    }

    public void replaceGenWsdlButtonActionListener(ActionListener actlis, boolean removeListener) {
        if (removeListener) {
            this.m_genWSDLBtn.removeActionListener(this);
        }
        this.m_genWSDLBtn.addActionListener(actlis);
    }

    public void showOperation(String operationName, String callbackOperationName) {
        this.m_showOperationPicker = true;
        this.m_operationName = operationName;
        this.m_callbackOperationName = callbackOperationName;
    }

    public SCAService getScaService() {
        return this.m_scaService;
    }

    public UDDIService getUDDIService() {
        return this.m_uddiService;
    }

    public void setUDDIService(UDDIService uddiService) {
        this.m_uddiService = uddiService;
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src.equals(this.m_wsdlLoc)) {
            String wsdlPath = this.m_wsdlLoc.getText().trim();
            if (!this.m_last_wsdlloc.equals(wsdlPath)) {
                this.m_uddiService = null;
            }
            this.checkNewWSDL();
        }
    }

    public boolean checkPanel() {
        String tempstr5;
        String tempstr4 = this.m_wsdlLoc.getText().trim();
        if (tempstr4 == null || tempstr4.length() == 0) {
            return false;
        }
        if (!this.m_last_wsdlloc.equals(tempstr4)) {
            return false;
        }
        if (this.m_wsdlHasError) {
            return false;
        }
        if (this.m_portCB.getItemCount() < 1 || this.m_portHasError) {
            return false;
        }
        return this.m_portCB.getItemCount() <= 1 || !(tempstr5 = ((PortTypeDisplay)this.m_portCB.getSelectedItem()).getQName().getLocalPart()).equals(this.m_notSpecified);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_importWSDLBtn) {
            this.handleImportWSDL();
        } else if (src == this.m_importSCAServiceBtn) {
            this.handleServiceBrowser();
        } else if (src == this.m_genWSDLBtn) {
            this.handleGenerateWSDL();
        } else if (src.equals(this.m_portCB)) {
            this.setOperationsForPorttype(this.m_portCB, this.m_operationCB, false);
            this.callDocListener();
        } else if (src.equals(this.m_callbackPortCB)) {
            this.setOperationsForPorttype(this.m_callbackPortCB, this.m_callbackOperationCB, true);
            this.callDocListener();
        } else if (src.equals(this.m_operationCB)) {
            this.callDocListener();
        } else if (src.equals(this.m_callbackOperationCB)) {
            this.callDocListener();
        }
    }

    private void validateWsdlPorttype(JComboBox port_CB) {
        PortTypeDisplay ptd = (PortTypeDisplay)port_CB.getSelectedItem();
        if (ptd == null) {
            return;
        }
        this.setCursor(new Cursor(3));
        this.m_portHasError = false;
        if (this.m_portHasError) {
            port_CB.requestFocus();
        }
        this.callDocListener();
        this.setCursor(new Cursor(0));
    }

    private void callDocListener() {
        if (this.m_doclis != null && this.m_initializationComplete) {
            this.m_doclis.changedUpdate(null);
        }
    }

    public void handleGenerateWSDL() {
        if (this.m_serviceName == null || this.m_serviceName.length() == 0) {
            MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)this.m_bundle.getString("WC_SERVICE_NAME_REQUIRED_ERROR"), (String)this.m_bundle.getString("WC_NAME_ERROR_TITLE"), (int)0);
            return;
        }
        WsdlCreatePanel wsdlCreatePanel = WsdlCreatePanel.displayDialog(this.m_parentFrame, this.m_project_context, this.m_serviceName, this.m_defaultNamespace);
        if (wsdlCreatePanel != null) {
            this.m_newWsdlInfo = wsdlCreatePanel.getWsdlInfo();
            this.m_wsdlLoc.setText(this.m_newWsdlInfo.getWsdlLocation());
            this.m_last_wsdlloc = "";
            this.m_scaService = null;
            this.m_uddiService = null;
            this.checkNewWSDL();
        }
    }

    public void setResourcePickerDialogResourceProvider(String resourceProvider) {
        this.m_resourcePickerResourceProvider = resourceProvider;
    }

    public void handleImportWSDL() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new ResourcePaletteWSILAdapater());
        list.add(new ResourcePaletteAppServerAdapater());
        if (this.m_showUDDIRegistry) {
            list.add(new ResourcePaletteUDDIAdapter());
        }
        ResourcePickerDialog resourcePickerDialog = new ResourcePickerDialog(GraphUtils.getFrame((Component)this), 1, new File(this.m_dirPath), list);
        resourcePickerDialog.setSelectedResourceProvider(this.m_resourcePickerResourceProvider);
        if (resourcePickerDialog.display() != 1) {
            return;
        }
        URL wsdlURL = resourcePickerDialog.getSelectedURL();
        this.m_scaService = null;
        if (resourcePickerDialog.getSelectedResource() instanceof UDDIService) {
            this.m_uddiService = (UDDIService)resourcePickerDialog.getSelectedResource();
            UDDIServiceOptionPicker uddiOptionPicker = new UDDIServiceOptionPicker(GraphUtils.getFrame((Component)this));
            uddiOptionPicker.run();
            this.m_uddiService.setResolveWSDL(uddiOptionPicker.isResolveWSDL());
            this.m_uddiService.setResolveEndpoint(uddiOptionPicker.isResolveEndpoint());
            wsdlURL = this.m_uddiService.getWSDL();
        }
        if (wsdlURL != null && (wsdlURL = CommonScaUtils.putFileinProjectDir((Component)this.m_parentFrame, (Project)this.m_project, (URL)this.m_projURL, (URL)this.m_wsdlDirURL, (URL)wsdlURL, BPELWSDLNode.class)) != null) {
            String wsdlURLString = URLUtil.toString((URL)wsdlURL);
            this.m_wsdlLoc.setText(wsdlURLString);
            if (this.m_uddiService != null) {
                this.m_newWsdlInfo = new WsdlInfo(CommonSchemaPanel.convertUriRelativeProject(this.m_dirPath, wsdlURLString), this.m_uddiService.getPortType(), this.m_uddiService.getCallbackPortType());
            }
            this.checkNewWSDL();
            return;
        }
        MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)this.m_bundle.getString("WS_NO_WSDL_ERROR"), (String)this.m_bundle.getString("WS_NO_WSDL_ERROR_T"), (int)0);
    }

    public void handleServiceBrowser() {
        ExternalServicesViewerContext svcViewContext = new ExternalServicesViewerContext(this.m_project_context);
        if (this.m_serviceBrowserCurrentCompositeOK) {
            svcViewContext.setCurrentCompositeOK(true);
        }
        ExternalServiceChooserDialog explorer = new ExternalServiceChooserDialog(GraphUtils.getFrame((Component)this), this.m_project_context, svcViewContext);
        explorer.getScaBrowser().setBorder(null);
        explorer.getScaBrowser().setLabelVisible(false);
        explorer.getScaBrowser().getCheckBox().setVisible(false);
        explorer.setTitle(BPELStringTranslator.getString("SCA_SERVICE_EXPLORER_TITTLE"));
        explorer.setMinimumSize(new Dimension(50, 50));
        explorer.setPreferredSize(new Dimension(450, 400));
        explorer.setSize(450, 400);
        boolean ok = explorer.runDialog();
        if (!ok) {
            return;
        }
        SCAService sserv = explorer.getSelectedService();
        if (sserv == null) {
            return;
        }
        this.m_scaService = sserv;
        URL wsdlurl = sserv.getWsdlUrl();
        this.m_wsdlLoc.setText(URLUtil.toExternalForm((URL)wsdlurl));
        SCAInterface scaint = sserv.getInterface();
        this.m_newWsdlInfo = new WsdlInfo(CommonSchemaPanel.convertUriRelativeProject(this.m_dirPath, URLUtil.toExternalForm((URL)wsdlurl)), scaint.getInterfaceQName(), scaint.getCallbankInterfaceQName());
        this.m_uddiService = null;
        this.checkNewWSDL();
    }

    public void setWsdlLoc(String wsdlloc) {
        this.m_wsdlLoc.setText(wsdlloc);
        this.checkNewWSDL();
    }

    private void checkNewWSDL() {
        String wsdlPath = this.m_wsdlLoc.getText().trim();
        String relpath = CommonSchemaPanel.convertUriRelativeProject(this.m_dirPath, wsdlPath);
        if (wsdlPath != null && wsdlPath.trim().length() > 0) {
            if (!wsdlPath.equals(relpath)) {
                this.m_wsdlLoc.setText(relpath);
                wsdlPath = relpath;
            }
            if (this.m_last_wsdlloc.equals(wsdlPath)) {
                return;
            }
            this.m_last_wsdlloc = wsdlPath;
            this.m_portCB.removeAllItems();
            this.m_callbackPortCB.removeAllItems();
            this.m_wdef = null;
            URL wsdlUrl = null;
            SCAProject scaproj = SCAProject.getSCAProject((Project)this.m_project);
            if (!MAIN_DEBUG) {
                wsdlUrl = scaproj.getScaWsdlUrl(relpath);
                SCAComposite scaComposite = null;
                try {
                    scaComposite = SCAModelBuilder.getSCAModelBuilder((Project)this.m_project).getSCAComposite();
                }
                catch (SCAModelBuilderException ex) {
                    ex.printStackTrace();
                    return;
                }
                SCAWSDLManager wsdlMgr = scaComposite.getWSDLManager();
                Container clientComponent = this.getParent();
                CommonWsdlSelectionPanel swmc = this;
                if (this.m_doReload) {
                    wsdlMgr.reloadWSDL(wsdlUrl, (SCAWSDLManagerClient)swmc, null, (Component)clientComponent);
                } else {
                    wsdlMgr.loadWSDL(wsdlUrl, (SCAWSDLManagerClient)swmc, null, (Component)clientComponent);
                }
            }
        }
    }

    public void callback(SCAWSDLManagerClient.Result result) {
        if (result.getStatus() == SCAWSDLManagerClient.Status.SUCCESS) {
            if (result instanceof SCAWSDLManagerClient.DefinitionResult) {
                this.m_wdef = ((SCAWSDLManagerClient.DefinitionResult)result).getDefinition();
                if (this.m_wdef == null) {
                    this.invalidWSDL();
                } else {
                    this.m_wsdlHasError = false;
                    this.m_portCB.removeAllItems();
                    this.setPortsForDefinition(this.m_wdef, false, 0);
                    if (this.m_portCB.getItemCount() < 2) {
                        this.m_portCB.setEnabled(true);
                        this.m_callbackPortCB.setEnabled(false);
                        this.m_callbackOperationCB.setEnabled(false);
                    } else {
                        this.m_portCB.setEnabled(true);
                        this.m_callbackPortCB.setEnabled(true);
                        this.m_callbackOperationCB.setEnabled(true);
                    }
                }
            }
        } else {
            if (result.getStatus() == SCAWSDLManagerClient.Status.ERROR) {
                Exception ex = result.getException();
                ex.printStackTrace();
                String errMsg = SCAResourceLookup.getString((String)"FABRIC_API_WSDL_FILE_ERROR");
                String errMsgTitle = SCAResourceLookup.getString((String)"FABRIC_API_FILE_ERROR_TITLE");
                MessageFormat errMsgformat = new MessageFormat(errMsg);
                Object[] obj = new Object[]{result.getURL().toExternalForm(), ex.getLocalizedMessage()};
                MultiLineOptionPane.showMessageDialog((Component)this.m_parentFrame, (Object)errMsgformat.format(obj), (String)errMsgTitle, (int)0);
                return;
            }
            if (result.getStatus() == SCAWSDLManagerClient.Status.USER_INTERRUPTED) {
                // empty if block
            }
        }
    }

    private void setPortsForDefinition(Definition def1, boolean isRecursiveCall, int portCntIn) {
        Map porttypes;
        int portcnt = 0;
        if (!isRecursiveCall) {
            this.m_portCB.removeActionListener(this);
            this.m_callbackPortCB.removeActionListener(this);
            this.m_callbackPortCB.addItem(new PortTypeDisplay(null, new QName(this.m_noCallback)));
        }
        if ((portcnt = portCntIn + (porttypes = def1.getPortTypes()).size()) > 1 && portCntIn < 2) {
            this.m_portCB.addItem(new PortTypeDisplay(null, new QName(this.m_notSpecified)));
        }
        for (PortType portt1 : porttypes.values()) {
            QName portqname = portt1.getQName();
            boolean haveDuplicate = false;
            int pcnt = this.m_portCB.getItemCount();
            for (int ii = 0; ii < pcnt; ++ii) {
                PortTypeDisplay cptd = (PortTypeDisplay)this.m_portCB.getItemAt(ii);
                if (!cptd.getQName().equals(portqname)) continue;
                haveDuplicate = true;
                break;
            }
            if (haveDuplicate) continue;
            PortTypeDisplay ptd = new PortTypeDisplay(portt1, portqname);
            this.m_portCB.addItem(ptd);
            if (this.m_newWsdlInfo != null && this.m_newWsdlInfo.getRequestPorttype().equals(portqname)) {
                this.m_portCB.setSelectedItem(ptd);
            }
            PortTypeDisplay ptd2 = new PortTypeDisplay(portt1, portqname);
            this.m_callbackPortCB.addItem(ptd2);
            if (this.m_newWsdlInfo == null || !portqname.equals(this.m_newWsdlInfo.getReplyPorttype())) continue;
            this.m_callbackPortCB.setSelectedItem(ptd2);
        }
        Map impL = def1.getImports();
        for (List implist : impL.values()) {
            for (Import imp : implist) {
                Definition impDef = imp.getDefinition();
                if (impDef == null) continue;
                this.setPortsForDefinition(impDef, true, portcnt);
            }
        }
        if (!isRecursiveCall) {
            this.setOperationsForPorttype(this.m_portCB, this.m_operationCB, false);
            this.setOperationsForPorttype(this.m_callbackPortCB, this.m_callbackOperationCB, true);
            this.m_portCB.addActionListener(this);
            this.m_callbackPortCB.addActionListener(this);
            this.validateWsdlPorttype(this.m_portCB);
        }
    }

    private void setOperationsForPorttype(JComboBox portCB, JComboBox operationCB, boolean isCallback) {
        operationCB.removeActionListener(this);
        operationCB.removeAllItems();
        PortTypeDisplay ptd = (PortTypeDisplay)portCB.getSelectedItem();
        if (ptd == null || ptd.getPortType() == null) {
            return;
        }
        List operationsL = ptd.getPortType().getOperations();
        for (Operation oper1 : operationsL) {
            OperationDisplay opdis = new OperationDisplay(oper1);
            operationCB.addItem(opdis);
            if (!isCallback && this.m_operationName != null && this.m_operationName.length() > 0 && this.m_operationName.equals(oper1.getName())) {
                operationCB.setSelectedItem(opdis);
            }
            if (!isCallback || this.m_callbackOperationName == null || this.m_callbackOperationName.length() <= 0 || !this.m_callbackOperationName.equals(oper1.getName())) continue;
            operationCB.setSelectedItem(opdis);
        }
        operationCB.addActionListener(this);
    }

    private void invalidWSDL() {
        this.m_wsdlHasError = true;
        this.m_wsdlLoc.requestFocus();
    }

    public WsdlInfo getWsdlInfo() {
        this.m_wsdl_relpath = this.m_wsdlLoc.getText().trim();
        this.m_porttypeQname = ((PortTypeDisplay)this.m_portCB.getSelectedItem()).getQName();
        QName callbackqname = ((PortTypeDisplay)this.m_callbackPortCB.getSelectedItem()).getQName();
        this.m_callbackPorttypeQname = !callbackqname.getLocalPart().equals(this.m_noCallback) ? callbackqname : null;
        return new WsdlInfo(this.m_wsdl_relpath, this.m_porttypeQname, this.m_callbackPorttypeQname);
    }

    public void setAllFieldsEnabled(boolean value) {
        this.m_wsdlLoc.setEnabled(value);
        this.m_importWSDLBtn.setEnabled(value);
        this.m_importSCAServiceBtn.setEnabled(value);
        this.m_genWSDLBtn.setEnabled(value);
        this.m_portCB.setEnabled(value);
        if (this.m_portCB.getItemCount() < 2) {
            this.m_callbackPortCB.setEnabled(false);
            this.m_callbackOperationCB.setEnabled(false);
        } else {
            this.m_callbackPortCB.setEnabled(value);
            this.m_callbackOperationCB.setEnabled(value);
        }
        this.m_operationCB.setEnabled(value);
    }

    public static void displayDialog(Frame parentFrame, Context jcontext, Project jdevProject, WsdlInfo wsdlInfo, String serviceName, String defaultNamespace, DocumentListener doclis) {
        CommonWsdlSelectionPanel wpanel = null;
        try {
            if (MAIN_DEBUG) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        JEWTDialog diag1 = new JEWTDialog(parentFrame, "Test CommonWsdlSelection", 7);
        diag1.setSize(600, 360);
        try {
            wpanel = new CommonWsdlSelectionPanel(parentFrame, jcontext, jdevProject, wsdlInfo, serviceName, defaultNamespace, doclis);
            wpanel.m_showOperationPicker = true;
            wpanel.initLayout();
        }
        catch (Exception exp) {
            exp.printStackTrace();
            return;
        }
        diag1.setContent((Component)wpanel);
        boolean ok = diag1.runDialog();
        if (ok) {
            WsdlInfo winfo = wpanel.getWsdlInfo();
        }
    }

    public static void main(String[] args) {
        MAIN_DEBUG = true;
        AdapterWizardContext.IS_STANDALONE_TESTING = true;
        BPELStringTranslator.initialize();
        WsdlInfo wsdlInfo = null;
        JFrame tframe = new JFrame();
        String serviceName = "testing";
        String defaultNamespace = "http://oracle.com/sca/soapservice/";
        DocumentListener doclis = null;
        try {
            CommonWsdlSelectionPanel.displayDialog(tframe, null, null, wsdlInfo, serviceName, defaultNamespace, doclis);
        }
        catch (Exception wex) {
            wex.printStackTrace();
        }
        System.exit(0);
    }
}

