/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JPanel;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.ComplexAppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.util.WindowUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class UIUtils {
    private static boolean _hasCursorBug = false;

    public static void setTableEditable(SpreadTable paramTable, boolean isEditable) {
        Grid tableGrid = paramTable.getGrid();
        if (!isEditable) {
            tableGrid.setDefaultInputHandler(null);
            UIUtils.setComplexAppearance(tableGrid, -1);
        }
    }

    public static void setComplexAppearance(Grid grid, int whichCol) {
        int end;
        int start;
        ComplexAppearanceManager am = new ComplexAppearanceManager();
        grid.setAppearanceManager((AppearanceManager)am);
        if (whichCol == -1) {
            start = 0;
            end = grid.getColumnCount();
        } else {
            start = whichCol;
            end = whichCol;
        }
        for (int i = start; i < end; ++i) {
            Appearance appearance = am.getColumnAppearance(i);
            appearance.setBackground(Color.lightGray);
            appearance.setSelectBackground(Color.darkGray);
            am.setColumnAppearance(i, appearance);
        }
    }

    public static void addCToLeftHalfSpace(Container container, Component component, int y0) {
        UIUtils.addComponentToGB(container, component, 0, y0, 1, 1, 1, 1, 0, 17);
        UIUtils.addComponentToGB(container, new JPanel(), 1, y0, 1, 1, 1, 1, 2, 17);
    }

    public static void addCToGBLeft(Container container, Component component, int y0, int deltaX) {
        UIUtils.addComponentToGB(container, component, 0, y0, deltaX, 1, 1, 1, 0, 17);
    }

    public static void addCToGBCenter(Container container, Component component, int y0, int deltaX) {
        UIUtils.addComponentToGB(container, component, 0, y0, deltaX, 1, 1, 1, 0, 10);
    }

    public static void addCToGBRight(Container container, Component component, int y0, int deltaX) {
        UIUtils.addComponentToGB(container, component, 0, y0, deltaX, 1, 1, 1, 0, 13);
    }

    public static void handleException(Exception e) {
        DebugUtility.debug(e);
    }

    public static void addComponentToGB(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int fill, int anchor) {
        UIUtils.addComponentToGB(container, component, gridx, gridy, gridwidth, gridheight, weightx, weighty, fill, anchor, 0, 0, new Insets(0, 0, 0, 0));
    }

    public static void addComponentToGB(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, int weightx, int weighty, int fill, int anchor, int ipadx, int ipady, Insets ins) {
        try {
            LayoutManager lm = container.getLayout();
            if (!(lm instanceof GridBagLayout)) {
                Object[] args = new Object[]{lm.toString()};
                throw new AWTException(UIUtils.getNLS("invalidLayout", args));
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = gridx;
            gbc.gridy = gridy;
            gbc.gridwidth = gridwidth;
            gbc.gridheight = gridheight;
            gbc.fill = fill;
            gbc.weighty = weighty;
            gbc.weightx = weightx;
            gbc.anchor = anchor;
            gbc.ipadx = ipadx;
            gbc.ipady = ipady;
            gbc.insets = ins;
            ((GridBagLayout)lm).setConstraints(component, gbc);
            container.add(component);
        }
        catch (AWTException e) {
            UIUtils.handleException(e);
        }
    }

    public static void addComponent(Container container, Component component, int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridwidth;
        gbc.gridheight = gridheight;
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        container.add(component, gbc);
    }

    public static void addComponent(Container container, Component component, GridBagConstraints gbc, int x, int y, int w, int h) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        container.add(component, gbc);
    }

    public static void addComponent(Container container, Component component, GridBagConstraints gbc, int x, int y, int w, int h, Insets insets) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.insets = insets;
        container.add(component, gbc);
    }

    public static void validateName(String objType, String newName, int parentId, String oldName, boolean isWizard) throws FlatFileValidationException {
    }

    public static void greyOutCell(SpreadTable table, int columnIndex, int rowIndex, boolean grey) {
        ComplexAppearanceManager am;
        AppearanceManager bm = table.getGrid().getAppearanceManager();
        if (bm == null || !(bm instanceof ComplexAppearanceManager)) {
            am = new ComplexAppearanceManager();
            table.getGrid().setAppearanceManager((AppearanceManager)am);
        } else {
            am = (ComplexAppearanceManager)bm;
        }
        Appearance appearance = am.getCellAppearance(columnIndex, rowIndex);
        if (grey) {
            appearance.setBackground(Color.lightGray);
            appearance.setSelectBackground(Color.darkGray);
        } else {
            appearance.setBackground(Color.white);
            appearance.setSelectBackground(Color.blue);
        }
        am.setCellAppearance(columnIndex, rowIndex, appearance);
    }

    public static void setBusyCursorParentFrame(Component comp) {
        UIUtils.setCursor(WindowUtils.parentFrame((Component)comp), Cursor.getPredefinedCursor(3));
    }

    public static void setBusyCursorParentWindow(Component comp) {
        UIUtils.setCursor(WindowUtils.getWindow((Component)comp), Cursor.getPredefinedCursor(3));
    }

    public static void setDefaultCursorParentFrame(Component comp) {
        UIUtils.setCursor(WindowUtils.parentFrame((Component)comp), Cursor.getDefaultCursor());
    }

    public static void setDefaultCursorParentWindow(Component comp) {
        UIUtils.setCursor(WindowUtils.getWindow((Component)comp), Cursor.getDefaultCursor());
    }

    public static void setBusyCursor(Component comp) {
        UIUtils.setCursor(comp, Cursor.getPredefinedCursor(3));
    }

    public static void setDefaultCursor(Component comp) {
        UIUtils.setCursor(comp, Cursor.getDefaultCursor());
    }

    public static void setCursor(Component comp, Cursor cursor) {
        UIUtils.debug("Setting cursor called on " + comp);
        if (!(comp instanceof Container)) {
            if (comp != null) {
                comp.setCursor(cursor);
            }
        } else {
            Container container = (Container)comp;
            UIUtils.setCursorForAll(container, cursor);
        }
    }

    private static void setCursorForAll(Container container, Cursor cursor) {
        container.setCursor(cursor);
        Component[] comp = container.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            if (!(comp[i] instanceof Container)) {
                comp[i].setCursor(cursor);
                continue;
            }
            UIUtils.setCursorForAll((Container)comp[i], cursor);
        }
    }

    private static String getNLS(String key) {
        return NLSUtils.getNLSString(key);
    }

    private static String getNLS(String key, Object[] args) {
        return NLSUtils.getNLSString(key, args);
    }

    public static void speakWizardDescription(Container d, String desc) {
    }

    public static boolean isActiveWindowModal() {
        Dialog theDialog;
        Window aWindow = WindowUtils.getActiveWindow();
        boolean isModal = false;
        if (aWindow != null && aWindow instanceof Dialog && (theDialog = (Dialog)aWindow).isModal()) {
            isModal = true;
        }
        return isModal;
    }

    private static void debug(String msg) {
        DebugUtility.debug(UIUtils.class, msg);
    }

    private static void debug(Exception msg) {
        DebugUtility.debug(UIUtils.class, msg);
    }

    public static Window getWindowForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof Frame || parentComponent instanceof Dialog) {
            return (Window)parentComponent;
        }
        return UIUtils.getWindowForComponent(parentComponent.getParent());
    }
}

