/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;

public class NLSUtils {
    public static final String MNEMONIC_CHAR = "@";
    public static final String ACCELERATOR_CHAR = "=";

    public static final String getResourceString(String directory, String s) {
        return NLSUtils.getResourceString(Locale.getDefault(), directory, s);
    }

    public static final String getResourceString(Locale locale, String directory, String s) {
        String str;
        ResourceBundle entry = null;
        try {
            entry = ResourceBundle.getBundle(directory.replace('/', '.'), Locale.getDefault());
            str = entry.getString(s);
        }
        catch (Exception e) {
            str = s + "??";
            NLSUtils.debug("key [" + s + "] not found in resource bundle " + " or resource bundle" + directory + " not found");
            NLSUtils.debug(e);
        }
        return str;
    }

    public static final String getNLSString(String s) {
        return NLSUtils.getNLSString(Locale.getDefault(), s);
    }

    public static final String getNLSString(Locale locale, String s) {
        Object bundleArray = null;
        ResourceBundle mrb = ResourceBundle.getBundle("oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.resource.IntegratorFlatFile", locale);
        String str = "";
        try {
            str = str + mrb.getString(s);
        }
        catch (Exception e) {
            str = s + "??";
            NLSUtils.debug("key [" + s + "] not found in resource bundle ");
            NLSUtils.debug(e);
        }
        return str;
    }

    private static String scanSingleQuote(String old) {
        StringTokenizer st = new StringTokenizer(old, "'", true);
        String output = "";
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            if (tmp.equals("'")) {
                tmp = "''";
            }
            output = output + tmp;
        }
        return output;
    }

    public static final String getMsgIDAndResourceString(String directory, String s) {
        String message = NLSUtils.getResourceString(directory, s);
        return message;
    }

    public static final String getMsgIDAndNLSString(int groupId, String s) {
        String message = NLSUtils.getNLSString(s);
        return message;
    }

    public static final String translateResourceString(String rtsString) {
        int idx = rtsString.indexOf(ACCELERATOR_CHAR);
        StringTokenizer buf = idx > 0 ? new StringTokenizer(rtsString.substring(0, idx), MNEMONIC_CHAR) : new StringTokenizer(rtsString, MNEMONIC_CHAR);
        String label = new String();
        while (buf.hasMoreElements()) {
            label = label + buf.nextToken(MNEMONIC_CHAR);
        }
        return label;
    }

    public static final char getMnemonicKey(String rtsString) {
        int idx = rtsString.indexOf(MNEMONIC_CHAR);
        if (idx == -1) {
            return '\n';
        }
        return rtsString.charAt(idx + 1);
    }

    public static final int getMnemonicKeyCode(String rtsString) {
        int c = NLSUtils.getMnemonicKey(rtsString);
        if (c != 10) {
            int vk = c;
            if (vk >= 97 && vk <= 122) {
                vk -= 32;
            }
            return vk;
        }
        return 0;
    }

    public static final int getMnemonicIndex(String rtsString) {
        int idx = rtsString.indexOf(MNEMONIC_CHAR);
        if (idx < 0) {
            return -1;
        }
        return idx;
    }

    public static final String getResourceString(String directory, String s, Object[] args) {
        return NLSUtils.getResourceString(Locale.getDefault(), directory, s, args);
    }

    public static final String getResourceString(Locale locale, String directory, String s, Object[] args) {
        ResourceBundle entry = null;
        String str = null;
        String str1 = null;
        String str2 = null;
        try {
            entry = ResourceBundle.getBundle(directory.replace('/', '.'), Locale.getDefault());
            str1 = entry.getString(s);
            str2 = NLSUtils.scanSingleQuote(str1);
            str = MessageFormat.format(str2, args);
        }
        catch (Exception e) {
            str = s + "??";
            NLSUtils.debug("key [" + s + "] not found in resource bundle " + directory + " or resource bundle is not found.");
            NLSUtils.debug(e);
        }
        return str;
    }

    public static final String getNLSString(String s, Object[] args) {
        return NLSUtils.getNLSString(Locale.getDefault(), s, args);
    }

    public static final String getNLSString(Locale locale, String s, Object[] args) {
        Object bundleArray = null;
        ResourceBundle mrb = ResourceBundle.getBundle("oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.resource.IntegratorFlatFile", locale);
        String str1 = "";
        String str = "";
        try {
            str1 = str1 + mrb.getString(s);
            String str2 = NLSUtils.scanSingleQuote(str1);
            str = MessageFormat.format(str2, args);
        }
        catch (Exception e) {
            str = s + "??";
            NLSUtils.debug("key [" + s + "] not found in resource bundle ");
            NLSUtils.debug(e);
        }
        return str;
    }

    private static final void debug(String msg) {
        DebugUtility.debug(NLSUtils.class, msg);
    }

    private static final void debug(Exception ex) {
        DebugUtility.debug(NLSUtils.class, ex);
    }

    public static final String stripMnemonicChar(String str) {
        StringBuffer buff = new StringBuffer(str);
        char mchar = MNEMONIC_CHAR.charAt(0);
        for (int i = 0; i < buff.length(); ++i) {
            if (buff.charAt(i) != mchar) continue;
            buff.delete(i, i + 1);
        }
        return buff.toString();
    }
}

