/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util;

import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;

public class DebugUtility {
    private static final String PREFERENCEFILE = "DebugUtility.properties";
    private static boolean _debug = false;
    private static String m_logFileLocation = "c:\\temp\\DebugUtility.log";
    private static boolean _Stdout = false;
    private static int _logFileSize = 100;
    private static String m_newLine = System.getProperty("line.separator");
    private static OutputStream m_outStream;

    public static void println(String s) {
        try {
            if (_debug) {
                s = s + m_newLine;
                m_outStream.write(s.getBytes());
                m_outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void println(int i) {
        DebugUtility.println("" + i);
    }

    public static final void println(Object debug_obj, Throwable ex) {
        String msg = debug_obj.toString();
        msg = msg + m_newLine + DebugUtility.getFullStackTrace(ex);
        DebugUtility.println(msg);
    }

    public static final void println(Throwable ex) {
        DebugUtility.println(DebugUtility.getFullStackTrace(ex));
    }

    public static void debug(Object debug_obj, String s) {
        String objectName = "";
        if (debug_obj instanceof FlatFileInfo) {
            objectName = "FFI ";
            objectName = ((FlatFileInfo)debug_obj).toString();
        } else {
            objectName = debug_obj.getClass().getName();
        }
        DebugUtility.println(objectName + m_newLine + s);
    }

    public static void debug(String s) {
        DebugUtility.println(s);
    }

    public static void debug(int i) {
        DebugUtility.println(i);
    }

    public static final void debug(Object debug_obj, Exception ex) {
        DebugUtility.println(debug_obj, ex);
    }

    public static final void debug(Object debug_obj, Throwable ex) {
        DebugUtility.debug(debug_obj, DebugUtility.getFullStackTrace(ex));
    }

    public static void debug(Object debug_obj, String s, Exception ex) {
        DebugUtility.debug(debug_obj, s);
        DebugUtility.debug(debug_obj, ex);
    }

    public static void debug(Exception ex) {
        DebugUtility.println(DebugUtility.getFullStackTrace(ex));
    }

    public static String getFullStackTrace(Throwable ex) {
        CharArrayWriter stwriter = new CharArrayWriter();
        PrintWriter pw = new PrintWriter(stwriter);
        Throwable throwable = ex;
        while (null != throwable) {
            throwable.printStackTrace(pw);
            Method getCause = null;
            try {
                getCause = throwable.getClass().getMethod("getCause", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                try {
                    getCause = throwable.getClass().getMethod("getException", new Class[0]);
                }
                catch (NoSuchMethodException nsme2) {
                    // empty catch block
                }
            }
            if (null != getCause) {
                try {
                    throwable = (Throwable)getCause.invoke((Object)throwable, new Object[0]);
                }
                catch (Exception e) {
                    pw.println("Error while trying to follow exception chain.");
                    throwable = null;
                }
                continue;
            }
            throwable = null;
        }
        String stackTrace = stwriter.toString();
        return stackTrace;
    }

    static {
        if (!_Stdout) {
            try {
                File logFile = new File(m_logFileLocation);
                if (logFile.exists()) {
                    logFile.delete();
                } else if (!logFile.createNewFile()) {
                    _debug = false;
                }
                m_outStream = new BufferedOutputStream(new FileOutputStream(logFile));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

