/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.Timer;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.UIUtils;

public class WizardWelcomePanel
extends JPanel {
    private JCheckBox _showNextTimeCheckbox;
    private String _adaWelcomeMsg;

    public WizardWelcomePanel(String introText, String[] stepText, boolean showPage) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 0, 0, 25);
        this._adaWelcomeMsg = introText;
        MultiLineLabel introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), introText);
        Font currentFont = new Font("SansSerif", 0, 18);
        introLabel.setFont(currentFont);
        this.add((Component)introLabel, gbc);
        gbc.gridwidth = 1;
        gbc.insets = new Insets(4, 0, 4, 10);
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        ++gbc.gridy;
        this.add((Component)new Label(), gbc);
        String msg = "";
        String cleanMsg = "";
        String completedMsg = "";
        StringTokenizer token = null;
        if (stepText != null) {
            for (int i = 0; i < stepText.length; ++i) {
                ++gbc.gridy;
                Object[] args = new Object[]{new Integer(i + 1), stepText[i]};
                msg = this.getNLS("WP_im_step", args);
                this._adaWelcomeMsg = this._adaWelcomeMsg + msg + " ";
                token = new StringTokenizer(msg, ":");
                while (token.hasMoreTokens()) {
                    cleanMsg = token.nextToken();
                    cleanMsg = cleanMsg.trim();
                }
                completedMsg = completedMsg + cleanMsg + " ";
            }
        }
        MultiLineLabel descLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), completedMsg);
        this.add((Component)descLabel, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 4);
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        String clicknext = NLSUtils.getNLSString("WP_clicknext");
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        JPanel filler = new JPanel();
        this.add((Component)filler, gbc);
        gbc.insets = new Insets(0, 0, 0, 4);
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 16;
        String checkText = CommonUtils.translateResourceString(NLSUtils.getNLSString("WP_showNextTime"));
        this._showNextTimeCheckbox = new JCheckBox(checkText, showPage);
        CommonUtils.setMnemonicAndAccelerator(this._showNextTimeCheckbox, NLSUtils.getNLSString("WP_showNextTime"));
        this.add((Component)this._showNextTimeCheckbox, gbc);
        this.addComponentListener(new WelcomeComponentAdapter());
    }

    public boolean showNextTime() {
        return this._showNextTimeCheckbox.isSelected();
    }

    public String getAdaWelcomeMsg() {
        return this._adaWelcomeMsg;
    }

    private String getNLS(String key) {
        return NLSUtils.getNLSString(key);
    }

    private String getNLS(String key, Object[] args) {
        return NLSUtils.getNLSString(key, args);
    }

    private class WelcomeTimeListener
    implements ActionListener {
        private Window win = null;
        private String mesg = null;

        public WelcomeTimeListener(Window w, String m) {
            this.win = w;
            this.mesg = m;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UIUtils.speakWizardDescription(this.win, this.mesg);
        }
    }

    private class WelcomeWindowAdapter
    extends WindowAdapter {
        private String mesg = null;

        public WelcomeWindowAdapter(String m) {
            this.mesg = m;
        }

        @Override
        public void windowActivated(WindowEvent e) {
            e.getWindow().removeWindowListener(this);
            Timer timer = new Timer(2000, new WelcomeTimeListener(e.getWindow(), this.mesg));
            timer.setInitialDelay(2000);
            timer.setRepeats(false);
            timer.start();
        }
    }

    private class WelcomeComponentAdapter
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            Container c = e.getComponent().getParent();
            Window w = null;
            while (c != null) {
                if (c instanceof Window) {
                    w = (Window)c;
                    w.addWindowListener(new WelcomeWindowAdapter(((WizardWelcomePanel)e.getComponent()).getAdaWelcomeMsg()));
                    e.getComponent().removeComponentListener(this);
                    c = null;
                    continue;
                }
                c = c.getParent();
            }
        }
    }
}

