/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Frame;
import java.awt.Window;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WhJOptionDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class WhAlertJ
extends WhJOptionDialog {
    public static final int BUTTON_CANCEL = 1;
    public static final int BUTTON_HELP = 2;
    public static final int BUTTON_USER = 4;
    public static final int BUTTON_YES = 8;
    public static final int BUTTON_NO = 16;
    public static final int TYPE_STOP = 0;
    public static final int TYPE_CAUTION = 2;
    public static final int TYPE_NOTE = 1;
    public static final int TYPE_MISC = -1;
    private static final int LC_BTN_YES_NO = 0;
    private static final int LC_BTN_YES_NO_CANCEL = 1;
    private static final int LC_BTN_OK_CANCEL = 2;
    private static final int LC_BTN_DEFAULT = 0;
    private String m_sMessage = null;
    private int m_nAlertType;
    private int m_nButton_Choice;
    private int[] m_lcbuttons = new int[5];
    private JButton[] m_buttons;
    private Hashtable m_buttonTable;
    private Window m_parent;
    private int m_defaultButton = 0;
    private int[] m_buttonTypes = new int[]{8, 16, 4, 1, 2};

    public WhAlertJ(int alertType, int buttons) {
        this.m_nAlertType = alertType;
        this.m_nButton_Choice = buttons;
        this.initButtons();
        this.buildPane(this.m_sMessage);
    }

    public WhAlertJ(String message, int alertType, int buttons) {
        this.m_sMessage = message;
        this.m_nAlertType = alertType;
        this.m_nButton_Choice = buttons;
        this.initButtons();
        this.buildPane(this.m_sMessage);
    }

    public WhAlertJ(Frame parent, int alertType, int buttons) {
        super(parent, null, null);
        this.m_sMessage = null;
        this.m_parent = parent;
        this.m_nAlertType = alertType;
        this.m_nButton_Choice = buttons;
        this.initButtons();
        this.buildPane(this.m_sMessage);
    }

    public WhAlertJ(JDialog parent, String message, int alertType, int buttons) {
        super(parent, null, null);
        this.m_sMessage = message;
        this.m_parent = parent;
        this.m_nAlertType = alertType;
        this.m_nButton_Choice = buttons;
        this.initButtons();
        this.buildPane(this.m_sMessage);
    }

    public WhAlertJ(Frame parent, String message, int alertType, int buttons) {
        super(parent, null, null);
        this.m_parent = parent;
        this.m_sMessage = message;
        this.m_nAlertType = alertType;
        this.m_nButton_Choice = buttons;
        this.initButtons();
        this.buildPane(this.m_sMessage);
    }

    private JOptionPane buildPane(String message) {
        JOptionPane jp;
        this._pane = jp = new JOptionPane(message, this.m_nAlertType, this.convertToLocalbtns(this.m_nButton_Choice), null, this.m_buttons);
        this.init();
        return jp;
    }

    private void initButtons() {
        this.m_lcbuttons[0] = 24;
        this.m_lcbuttons[1] = 25;
        this.m_lcbuttons[2] = 9;
        this.m_buttonTable = new Hashtable(10);
    }

    private int convertToLocalbtns(int nPublicButtons) {
        if ((nPublicButtons &= 0xFFFFFFFD) == this.m_lcbuttons[0]) {
            this.m_buttons = new JButton[2];
            this.m_buttons[0] = this.createButton("YesButton");
            this.m_buttonTable.put("YesButton", this.m_buttons[0]);
            this.m_buttons[1] = this.createButton("NoButton");
            this.m_buttonTable.put("NoButton", this.m_buttons[1]);
            return 0;
        }
        if (nPublicButtons == this.m_lcbuttons[1]) {
            this.m_buttons = new JButton[3];
            this.m_buttons[0] = this.createButton("YesButton");
            this.m_buttonTable.put("YesButton", this.m_buttons[0]);
            this.m_buttons[1] = this.createButton("NoButton");
            this.m_buttonTable.put("NoButton", this.m_buttons[1]);
            this.m_buttons[2] = this.createButton("CancelButton");
            this.m_buttonTable.put("CancelButton", this.m_buttons[2]);
            return 1;
        }
        if (nPublicButtons == this.m_lcbuttons[2]) {
            this.m_buttons = new JButton[2];
            this.m_buttons[0] = this.createButton("OkButton");
            this.m_buttonTable.put("YesButton", this.m_buttons[0]);
            this.m_buttons[1] = this.createButton("CancelButton");
            this.m_buttonTable.put("CancelButton", this.m_buttons[1]);
            return 2;
        }
        this.m_buttons = new JButton[1];
        this.m_buttons[0] = this.createButton("OkButton");
        this.m_buttonTable.put("YesButton", this.m_buttons[0]);
        return 0;
    }

    private int convertToPublicbtn(int nLocalButtons) {
        if (nLocalButtons == 0 || nLocalButtons == 0) {
            return 8;
        }
        if (nLocalButtons == 1) {
            return 16;
        }
        if (nLocalButtons == 2) {
            return 1;
        }
        return 4;
    }

    protected JButton getButton(int button) {
        Object result = null;
        String buttonText = null;
        switch (button) {
            case 1: {
                buttonText = "CancelButton";
                break;
            }
            case 2: {
                buttonText = "HelpButton";
                break;
            }
            case 4: {
                buttonText = "UserButton";
                break;
            }
            case 8: {
                buttonText = "YesButton";
                break;
            }
            case 16: {
                buttonText = "NoButton";
            }
        }
        return (JButton)this.m_buttonTable.get(buttonText);
    }

    public void setHelpTopic(String topic) {
    }

    public void setDefaultButton(int buttonId) {
        this.m_defaultButton = buttonId;
    }

    public int runAlert() {
        return this.runAlert(null);
    }

    public int runAlert(String title) {
        JButton button;
        if (title == null) {
            title = NLSUtils.getNLSString("GN_error_title");
            if (this.m_nAlertType == 2) {
                title = NLSUtils.getNLSString("NXSDWarning");
            } else if (this.m_nAlertType == 1 || this.m_nAlertType == -1) {
                title = NLSUtils.getNLSString("NXSDNote");
            }
        }
        if (this.m_defaultButton != 0 && (button = this.getButton(this.m_defaultButton)) != null) {
            this.getRootPane().setDefaultButton(button);
        }
        this.setTitle(title);
        this.setVisible(true);
        int locbtn = this.getResult();
        return this.convertToPublicbtn(locbtn);
    }

    private JButton createButton(String buttonName) {
        String tr_button = NLSUtils.getNLSString(buttonName);
        JButton retVal = new JButton(CommonUtils.translateResourceString(tr_button));
        CommonUtils.setMnemonicAndAccelerator(retVal, tr_button);
        return retVal;
    }
}

