/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerCellRenderer;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;

public class RecTypeTreeExplorerCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    protected TreeCellEditor realEditor;
    protected RecTypeExplorerCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;

    public RecTypeTreeExplorerCellEditor(JTree tree, RecTypeExplorerCellRenderer renderer) {
        this(tree, renderer, null);
    }

    public RecTypeTreeExplorerCellEditor(JTree tree, RecTypeExplorerCellRenderer renderer, TreeCellEditor editor) {
        this.renderer = renderer;
        this.realEditor = editor;
        if (this.realEditor == null) {
            this.realEditor = this.createTreeCellEditor();
        }
        this.editingContainer = this.createContainer();
        this.setTree(tree);
        this.setBorderSelectionColor(UIManager.getColor("Tree.editorBorderSelectionColor"));
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.setTree(tree);
        this.lastRow = row;
        this.determineOffset(tree, value, isSelected, expanded, leaf, row);
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = this.realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        TreePath newPath = tree.getPathForRow(row);
        this.canEdit = this.lastPath != null && newPath != null && this.lastPath.equals(newPath);
        Font font = this.getFont();
        if (font == null) {
            if (this.renderer != null) {
                font = this.renderer.getFont();
            }
            if (font == null) {
                font = tree.getFont();
            }
        }
        this.editingContainer.setFont(font);
        this.prepareForEditing();
        return this.editingContainer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        boolean retValue = false;
        boolean editable = false;
        if (event != null && event.getSource() instanceof JTree) {
            this.setTree((JTree)event.getSource());
            if (event instanceof MouseEvent) {
                TreePath path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
                boolean bl = editable = this.lastPath != null && path != null && this.lastPath.equals(path);
                if (path != null) {
                    this.lastRow = this.tree.getRowForPath(path);
                    Object value = path.getLastPathComponent();
                    if (value instanceof RecTypeExplorerTreeNode) {
                        this.editingIcon = ((RecTypeExplorerTreeNode)((Object)value)).getIcons()[0];
                    }
                    boolean isSelected = this.tree.isRowSelected(this.lastRow);
                    boolean expanded = this.tree.isExpanded(path);
                    TreeModel treeModel = this.tree.getModel();
                    boolean leaf = treeModel.isLeaf(value);
                    this.determineOffset(this.tree, value, isSelected, expanded, leaf, this.lastRow);
                    if (path.getPathCount() == 1) {
                        return false;
                    }
                    if (!((RecTypeExplorerTreeNode)((Object)path.getLastPathComponent())).canEdit()) {
                        return false;
                    }
                }
            }
        }
        if (!this.realEditor.isCellEditable(event)) {
            return false;
        }
        if (this.canEditImmediately(event)) {
            retValue = true;
        } else if (editable && this.shouldStartEditingTimer(event)) {
            this.startEditingTimer();
        } else if (this.timer != null && this.timer.isRunning()) {
            this.timer.stop();
        }
        if (retValue) {
            this.prepareForEditing();
        }
        return retValue;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        return this.realEditor.shouldSelectCell(event);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            this.cleanupAfterEditing();
            return true;
        }
        return false;
    }

    @Override
    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        this.cleanupAfterEditing();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.realEditor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.realEditor.removeCellEditorListener(l);
    }

    public CellEditorListener[] getCellEditorListeners() {
        return ((DefaultCellEditor)this.realEditor).getCellEditorListeners();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree != null) {
            this.lastPath = this.tree.getSelectionCount() == 1 ? this.tree.getSelectionPath() : null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.tree != null && this.lastPath != null) {
            this.tree.startEditingAtPath(this.lastPath);
        }
    }

    protected void setTree(JTree newTree) {
        if (this.tree != newTree) {
            if (this.tree != null) {
                this.tree.removeTreeSelectionListener(this);
            }
            this.tree = newTree;
            if (this.tree != null) {
                this.tree.addTreeSelectionListener(this);
            }
            if (this.timer != null) {
                this.timer.stop();
            }
        }
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() == 1 && this.inHitRegion(me.getX(), me.getY());
        }
        return false;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
            this.timer.setRepeats(false);
        }
        this.timer.start();
    }

    protected boolean canEditImmediately(EventObject event) {
        if (event instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)event)) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() > 1 && this.inHitRegion(me.getX(), me.getY());
        }
        return event == null;
    }

    protected boolean inHitRegion(int x, int y) {
        if (this.lastRow != -1 && this.tree != null) {
            Rectangle bounds = this.tree.getRowBounds(this.lastRow);
            ComponentOrientation treeOrientation = this.tree.getComponentOrientation();
            if (treeOrientation.isLeftToRight() ? bounds != null && x <= bounds.x + this.offset && this.offset < bounds.width - 5 : bounds != null && (x >= bounds.x + bounds.width - this.offset + 5 || x <= bounds.x + 5) && this.offset < bounds.width - 5) {
                return false;
            }
        }
        return true;
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.renderer != null) {
            this.offset = this.editingIcon != null ? this.renderer.getIconSpace() + this.editingIcon.getIconWidth() : this.renderer.getIconSpace();
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    protected void prepareForEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.add(this.editingComponent);
        }
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        Border aBorder = UIManager.getBorder("Tree.editorBorder");
        DefaultCellEditor editor = new DefaultCellEditor(new DefaultTextField(aBorder)){

            @Override
            public boolean shouldSelectCell(EventObject event) {
                boolean retValue = super.shouldSelectCell(event);
                return retValue;
            }
        };
        editor.setClickCountToStart(1);
        return editor;
    }

    private void cleanupAfterEditing() {
        if (this.editingComponent != null) {
            this.editingContainer.remove(this.editingComponent);
        }
        this.editingComponent = null;
    }

    public class EditorContainer
    extends Container {
        public EditorContainer() {
            this.setLayout(null);
        }

        public void EditorContainer() {
            this.setLayout(null);
        }

        @Override
        public void paint(Graphics g) {
            Color background;
            Dimension size = this.getSize();
            if (RecTypeTreeExplorerCellEditor.this.editingIcon != null) {
                int yLoc = Math.max(0, (this.getSize().height - RecTypeTreeExplorerCellEditor.this.editingIcon.getIconHeight()) / 2);
                RecTypeTreeExplorerCellEditor.this.editingIcon.paintIcon(this, g, 0, yLoc);
            }
            if ((background = RecTypeTreeExplorerCellEditor.this.getBorderSelectionColor()) != null) {
                g.setColor(background);
                g.drawRect(0, 0, size.width - 1, size.height - 1);
            }
            super.paint(g);
        }

        @Override
        public void doLayout() {
            if (RecTypeTreeExplorerCellEditor.this.editingComponent != null) {
                Dimension cSize = this.getSize();
                RecTypeTreeExplorerCellEditor.this.editingComponent.getPreferredSize();
                RecTypeTreeExplorerCellEditor.this.editingComponent.setLocation(RecTypeTreeExplorerCellEditor.this.offset, 0);
                RecTypeTreeExplorerCellEditor.this.editingComponent.setBounds(RecTypeTreeExplorerCellEditor.this.offset, 0, cSize.width - RecTypeTreeExplorerCellEditor.this.offset, cSize.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (RecTypeTreeExplorerCellEditor.this.editingComponent != null) {
                Dimension rSize;
                Dimension pSize = RecTypeTreeExplorerCellEditor.this.editingComponent.getPreferredSize();
                pSize.width += RecTypeTreeExplorerCellEditor.this.offset + 5;
                Dimension dimension = rSize = RecTypeTreeExplorerCellEditor.this.renderer != null ? RecTypeTreeExplorerCellEditor.this.renderer.getPreferredSize() : null;
                if (rSize != null) {
                    pSize.height = Math.max(pSize.height, rSize.height);
                }
                if (RecTypeTreeExplorerCellEditor.this.editingIcon != null) {
                    pSize.height = Math.max(pSize.height, RecTypeTreeExplorerCellEditor.this.editingIcon.getIconHeight());
                }
                pSize.width = Math.max(pSize.width, 100);
                return pSize;
            }
            return new Dimension(0, 0);
        }
    }

    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public DefaultTextField(Border border) {
            this.setBorder(border);
        }

        @Override
        public void setBorder(Border border) {
            super.setBorder(border);
            this.border = border;
        }

        @Override
        public Border getBorder() {
            return this.border;
        }

        @Override
        public Font getFont() {
            Container parent;
            Font font = super.getFont();
            if (font instanceof FontUIResource && (parent = this.getParent()) != null && parent.getFont() != null) {
                font = parent.getFont();
            }
            return font;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (RecTypeTreeExplorerCellEditor.this.renderer != null && this.getFont() == null) {
                Dimension rSize = RecTypeTreeExplorerCellEditor.this.renderer.getPreferredSize();
                size.height = rSize.height;
            }
            return size;
        }
    }
}

