/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ComplexFieldPropertiesDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDataSourceObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorer;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;

public class RecTypeStringTransferHandler
extends TransferHandler {
    private String _selectedText;
    private JFrame _frame;
    private WBTranslatable _helper;
    private FlatFileInfo _ff_info;

    public RecTypeStringTransferHandler(JFrame f, WBTranslatable h, FlatFileInfo info) {
        this._frame = f;
        this._helper = h;
        this._ff_info = info;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    protected void importString(JComponent c, String str, TreePath path) {
        RecTypeExplorerTreeNode currNode = null;
        String fldName = "";
        String fldType = "";
        String currNodeName = "";
        JTree m_tree = (JTree)c;
        DefaultTreeModel m_model = (DefaultTreeModel)m_tree.getModel();
        if (str != null) {
            this._selectedText = str;
            currNode = (RecTypeExplorerTreeNode)((Object)path.getLastPathComponent());
            currNodeName = ((RecTypeDataSourceObject)currNode.getNodeData()).getName();
            int nodeType = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)path.getLastPathComponent())).getNodeData()).getRecType();
            String nodeName = ((RecTypeExplorerTreeNode)((Object)path.getLastPathComponent())).getDisplayName();
            if (nodeType == 1) {
                String parentNodeName = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)currNode.getParent())).getNodeData()).getName();
                int nodeIndex = currNode.getParent().getIndex((TreeNode)((Object)currNode));
                ComplexFieldPropertiesDialog fldPropDlg = new ComplexFieldPropertiesDialog(this._frame, this._helper);
                int ret = fldPropDlg.display(this._ff_info, this._selectedText, parentNodeName, nodeIndex);
                String fieldType = (String)this._ff_info.getFieldPropertiesDs(parentNodeName).getData(2, nodeIndex);
                TextInfo t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, currNodeName + " - " + fieldType);
                NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                currNode.setNodeText(nodeTxt);
                ((RecTypeDataSourceObject)currNode.getNodeData()).setDataType(fieldType);
                m_model.nodeChanged((TreeNode)((Object)currNode));
            } else {
                RecTypeAttributes recAttr = this._ff_info.getRecordAttributes(nodeName);
                if (recAttr != null) {
                    if (Arrays.asList(FlatFileInfo.getXmlDataTypes()).contains(recAttr.getType())) {
                        ComplexFieldPropertiesDialog recPropDlg = new ComplexFieldPropertiesDialog(this._frame, this._helper);
                        int ret = recPropDlg.display(this._ff_info, this._selectedText, nodeName);
                        if (ret == 0) {
                            String recname = recPropDlg.getRecAttributes().getRecordName();
                            String recType = recPropDlg.getRecAttributes().getType();
                            RecTypeDataSourceObject dso = (RecTypeDataSourceObject)currNode.getNodeData();
                            dso.setName(recname);
                            dso.setDataType(recType);
                            currNode.setNodeData(dso);
                            TextInfo t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, recname + " - " + recType);
                            NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                            currNode.setNodeText(nodeTxt);
                            if (!this._selectedText.equals("")) {
                                for (int i = 0; i < this._ff_info.getRecordClassifierDs().getRowCount(); ++i) {
                                    if (!((String)this._ff_info.getRecordClassifierDs().getData(2, i)).equals(recname)) continue;
                                    this._ff_info.getRecordClassifierDs().setData(1, i, (Object)this._selectedText);
                                    break;
                                }
                            }
                        }
                    } else {
                        int ret = MultiLineOptionPane.showMessageDialog((Component)this._frame, (Object)this._helper.translate("CX_DNDTextDropMessage"), (String)"Alert", (int)1, (int)-1, (Icon)UIHelper.loadIcon((String)"images/information.png", UIHelper.class));
                    }
                } else {
                    RecTypeDialog dlg = new RecTypeDialog(this._frame, this._helper);
                    dlg.setDialogType(nodeType);
                    int ret = dlg.display(this._ff_info, this._selectedText, nodeName);
                    if (ret == 0) {
                        String recordType = this._ff_info.getRecordAttributes(dlg.getCurrentRecord()).getType();
                        ArrayTwoDModel fieldProps = this._ff_info.getFieldPropertiesDs(dlg.getCurrentRecord());
                        currNode = (RecTypeExplorerTreeNode)((Object)path.getLastPathComponent());
                        currNode.setName(dlg.getCurrentRecord());
                        RecTypeDataSourceObject nodedata = (RecTypeDataSourceObject)currNode.getNodeData();
                        nodedata.setName(dlg.getCurrentRecord());
                        nodedata.setDataType(recordType);
                        if (!(nodeType != 0 && nodeType != 1 || recordType.equals(""))) {
                            TextInfo t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, dlg.getCurrentRecord() + " - " + recordType);
                            NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                            currNode.setNodeText(nodeTxt);
                        } else {
                            for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                                for (int j = 0; j < fieldProps.getColumnCount(); ++j) {
                                    if (j == 1) {
                                        fldName = (String)fieldProps.getData(j, i);
                                        continue;
                                    }
                                    if (j != 2) continue;
                                    fldType = (String)fieldProps.getData(j, i);
                                }
                                if (!currNode.canCreate()) continue;
                                try {
                                    TextInfo t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, fldName + " - " + fldType);
                                    NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                                    RecTypeDataSourceObject dso = new RecTypeDataSourceObject(1, fldName, fldType, 1, 1, false);
                                    RecTypeExplorerTreeNode newNode = new RecTypeExplorerTreeNode(RecTypeExplorer.ELEMENT_ICON, fldName, (Object)dso);
                                    newNode.setNodeText(nodeTxt);
                                    currNode.add((MutableTreeNode)((Object)newNode));
                                    continue;
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                this.synchronizeParentNodeFieldNames(currNode, nodeName);
                m_model.nodeStructureChanged((TreeNode)((Object)currNode));
                m_tree.expandPath(path);
                this._ff_info.setHierarchicalTreeModel(m_model);
            }
        }
    }

    public boolean importData(JComponent c, Transferable t, TreePath path) {
        if (this.canImport(c, t.getTransferDataFlavors())) {
            try {
                String str = (String)t.getTransferData(DataFlavor.stringFlavor);
                this.importString(c, str, path);
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        for (int i = 0; i < flavors.length; ++i) {
            if (!DataFlavor.stringFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    private void synchronizeParentNodeFieldNames(RecTypeExplorerTreeNode currNode, String prevNodeName) {
        String fldName = "";
        String fldType = "";
        String parentNodeName = "";
        if (currNode == null) {
            return;
        }
        RecTypeExplorerTreeNode parentNode = (RecTypeExplorerTreeNode)((Object)currNode.getParent());
        String currNodeName = ((RecTypeDataSourceObject)currNode.getNodeData()).getName();
        boolean found = false;
        if (!parentNode.isRoot()) {
            parentNodeName = ((RecTypeDataSourceObject)parentNode.getNodeData()).getName();
            ArrayTwoDModel fieldProps = this._ff_info.getFieldPropertiesDs(parentNodeName);
            for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                fldName = (String)fieldProps.getData(1, i);
                fldType = (String)fieldProps.getData(2, i);
                RecTypeStringTransferHandler recTypeStringTransferHandler = this;
                if (Arrays.asList(recTypeStringTransferHandler._ff_info.getXmlDataTypes()).contains(fldType) || !fldName.equals(prevNodeName)) continue;
                fieldProps.setData(1, i, (Object)currNodeName);
                found = true;
                break;
            }
            this._ff_info.updateRecordClassifierDs(prevNodeName, currNodeName);
            if (!found) {
                fieldProps.addRows(fieldProps.getRowCount(), 1);
                int currrow = fieldProps.getRowCount();
                this._ff_info.resetFieldPropertiesRow(fieldProps, currrow - 1);
                fieldProps.setData(1, currrow - 1, (Object)currNodeName);
            }
        }
    }

    public FlatFileInfo getFlatFileInfo() {
        return this._ff_info;
    }

    public RecTypeExplorerTreeNode makeDeepCopy(DefaultMutableTreeNode node) {
        RecTypeExplorerTreeNode srcnode = (RecTypeExplorerTreeNode)((Object)node);
        RecTypeExplorerTreeNode copy = new RecTypeExplorerTreeNode(srcnode.getIcons(), srcnode.getNodeText(), srcnode.getNodeData());
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            copy.add((MutableTreeNode)((Object)this.makeDeepCopy((DefaultMutableTreeNode)((Object)((RecTypeExplorerTreeNode)((Object)e.nextElement()))))));
        }
        return copy;
    }
}

