/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.DummyNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerTreeNode;

public class RecTypeExplorerCellRenderer
extends JLabel
implements TreeCellRenderer {
    public static Icon DEFAULT_ICON = new ImageIcon(UIHelper.loadImage((String)"images/folder.png", UIHelper.class));
    public static Icon FOLDER_OPEN_ICON = new ImageIcon(UIHelper.loadImage((String)"images/folder.png", UIHelper.class));
    public static Icon FOLDER_CLOSED_ICON = new ImageIcon(UIHelper.loadImage((String)"images/folder_closed.png", UIHelper.class));
    private ArrayList m_iconLst = new ArrayList();
    private ArrayList m_textLst = new ArrayList();
    private int m_iconSpace = 3;
    private int m_leftTextSidePadding = 2;
    private int m_rightTextSidePadding = 2;
    private boolean m_bSelected;
    private boolean m_bShowNamespace = true;
    private boolean m_bHasFocus = false;

    public void showNodeDetails(boolean bShow) {
        this.m_bShowNamespace = bShow;
    }

    public boolean getShowNodeDetails() {
        return this.m_bShowNamespace;
    }

    @Override
    public Color getBackground() {
        if (this.m_bSelected) {
            return this.m_bHasFocus ? UIManager.getColor("Tree.selectionBackground") : Color.lightGray;
        }
        return Color.white;
    }

    @Override
    public void paint(Graphics g) {
        Color bgColor = this.getBackground();
        if (bgColor != null) {
            int imageOffset = 0;
            for (Icon icon : this.m_iconLst) {
                if (icon == null) continue;
                imageOffset += icon.getIconWidth();
                imageOffset += this.m_iconSpace;
            }
            g.setColor(bgColor);
            g.fillRect(imageOffset, 0, this.getWidth() - imageOffset, this.getHeight());
        }
        int x = 0;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) continue;
            int iconHeight = icon.getIconHeight();
            int yOffset = Math.max(0, (this.getHeight() - iconHeight) / 2);
            icon.paintIcon(this, g, x, yOffset);
            x += icon.getIconWidth();
            x += this.m_iconSpace;
        }
        x += this.m_leftTextSidePadding;
        for (TextInfo info : this.m_textLst) {
            g.setFont(info.getFont());
            Color c = info.getColor();
            if (this.m_bSelected) {
                c = this.m_bHasFocus ? UIManager.getColor("Tree.selectionForeground") : Color.black;
            }
            g.setColor(c);
            int strWidth = UIHelper.getStringWidth((Font)info.getFont(), (String)info.getText());
            int yOffset = Math.max(0, (this.getHeight() - UIHelper.getFontHeight((Font)info.getFont())) / 2);
            g.drawString(info.getText(), x, UIHelper.getFontAscent((Font)info.getFont()) + yOffset);
            x += strWidth;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int w = 0;
        int h = 0;
        for (Icon icon : this.m_iconLst) {
            if (icon == null) continue;
            w += icon.getIconWidth();
            w += this.m_iconSpace;
            h = Math.max(h, icon.getIconHeight());
        }
        w += this.m_leftTextSidePadding;
        for (TextInfo info : this.m_textLst) {
            w += UIHelper.getStringWidth((Font)info.getFont(), (String)info.getText());
            h = Math.max(h, UIHelper.getFontHeight((Font)info.getFont()));
        }
        return new Dimension(w += this.m_rightTextSidePadding, h);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.m_bSelected = selected;
        this.m_bHasFocus = hasFocus;
        this.m_iconLst.clear();
        this.m_textLst.clear();
        if (!(value instanceof DefaultMutableTreeNode)) {
            return this;
        }
        this.setToolTipText(null);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj != null) {
            if (userObj instanceof TreeExplorerTreeNode) {
                TreeExplorerTreeNode tnode = (TreeExplorerTreeNode)userObj;
                this.setIconAndText(tnode, expanded);
            }
        } else if (value instanceof DummyNode) {
            TextInfo textInfo = new TextInfo(Color.black, TextInfo.PLAIN_FONT, MessageBundleUtil.getCommonString((String)"UI_TECR_LOADING", (String)"Loading..."));
            this.m_textLst.add(textInfo);
        } else if (value instanceof TreeExplorerTreeNode) {
            TreeExplorerTreeNode tnode = (TreeExplorerTreeNode)value;
            this.setIconAndText(tnode, expanded);
        }
        if (this.m_iconLst.size() == 0) {
            this.m_iconLst.add(DEFAULT_ICON);
        }
        this.updateTextForAccessiblity();
        return this;
    }

    private void updateTextForAccessiblity() {
        StringBuffer sb = new StringBuffer();
        for (TextInfo info : this.m_textLst) {
            String s = info.getText();
            if (s == null) continue;
            sb.append(s);
        }
        this.setText(sb.toString());
    }

    private void setIconAndText(TreeExplorerTreeNode tnode, boolean expanded) {
        NodeText text;
        Icon[] icons = tnode.getIcons();
        if (icons != null) {
            for (int i = 0; i < icons.length; ++i) {
                Icon icon = icons[i];
                if (icons[i] == DEFAULT_ICON) {
                    icon = expanded ? FOLDER_OPEN_ICON : FOLDER_CLOSED_ICON;
                }
                this.m_iconLst.add(icon);
            }
        }
        if ((text = tnode.getNodeText()) != null) {
            TextInfo[] info = text.isExpanded() ? text.m_expandedText : text.m_compactText;
            for (int i = 0; i < info.length; ++i) {
                TextInfo textInfo = info[i];
                this.m_textLst.add(textInfo);
            }
        }
        this.setToolTipText(tnode.getToolTip());
    }

    public int getIconSpace() {
        return this.m_iconSpace;
    }
}

