/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.CellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.ide.util.ResourceUtils;
import oracle.tip.tools.ide.common.resource.MessageBundleUtil;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.JTreeCellRendererExtendor;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.WaitPanel;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultPopupListener;
import oracle.tip.tools.ide.common.ui.treeexplorer.DefaultTreeExplorerTreeNode;
import oracle.tip.tools.ide.common.ui.treeexplorer.NodeText;
import oracle.tip.tools.ide.common.ui.treeexplorer.PopupListener;
import oracle.tip.tools.ide.common.ui.treeexplorer.TextInfo;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorer;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerCellRenderer;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.AddChildNodeAction;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.AddChoiceNodeAction;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.AddComplexTypeAction;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ChoicePropertiesDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ComplexFieldPropertiesDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.DNDTreeTransferHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.DeleteChildNodeAction;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.EditRecTypeNodeAction;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileTranslationHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDataSourceObject;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerCellRenderer;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeExplorerTreeNode;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeStringTransferHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeTreeExplorerCellEditor;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeTreeModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;

public class RecTypeExplorer
extends TreeExplorer {
    protected static Icon FOLDER_ICON = TreeExplorerCellRenderer.DEFAULT_ICON;
    protected static Icon ELEMENT_ICON = UIHelper.loadIcon((String)"images/element.png", UIHelper.class);
    protected static Icon COMPLEXTYPE_ICON = UIHelper.loadIcon((String)"images/complextype.gif", UIHelper.class);
    protected static Icon CHILD_ICON = UIHelper.loadIcon((String)"images/element.png", UIHelper.class);
    protected static Icon CHOICE_ICON = UIHelper.loadIcon((String)"images/xml_choice.gif", UIHelper.class);
    protected static final String DEFAULT_NODE_TEXT = "<new_element>";
    protected static final String DEFAULT_COMPLEXTYPE_TEXT = "<new_complex_type>";
    protected static final String CHOICE_NODE_TEXT = "choice";
    public static final int ELEMENT = 0;
    public static final int COMPLEX_TYPE = 9;
    public static final int CHOICE = 99;
    protected FlatFileInfo m_ffInfo;
    protected WBTranslatable m_helper;
    protected TransferHandler m_xfrhdlr;
    protected DNDTreeTransferHandler m_dndxfrhdlr;
    private String _selectedNodeName;
    private JLabel _nameTreeIntro;

    public RecTypeExplorer() {
        this(new Insets(0, 2, 2, 2));
    }

    public RecTypeExplorer(Insets insets) {
        super(insets);
        ResourceUtils.resLabel((JLabel)this.m_label, (Component)this.m_txtField, (String)MessageBundleUtil.getCommonString((String)"TE_TYPE", (String)"&Type:"));
        this.setBorder(BorderFactory.createEmptyBorder());
        JToolBar tb = this.getToolBar();
        for (int i = 0; i < tb.getComponentCount(); ++i) {
            JButton btn;
            Component c = tb.getComponent(i);
            if (!(c instanceof JButton) || !((btn = (JButton)c).getAction() instanceof AddChildNodeAction)) continue;
            btn.setMnemonic('1');
        }
    }

    protected void layoutControls() {
        this.setLayout(new GridBagLayout());
        this._nameTreeIntro = new JLabel(new FlatFileTranslationHelper().translate("CX_SchemaTree"));
        UIHelper.addComponent((Container)((Object)this), (Component)this._nameTreeIntro, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(0, this.m_insets.left, 2, this.m_insets.right), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)((Object)this), (Component)this.m_toolBar, (int)1, (int)0, (int)1, (int)1, (int)13, (int)0, (Insets)new Insets(0, this.m_insets.left, 2, this.m_insets.right), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)((Object)this), (Component)this.m_cardPnl, (int)0, (int)1, (int)2, (int)1, (int)17, (int)1, (Insets)new Insets(0, this.m_insets.left, 2, this.m_insets.right), (int)100, (int)240, (double)0.0, (double)0.0);
    }

    protected void createControls(String type) {
        this.m_toolBar = new JToolBar();
        this.m_cardPnl = new CardPanel();
        this.m_label = new JLabel(type);
        this.m_txtField = new JTextField();
        this.m_txtField.setEditable(false);
        this.m_model = new RecTypeTreeModel((TreeNode)((Object)new RecTypeExplorerTreeNode(MessageBundleUtil.getCommonString((String)"UI_TE_TREE_EXPLORER", (String)"Generic Tree Explorer"))));
        this.m_tree = new JTree(this.m_model);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        new JTreeCellRendererExtendor(this.m_tree);
        this.m_tree.setRowHeight(0);
        RecTypeExplorerCellRenderer renderer = new RecTypeExplorerCellRenderer();
        renderer.showNodeDetails(false);
        this.m_tree.setCellRenderer(renderer);
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    RecTypeExplorer.this.fireDoubleClickEvent();
                }
            }
        });
        this.m_tree.setAutoscrolls(true);
        this.m_popup = new JPopupMenu();
        this.m_tree.add(this.m_popup);
        this.m_tree.addTreeExpansionListener(new TreeNodeExpansionListener());
        this.m_tree.addTreeSelectionListener((TreeSelectionListener)((Object)this));
        this.m_tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (e.getSource() == RecTypeExplorer.this.m_tree) {
                    RecTypeExplorer.this._selectedNodeName = ((DefaultTreeExplorerTreeNode)e.getPath().getLastPathComponent()).getDisplayName();
                }
            }
        });
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RecTypeExplorer.this.handlePopupTrigger(e);
                }
            }
        });
        this.addPopupListener((PopupListener)new RecTypeTreePopupListener());
        DefaultTreeSelectionModel treeSelectionModel = new DefaultTreeSelectionModel();
        treeSelectionModel.setSelectionMode(1);
        this.m_tree.setSelectionModel(treeSelectionModel);
        this.m_tree.setCellEditor(new RecTypeTreeExplorerCellEditor(this.m_tree, renderer));
        this.m_tree.setEditable(true);
        this.m_tree.getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String editNodeName = (String)((CellEditor)e.getSource()).getCellEditorValue();
                RecTypeExplorer.this.handleTreeCellEditing(editNodeName);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.m_cardPnl.add("TREE_PANEL", (Component)new JScrollPane(this.m_tree));
        WaitPanel waitPanel = new WaitPanel();
        waitPanel.setText(MessageBundleUtil.getCommonString((String)"UI_TECR_LOADING", (String)"Loading..."));
        this.m_cardPnl.add("WAIT_PANEL", (Component)waitPanel);
    }

    protected void buildToolBarActions(DefaultTreeExplorerTreeNode node) {
        block9: {
            block7: {
                RecTypeDataSourceObject dso;
                block11: {
                    block10: {
                        RecTypeExplorerTreeNode selectedNode;
                        block8: {
                            selectedNode = (RecTypeExplorerTreeNode)node;
                            if (selectedNode == null) break block7;
                            if (!selectedNode.isRoot()) break block8;
                            this.m_toolBar.getComponent(0).setEnabled(true);
                            this.m_toolBar.getComponent(1).setEnabled(true);
                            this.m_toolBar.getComponent(2).setEnabled(true);
                            this.m_toolBar.getComponent(3).setEnabled(false);
                            this.m_toolBar.getComponent(4).setEnabled(false);
                            break block9;
                        }
                        dso = (RecTypeDataSourceObject)selectedNode.getNodeData();
                        if (dso.getRecType() == 9) break block10;
                        if (dso.getRecType() == 0) break block10;
                        if (dso.getRecType() != 99) break block11;
                    }
                    this.m_toolBar.getComponent(0).setEnabled(true);
                    this.m_toolBar.getComponent(1).setEnabled(false);
                    this.m_toolBar.getComponent(2).setEnabled(false);
                    this.m_toolBar.getComponent(3).setEnabled(true);
                    this.m_toolBar.getComponent(4).setEnabled(true);
                }
                if (dso.getRecType() == 1) {
                    this.m_toolBar.getComponent(0).setEnabled(false);
                    this.m_toolBar.getComponent(1).setEnabled(false);
                    this.m_toolBar.getComponent(2).setEnabled(false);
                    this.m_toolBar.getComponent(3).setEnabled(true);
                    this.m_toolBar.getComponent(4).setEnabled(true);
                }
                if (dso.getRecType() == 99) {
                    this.m_toolBar.getComponent(0).setEnabled(true);
                    this.m_toolBar.getComponent(1).setEnabled(false);
                    this.m_toolBar.getComponent(2).setEnabled(false);
                    this.m_toolBar.getComponent(3).setEnabled(true);
                    this.m_toolBar.getComponent(4).setEnabled(true);
                }
                break block9;
            }
            if (this.m_toolBar.getComponentCount() == 0) {
                AddChildNodeAction action1 = new AddChildNodeAction(this);
                JButton addElementBtn = UIHelper.createModelerButton((Action)action1);
                AddComplexTypeAction action2 = new AddComplexTypeAction(this);
                JButton addComplexTypeBtn = UIHelper.createModelerButton((Action)action2);
                AddChoiceNodeAction action3 = new AddChoiceNodeAction(this);
                JButton addChoiceBtn = UIHelper.createModelerButton((Action)action3);
                EditRecTypeNodeAction action4 = new EditRecTypeNodeAction(this);
                JButton addEditTypeBtn = UIHelper.createModelerButton((Action)action4);
                DeleteChildNodeAction action5 = new DeleteChildNodeAction(this);
                JButton addDeleteTypeBtn = UIHelper.createModelerButton((Action)action5);
                this.m_toolBar.add(addElementBtn);
                this.m_toolBar.add(addComplexTypeBtn);
                this.m_toolBar.add(addChoiceBtn);
                this.m_toolBar.add(addEditTypeBtn);
                this.m_toolBar.add(addDeleteTypeBtn);
            }
        }
        this.forceLayout();
    }

    protected void handleTreeSelectionChange() {
        DefaultTreeExplorerTreeNode node = this.getSelectedNode();
        this.buildToolBarActions(node);
        this.firePropertyChange("TYPE_SELECTION_CHANGED", "", this.getSelectedNode());
    }

    public Object getSelectedNodeUserObject() {
        Object obj;
        TreePath path = this.m_tree.getSelectionPath();
        if (path != null && (obj = path.getLastPathComponent()) instanceof RecTypeExplorerTreeNode) {
            return ((RecTypeExplorerTreeNode)((Object)obj)).getNodeData();
        }
        return null;
    }

    public void handleCreateNode(int nodeType) {
        Icon[] newNodeIcon;
        int recType;
        String defaultNodeText = "";
        String dataType = "";
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        RecTypeExplorerTreeNode treeNode = (RecTypeExplorerTreeNode)((Object)obj);
        int parentNodeRecType = 0;
        if (!treeNode.isRoot()) {
            parentNodeRecType = ((RecTypeDataSourceObject)treeNode.getNodeData()).getRecType();
        }
        if (nodeType == 9) {
            defaultNodeText = DEFAULT_COMPLEXTYPE_TEXT;
            recType = 9;
            newNodeIcon = new Icon[]{COMPLEXTYPE_ICON};
            dataType = "";
        } else if (nodeType == 99) {
            defaultNodeText = CHOICE_NODE_TEXT;
            recType = 99;
            newNodeIcon = new Icon[]{CHOICE_ICON};
            dataType = "";
        } else {
            defaultNodeText = DEFAULT_NODE_TEXT;
            recType = treeNode.isRoot() ? 0 : (parentNodeRecType == 99 ? 0 : 1);
            newNodeIcon = new Icon[]{ELEMENT_ICON};
            dataType = "string";
        }
        if (treeNode.canCreate()) {
            try {
                if (nodeType == 99 && this.choiceNodeExists()) {
                    throw new Exception(this.m_helper.translate("CX_DupChoiceNodeMessage"));
                }
                if (recType == 1 && !((RecTypeDataSourceObject)treeNode.getNodeData()).getDataType().equals("")) {
                    throw new Exception(this.m_helper.translate("CX_AddChildElementMessage"));
                }
                TextInfo t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, defaultNodeText);
                NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                RecTypeDataSourceObject dso = new RecTypeDataSourceObject(recType, defaultNodeText, dataType, 1, 1, false);
                if (parentNodeRecType == 99) {
                    dso.setChoiceElement(true);
                }
                RecTypeExplorerTreeNode newNode = new RecTypeExplorerTreeNode(newNodeIcon, nodeTxt, (Object)dso);
                if (recType == 99) {
                    newNode.setEditable(false);
                }
                if (nodeType != 99) {
                    treeNode.add((MutableTreeNode)((Object)newNode));
                    this.m_model = (DefaultTreeModel)this.m_tree.getModel();
                    this.m_model.nodeStructureChanged((TreeNode)((Object)treeNode));
                    this.m_tree.setSelectionPath(new TreePath(newNode.getPath()));
                } else {
                    ChoicePropertiesDialog choiceDlg = new ChoicePropertiesDialog(UIHelper.getFrame((Component)((Object)this)), this.m_helper);
                    int ret = choiceDlg.display(this.m_ffInfo, false);
                    if (ret == 0) {
                        treeNode.add((MutableTreeNode)((Object)newNode));
                        this.m_model = (DefaultTreeModel)this.m_tree.getModel();
                        this.m_model.nodeStructureChanged((TreeNode)((Object)treeNode));
                        this.m_tree.setSelectionPath(new TreePath(newNode.getPath()));
                    }
                }
            }
            catch (Exception ex) {
                MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)ex.getMessage(), (String)this.m_helper.translate("CX_AlertMessageTitle"), (int)0);
            }
        }
    }

    public void handleDeleteNode() {
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        RecTypeExplorerTreeNode treeNode = (RecTypeExplorerTreeNode)((Object)obj);
        if (treeNode.canDelete()) {
            try {
                String nodeName = ((RecTypeDataSourceObject)treeNode.getNodeData()).getName();
                int nodeType = ((RecTypeDataSourceObject)treeNode.getNodeData()).getRecType();
                if (nodeType == 9) {
                    if (this.m_ffInfo.isRecordUsedAsField(nodeName)) {
                        CommonUtils.error((Object)this, this.m_helper.translate("CX_RecExplorer_Message1"));
                        return;
                    }
                    if (this.confirmDeleteMsg(this.m_helper.translate("CX_DeleteCT_ConfirmMsg", new String[]{nodeName})) != 0) {
                        return;
                    }
                }
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)treeNode.getParent();
                if (!nodeName.equals(DEFAULT_NODE_TEXT)) {
                    if (nodeType == 1) {
                        if (this.confirmDeleteMsg(this.m_helper.translate("CX_DeleteFld_ConfirmMsg", new String[]{nodeName})) != 0) {
                            return;
                        }
                        String parentNodeName = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)parentNode)).getNodeData()).getName();
                        int fieldnum = parentNode.getIndex((TreeNode)((Object)treeNode));
                        if (this.m_ffInfo.getFieldPropertiesDs(parentNodeName).getRowCount() == 1) {
                            this.m_ffInfo.resetFieldPropertiesRow(parentNodeName, fieldnum);
                        } else {
                            this.m_ffInfo.getFieldPropertiesDs(parentNodeName).removeRows(fieldnum, 1);
                        }
                    } else if (nodeType == 99) {
                        if (this.confirmDeleteMsg(this.m_helper.translate("CX_DeleteChoice_ConfirmMsg")) != 0) {
                            return;
                        }
                        List choiceNodeList = this.getChoiceElementNodeList();
                        for (String choiceElement : choiceNodeList) {
                            this.m_ffInfo.removeFromRecordClassifierDs(choiceElement);
                        }
                        this.m_ffInfo.removeFromRecordClassifierDs(CHOICE_NODE_TEXT);
                    } else {
                        if (nodeType == 0 && this.confirmDeleteMsg(this.m_helper.translate("CX_DeleteElem_ConfirmMsg", new String[]{nodeName})) != 0) {
                            return;
                        }
                        this.m_ffInfo.removeFromRecordClassifierDs(nodeName);
                        this.m_ffInfo.removeFieldPropertiesDs(nodeName);
                    }
                }
                parentNode.remove((MutableTreeNode)((Object)treeNode));
                this.m_model = (DefaultTreeModel)this.m_tree.getModel();
                this.m_model.nodeStructureChanged(parentNode);
            }
            catch (Exception ex) {
                MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)ex.getMessage());
            }
        }
    }

    public void handleEditNode() {
        int ret = 0;
        TreePath path = this.m_tree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object obj = path.getLastPathComponent();
        if (!(obj instanceof DefaultMutableTreeNode)) {
            return;
        }
        RecTypeExplorerTreeNode treeNode = (RecTypeExplorerTreeNode)((Object)obj);
        String currNodeName = ((RecTypeDataSourceObject)treeNode.getNodeData()).getName();
        int nodeType = ((RecTypeDataSourceObject)treeNode.getNodeData()).getRecType();
        int nodeIndex = treeNode.getParent().getIndex((TreeNode)((Object)treeNode));
        if (nodeType == 1) {
            String parentNodeName = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)treeNode.getParent())).getNodeData()).getName();
            ComplexFieldPropertiesDialog fldPropDlg = new ComplexFieldPropertiesDialog(UIHelper.getFrame((Component)((Object)this)), this.m_helper);
            ret = fldPropDlg.display(this.m_ffInfo, this.m_ffInfo.getFieldSampleText(parentNodeName, nodeIndex), parentNodeName, nodeIndex);
            String fieldType = (String)this.m_ffInfo.getFieldPropertiesDs(parentNodeName).getData(2, nodeIndex);
            String fieldName = (String)this.m_ffInfo.getFieldPropertiesDs(parentNodeName).getData(1, nodeIndex);
            TextInfo t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, fieldName + " - " + fieldType);
            NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
            treeNode.setNodeText(nodeTxt);
            ((RecTypeDataSourceObject)treeNode.getNodeData()).setDataType(fieldType);
            this.m_model.nodeChanged((TreeNode)((Object)treeNode));
        } else if (nodeType == 99) {
            ChoicePropertiesDialog choiceDlg = new ChoicePropertiesDialog(UIHelper.getFrame((Component)((Object)this)), this.m_helper);
            ret = choiceDlg.display(this.m_ffInfo, true);
        } else {
            RecTypeDialog dlg = new RecTypeDialog(UIHelper.getFrame((Component)((Object)this)), this.m_helper);
            dlg.setDialogType(nodeType);
            try {
                int parentRecType = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)treeNode.getParent())).getNodeData()).getRecType();
                if (parentRecType == 99) {
                    dlg.setChoiceElement(true);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.m_ffInfo.getRecordAttributes(currNodeName) != null) {
                dlg.setEditMode(true);
                dlg.setChoiceElement(this.m_ffInfo.getRecordAttributes(currNodeName).isChoice());
                ret = dlg.displayRecordDetails(this.m_ffInfo, currNodeName);
            } else {
                if (this.m_ffInfo.getFieldPropertiesDs(currNodeName) != null && !this.m_ffInfo.getFieldPropertiesDs(currNodeName).getData(1, 0).equals("C1")) {
                    dlg.setEditMode(true);
                }
                ret = dlg.display(this.m_ffInfo, "", currNodeName);
            }
            if (ret == 0) {
                String recordType = this.m_ffInfo.getRecordAttributes(dlg.getCurrentRecord()).getType();
                RecTypeDataSourceObject nodedata = (RecTypeDataSourceObject)treeNode.getNodeData();
                nodedata.setName(dlg.getCurrentRecord());
                nodedata.setDataType(recordType);
                treeNode.setName(dlg.getCurrentRecord());
                this.updateTreeModel(dlg.getCurrentRecord(), path);
                this.propagateNodeNameChange(treeNode, dlg.getCurrentRecord());
            }
        }
    }

    public void addTreeDropTargetListener(WBTranslatable h, FlatFileInfo info, JFrame parent) {
        this.m_ffInfo = info;
        this.m_helper = h;
        RecTypeStringTransferHandler tf = new RecTypeStringTransferHandler(parent, h, info);
        this.m_xfrhdlr = tf;
        this.m_dndxfrhdlr = new DNDTreeTransferHandler(this.m_tree, tf, 1);
    }

    private void propagateNodeNameChange(RecTypeExplorerTreeNode currNode, String prevNodeName) {
        ArrayTwoDModel fieldProps = null;
        String fldName = "";
        String fldType = "";
        String currNodeName = "";
        boolean existingFieldFound = false;
        currNodeName = ((RecTypeDataSourceObject)currNode.getNodeData()).getName();
        int currNodeType = ((RecTypeDataSourceObject)currNode.getNodeData()).getRecType();
        if (currNodeType == 1) {
            RecTypeExplorerTreeNode parentNode = (RecTypeExplorerTreeNode)((Object)currNode.getParent());
            if (!parentNode.isRoot()) {
                fieldProps = this.m_ffInfo.getFieldPropertiesDs(((RecTypeDataSourceObject)parentNode.getNodeData()).getName());
                for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                    fldName = (String)fieldProps.getData(1, i);
                    if (!fldName.equals(prevNodeName)) continue;
                    fieldProps.setData(1, i, (Object)currNodeName);
                    existingFieldFound = true;
                    break;
                }
            }
            if (!existingFieldFound) {
                int row = 0;
                if (!fieldProps.getData(1, 0).equals("C1")) {
                    fieldProps.addRows(fieldProps.getRowCount(), 1);
                    row = fieldProps.getRowCount() - 1;
                } else {
                    row = 0;
                }
                this.m_ffInfo.resetFieldPropertiesRow(fieldProps, row);
                fieldProps.setData(1, row, (Object)currNodeName);
            }
        } else if (currNodeType == 9) {
            Vector recList = this.m_ffInfo.getRecordTypeList();
            Enumeration e = recList.elements();
            while (e.hasMoreElements()) {
                String record = (String)e.nextElement();
                RecTypeAttributes recAttr = this.m_ffInfo.getRecordAttributes(record);
                if (record.equals(prevNodeName)) continue;
                if (recAttr.getType().equals(prevNodeName)) {
                    recAttr.setType(currNodeName);
                    this.updateTreeModel(record, new TreePath((Object)this.m_ffInfo.getTreeNode(record)));
                    continue;
                }
                fieldProps = this.m_ffInfo.getFieldPropertiesDs(record);
                for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                    for (int j = 0; j < fieldProps.getColumnCount(); ++j) {
                        if (j != 2) continue;
                        fldType = (String)fieldProps.getData(j, i);
                    }
                    if (fldType == null || !fldType.equals(prevNodeName)) continue;
                    fieldProps.setData(2, i, (Object)currNodeName);
                    this.updateTreeModel(record, new TreePath((Object)this.m_ffInfo.getTreeNode(record)));
                }
            }
        }
        if (!prevNodeName.equals(DEFAULT_NODE_TEXT)) {
            this.m_ffInfo.updateRecordClassifierDs(prevNodeName, currNodeName);
        }
        if (!prevNodeName.equals(currNodeName)) {
            this.m_ffInfo.setFieldPropertiesDs(currNodeName, this.m_ffInfo.getFieldPropertiesDs(prevNodeName));
            this.m_ffInfo.removeFieldPropertiesDs(prevNodeName);
        }
    }

    private boolean checkDuplicateNodeName(RecTypeExplorerTreeNode currNode, String newNodeName) {
        boolean existingFieldFound = false;
        int currNodeType = ((RecTypeDataSourceObject)currNode.getNodeData()).getRecType();
        if (currNodeType == 1) {
            RecTypeExplorerTreeNode parentNode = (RecTypeExplorerTreeNode)((Object)currNode.getParent());
            if (!parentNode.isRoot() && (existingFieldFound = this.m_ffInfo.isFieldInRecord(((RecTypeDataSourceObject)parentNode.getNodeData()).getName(), newNodeName))) {
                CommonUtils.error((Object)this, this.m_helper.translate("CX_RecExplorer_Message2"));
                return true;
            }
        } else if (currNodeType == 9) {
            if (this.isDuplicateNode(newNodeName)) {
                CommonUtils.error((Object)this, this.m_helper.translate("CX_RecExplorer_Message3"));
                return true;
            }
            if (this.m_ffInfo.getRecordAttributes(newNodeName) != null) {
                CommonUtils.error((Object)this, this.m_helper.translate("CX_RecExplorer_Message4"));
                return true;
            }
            if (this.m_ffInfo.isRecordUsedAsField(newNodeName)) {
                CommonUtils.error((Object)this, this.m_helper.translate("CX_RecExplorer_Message5"));
                return true;
            }
        } else if (currNodeType == 0 && this.m_ffInfo.getRecordAttributes(newNodeName) != null) {
            CommonUtils.error((Object)this, this.m_helper.translate("CX_RecExplorer_Message4"));
            return true;
        }
        return false;
    }

    public void updateTreeModel(String recordName, TreePath path) {
        String fldName = "";
        String fldType = "";
        ArrayTwoDModel fieldProps = this.m_ffInfo.getFieldPropertiesDs(recordName);
        RecTypeExplorerTreeNode currNode = (RecTypeExplorerTreeNode)((Object)path.getLastPathComponent());
        RecTypeDataSourceObject nodedata = (RecTypeDataSourceObject)currNode.getNodeData();
        String recordType = this.m_ffInfo.getRecordAttributes(recordName).getType();
        int nodeType = nodedata.getRecType();
        nodedata.setName(recordName);
        nodedata.setDataType(recordType);
        TextInfo t1 = null;
        t1 = nodeType == 9 ? new TextInfo(Color.black, TextInfo.PLAIN_FONT, recordName) : new TextInfo(Color.black, TextInfo.PLAIN_FONT, recordName + " - " + recordType);
        NodeText nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
        currNode.setNodeText(nodeTxt);
        if (recordType.equals("")) {
            currNode.removeAllChildren();
            for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                for (int j = 0; j < fieldProps.getColumnCount(); ++j) {
                    if (j == 1) {
                        fldName = (String)fieldProps.getData(j, i);
                        continue;
                    }
                    if (j != 2) continue;
                    fldType = (String)fieldProps.getData(j, i);
                }
                if (!currNode.canCreate()) continue;
                t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, fldName + " - " + fldType);
                nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                RecTypeDataSourceObject dso = new RecTypeDataSourceObject(1, fldName, fldType, 1, 1, false);
                RecTypeExplorerTreeNode newNode = new RecTypeExplorerTreeNode(CHILD_ICON, fldName, (Object)dso);
                newNode.setNodeText(nodeTxt);
                currNode.add((MutableTreeNode)((Object)newNode));
            }
        }
        DefaultTreeModel m_model = (DefaultTreeModel)this.m_tree.getModel();
        m_model.nodeStructureChanged((TreeNode)((Object)currNode));
        this.m_tree.expandPath(path);
        this.m_ffInfo.setHierarchicalTreeModel(m_model);
    }

    private void synchronizeParentNodeFieldNames(RecTypeExplorerTreeNode currNode, String prevNodeName) {
        String fldName = "";
        boolean existingFieldFound = false;
        if (currNode == null) {
            return;
        }
        RecTypeExplorerTreeNode parentNode = (RecTypeExplorerTreeNode)((Object)currNode.getParent());
        String currNodeName = ((RecTypeDataSourceObject)currNode.getNodeData()).getName();
        if (!parentNode.isRoot()) {
            ArrayTwoDModel fieldProps = this.m_ffInfo.getFieldPropertiesDs(((RecTypeDataSourceObject)parentNode.getNodeData()).getName());
            for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                fldName = (String)fieldProps.getData(1, i);
                if (!fldName.equals(prevNodeName)) continue;
                fieldProps.setData(1, i, (Object)currNodeName);
                existingFieldFound = true;
                break;
            }
            this.m_ffInfo.updateRecordClassifierDs(prevNodeName, currNodeName);
            if (!existingFieldFound) {
                int row = 0;
                if (!fieldProps.getData(1, 0).equals("C1")) {
                    fieldProps.addRows(fieldProps.getRowCount(), 1);
                    row = fieldProps.getRowCount() - 1;
                } else {
                    row = 0;
                }
                this.m_ffInfo.resetFieldPropertiesRow(fieldProps, row);
                fieldProps.setData(1, row, (Object)currNodeName);
            }
        }
    }

    public String getSelectedNodeName() {
        return this._selectedNodeName;
    }

    private boolean isDuplicateNode(String nodename) {
        DefaultTreeModel model = this.m_ffInfo.getHierarchicalTreeModel();
        if (model == null) {
            return false;
        }
        RecTypeExplorerTreeNode rootnode = (RecTypeExplorerTreeNode)((Object)model.getRoot());
        Enumeration e = rootnode.children();
        while (e.hasMoreElements()) {
            RecTypeExplorerTreeNode node = (RecTypeExplorerTreeNode)((Object)e.nextElement());
            if (!((RecTypeDataSourceObject)node.getNodeData()).getName().equals(nodename)) continue;
            return true;
        }
        return false;
    }

    private List getChoiceElementNodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        DefaultTreeModel model = this.m_ffInfo.getHierarchicalTreeModel();
        if (model == null) {
            return arrayList;
        }
        RecTypeExplorerTreeNode rootnode = (RecTypeExplorerTreeNode)((Object)model.getRoot());
        Enumeration e = rootnode.children();
        while (e.hasMoreElements()) {
            RecTypeExplorerTreeNode node = (RecTypeExplorerTreeNode)((Object)e.nextElement());
            if (!((RecTypeDataSourceObject)node.getNodeData()).getName().equals(CHOICE_NODE_TEXT)) continue;
            Enumeration e1 = node.children();
            while (e1.hasMoreElements()) {
                arrayList.add(((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)e1.nextElement())).getNodeData()).getName());
            }
            break block0;
        }
        return arrayList;
    }

    public void handleTreeCellEditing(String newNodeName) {
        NodeText nodeTxt;
        int ret;
        RecTypeExplorerTreeNode selectedNode = (RecTypeExplorerTreeNode)((Object)this.m_tree.getLeadSelectionPath().getLastPathComponent());
        int parentNodeRecType = 0;
        if (!((RecTypeExplorerTreeNode)((Object)selectedNode.getParent())).isRoot()) {
            parentNodeRecType = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)selectedNode.getParent())).getNodeData()).getRecType();
        }
        RecTypeDataSourceObject selectedNodeData = (RecTypeDataSourceObject)selectedNode.getNodeData();
        if (this.checkDuplicateNodeName(selectedNode, newNodeName)) {
            selectedNode.setName(this._selectedNodeName);
            if (!selectedNodeData.getDataType().equals("")) {
                TextInfo t1 = null;
                t1 = this._selectedNodeName.equals(DEFAULT_NODE_TEXT) || this._selectedNodeName.equals(DEFAULT_COMPLEXTYPE_TEXT) ? new TextInfo(Color.black, TextInfo.PLAIN_FONT, this._selectedNodeName) : new TextInfo(Color.black, TextInfo.PLAIN_FONT, this._selectedNodeName + " - " + selectedNodeData.getDataType());
                NodeText nodeTxt2 = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
                selectedNode.setNodeText(nodeTxt2);
            }
            return;
        }
        if (selectedNodeData.getRecType() == 9 && this.m_ffInfo.isRecordUsedAsField(this._selectedNodeName) && (ret = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)this.m_helper.translate("CX_RecExplorer_Message6"), (String)this.m_helper.translate("CX_AlertMessageTitle"), (int)3, (int)2, (Icon)UIHelper.loadIcon((String)"images/help2.png", UIHelper.class))) == 2) {
            return;
        }
        selectedNode.setName(newNodeName);
        if (!selectedNodeData.getDataType().equals("")) {
            TextInfo t1 = null;
            t1 = new TextInfo(Color.black, TextInfo.PLAIN_FONT, newNodeName + " - " + selectedNodeData.getDataType());
            nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
            selectedNode.setNodeText(nodeTxt);
            if (this._selectedNodeName.equals(DEFAULT_NODE_TEXT) && selectedNodeData.getRecType() != 1) {
                this.m_ffInfo.addNewRecordToClassifierDs(newNodeName, selectedNodeData.getRecType());
                this.m_ffInfo.getRecordAttributes(newNodeName).setType(selectedNodeData.getDataType());
                if (parentNodeRecType == 99) {
                    this.m_ffInfo.getRecordAttributes(newNodeName).setChoice(true);
                }
            }
        }
        if (selectedNodeData.getRecType() == 1) {
            TextInfo t1 = null;
            t1 = selectedNodeData.getDataType().equals("") ? new TextInfo(Color.black, TextInfo.PLAIN_FONT, newNodeName + " - string") : new TextInfo(Color.black, TextInfo.PLAIN_FONT, newNodeName + " - " + selectedNodeData.getDataType());
            nodeTxt = new NodeText(new TextInfo[]{t1}, new TextInfo[]{t1});
            selectedNode.setNodeText(nodeTxt);
        }
        RecTypeDataSourceObject dso = new RecTypeDataSourceObject(selectedNodeData.getRecType(), newNodeName, selectedNodeData.getDataType(), 1, 1, false);
        selectedNode.setNodeData(dso);
        this.propagateNodeNameChange(selectedNode, this._selectedNodeName);
        if (selectedNodeData.getRecType() == 1) {
            String parentNodeName = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)selectedNode.getParent())).getNodeData()).getName();
            int parentNodeType = ((RecTypeDataSourceObject)((RecTypeExplorerTreeNode)((Object)selectedNode.getParent())).getNodeData()).getRecType();
            if (!this.m_ffInfo.getFieldPropertiesDs(parentNodeName).getData(1, 0).equals("C1") && this.m_ffInfo.getRecordAttributes(parentNodeName) == null) {
                this.m_ffInfo.addNewRecordToClassifierDs(parentNodeName, parentNodeType);
            }
        }
        this._selectedNodeName = newNodeName;
    }

    public boolean globalElementsExist() {
        SortableTwoDModel recClassifierDs = this.m_ffInfo.getRecordClassifierDs();
        for (int i = 0; i < recClassifierDs.getRowCount(); ++i) {
            if (((RecTypeAttributes)recClassifierDs.getData(3, i)).getRecType() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean choiceNodeExists() {
        SortableTwoDModel recClassifierDs = this.m_ffInfo.getRecordClassifierDs();
        for (int i = 0; i < recClassifierDs.getRowCount(); ++i) {
            if (((RecTypeAttributes)recClassifierDs.getData(3, i)).getRecordName() != CHOICE_NODE_TEXT) continue;
            return true;
        }
        return false;
    }

    public void validComplexTypes() throws FlatFileValidationException {
        ArrayTwoDModel fieldProps = null;
        SortableTwoDModel recClassifierDs = this.m_ffInfo.getRecordClassifierDs();
        for (int i = 0; i < recClassifierDs.getRowCount(); ++i) {
            String recname = ((RecTypeAttributes)recClassifierDs.getData(3, i)).getRecordName();
            if (((RecTypeAttributes)recClassifierDs.getData(3, i)).getRecType() != 9 || (fieldProps = this.m_ffInfo.getFieldPropertiesDs(recname)).getRowCount() != 1) continue;
            if (!fieldProps.getData(1, 0).equals("C1")) continue;
            throw new FlatFileValidationException("Complex Type: " + recname + " does not have any elements!");
        }
    }

    public void showWaitPanel() {
        this.m_cardPnl.show("WAIT_PANEL");
    }

    public void showTreePanel() {
        this.m_cardPnl.show("TREE_PANEL");
    }

    public TransferHandler getTransferHandler() {
        return this.m_xfrhdlr;
    }

    public DNDTreeTransferHandler getDNDTransferHandler() {
        return this.m_dndxfrhdlr;
    }

    private int confirmDeleteMsg(String delMsg) {
        int ret = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)delMsg, (String)this.m_helper.translate("CX_AlertMessageTitle"), (int)3, (int)0, (Icon)UIHelper.loadIcon((String)"images/help2.png", UIHelper.class));
        return ret;
    }

    public class RecTypeTreePopupListener
    extends DefaultPopupListener {
        public List getPopupMenuItems(TreeExplorer explorer, TreePath path) {
            ArrayList<AbstractAction> l = new ArrayList<AbstractAction>();
            if (path == null) {
                return null;
            }
            Object obj = path.getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode)) {
                return null;
            }
            RecTypeExplorerTreeNode treeNode = (RecTypeExplorerTreeNode)((Object)obj);
            if (!treeNode.isRoot()) {
                RecTypeDataSourceObject dso = (RecTypeDataSourceObject)treeNode.getNodeData();
                if (!treeNode.getDisplayName().equals(RecTypeExplorer.DEFAULT_NODE_TEXT) && !treeNode.getDisplayName().equals(RecTypeExplorer.DEFAULT_COMPLEXTYPE_TEXT)) {
                    if (dso.getRecType() == 1) {
                        l.add(new EditRecTypeNodeAction(explorer, true));
                    } else {
                        l.add(new AddChildNodeAction(explorer, true));
                        l.add(new EditRecTypeNodeAction(explorer, true));
                    }
                }
                l.add(new DeleteChildNodeAction(explorer, true));
            }
            return l;
        }
    }

    class TreeNodeExpansionListener
    implements TreeExpansionListener {
        TreeNodeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            final DefaultTreeExplorerTreeNode node = RecTypeExplorer.this.getTreeNode(event.getPath());
            RecTypeExplorer.this.setCursor(Cursor.getPredefinedCursor(3));
            Thread runner = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        if (node != null) {
                            RecTypeExplorer.this.expandNode(node);
                        }
                    }
                    finally {
                        RecTypeExplorer.this.setCursor(Cursor.getDefaultCursor());
                    }
                }
            };
            runner.start();
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
        }
    }
}

