/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileTranslationHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class RecTypeDialogAttrPanel
extends JPanel {
    private static final String EOL = "${eol}";
    private static String[] xmlDataTypes = new String[]{"", "anyURI", "base64Binary", "boolean", "byte", "date", "dateTime", "decimal", "double", "duration", "ENTITIES", "ENTITY", "float", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "hexBinary", "ID", "IDREF", "IDREFS", "int", "integer", "language", "long", "Name", "NCName", "negativeInteger", "NMTOKEN", "NMTOKENS", "nonNegativeInteger", "nonPositiveInteger", "normalizedString", "NOTATION", "positiveInteger", "QName", "short", "string", "time", "token", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort"};
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JCheckBox jOptionalCB = new JCheckBox();
    private JCheckBox jChoiceCB = new JCheckBox();
    private JLabel jChoiceTextLabel = new JLabel();
    private JTextField jChoiceText = new JTextField();
    private JLabel jChoiceTypeLabel = new JLabel();
    private JTextField jChoiceTypeText = new JTextField();
    private JComboBox jMaxOccursCombo = new JComboBox();
    private JLabel jMaxOccursLabel = new JLabel();
    private JLabel jTypeLabel = new JLabel();
    private JComboBox jTypeCombo = new JComboBox();
    private JLabel jRecNameLabel = new JLabel();
    private JTextField jRecName = new JTextField();
    private JComboBox jCellSepCombo = new JComboBox();
    private JLabel jCellSepLabel = new JLabel();
    private JComboBox jArraySepCombo = new JComboBox();
    private JLabel jArraySepLabel = new JLabel();
    private JCheckBox jArrayCB = new JCheckBox();
    private JCheckBox jListCB = new JCheckBox();
    private JComboBox jItemSepCombo = new JComboBox();
    private JLabel jItemSepLabel = new JLabel();
    private JComboBox jListSepCombo = new JComboBox();
    private JLabel jListSepLabel = new JLabel();
    private JLabel jArrayLengthLabel = new JLabel();
    private JSpinner jArrayLengthSpinner = new JSpinner();
    private JLabel jStartsWithLabel = new JLabel();
    private JTextField jStartsWith = new JTextField();
    private JButton jFieldPropBtn = new JButton();
    private int _recType;
    private FlatFileTranslationHelper _h = new FlatFileTranslationHelper();

    public RecTypeDialogAttrPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.setSize(new Dimension(537, 192));
        this.jOptionalCB.setText(this._h.translate("CX_RecAttrFieldLabel_Optional"));
        CommonUtils.setMnemonicAndAccelerator(this.jOptionalCB, NLSUtils.getNLSString("CX_RecAttrFieldLabel_Optional"));
        this.jChoiceCB.setText(this._h.translate("CX_RecAttrFieldLabel_Choice"));
        CommonUtils.setMnemonicAndAccelerator(this.jChoiceCB, NLSUtils.getNLSString("CX_RecAttrFieldLabel_Choice"));
        this.jChoiceTypeLabel.setText(this._h.translate("CX_FieldLabel_ChoiceType"));
        this.jChoiceTypeText.setEnabled(false);
        this.jChoiceCB.setEnabled(false);
        this.jMaxOccursLabel.setText(this._h.translate("CX_RecAttrFieldLabel_MaxOccurs"));
        this.jMaxOccursLabel.setLabelFor(this.jMaxOccursCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jMaxOccursLabel, NLSUtils.getNLSString("CX_RecAttrFieldLabel_MaxOccurs"));
        this.jMaxOccursCombo.addItem("1");
        this.jMaxOccursCombo.addItem("UNBOUNDED");
        this.jMaxOccursCombo.setEditable(true);
        this.jMaxOccursCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (((String)e.getItem()).equals("UNBOUNDED")) {
                    RecTypeDialogAttrPanel.this.jArrayCB.setEnabled(true);
                } else if (((String)e.getItem()).equals("1")) {
                    RecTypeDialogAttrPanel.this.jArrayCB.setEnabled(false);
                    RecTypeDialogAttrPanel.this.jArrayCB.setSelected(false);
                } else {
                    RecTypeDialogAttrPanel.this.jArrayCB.setSelected(false);
                    RecTypeDialogAttrPanel.this.jArrayCB.setEnabled(false);
                }
            }
        });
        this.jTypeLabel.setText(this._h.translate("CX_RecAttrFieldLabel_DataType"));
        this.jTypeLabel.setLabelFor(this.jTypeCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jTypeLabel, NLSUtils.getNLSString("CX_RecAttrFieldLabel_DataType"));
        for (int i = 0; i < xmlDataTypes.length; ++i) {
            this.jTypeCombo.addItem(xmlDataTypes[i]);
        }
        this.jRecNameLabel.setText(this._h.translate("CX_RecAttrFieldLabel_ElementName"));
        this.jRecNameLabel.setLabelFor(this.jRecName);
        CommonUtils.setMnemonicAndAccelerator(this.jRecNameLabel, NLSUtils.getNLSString("CX_RecAttrFieldLabel_ElementName"));
        this.jStartsWithLabel.setText(this._h.translate("CX_FieldLabel_StartsWith"));
        this.jStartsWithLabel.setLabelFor(this.jStartsWith);
        CommonUtils.setMnemonicAndAccelerator(this.jStartsWithLabel, NLSUtils.getNLSString("CX_FieldLabel_StartsWith"));
        this.jCellSepCombo.setEnabled(false);
        this.jCellSepCombo.setEditable(true);
        this.jCellSepCombo.addItem(EOL);
        this.jCellSepCombo.setSelectedItem("");
        this.jCellSepLabel.setText(this._h.translate("CX_FieldLabel_CellSep"));
        this.jCellSepLabel.setLabelFor(this.jCellSepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jCellSepLabel, NLSUtils.getNLSString("CX_FieldLabel_CellSep"));
        this.jArraySepCombo.setEnabled(false);
        this.jArraySepCombo.setEditable(true);
        this.jArraySepCombo.addItem(EOL);
        this.jArraySepCombo.setSelectedItem("");
        this.jArraySepLabel.setText(this._h.translate("CX_FieldLabel_ArraySep"));
        this.jArraySepLabel.setLabelFor(this.jArraySepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jArraySepLabel, NLSUtils.getNLSString("CX_FieldLabel_ArraySep"));
        this.jArrayCB.setText(this._h.translate("CX_FieldLabel_Array"));
        this.jArrayCB.setSize(new Dimension(40, 18));
        this.jArrayCB.setBounds(new Rectangle(60, 72, 45, 18));
        this.jArrayCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RecTypeDialogAttrPanel.this.jArrayCB_itemStateChanged(e);
            }
        });
        this.jArrayLengthLabel.setText(this._h.translate("CX_FieldLabel_ArrayLength"));
        this.jArrayLengthLabel.setLabelFor(this.jArrayLengthSpinner);
        CommonUtils.setMnemonicAndAccelerator(this.jArrayLengthLabel, NLSUtils.getNLSString("CX_FieldLabel_ArrayLength"));
        this.jArrayLengthSpinner.setEnabled(false);
        this.jItemSepCombo.setEnabled(false);
        this.jItemSepCombo.setEditable(true);
        this.jItemSepCombo.addItem(EOL);
        this.jItemSepCombo.setSelectedItem("");
        this.jItemSepLabel.setText(this._h.translate("CX_FieldLabel_ItemSep"));
        this.jItemSepLabel.setLabelFor(this.jItemSepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jItemSepLabel, NLSUtils.getNLSString("CX_FieldLabel_ItemSep"));
        this.jListSepCombo.setEnabled(false);
        this.jListSepCombo.setEditable(true);
        this.jListSepCombo.addItem(EOL);
        this.jListSepCombo.setSelectedItem("");
        this.jListSepLabel.setText(this._h.translate("CX_FieldLabel_ListSep"));
        this.jListSepLabel.setLabelFor(this.jListSepCombo);
        CommonUtils.setMnemonicAndAccelerator(this.jListSepLabel, NLSUtils.getNLSString("CX_FieldLabel_ListSep"));
        this.jListCB.setText(this._h.translate("CX_FieldLabel_List"));
        this.jListCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RecTypeDialogAttrPanel.this.jListCB_itemStateChanged(e);
            }
        });
        this.jChoiceTextLabel.setText(this._h.translate("CX_RecAttrFieldLabel_ChoiceValue"));
        this.jChoiceTextLabel.setLabelFor(this.jChoiceText);
        CommonUtils.setMnemonicAndAccelerator(this.jChoiceTextLabel, NLSUtils.getNLSString("CX_RecAttrFieldLabel_ChoiceValue"));
        this.jChoiceText.setEnabled(false);
        this.jFieldPropBtn.setText(this._h.translate("CX_RecAttrFieldLabel_EditProps"));
        CommonUtils.setMnemonicAndAccelerator(this.jFieldPropBtn, NLSUtils.getNLSString("CX_RecAttrFieldLabel_EditProps"));
        this.jChoiceCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JCheckBox) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        RecTypeDialogAttrPanel.this.jChoiceText.setEnabled(true);
                        RecTypeDialogAttrPanel.this.jStartsWith.setEnabled(false);
                    } else {
                        RecTypeDialogAttrPanel.this.jChoiceText.setEnabled(false);
                        RecTypeDialogAttrPanel.this.jStartsWith.setEnabled(true);
                    }
                }
            }
        });
        this.add((Component)this.jRecNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 9, 0, 7), 0, 0));
        this.add((Component)this.jRecName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 0, 13), 100, 0));
        this.add((Component)this.jMaxOccursLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 2, 0, 6), 0, 0));
        this.add((Component)this.jMaxOccursCombo, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 14), 33, -4));
        this.add((Component)this.jArrayCB, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        this.add((Component)this.jArrayLengthLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 16, 0, 7), 0, 0));
        this.add((Component)this.jArrayLengthSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 14), 10, -4));
        this.add((Component)this.jCellSepLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 0, 0, 7), 0, 0));
        this.add((Component)this.jCellSepCombo, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), -19, 0));
        this.add((Component)this.jArraySepLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 16, 0, 6), 0, 0));
        this.add((Component)this.jArraySepCombo, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 0, 0), -19, 0));
        this.add((Component)this.jTypeLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 32, 0, 0), 0, 0));
        this.add((Component)this.jTypeCombo, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 3, 0), 49, 0));
        this.add((Component)this.jStartsWithLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 9, 0, 7), 0, 0));
        this.add((Component)this.jStartsWith, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 13), 100, 0));
        this.add((Component)this.jOptionalCB, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 8), 0, 0));
        this.add((Component)this.jFieldPropBtn, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.validate();
    }

    public void hideControlsForComplexType() {
        this.jOptionalCB.setVisible(false);
        this.jChoiceCB.setVisible(false);
        this.jMaxOccursCombo.setVisible(false);
        this.jMaxOccursLabel.setVisible(false);
        this.jTypeLabel.setVisible(false);
        this.jTypeCombo.setVisible(false);
        this.jRecNameLabel.setText(this._h.translate("CX_RecAttrFieldLabel_CTName"));
        this.jCellSepCombo.setVisible(false);
        this.jCellSepLabel.setVisible(false);
        this.jArraySepCombo.setVisible(false);
        this.jArraySepLabel.setVisible(false);
        this.jArrayCB.setVisible(false);
        this.jArrayLengthLabel.setVisible(false);
        this.jArrayLengthSpinner.setVisible(false);
        this.jStartsWithLabel.setVisible(false);
        this.jStartsWith.setVisible(false);
        this.jChoiceTextLabel.setVisible(false);
        this.jChoiceText.setVisible(false);
        this.jFieldPropBtn.setVisible(false);
        this.remove(this.jRecName);
        this.add((Component)this.jRecName, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 0, 360), 110, 0));
        JPanel listPanel = new JPanel(new GridBagLayout());
        listPanel.add((Component)this.jListCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        listPanel.add((Component)this.jItemSepLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        listPanel.add((Component)this.jItemSepCombo, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        listPanel.add((Component)this.jListSepLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 20, 0, 0), 0, 0));
        listPanel.add((Component)this.jListSepCombo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)listPanel, new GridBagConstraints(1, 1, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.validate();
    }

    public String getRecordName() {
        return this.jRecName.getText();
    }

    public void setRecordName(String recname) {
        this.jRecName.setText(recname);
    }

    public boolean isOptional() {
        return this.jOptionalCB.isSelected();
    }

    public void setOptional(boolean choice) {
        this.jOptionalCB.setSelected(choice);
    }

    public boolean isChoice() {
        return this.jChoiceCB.isSelected();
    }

    public void setChoice(boolean choice) {
        this.jChoiceCB.setSelected(choice);
        if (choice) {
            this.jChoiceText.setEnabled(true);
        }
    }

    public void setArray(boolean array) {
        this.jArrayCB.setSelected(array);
    }

    public void setList(boolean list) {
        this.jListCB.setSelected(list);
    }

    public int getMaxOccurs() {
        if (((String)this.jMaxOccursCombo.getSelectedItem()).equals("1")) {
            return 1;
        }
        if (((String)this.jMaxOccursCombo.getSelectedItem()).equals("UNBOUNDED")) {
            return 0x7FFFFFF8;
        }
        return new Integer((String)this.jMaxOccursCombo.getSelectedItem());
    }

    public void setMaxOccurs(int maxOccurs) {
        if (maxOccurs == 1 || maxOccurs == -1) {
            this.jMaxOccursCombo.setSelectedItem("1");
            this.jArrayCB.setSelected(false);
            this.jArrayCB.setEnabled(false);
        } else if (maxOccurs == 0x7FFFFFF8) {
            this.jMaxOccursCombo.setSelectedItem("UNBOUNDED");
            this.jArrayCB.setEnabled(true);
        } else {
            this.jMaxOccursCombo.setSelectedItem(new Integer(maxOccurs).toString());
            this.jArrayCB.setSelected(false);
            this.jArrayCB.setEnabled(false);
        }
    }

    public String getArraySeparator() {
        return (String)this.jArraySepCombo.getSelectedItem();
    }

    public void setArraySeparator(String arraySeparator) {
        this.jArraySepCombo.setSelectedItem(arraySeparator);
    }

    public String getCellSeparator() {
        return (String)this.jCellSepCombo.getSelectedItem();
    }

    public void setCellSeparator(String cellSeparator) {
        this.jCellSepCombo.setSelectedItem(cellSeparator);
    }

    public boolean isArray() {
        return this.jArrayCB.isSelected();
    }

    public String getArrayLength() {
        return ((Integer)this.jArrayLengthSpinner.getValue()).toString();
    }

    public void setArrayLength(String arrayLength) {
        this.jArrayLengthSpinner.setValue(new Integer(arrayLength));
    }

    public boolean isList() {
        return this.jListCB.isSelected();
    }

    public String getListSeparator() {
        return (String)this.jListSepCombo.getSelectedItem();
    }

    public void setListSeparator(String listSeparator) {
        this.jListSepCombo.setSelectedItem(listSeparator);
    }

    public String getItemSeparator() {
        return (String)this.jItemSepCombo.getSelectedItem();
    }

    public void setItemSeparator(String itemSeparator) {
        this.jItemSepCombo.setSelectedItem(itemSeparator);
    }

    public String getStartsWith() {
        return this.jStartsWith.getText();
    }

    public void setStartsWith(String startsWith) {
        this.jStartsWith.setText(startsWith);
    }

    public String getChoiceValue() {
        return this.jChoiceText.getText();
    }

    public void setChoiceValue(String choice) {
        this.jChoiceText.setText(choice);
    }

    public RecTypeAttributes getRecordAttributes() {
        RecTypeAttributes recAttr = new RecTypeAttributes();
        recAttr.setRecordName(this.getRecordName());
        recAttr.setChoice(this.isChoice());
        recAttr.setOccurs(this.getMaxOccurs());
        recAttr.setArray(this.isArray());
        recAttr.setArraySeparator(this.getArraySeparator());
        recAttr.setCellSeparator(this.getCellSeparator());
        recAttr.setList(this.isList());
        recAttr.setListSeparator(this.getListSeparator());
        recAttr.setItemSeparator(this.getItemSeparator());
        recAttr.setType(this.getRecType());
        recAttr.setRecType(this._recType);
        recAttr.setArrayLength(this.getArrayLength());
        recAttr.setStartsWith(this.getStartsWith());
        if (this.isOptional()) {
            recAttr.setMinOccurs(0);
        } else {
            recAttr.setMinOccurs(1);
        }
        if (this.isChoice()) {
            recAttr.setChoiceType(this.getChoiceType());
            recAttr.setChoiceValue(this.getChoiceValue());
        }
        return recAttr;
    }

    public void setRecordAttributes(RecTypeAttributes recAttr) {
        this.setRecordName(recAttr.getRecordName());
        this.setChoice(recAttr.isChoice());
        this.setMaxOccurs(recAttr.getOccurs());
        this.setArray(recAttr.isArray());
        this.setArraySeparator(recAttr.getArraySeparator());
        this.setCellSeparator(recAttr.getCellSeparator());
        this.setList(recAttr.isList());
        this.setListSeparator(recAttr.getListSeparator());
        this.setItemSeparator(recAttr.getItemSeparator());
        this.setTypeCombo(recAttr.getType());
        this.setRecType(recAttr.getRecType());
        this.setArrayLength(recAttr.getArrayLength());
        this.setStartsWith(recAttr.getStartsWith());
        this.setOptional(recAttr.getMinOccurs() == 0);
        this.setChoiceValue(recAttr.getChoiceValue());
    }

    public JTextField getRecNameField() {
        return this.jRecName;
    }

    public JCheckBox getChoiceCB() {
        return this.jChoiceCB;
    }

    public JTextField getChoiceText() {
        return this.jChoiceText;
    }

    public String getChoiceType() {
        return this.jChoiceTypeText.getText();
    }

    public JComboBox getTypeCombo() {
        return this.jTypeCombo;
    }

    public String getRecType() {
        return (String)this.jTypeCombo.getSelectedItem();
    }

    public void setTypeCombo(String type) {
        this.jTypeCombo.setSelectedItem(type);
    }

    public void setRecType(int recType) {
        this._recType = recType;
    }

    public JButton getFieldPropBtn() {
        return this.jFieldPropBtn;
    }

    private void jArrayCB_itemStateChanged(ItemEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            this.jCellSepCombo.setEnabled(true);
            this.jArraySepCombo.setEnabled(true);
            this.jArrayLengthSpinner.setEnabled(true);
        } else {
            this.jCellSepCombo.setSelectedItem("");
            this.jCellSepCombo.setEnabled(false);
            this.jArraySepCombo.setSelectedItem("");
            this.jArraySepCombo.setEnabled(false);
            this.jArrayLengthSpinner.setEnabled(false);
            this.jArrayLengthSpinner.setValue(0);
        }
    }

    private void jListCB_itemStateChanged(ItemEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            this.jItemSepCombo.setEnabled(true);
            this.jListSepCombo.setEnabled(true);
        } else {
            this.jItemSepCombo.setSelectedItem("");
            this.jItemSepCombo.setEnabled(false);
            this.jListSepCombo.setSelectedItem("");
            this.jListSepCombo.setEnabled(false);
        }
    }

    public void createChoiceTypeFields(RecTypeAttributes attr) {
        JPanel choiceType1Panel = new JPanel(new GridBagLayout());
        JPanel choiceType2Panel = new JPanel(new GridBagLayout());
        JLabel choiceTypeLabel = new JLabel(this._h.translate("CX_FieldLabel_ChoiceType"));
        JTextField choiceTypeText = new JTextField();
        choiceTypeText.setEnabled(false);
        choiceTypeLabel.setLabelFor(choiceTypeText);
        choiceType1Panel.add((Component)this.jChoiceCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        choiceType1Panel.add((Component)this.jChoiceTypeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        choiceType1Panel.add((Component)this.jChoiceTypeText, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 40, 0));
        choiceType1Panel.add((Component)this.jChoiceTextLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 8), 0, 0));
        choiceType1Panel.add((Component)this.jChoiceText, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 8), 50, 0));
        if (attr.getChoiceType() == "A") {
            this.jChoiceTypeText.setText(this._h.translate("CX_ChoiceDlg_AdhocOption"));
        } else if (attr.getChoiceType() == "F") {
            this.jChoiceTypeText.setText(this._h.translate("CX_ChoiceDlg_FixedOption"));
            JLabel lengthLabel = new JLabel(this._h.translate("CX_FieldLabel_Length"));
            JTextField lengthText = new JTextField();
            lengthText.setEnabled(false);
            lengthLabel.setLabelFor(lengthText);
            lengthText.setText(Integer.valueOf(attr.getLength()).toString());
            choiceType1Panel.add((Component)lengthLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            choiceType1Panel.add((Component)lengthText, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 40, 0));
        } else if (attr.getChoiceType() == "D") {
            this.jChoiceTypeText.setText(this._h.translate("CX_ChoiceDlg_DelimOption"));
            JLabel delimiterLabel = new JLabel(this._h.translate("CX_FieldLabel_DelimBy"));
            JTextField delimiterText = new JTextField();
            delimiterText.setEnabled(false);
            delimiterLabel.setLabelFor(delimiterText);
            delimiterText.setText(this.getDelimiterAsComboItem(attr.getStylePattern1()));
            choiceType1Panel.add((Component)delimiterLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            choiceType1Panel.add((Component)delimiterText, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 80, 0));
        } else if (attr.getChoiceType() == "V") {
            this.jChoiceTypeText.setText(this._h.translate("CX_ChoiceDlg_VarOption"));
            JLabel varNameLabel = new JLabel(this._h.translate("CX_FieldLabel_VarName"));
            JTextField varNameText = new JTextField();
            varNameText.setEnabled(false);
            varNameLabel.setLabelFor(varNameText);
            varNameText.setText(attr.getVarName());
            JLabel lookAheadLabel = new JLabel(this._h.translate("CX_FieldLabel_LookAhead"));
            JTextField lookAheadText = new JTextField();
            lookAheadText.setEnabled(false);
            lookAheadLabel.setLabelFor(lookAheadText);
            lookAheadText.setText(attr.getLookAhead());
            JLabel scanLabel = new JLabel(this._h.translate("CX_FieldLabel_ScanLength"));
            JTextField scanText = new JTextField();
            scanText.setEnabled(false);
            scanLabel.setLabelFor(scanText);
            scanText.setText(attr.getScanLength());
            JLabel assignToLabel = new JLabel(this._h.translate("CX_FieldLabel_AssignTo"));
            JTextField assignToText = new JTextField();
            assignToText.setEnabled(false);
            assignToLabel.setLabelFor(assignToText);
            assignToText.setText(attr.getAssignTo());
            choiceType2Panel.add((Component)varNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            choiceType2Panel.add((Component)varNameText, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 40, 0));
            choiceType2Panel.add((Component)lookAheadLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            choiceType2Panel.add((Component)lookAheadText, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 40, 0));
            choiceType2Panel.add((Component)scanLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            choiceType2Panel.add((Component)scanText, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 40, 0));
            choiceType2Panel.add((Component)assignToLabel, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
            choiceType2Panel.add((Component)assignToText, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 0), 40, 0));
            this.add((Component)choiceType2Panel, new GridBagConstraints(1, 7, 9, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        }
        this.add((Component)choiceType1Panel, new GridBagConstraints(1, 6, 9, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
    }

    private String getDelimiterAsComboItem(String delimiter) {
        String newDelim = delimiter;
        if (newDelim.equals("  ")) {
            newDelim = this._h.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile");
        } else if (newDelim.equals(",")) {
            newDelim = this._h.translate("DA_delimitedColDelimiterComma_FlatFile");
        } else if (newDelim.equals(";")) {
            newDelim = this._h.translate("DA_delimitedColDelimiterSemicolon_FlatFile");
        } else if (newDelim.equals("\\t")) {
            newDelim = this._h.translate("DA_delimitedColDelimiterTab_FlatFile");
        } else if (newDelim.equals(" ")) {
            newDelim = this._h.translate("DA_delimitedColDelimiterSpace_FlatFile");
        }
        return newDelim;
    }
}

