/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooserListener;
import oracle.tip.tools.ide.common.ui.CardPanel;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.utils.MultiLineOptionPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.ComplexFieldPropertiesDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileComplexFieldProperties;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmoForDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeAttributes;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.RecTypeDialogAttrPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatableDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class RecTypeDialog
extends WBTranslatableDialog
implements ActionListener,
PropertyChangeListener {
    public static final int OK = 0;
    public static final int CANCEL = 2;
    private static final String WAIT_PANEL = "WAIT_PANEL";
    private static final String ACTUAL_PANEL = "ACTUAL_PANEL";
    private JPanel mainPanel;
    private JButton m_CreateFieldsBtn;
    private JLabel _delimiterLabel;
    private JComboBox _delimiterCombo;
    private static String[] _delimiterList = new String[]{"FI_generalColDelimiterSpace_FlatFile", "FI_generalColDelimiterComma_FlatFile", "FI_generalColDelimiterSemicolon_FlatFile", "FI_generalColDelimiterWhiteSpace_FlatFile", "FI_generalColDelimiterTab_FlatFile", "CX_Fixed_Length", "CX_Mixed"};
    protected int m_retVal = 2;
    protected boolean m_editMode = false;
    private RecTypeDialogAttrPanel _recAttributePanel;
    private JLabel _nameFileNameIntro;
    private FlatFileDisplayGizmoForDialog _dataGizmo;
    private JLabel _identifyFieldsLabel;
    private MultiLineLabel _identifyFieldsIntro;
    private SortableTwoDModel _valueGridDs;
    private CardPanel _cardPanel;
    private int _classifierStart;
    private int _classifierEnd;
    private FlatFileComplexFieldProperties _fieldPropertiesPanel;
    protected TypeChooserListener m_listener;
    protected WBTranslatable _translatable;
    protected JFrame _parentFrame;
    protected FlatFileInfo _ffInfo;
    protected String _selectedRecord;
    protected String _recordName;
    protected String _recType;
    protected int _dialogType;
    protected boolean _bChoice = false;

    public RecTypeDialog(JFrame f, WBTranslatable h) {
        super(f, h, h.translate("CX_RecTypeDetailsTitle"), true);
        this._translatable = h;
        this._parentFrame = f;
        this.createControls();
        this.layoutControls();
        this.m_listener = new TypeChooserListener(){

            public void typeSelectionOccurred() {
            }
        };
    }

    public void dispose() {
        super.dispose();
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = RecTypeDialog.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public int getReturnValue() {
        return this.m_retVal;
    }

    public void setDialogType(int dlgType) {
        this._dialogType = dlgType;
    }

    protected void createControls() {
        this.m_CreateFieldsBtn = new JButton(this._translatable.translate("CX_CreateFieldsLabel"));
        this.m_CreateFieldsBtn.addActionListener(this);
        this.m_CreateFieldsBtn.setEnabled(false);
        CommonUtils.setMnemonicAndAccelerator(this.m_CreateFieldsBtn, NLSUtils.getNLSString("CX_CreateFieldsLabel"));
        this._nameFileNameIntro = new JLabel(this._translatable.translate("CX_RecTypeDetailsIntro"));
        this._recAttributePanel = new RecTypeDialogAttrPanel();
        this._recAttributePanel.getRecNameField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                RecTypeDialog.this.handleCreateFieldsButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                RecTypeDialog.this.handleCreateFieldsButton();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                RecTypeDialog.this.handleCreateFieldsButton();
            }
        });
        this._recAttributePanel.getTypeCombo().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ((String)e.getItem()).equals("")) {
                    CommonUtils.error((Object)RecTypeDialog.this._recAttributePanel, RecTypeDialog.this._translatable.translate("CX_RecAttrTypeValidationMessage"));
                    RecTypeDialog.this._recAttributePanel.getTypeCombo().setSelectedItem(RecTypeDialog.this._recType);
                } else {
                    RecTypeDialog.this.handleTypeSelection((String)e.getItem());
                }
            }
        });
        this._identifyFieldsLabel = new JLabel(this._translatable.translate("CX_IdentifyFields"));
        this._identifyFieldsIntro = new MultiLineLabel(WordWrapper.getTextWrapper(), this._translatable.translate("CX_rulerInstructions"));
        this._delimiterLabel = new JLabel(this._translatable.translate("DA_delimitedColDelimiterHeading_FlatFile"));
        this._delimiterCombo = new JComboBox();
        for (int i = 0; i < _delimiterList.length; ++i) {
            this._delimiterCombo.addItem(this._translatable.translate(_delimiterList[i]));
        }
        this._delimiterCombo.setSelectedItem(this._translatable.translate("CX_Mixed"));
        ItemListener delimiterChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RecTypeDialog.this.delimiterValueChanged((String)RecTypeDialog.this._delimiterCombo.getSelectedItem());
                }
            }
        };
        this._delimiterCombo.addItemListener(delimiterChangedListener);
        ActionListener delimiterTextListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecTypeDialog.this.delimiterValueChanged((String)RecTypeDialog.this._delimiterCombo.getSelectedItem());
            }
        };
        this._delimiterCombo.addActionListener(delimiterTextListener);
        this._delimiterCombo.setEditable(true);
        this._delimiterLabel.setLabelFor(this._delimiterCombo);
        CommonUtils.setMnemonicAndAccelerator(this._delimiterLabel, NLSUtils.getNLSString("DA_delimitedColDelimiterHeading_FlatFile"));
        this._dataGizmo = new FlatFileDisplayGizmoForDialog(2, this);
        this._dataGizmo.getRuler().addRulerListener(new FlatFileRulerListener(){

            @Override
            public void rulerSet(FlatFileRulerEvent e) {
                RecTypeDialog.this.handleCreateFieldsButton();
            }

            @Override
            public void rulerDeleted(FlatFileRulerEvent e) {
                RecTypeDialog.this.handleCreateFieldsButton();
            }

            @Override
            public void rulerDragged(FlatFileRulerEvent e) {
            }
        });
        this._valueGridDs = new SortableTwoDModel(4, 0);
        this._fieldPropertiesPanel = new FlatFileComplexFieldProperties(this._translatable);
        this._fieldPropertiesPanel.buildFieldProperties();
        this._fieldPropertiesPanel.getFieldGrid().getGrid().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                int row;
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    row = ((Grid)e.getSource()).getFocusCell().row;
                    RecTypeDialog.this.handleFieldGridCellEdit(row + 1);
                }
                if (e.getKeyCode() == 38) {
                    row = ((Grid)e.getSource()).getFocusCell().row;
                    RecTypeDialog.this.handleFieldGridCellEdit(row - 1);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this._fieldPropertiesPanel.getFieldGrid().getGrid().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                int row = ((Grid)e.getSource()).getFocusCell().row;
                RecTypeDialog.this.handleFieldGridCellEdit(row);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this._fieldPropertiesPanel.getFieldGrid().getGrid().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ((Grid)e.getSource()).getFocusCell().row;
                int col = ((Grid)e.getSource()).getFocusCell().column;
                RecTypeDialog.this.handleFieldGridCellEdit(row);
                FlatFileInfo cfr_ignored_0 = RecTypeDialog.this._ffInfo;
                if (col == 14) {
                    RecTypeDialog.this.launchFieldPropertiesDialog(row);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this._recAttributePanel.getFieldPropBtn().addActionListener(this);
        this._cardPanel = new CardPanel();
    }

    protected void layoutControls() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.setContent(this.mainPanel);
        JPanel delimiterPnl = new JPanel(new FlowLayout());
        delimiterPnl.add(this._delimiterLabel);
        delimiterPnl.add(this._delimiterCombo);
        JPanel recTypePanel = new JPanel(new GridBagLayout());
        this._cardPanel.add(ACTUAL_PANEL, (Component)recTypePanel);
        UIHelper.addComponent((Container)this.mainPanel, (Component)this._cardPanel, (int)0, (int)0, (int)1, (int)1, (int)18, (int)1, (Insets)new Insets(3, 3, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this._nameFileNameIntro, (int)0, (int)0, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(3, 3, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this._recAttributePanel, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(5, 3, 5, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this._identifyFieldsLabel, (int)0, (int)2, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 5, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this._identifyFieldsIntro, (int)0, (int)3, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(0, 5, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)delimiterPnl, (int)0, (int)4, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 3, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this._dataGizmo, (int)0, (int)5, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(3, 3, 3, 3), (int)0, (int)60, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this.m_CreateFieldsBtn, (int)0, (int)6, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(3, 5, 3, 5), (int)0, (int)0, (double)1.0, (double)0.0);
        UIHelper.addComponent((Container)recTypePanel, (Component)this._fieldPropertiesPanel, (int)0, (int)7, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(3, 3, 3, 3), (int)0, (int)5, (double)0.0, (double)0.0);
        this.setSize(610, 520);
        UIHelper.centerInScreen((Component)((Object)this));
    }

    private void customizeControlsForComplexType() {
        this._nameFileNameIntro.setText(this._translatable.translate("CX_RecDialogIntroCT"));
        this.setTitle(this._translatable.translate("CX_RecDialogTitleCT"));
        this._recAttributePanel.hideControlsForComplexType();
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.pack();
    }

    public void handleOK() throws FlatFileValidationException {
        try {
            if (!this._recordName.equals(this._recAttributePanel.getRecordName())) {
                this.isDuplicateRecord(this._recAttributePanel.getRecordName());
                if (this._dialogType == 9 && this._ffInfo.isRecordUsedAsField(this._recordName)) {
                    int ret = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)this._translatable.translate("CX_RecDialogCTMessage"), (String)this._translatable.translate("CX_AlertMessageTitle"), (int)3, (int)2, (Icon)UIHelper.loadIcon((String)"images/help2.png", UIHelper.class));
                    if (ret == 2) {
                        throw new FlatFileValidationException(this._translatable.translate("CX_RecDialogCTValidation"));
                    }
                    this.propagateComplexTypeNameChange(this._recAttributePanel.getRecordName(), this._recordName);
                }
            }
            this.m_retVal = 0;
            if (this._fieldPropertiesPanel.isVisible() && this._ffInfo.getFieldPropertiesDs(this._recordName).getRowCount() == 0) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogNumFieldsValidation"));
                return;
            }
            if (this._ffInfo.existsDupFields(this._recordName)) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogFldValidation"));
                return;
            }
            if (!this.validateAttributes()) {
                return;
            }
            if (!this._recAttributePanel.getRecType().equals("") && !this.m_editMode) {
                this._recordName = this._recAttributePanel.getRecordName();
                Vector<String> unique_values = new Vector<String>();
                unique_values.add(this._selectedRecord);
                Object[] value_list = new String[1];
                unique_values.copyInto(value_list);
                this.setClassifierValues((String[])value_list);
            } else {
                this.updateInfoRecordAttributes(this._recordName);
                if (this._recAttributePanel.getRecordAttributes().getType().equals("") && this._ffInfo.getFieldPropertiesDs(this._recordName).getRowCount() == 0) {
                    CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogNumFieldsValidation"));
                    return;
                }
            }
            if (this.m_editMode) {
                this.updateInfoRecordAttributes(this._recordName);
                this.m_editMode = false;
            }
            this.dispose();
        }
        catch (FlatFileValidationException ex) {
            this._recAttributePanel.getRecNameField().requestFocus();
        }
    }

    public void handleCancel() {
        this.m_retVal = 2;
        if (!this.m_editMode) {
            this._ffInfo.removeFromRecordClassifierDs(this._recAttributePanel.getRecordName());
            this._ffInfo.removeFieldPropertiesDs(this._recAttributePanel.getRecordName());
            this.m_editMode = false;
        }
        this.dispose();
    }

    public void handleCreateFields() {
        int ret;
        try {
            if (!this._recordName.equals(this._recAttributePanel.getRecordName())) {
                this.isDuplicateRecord(this._recordName);
                this._recAttributePanel.getRecNameField().requestFocus();
            }
        }
        catch (FlatFileValidationException ex) {
            CommonUtils.error((Object)this, ex.getMessage());
            return;
        }
        this._recordName = this._recAttributePanel.getRecordName();
        if (this._dataGizmo.getType() == 2) {
            int[] markedcolumns;
            int[] prevColMarkers = this._ffInfo.getColumnMarkers(this._recordName);
            if (this._ffInfo.hasColumnMarkersChanged(prevColMarkers, markedcolumns = this._dataGizmo.getMarkedColumns())) {
                try {
                    int ret2;
                    if (!this._ffInfo.getFieldPropertiesDs(this._recordName).getData(1, 0).equals("C1") && (ret2 = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)this._translatable.translate("CX_RecDialogCTMessage2"), (String)this._translatable.translate("CX_AlertMessageTitle"), (int)3, (int)2, (Icon)UIHelper.loadIcon((String)"images/help2.png", UIHelper.class))) == 2) {
                        return;
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                this._ffInfo.setRecordSize(this._selectedRecord.length());
                this._classifierStart = 0;
                this._classifierEnd = this._selectedRecord.length();
                Vector<String> unique_values = new Vector<String>();
                unique_values.add(this._selectedRecord);
                Object[] value_list = new String[1];
                unique_values.copyInto(value_list);
                this.setClassifierValues((String[])value_list);
                this._ffInfo.setColumnStartPositions(this._recordName, markedcolumns);
            }
        } else {
            Vector<String> unique_values = new Vector<String>();
            unique_values.add(this._selectedRecord);
            Object[] value_list = new String[1];
            unique_values.copyInto(value_list);
            this.setClassifierValues((String[])value_list);
        }
        this._fieldPropertiesPanel.initializeFrom(this._ffInfo);
        this._fieldPropertiesPanel.resetLastRecord();
        this._fieldPropertiesPanel.processRecordSelection(this._recordName);
        if (this._ffInfo.getFieldPropertiesDs(this._recordName).getRowCount() == 1 && this._ffInfo.getFieldPropertiesDs(this._recordName).getData(1, 0).equals("C1") && this._dialogType != 9 && (ret = MultiLineOptionPane.showMessageDialog((Component)((Object)this), (Object)this._translatable.translate("CX_RecDialogCTMessage3"), (String)this._translatable.translate("CX_AlertMessageTitle"), (int)1, (int)-1, (Icon)UIHelper.loadIcon((String)"images/information.png", UIHelper.class))) == 0) {
            this._recAttributePanel.getTypeCombo().setSelectedItem(this._fieldPropertiesPanel.getFieldGrid().getGrid().getModel().getData(2, 0));
            this.copyTwoDModelToOneDModel(this._ffInfo.getFieldPropertiesDs(this._recordName), this._ffInfo.getRecordAttributes(this._recordName).getFieldProps());
            return;
        }
        if (this._recAttributePanel.isChoice()) {
            this._fieldPropertiesPanel.getFieldGrid().setColumnVisible(0, true);
        } else {
            this._fieldPropertiesPanel.getFieldGrid().setColumnVisible(0, false);
        }
        int width = Double.valueOf(this.getSize().getWidth()).intValue();
        int height = Double.valueOf(this.getSize().getHeight()).intValue();
        if (!this._fieldPropertiesPanel.isVisible()) {
            this.setSize(width, height + 150);
        }
        this._fieldPropertiesPanel.setVisible(true);
        UIHelper.centerInScreen((Component)((Object)this));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_CreateFieldsBtn) {
            this.handleCreateFields();
        } else if (src == this._recAttributePanel.getFieldPropBtn()) {
            this.launchFieldPropertiesDialog();
        }
    }

    protected void dismissDialog(boolean cancelled) {
        try {
            if (!cancelled) {
                this.handleOK();
            } else {
                this.handleCancel();
            }
        }
        catch (FlatFileValidationException ex) {
            CommonUtils.error((Object)this, ex.getMessage());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.m_listener != null) {
            this.m_listener.typeSelectionOccurred();
        }
    }

    public TypeChooserListener getTypeChooserListener() {
        return this.m_listener;
    }

    public void setTypeChooserListener(TypeChooserListener listener) {
        this.m_listener = listener;
    }

    public void cancelOccurred(JDialog dlg) {
        this.handleCancel();
    }

    public int display(FlatFileInfo info, String samplerecord, String record) {
        this._ffInfo = info;
        this._recordName = record;
        this._recType = "";
        if (this._dialogType == 9) {
            this.customizeControlsForComplexType();
            this.setSize(640, 440);
            if (!this._ffInfo.isStandaloneTesting()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_complextype_dtls");
            }
        } else {
            RecTypeAttributes choiceAttr;
            if (!this._ffInfo.isStandaloneTesting()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_element_dtls");
            }
            this._nameFileNameIntro.setText(this._translatable.translate("CX_RecDialogIntroElement"));
            this.setTitle(this._translatable.translate("CX_RecDialogTitleElement"));
            Vector recTypeList = this._ffInfo.getValidRecordTypeList(record);
            Enumeration e = recTypeList.elements();
            while (e.hasMoreElements()) {
                this._recAttributePanel.getTypeCombo().addItem(e.nextElement());
            }
            if (this.isChoiceElement() && (choiceAttr = this._ffInfo.getRecordAttributes("choice")) != null) {
                this._recAttributePanel.createChoiceTypeFields(choiceAttr);
                this._recAttributePanel.getChoiceCB().setSelected(true);
                this._recAttributePanel.getChoiceText().setEnabled(true);
            }
            this.displayRecordAttributes(this._recordName);
            if (this._recAttributePanel.getRecordName().trim().equals("") || this._recAttributePanel.getRecordName().trim().equals("<new_element>") || this._recAttributePanel.getRecType().equals("")) {
                this._recAttributePanel.getFieldPropBtn().setEnabled(false);
            }
            this.setSize(600, 540);
        }
        this._recAttributePanel.setRecordName(this._recordName);
        this._selectedRecord = samplerecord;
        if (samplerecord.equals("")) {
            this._dataGizmo.setEditGizmoText(this._ffInfo, "", this._recordName);
            this.showUIComponentsForSampleText(false);
            if (!this.m_editMode) {
                this.displayFieldAttributes();
            }
            this.pack();
        } else {
            this._dataGizmo.setGizmoText(info, samplerecord);
        }
        this.setVisible(true);
        return this.m_retVal;
    }

    public int displayRecordDetails(FlatFileInfo info, String record) {
        Vector recClassifierValues;
        RecTypeAttributes choiceAttr;
        this._ffInfo = info;
        this._recordName = record;
        if (!this._ffInfo.isStandaloneTesting()) {
            if (this._dialogType == 9) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_complextype_dtls");
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)this.mainPanel, "bpmjdev_adp_wiz_nfb_file_element_dtls");
            }
        }
        this.displayRecordAttributes(this._recordName);
        this.displayFieldAttributes();
        if (this.isChoiceElement() && (choiceAttr = this._ffInfo.getRecordAttributes("choice")) != null) {
            this._recAttributePanel.createChoiceTypeFields(choiceAttr);
            this._recAttributePanel.setChoice(true);
        }
        if (!(recClassifierValues = this._ffInfo.getClassifierValues(this._recordName)).isEmpty()) {
            if (((String)recClassifierValues.get(0)).equals("")) {
                this.showUIComponentsForSampleText(false);
            }
            if (this._dataGizmo.isVisible()) {
                this._dataGizmo.setEditGizmoText(this._ffInfo, (String)recClassifierValues.get(0), this._recordName);
            }
        } else {
            this._dataGizmo.setEditGizmoText(this._ffInfo, "", this._recordName);
            this.showUIComponentsForSampleText(false);
        }
        if (this._dataGizmo.getType() == 3) {
            OneDModel display_headers = this._ffInfo.getColumnHeaderDataSource(this._recordName);
            this._dataGizmo.getColumnDisplay().getColumnHeader().setModel(display_headers);
        }
        this.pack();
        this.setVisible(true);
        return this.m_retVal;
    }

    private void displayRecordAttributes(String recname) {
        RecTypeAttributes attr = null;
        SortableTwoDModel recModel = this._ffInfo.getRecordClassifierDs();
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            if (!((String)recModel.getData(2, i)).equals(recname)) continue;
            attr = (RecTypeAttributes)recModel.getData(3, i);
            this._selectedRecord = (String)recModel.getData(1, i);
            break;
        }
        if (attr != null) {
            this._recType = attr.getType();
            if (this._recType == null) {
                this._recType = "";
            }
            if (this._dialogType != 9) {
                Vector recTypeList = this._ffInfo.getValidRecordTypeList(recname);
                Enumeration enum_rectype = recTypeList.elements();
                while (enum_rectype.hasMoreElements()) {
                    this._recAttributePanel.getTypeCombo().addItem(enum_rectype.nextElement());
                }
            }
            this._recAttributePanel.setRecordAttributes(attr);
            if (this._dialogType == 9) {
                this.customizeControlsForComplexType();
                this.setSize(650, 350);
            }
            if (attr.isDelimited()) {
                this._delimiterCombo.setSelectedItem(this.getDelimiterAsComboItem(attr.getDelimiter()));
            }
        } else {
            this._recAttributePanel.setRecordName(recname);
        }
    }

    private void displayFieldAttributes() {
        if (this._dialogType == 9 || this._dialogType == 0 && this._recType.equals("")) {
            this._fieldPropertiesPanel.initializeFrom(this._ffInfo);
            this._fieldPropertiesPanel.processRecordSelection(this._recordName);
            this._fieldPropertiesPanel.setVisible(true);
            if (this._recAttributePanel.isChoice()) {
                this._fieldPropertiesPanel.getFieldGrid().setColumnVisible(0, true);
            } else {
                this._fieldPropertiesPanel.getFieldGrid().setColumnVisible(0, false);
            }
        } else {
            this.handleTypeSelection(this._recType);
        }
    }

    private void setClassifierValues(String[] classifierValues) {
        int rowCount = this._valueGridDs.getRowCount();
        this._valueGridDs.removeRows(0, rowCount);
        this._valueGridDs.addRows(0, classifierValues.length);
        String[] record_names = new String[classifierValues.length];
        for (int i = 0; i < classifierValues.length; ++i) {
            this._valueGridDs.setData(1, i, (Object)classifierValues[i]);
            record_names[i] = this._recordName;
            this._valueGridDs.setData(2, i, (Object)record_names[i]);
            RecTypeAttributes recAttr = this._recAttributePanel.getRecordAttributes();
            recAttr = this.copyRecAttrPanelValuesToRecPropertiesModel(recAttr);
            recAttr.setRecType(this._dialogType);
            if (this._dataGizmo.getType() == 3) {
                recAttr.setDelimiter(this.getDelimiterAsString((String)this._delimiterCombo.getSelectedItem()));
            }
            this._valueGridDs.setData(3, i, (Object)recAttr);
        }
        this._ffInfo.removeFromRecordClassifierDs(this._recordName);
        this._ffInfo.removeFieldPropertiesDs(this._recordName);
        this._ffInfo.addIntoRecordClassifierDs(this._valueGridDs);
        this.addRecordToHash();
    }

    private void addRecordToHash() {
        SortableTwoDModel recClassifiers = this._ffInfo.getRecordClassifierDs();
        if (recClassifiers != null) {
            String aRecord = "";
            if (this._ffInfo.isDelimitedFile()) {
                this._ffInfo.setRecordClassifierStart(this._classifierStart);
            } else {
                this._ffInfo.setRecordClassifierStart(this._classifierStart + 1);
                if (this._classifierEnd == 0 || this._classifierEnd < this._classifierStart) {
                    this._classifierEnd = this._classifierStart;
                }
                this._ffInfo.setRecordClassifierEnd(this._classifierEnd);
            }
            for (int i = 0; i < recClassifiers.getRowCount(); ++i) {
                aRecord = (String)recClassifiers.getData(2, i);
                if (aRecord == null || aRecord.trim().equals("")) continue;
                this._ffInfo.getFieldPropertiesDs(aRecord);
            }
        }
    }

    public String getCurrentRecord() {
        return this._recordName;
    }

    private void handleCreateFieldsButton() {
        if (!(this._recAttributePanel.getRecordName().trim().equals("") || this._recAttributePanel.getRecordName().trim().equals("<new_element>") || this._recAttributePanel.getRecordName().trim().equals("<new_complex_type>") || this._dataGizmo.getMarkedColumns().length <= 0)) {
            this.m_CreateFieldsBtn.setEnabled(true);
        } else {
            this.m_CreateFieldsBtn.setEnabled(false);
        }
    }

    public void setEditMode(boolean bEditMode) {
        this.m_editMode = bEditMode;
    }

    private void updateInfoRecordAttributes(String recname) {
        SortableTwoDModel recModel = this._ffInfo.getRecordClassifierDs();
        RecTypeAttributes recAttr = this._ffInfo.getRecordAttributes(recname);
        if (recAttr == null) {
            this.setClassifierValues(new String[]{""});
            recModel = this._ffInfo.getRecordClassifierDs();
        }
        for (int i = 0; i < recModel.getRowCount(); ++i) {
            if (!((String)recModel.getData(2, i)).equals(recname)) continue;
            RecTypeAttributes attr = this._recAttributePanel.getRecordAttributes();
            recAttr = this.copyRecAttrPanelValuesToRecPropertiesModel(attr);
            recAttr.setRecType(this._dialogType);
            recModel.setData(3, i, (Object)recAttr);
            this._recordName = this._recAttributePanel.getRecordName();
            recModel.setData(2, i, (Object)this._recordName);
            this._ffInfo.updateFieldPropertiesDs(recname, this._recordName, (ArrayTwoDModel)this._fieldPropertiesPanel.getFieldGrid().getGrid().getModel());
            if (recAttr.getType() == null || !recAttr.getType().equals("")) break;
            this.checkLastFieldTermination(this._recordName);
            break;
        }
    }

    private void handleFieldGridCellEdit(int row) {
        int startCol = 0;
        int endCol = 0;
        Color hightlightColor = null;
        try {
            ArrayTwoDModel fieldProps = this._ffInfo.getFieldPropertiesDs(this._recordName);
            if (this._dataGizmo.getType() == 2) {
                startCol = (Integer)fieldProps.getData(4, row);
                endCol = (Integer)fieldProps.getData(5, row);
                this._dataGizmo.getTextArea().getHighlighter().removeAllHighlights();
                this._dataGizmo.getTextArea().select(startCol - 1, endCol);
                hightlightColor = new Color(-4665371);
                this._dataGizmo.getTextArea().getHighlighter().addHighlight(startCol - 1, endCol, new DefaultHighlighter.DefaultHighlightPainter(hightlightColor));
                this._dataGizmo.getTextArea().getHighlighter().addHighlight(startCol - 1, endCol, new DefaultHighlighter.DefaultHighlightPainter(hightlightColor));
            } else {
                ArrayOneDModel display_headers = (ArrayOneDModel)this._ffInfo.getColumnHeaderDataSource(this._recordName);
                display_headers.setData(row, (Object)((String)this._ffInfo.getFieldPropertiesDs(this._recordName).getData(1, row)));
                this._dataGizmo.getColumnDisplay().getColumnHeader().setModel((OneDModel)display_headers);
            }
        }
        catch (BadLocationException le) {
        }
        catch (Exception e1) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void launchFieldPropertiesDialog(int row) {
        try {
            String selectedText = this._ffInfo.getFieldSampleText(this._recordName, row);
            ComplexFieldPropertiesDialog fldPropDlg = new ComplexFieldPropertiesDialog(this._parentFrame, this._translatable);
            int ret = fldPropDlg.display(this._ffInfo, selectedText, this._recordName, row);
            if (ret != 0) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void launchFieldPropertiesDialog() {
        try {
            RecTypeAttributes recPanelAttr = this._recAttributePanel.getRecordAttributes();
            recPanelAttr = this.copyRecAttrPanelValuesToRecPropertiesModel(recPanelAttr);
            String selectedText = this._ffInfo.getRecordSampleText(this._recordName);
            ComplexFieldPropertiesDialog fldPropDlg = new ComplexFieldPropertiesDialog(this._parentFrame, this._translatable);
            int ret = fldPropDlg.display(this._ffInfo, selectedText, this._recordName, recPanelAttr);
            if (ret == 0) {
                RecTypeAttributes recAttr = this._ffInfo.getRecordAttributes(this._recordName);
                this._recAttributePanel.setRecordAttributes(recAttr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleTypeSelection(String item) {
        if (!(this._dialogType != 0 && this._dialogType != 1 || item.equals(""))) {
            this._dataGizmo.setVisible(false);
            this._fieldPropertiesPanel.getFieldGrid().removeAll();
            this._fieldPropertiesPanel.setVisible(false);
            this._recAttributePanel.getFieldPropBtn().setEnabled(true);
            this.showUIComponentsForSampleText(false);
        } else {
            this._dataGizmo.setVisible(true);
            this._fieldPropertiesPanel.setVisible(true);
            this._recAttributePanel.getFieldPropBtn().setEnabled(false);
            this.showUIComponentsForSampleText(true);
        }
        this.pack();
    }

    private void delimiterValueChanged(String newTxt) {
        String newDelim = this.getDelimiterAsString(newTxt);
        if (newDelim.equals("")) {
            this._dataGizmo.setType(2);
            this._dataGizmo.getRuler().addRulerListener(new FlatFileRulerListener(){

                @Override
                public void rulerSet(FlatFileRulerEvent e) {
                    RecTypeDialog.this.handleCreateFieldsButton();
                }

                @Override
                public void rulerDeleted(FlatFileRulerEvent e) {
                    RecTypeDialog.this.handleCreateFieldsButton();
                }

                @Override
                public void rulerDragged(FlatFileRulerEvent e) {
                }
            });
            this._dataGizmo.getWidthsTextField().setVisible(true);
        } else {
            this._dataGizmo.setType(3);
            this._dataGizmo.getWidthsTextField().setVisible(false);
        }
        this._dataGizmo.setDelimiter(newDelim);
        this._dataGizmo.setGizmoText(this._ffInfo, this._selectedRecord);
    }

    public String getDelimiterAsString(String comboTxt) {
        String newDelim = comboTxt;
        if (newDelim.equals(this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile"))) {
            newDelim = "  ";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterComma_FlatFile"))) {
            newDelim = ",";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterSemicolon_FlatFile"))) {
            newDelim = ";";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterTab_FlatFile"))) {
            newDelim = "\\t";
        } else if (newDelim.equals(this.translate("DA_delimitedColDelimiterSpace_FlatFile"))) {
            newDelim = " ";
        } else if (newDelim.equals(this.translate("CX_Fixed_Length")) || newDelim.equals(this.translate("CX_Mixed"))) {
            newDelim = "";
        }
        return newDelim;
    }

    public String getDelimiterAsComboItem(String delimiter) {
        String newDelim = delimiter;
        if (newDelim.equals("  ")) {
            newDelim = this.translate("DA_delimitedColDelimiterWhiteSpace_FlatFile");
        } else if (newDelim.equals(",")) {
            newDelim = this.translate("DA_delimitedColDelimiterComma_FlatFile");
        } else if (newDelim.equals(";")) {
            newDelim = this.translate("DA_delimitedColDelimiterSemicolon_FlatFile");
        } else if (newDelim.equals("\\t")) {
            newDelim = this.translate("DA_delimitedColDelimiterTab_FlatFile");
        } else if (newDelim.equals(" ")) {
            newDelim = this.translate("DA_delimitedColDelimiterSpace_FlatFile");
        } else if (newDelim == "") {
            newDelim = this.translate("CX_Mixed");
        }
        return newDelim;
    }

    private void isDuplicateRecord(String newrecname) throws FlatFileValidationException {
        SortableTwoDModel recClassifierDs = this._ffInfo.getRecordClassifierDs();
        for (int i = 0; i < recClassifierDs.getRowCount(); ++i) {
            String recname = (String)recClassifierDs.getData(2, i);
            if (!recname.equals(newrecname)) continue;
            throw new FlatFileValidationException(this._translatable.translate("CX_RecDialogCTValidation2"));
        }
    }

    private void propagateComplexTypeNameChange(String currRecName, String prevRecName) {
        ArrayTwoDModel fieldProps = null;
        String fldType = "";
        Vector recList = this._ffInfo.getRecordTypeList();
        Enumeration e = recList.elements();
        while (e.hasMoreElements()) {
            String record = (String)e.nextElement();
            RecTypeAttributes recAttr = this._ffInfo.getRecordAttributes(record);
            if (record.equals(prevRecName)) continue;
            if (recAttr.getType().equals(prevRecName)) {
                recAttr.setType(currRecName);
                continue;
            }
            fieldProps = this._ffInfo.getFieldPropertiesDs(record);
            for (int i = 0; i < fieldProps.getRowCount(); ++i) {
                for (int j = 0; j < fieldProps.getColumnCount(); ++j) {
                    if (j != 2) continue;
                    fldType = (String)fieldProps.getData(j, i);
                }
                if (fldType == null || !fldType.equals(prevRecName)) continue;
                fieldProps.setData(2, i, (Object)currRecName);
            }
        }
    }

    private void showUIComponentsForSampleText(boolean bshow) {
        this.m_CreateFieldsBtn.setVisible(bshow);
        this._identifyFieldsLabel.setVisible(bshow);
        this._identifyFieldsIntro.setVisible(bshow);
        this._delimiterLabel.setVisible(bshow);
        this._delimiterCombo.setVisible(bshow);
    }

    private void copyTwoDModelToOneDModel(ArrayTwoDModel twoDModel, ArrayOneDModel oneDModel) {
        if (oneDModel != null && twoDModel != null) {
            for (int i = 0; i < twoDModel.getColumnCount(); ++i) {
                oneDModel.setData(i, twoDModel.getData(i, 0));
            }
        }
    }

    private RecTypeAttributes copyRecAttrPanelValuesToRecPropertiesModel(RecTypeAttributes recPanelAttr) {
        RecTypeAttributes recProps = this._ffInfo.getRecordAttributes(this._recordName);
        if (recProps != null) {
            recProps.setRecordName(recPanelAttr.getRecordName());
            recProps.setType(recPanelAttr.getType());
            recProps.setMinOccurs(recPanelAttr.getMinOccurs());
            recProps.setOccurs(recPanelAttr.getOccurs());
            recProps.setArray(recPanelAttr.isArray());
            if (recProps.isArray()) {
                recProps.setArrayLength(recPanelAttr.getArrayLength());
                recProps.setArraySeparator(recPanelAttr.getArraySeparator());
                recProps.setCellSeparator(recPanelAttr.getCellSeparator());
            } else {
                recProps.setArrayLength("0");
                recProps.setArraySeparator("");
                recProps.setCellSeparator("");
            }
            recProps.setList(recPanelAttr.isList());
            if (recProps.isList()) {
                recProps.setListSeparator(recPanelAttr.getListSeparator());
                recProps.setItemSeparator(recPanelAttr.getItemSeparator());
            } else {
                recProps.setListSeparator("");
                recProps.setItemSeparator("");
            }
            recProps.setStartsWith(recPanelAttr.getStartsWith());
            recProps.setChoice(recPanelAttr.isChoice());
            if (recProps.isChoice()) {
                recProps.setChoiceValue(recPanelAttr.getChoiceValue());
                recProps.setChoiceType(recPanelAttr.getChoiceType());
            }
            return recProps;
        }
        return recPanelAttr;
    }

    private void checkLastFieldTermination(String recname) {
        ArrayTwoDModel fieldProps = this._ffInfo.getFieldPropertiesDs(recname);
        if (fieldProps.getRowCount() > 0) {
            String lastfldType = (String)fieldProps.getData(2, fieldProps.getRowCount() - 1);
            String lastfldStyle = (String)fieldProps.getData(7, fieldProps.getRowCount() - 1);
            RecTypeDialog recTypeDialog = this;
            if (Arrays.asList(recTypeDialog._ffInfo.getXmlDataTypes()).contains(lastfldType) && lastfldStyle.equals("")) {
                fieldProps.setData(7, fieldProps.getRowCount() - 1, (Object)"terminated");
                fieldProps.setData(8, fieldProps.getRowCount() - 1, (Object)"${eol}");
                fieldProps.setData(10, fieldProps.getRowCount() - 1, (Object)"");
                fieldProps.setData(11, fieldProps.getRowCount() - 1, (Object)"");
            }
        }
    }

    public void showWaitPanel() {
        this._cardPanel.show(WAIT_PANEL);
    }

    public void showActualPanel() {
        this._cardPanel.show(ACTUAL_PANEL);
    }

    private boolean validateAttributes() {
        if (this._recAttributePanel.isArray()) {
            if (this._recAttributePanel.getArrayLength().equals("0") & this._recAttributePanel.getArraySeparator().equals("") & this._recAttributePanel.getCellSeparator().equals("")) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogFldValidation1"));
                return false;
            }
            if (!this._recAttributePanel.getArraySeparator().equals("") & !this._recAttributePanel.getCellSeparator().equals("") && this._recAttributePanel.getArraySeparator().equals(this._recAttributePanel.getCellSeparator())) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogFldValidation3"));
                return false;
            }
        }
        if (this._recAttributePanel.isList()) {
            if (this._recAttributePanel.getItemSeparator().equals("")) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogFldValidation4"));
                return false;
            }
            if (!this._recAttributePanel.getListSeparator().equals("") & !this._recAttributePanel.getItemSeparator().equals("") && this._recAttributePanel.getListSeparator().equals(this._recAttributePanel.getItemSeparator())) {
                CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogFldValidation5"));
                return false;
            }
        }
        if (this._recAttributePanel.isChoice() && this._recAttributePanel.getChoiceValue().equals("")) {
            CommonUtils.error((Object)this, this._translatable.translate("CX_RecDialogFldValidation2"));
            return false;
        }
        return true;
    }

    public void setChoiceElement(boolean bChoice) {
        this._bChoice = bChoice;
    }

    public boolean isChoiceElement() {
        return this._bChoice;
    }
}

