/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.ide.help.HelpSystem;
import oracle.javatools.editor.BasicEditorPane;
import oracle.tip.pc.services.translation.framework.TranslationContext;
import oracle.tip.pc.services.translation.framework.TranslationException;
import oracle.tip.pc.services.translation.framework.Translator;
import oracle.tip.pc.services.translation.framework.TranslatorFactory;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmoForDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileTranslationHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatableDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Document;

public class NXSDTestDialog
extends JEWTDialog
implements ActionListener {
    private static final String RUN_BUTTON_ICON = "images/run.png";
    private JButton m_testBtn;
    private MultiLineLabel _testPanelIntro;
    private JLabel _nameFileStructureNameLbl;
    private JTextField _nameFileStructureName;
    private FlatFileDisplayGizmoForDialog _dataGizmo;
    private JPanel _gizmoPanel;
    private BasicEditorPane _textArea;
    private JScrollPane _nxsdTextPane;
    private BasicEditorPane _resultTextArea;
    private JScrollPane _resultTextPane;
    private FlatFileTranslationHelper _translatable = new FlatFileTranslationHelper();
    private FlatFileInfo ff_info;
    private String _testFileName;
    private String _nxsdString;

    public NXSDTestDialog(JFrame f) {
        super((Frame)f, "");
        this.setTitle(this._translatable.translate("CX_NXSDTestDialogTitle"));
        this.setModal(true);
        this.buildControls();
    }

    public void dispose() {
        super.dispose();
    }

    public void enableUserInput(final boolean bEnable) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Component glass = NXSDTestDialog.this.getGlassPane();
                glass.setVisible(!bEnable);
                if (bEnable) {
                    glass.setCursor(Cursor.getDefaultCursor());
                } else {
                    glass.setCursor(Cursor.getPredefinedCursor(3));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    protected void buildControls() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        this.setButtonMask(7);
        this.setContent(mainPanel);
        HelpSystem.getHelpSystem().registerTopic((JComponent)mainPanel, "bpmjdev_adp_wiz_nfb_test_nxsd");
        this.m_testBtn = UIHelper.createModelerButton((Icon)new ImageIcon(UIHelper.loadImage((String)RUN_BUTTON_ICON, UIHelper.class)));
        this.m_testBtn.setToolTipText(this._translatable.translate("CX_NXSDTestDialogFieldLabel_Generate"));
        this.m_testBtn.addActionListener(this);
        this.addCustomButton(this.m_testBtn);
        Insets pnlInsets = new Insets(3, 3, 0, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 2);
        this._testPanelIntro = new MultiLineLabel(WordWrapper.getTextWrapper(), this._translatable.translate("CX_NXSDTestDialogIntro"));
        UIHelper.addComponent((Container)mainPanel, (Component)this._testPanelIntro, (int)0, (int)0, (int)1, (int)1, (int)18, (int)2, (Insets)new Insets(3, 5, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel nameFileNamePanel = new JPanel();
        nameFileNamePanel.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)mainPanel, (Component)nameFileNamePanel, (int)0, (int)1, (int)1, (int)1, (int)17, (int)2, (Insets)new Insets(1, 3, 3, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        this._gizmoPanel = new JPanel();
        this._gizmoPanel.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)mainPanel, (Component)this._gizmoPanel, (int)0, (int)2, (int)1, (int)1, (int)18, (int)0, (Insets)pnlInsets, (int)0, (int)0, (double)0.0, (double)0.0);
        JPanel nxsdPanel = new JPanel();
        nxsdPanel.setLayout(new GridBagLayout());
        UIHelper.addComponent((Container)mainPanel, (Component)nxsdPanel, (int)0, (int)3, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(1, 3, 3, 5), (int)0, (int)0, (double)0.0, (double)0.0);
        this._nameFileStructureNameLbl = new JLabel(this._translatable.translate("GN_nameFileStructureName_FlatFile"));
        UIHelper.addComponent((Container)nameFileNamePanel, (Component)this._nameFileStructureNameLbl, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)cmpInsets, (int)0, (int)0, (double)0.0, (double)0.0);
        this._nameFileStructureName = new JTextField();
        KeyAdapter fileNameListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 10 || code == 9) && code == 10) {
                    e.consume();
                }
            }
        };
        this._nameFileStructureName.addKeyListener(fileNameListener);
        this._nameFileStructureName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField field = (JTextField)e.getSource();
                String fileName = field.getText();
                if (fileName == null || fileName.equals("") || NXSDTestDialog.this.ff_info.getFileStructureName().equals(fileName)) {
                    return;
                }
                NXSDTestDialog.this._nameFileStructureName.setText(fileName);
                String rootName = NXSDTestDialog.this.ff_info.getRootElement();
                String namespace = NXSDTestDialog.this.ff_info.getNamespace();
                try {
                    NXSDTestDialog.this.ff_info.setFileStructureName(fileName);
                    NXSDTestDialog.this.ff_info.setNamespace(namespace);
                    NXSDTestDialog.this.ff_info.setRootElement(rootName);
                    NXSDTestDialog.this.setDataGizmoAttributes();
                }
                catch (FlatFileValidationException ex) {
                    // empty catch block
                }
            }
        });
        this._nameFileStructureNameLbl.setLabelFor(this._nameFileStructureName);
        CommonUtils.setMnemonicAndAccelerator(this._nameFileStructureNameLbl, NLSUtils.getNLSString("GN_nameFileStructureName_FlatFile"));
        int fieldWidth = new Float(240.0).intValue();
        this._nameFileStructureName.setPreferredSize(new Dimension(fieldWidth, 20));
        UIHelper.addComponent((Container)nameFileNamePanel, (Component)this._nameFileStructureName, (int)1, (int)0, (int)1, (int)1, (int)17, (int)2, (Insets)cmpInsets, (int)100, (int)0, (double)0.0, (double)0.0);
        JButton fileBrowseButton = new JButton(this._translatable.translate("GN_browseButton"));
        fileBrowseButton.setToolTipText(this._translatable.translate("NM_FileBrowse_toolTip"));
        fileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                String prjDir = ((NXSDTestDialog)NXSDTestDialog.this).ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                if (prjDir == null) {
                    prjDir = "";
                }
                if ((chooser = NXSDTestDialog.this.ff_info.getFileChooser()) == null) {
                    chooser = new JFileChooser(prjDir);
                    chooser.setDialogTitle(NXSDTestDialog.this._translatable.translate("NM_flatFileDialog_title"));
                }
                int returnVal = chooser.showOpenDialog(NXSDTestDialog.this.getParentFrame());
                NXSDTestDialog.this.ff_info.setFileChooser(chooser);
                String fileName = "";
                String directory = "";
                if (returnVal != 0) {
                    return;
                }
                fileName = chooser.getSelectedFile().getName();
                directory = chooser.getSelectedFile().getParent() + File.separator;
                if (directory != null && fileName != null) {
                    NXSDTestDialog.this._nameFileStructureName.setText(directory + fileName);
                    String rootName = NXSDTestDialog.this.ff_info.getRootElement();
                    String namespace = NXSDTestDialog.this.ff_info.getNamespace();
                    try {
                        NXSDTestDialog.this.ff_info.setFileStructureName(directory + fileName);
                        NXSDTestDialog.this.ff_info.setNamespace(namespace);
                        NXSDTestDialog.this.ff_info.setRootElement(rootName);
                        NXSDTestDialog.this.setDataGizmoAttributes();
                    }
                    catch (FlatFileValidationException ex) {
                        // empty catch block
                    }
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(fileBrowseButton, NLSUtils.getNLSString("GN_browseButton"));
        UIHelper.addComponent((Container)nameFileNamePanel, (Component)fileBrowseButton, (int)2, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)cmpInsets, (int)1, (int)0, (double)0.0, (double)0.0);
        this._dataGizmo = new FlatFileDisplayGizmoForDialog(3, new WBTranslatableDialog(this.getParentFrame(), this._translatable, "", false));
        UIHelper.addComponent((Container)this._gizmoPanel, (Component)this._dataGizmo, (int)0, (int)0, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(1, 1, 1, 1), (int)480, (int)60, (double)0.0, (double)0.0);
        this._textArea = new BasicEditorPane();
        this._textArea.setLanguageSupport("dummy.xml");
        this._textArea.setBaseFont("Dialog", 11);
        this._nxsdTextPane = new JScrollPane((Component)this._textArea, 20, 30);
        JLabel textAreaLabel = new JLabel(this._translatable.translate("CX_NXSDTestDialogFieldLabel_Schema"));
        UIHelper.addComponent((Container)nxsdPanel, (Component)textAreaLabel, (int)0, (int)0, (int)1, (int)1, (int)17, (int)0, (Insets)new Insets(1, 3, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)nxsdPanel, (Component)this._nxsdTextPane, (int)0, (int)1, (int)1, (int)1, (int)17, (int)1, (Insets)new Insets(1, 3, 3, 3), (int)240, (int)265, (double)0.0, (double)0.0);
        this._resultTextArea = new BasicEditorPane();
        this._resultTextArea.setLanguageSupport("dummy.xml");
        this._resultTextArea.setBaseFont("Dialog", 11);
        this._resultTextPane = new JScrollPane((Component)this._resultTextArea, 20, 30);
        JLabel resultAreaLabel = new JLabel(this._translatable.translate("CX_NXSDTestDialogFieldLabel_Result"));
        JPanel labelPanel = new JPanel(new GridLayout(1, 1, 140, 0));
        labelPanel.add(resultAreaLabel);
        labelPanel.add(this.m_testBtn);
        UIHelper.addComponent((Container)nxsdPanel, (Component)labelPanel, (int)1, (int)0, (int)1, (int)1, (int)13, (int)1, (Insets)new Insets(1, 3, 3, 3), (int)0, (int)0, (double)0.0, (double)0.0);
        UIHelper.addComponent((Container)nxsdPanel, (Component)this._resultTextPane, (int)1, (int)1, (int)1, (int)1, (int)13, (int)1, (Insets)new Insets(1, 3, 3, 3), (int)222, (int)200, (double)0.0, (double)0.0);
        this.setSize(540, 550);
        UIHelper.centerInScreen((Component)((Object)this));
    }

    protected void updateButtons() {
    }

    public void handleTest() {
        this.enableUserInput(false);
        this._resultTextArea.setText(this._translatable.translate("CX_NXSDTestDialogFieldLabel_ResultText"));
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!NXSDTestDialog.this._textArea.getText().equals("")) {
                        NXSDTestDialog.this._nxsdString = NXSDTestDialog.this._textArea.getText();
                    }
                    ByteArrayInputStream in = null;
                    String nxsdEncoding = CommonUtils.getNewEncoding(NXSDTestDialog.this._nxsdString);
                    in = nxsdEncoding != "" && nxsdEncoding != null ? new ByteArrayInputStream(NXSDTestDialog.this._nxsdString.getBytes(nxsdEncoding)) : new ByteArrayInputStream(NXSDTestDialog.this._nxsdString.getBytes());
                    XSDBuilder xsdBuilder = new XSDBuilder();
                    XMLSchema schema = xsdBuilder.build((InputStream)in, null);
                    String rootName = "";
                    rootName = NXSDTestDialog.this.ff_info.isSingleInstance() && !NXSDTestDialog.this.ff_info.isMultiRecord() ? NXSDTestDialog.this.ff_info.getSingleRecordName() : NXSDTestDialog.this.ff_info.getRootElement();
                    XSDElement rootElement = schema.getElement(schema.getSchemaTargetNS(), rootName);
                    if (schema != null && rootElement != null) {
                        TranslatorFactory tf = TranslatorFactory.getInstance();
                        Translator t = tf.createTranslator(schema, rootElement);
                        FileInputStream in_stream = new FileInputStream(NXSDTestDialog.this.ff_info.getFileName());
                        DOMResult xmlResult = new DOMResult();
                        t.translateFromNative((InputStream)in_stream, (Result)xmlResult, new TranslationContext());
                        XMLElement resultNode = (XMLElement)xmlResult.getNode();
                        XMLDocument resultDoc = resultNode.getDocument();
                        NXSDTestDialog.this._resultTextArea.setText(NXSDTestDialog.this.xmldocToStr((Document)resultDoc));
                    }
                }
                catch (XSDException xsde) {
                    UIHelper.displayErrorMessage((Component)NXSDTestDialog.this.getParentFrame(), (String)xsde.getMessage());
                }
                catch (TranslationException nxsde) {
                    UIHelper.displayErrorMessage((Component)NXSDTestDialog.this.getParentFrame(), (String)nxsde.getMessage());
                }
                catch (FileNotFoundException fe) {
                    UIHelper.displayErrorMessage((Component)NXSDTestDialog.this.getParentFrame(), (String)fe.getMessage());
                }
                catch (Exception e) {
                    UIHelper.displayErrorMessage((Component)NXSDTestDialog.this.getParentFrame(), (String)e.getMessage());
                }
                finally {
                    NXSDTestDialog.this.enableUserInput(true);
                }
            }
        };
        SwingUtilities.invokeLater(r);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.m_testBtn) {
            this.handleTest();
        }
    }

    public void display(FlatFileInfo info, String nxsdStr) {
        this.ff_info = new FlatFileInfo(info.getFileName(), this._translatable);
        this.ff_info.isEditingNXSD(true);
        if (info.isDelimitedFile()) {
            this.ff_info.isDelimitedFile(true);
            this.ff_info.setDelimiter(info.getDelimiter());
            this.ff_info.setRecordTerminator(info.getRecordTerminator());
        } else if (info.isFixedLength()) {
            this.ff_info.isFixedLengthFile(true);
        } else if (info.isComplexFile()) {
            this.ff_info.isComplexFile(true);
        } else if (info.isDTD()) {
            this.ff_info.isDTDFile(true);
        } else {
            this.ff_info.isCCBFile(true);
        }
        this.ff_info.setFlatFileWizard(info.getFlatFileWizard());
        try {
            this.ff_info.setFileStructureName(info.getFileStructureName());
            this.ff_info.setFileChooser(info.getFileChooser());
            if (info.getRootElement() != null && !info.getRootElement().equals("")) {
                this.ff_info.setRootElement(info.getRootElement());
            }
            this.ff_info.setDefaultCoding(info.getDefaultCoding());
        }
        catch (FlatFileValidationException ff_e1) {
            // empty catch block
        }
        if (!nxsdStr.equals("")) {
            this.ff_info.setModifiedNXSD(nxsdStr);
        } else {
            this.ff_info.setModifiedNXSD(info.getModifiedNXSD());
        }
        this.ff_info.setNamespace(info.getNamespace());
        if (info.isSingleInstance()) {
            this.ff_info.isSingleInstance(info.isSingleInstance());
            try {
                this.ff_info.setSingleRecordName(info.getSingleRecordName());
            }
            catch (FlatFileValidationException ff_e2) {
                // empty catch block
            }
        }
        if (info.isComplexFile()) {
            this._dataGizmo.setType(1);
        }
        if (!this.ff_info.getFileStructureName().equals("")) {
            if (!info.isCCB()) {
                this._testFileName = this.ff_info.getFileStructureName();
                this._nameFileStructureName.setText(this._testFileName);
                this._dataGizmo.refreshContents(this.ff_info);
            } else {
                this._dataGizmo.setVisible(false);
                this.setSize(540, 460);
            }
            String schemaString = this.ff_info.getModifiedNXSD();
            if (!schemaString.equals("")) {
                this._nxsdString = schemaString;
                this._textArea.setText(this._nxsdString);
            }
        }
        if (info.isCCB()) {
            this._testPanelIntro.setText(this._translatable.translate("CX_NXSDTestDialogIntroCobol"));
        }
        this.setVisible(true);
    }

    private JFrame getParentFrame() {
        return UIHelper.getFrame((Component)((Object)this));
    }

    private String xmldocToStr(Document document) throws Exception {
        StringWriter sw = new StringWriter();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        if (document.getXmlEncoding() != null) {
            transformer.setOutputProperty("encoding", document.getXmlEncoding());
        }
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }

    private void setDataGizmoAttributes() {
        this._dataGizmo.getColumnDisplay().getGrid().getModel().setData(0, 0, null);
        this._dataGizmo.refreshContents(this.ff_info);
        this._dataGizmo.setVisible(true);
        this.setSize(new Dimension(540, 550));
        this.validate();
    }
}

