/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.util.Vector;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class NXSDGenerator {
    public static final short SINGLE_RECORD = 0;
    public static final short SINGLE_TYPE_RECORDS = 1;
    public static final short MULTIPLE_TYPE_RECORDS = 2;
    public static final short FIXED_LENGTH_TYPE = 3;
    public static final short DELIMITED_TYPE = 4;
    private static final String EOL = "${eol}";
    private static final String EOF = "${eof}";
    public static final int FIELD_PROPERTY_COUNT = 7;
    private FlatFileInfo fFlatFileInfo;
    private Vector _localRecordVector = new Vector();
    private String _fieldDelimiter = "";

    public NXSDGenerator(FlatFileInfo wizardInfo) {
        this.fFlatFileInfo = wizardInfo;
    }

    public String getNxsdEncoding() {
        return this.fFlatFileInfo.getNxsdEncoding();
    }

    public String getNamespace() {
        return this.fFlatFileInfo.getNamespace();
    }

    public String getEncoding() {
        return this.fFlatFileInfo.getDefaultCoding();
    }

    public String getByteOrder() {
        return null;
    }

    public int getHeaderLines() {
        return this.fFlatFileInfo.getSkipRecords();
    }

    public int getDataLines() {
        return this.fFlatFileInfo.getProcessRows();
    }

    public String getLinesTerminatedBy() {
        String realTerminator;
        String showTerminator = realTerminator = this.fFlatFileInfo.getRecordTerminator();
        if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
            showTerminator = this.fFlatFileInfo.isRecordTerminatorEOL() ? EOL : EOF;
        }
        return showTerminator;
    }

    public boolean isFixedLengthType() {
        return this.fFlatFileInfo.isFixedLength();
    }

    public boolean isDelimitedType() {
        return this.fFlatFileInfo.isDelimitedFile();
    }

    public boolean isSingleRecord() {
        return this.fFlatFileInfo.isSingleInstance();
    }

    public boolean isSingleTypeRecords() {
        return !this.fFlatFileInfo.isSingleInstance() && !this.fFlatFileInfo.isMultiRecord();
    }

    public boolean isMultipleTypeRecords() {
        return !this.fFlatFileInfo.isSingleInstance() && this.fFlatFileInfo.isMultiRecord();
    }

    public String getContainerName() {
        return this.fFlatFileInfo.getRootElement();
    }

    public String getRecordName(int record) {
        if (!this.fFlatFileInfo.isMultiRecord()) {
            return this.fFlatFileInfo.getSingleRecordName();
        }
        return this.fFlatFileInfo.getRecordList()[record];
    }

    public boolean isChoiceConditionFixedLen() {
        return this.fFlatFileInfo.isFixedLength();
    }

    public String getChoiceConditionLen() {
        return "" + this.fFlatFileInfo.getRecordClassifierEnd();
    }

    public boolean isChoiceConditionDelimited() {
        return this.fFlatFileInfo.isDelimitedFile();
    }

    public String getChoiceConditionTerminatedBy() {
        return this.fFlatFileInfo.getDelimiter();
    }

    public String getConditionValue(int record) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFormattedColumnDataSource(this.fFlatFileInfo.getRecordList()[record]);
        return dataSource.getData(0, 0).toString();
    }

    public int getRecordTypeCount() {
        return this.fFlatFileInfo.getRecordList().length;
    }

    public String getRecordSeparator(int record) {
        String realTerminator;
        String showTerminator = realTerminator = this.fFlatFileInfo.getRecordTerminator();
        if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
            showTerminator = this.fFlatFileInfo.isRecordTerminatorEOL() ? EOL : EOF;
        }
        return showTerminator;
    }

    public int getFieldCount(int record) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFormattedColumnDataSource(this.fFlatFileInfo.getRecordList()[record]);
        int fieldCount = dataSource.getColumnCount();
        if (this.fFlatFileInfo.isMultiRecord()) {
            --fieldCount;
        }
        return fieldCount;
    }

    public String getFieldName(int record, int field) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs(this.fFlatFileInfo.getRecordList()[record]);
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++field;
        }
        return dataSource.getData(1, field).toString();
    }

    public String getFieldType(int record, int field) {
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs(this.fFlatFileInfo.getRecordList()[record]);
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++field;
        }
        return dataSource.getData(2, field).toString();
    }

    public String getFieldTerminator(int record, int field) {
        String delimiter;
        int fieldCount;
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs(this.fFlatFileInfo.getRecordList()[record]);
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++field;
        }
        if (!((fieldCount = dataSource.getRowCount()) != field + 1 || fieldCount == 1 && this.fFlatFileInfo.isSingleInstance())) {
            String realTerminator;
            String showTerminator = realTerminator = this.fFlatFileInfo.getRecordTerminator();
            if (realTerminator.equals("\\n") || realTerminator.equals("\\r\\n")) {
                showTerminator = this.fFlatFileInfo.isRecordTerminatorEOL() ? EOL : EOF;
            }
            return showTerminator;
        }
        String realDelim = delimiter = dataSource.getData(6, field).toString();
        if (delimiter != null && !delimiter.equals("")) {
            realDelim = delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterWhiteSpace_FlatFile")) ? "  " : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterComma_FlatFile")) ? "," : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterSemicolon_FlatFile")) ? ";" : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterTab_FlatFile")) ? "\\t" : (delimiter.equals(NLSUtils.getNLSString("DA_delimitedColDelimiterSpace_FlatFile")) ? " " : delimiter))));
        }
        return realDelim;
    }

    public int getFieldLength(int record, int field) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++field;
        }
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs(this.fFlatFileInfo.getRecordList()[record]);
        Integer intObj = new Integer(dataSource.getData(3, field).toString());
        return intObj;
    }

    public String getFieldQuotedBy(int record, int field) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++field;
        }
        if (this.fFlatFileInfo.getEnclosureLeft().equals("\"")) {
            return "&quot;";
        }
        if (this.fFlatFileInfo.getEnclosureLeft().equals("\u0000")) {
            return "";
        }
        return this.fFlatFileInfo.getEnclosureLeft();
    }

    public void setRecordType(short recordType) {
        if (recordType == 0) {
            this.fFlatFileInfo.isSingleInstance(true);
            this.fFlatFileInfo.isMultiRecord(false);
            this.fFlatFileInfo.setRecordClassifierStart(0);
        } else if (recordType == 1) {
            this.fFlatFileInfo.isSingleInstance(false);
            this.fFlatFileInfo.isMultiRecord(false);
            this.fFlatFileInfo.setRecordClassifierStart(0);
        } else {
            this.fFlatFileInfo.isSingleInstance(false);
            this.fFlatFileInfo.isMultiRecord(true);
        }
    }

    public void setFieldStyle(short fieldStyle) {
        if (fieldStyle == 3) {
            this.fFlatFileInfo.isFixedLengthFile(true);
        } else {
            this.fFlatFileInfo.isDelimitedFile(true);
        }
    }

    public void setContainerName(String containerName) throws FlatFileValidationException {
        if (containerName != null) {
            this.fFlatFileInfo.setRootElement(containerName);
        }
    }

    public void setRecordName(int recordNum, String recordName, int fieldCount) {
        try {
            if (this.fFlatFileInfo.isMultiRecord()) {
                ++fieldCount;
            }
            ArrayTwoDModel fieldPropertiesDs = new ArrayTwoDModel(7, fieldCount);
            if (!this.fFlatFileInfo.isMultiRecord()) {
                this.fFlatFileInfo.setSingleRecordName(recordName);
            }
            this.fFlatFileInfo.setFieldPropertiesDs(recordName.toUpperCase(), fieldPropertiesDs);
            this._localRecordVector.add(recordNum, recordName);
            if (this.fFlatFileInfo.isMultiRecord()) {
                SortableTwoDModel source = this.fFlatFileInfo.getRecordClassifierDs();
                source.addRows(source.getRowCount(), 1);
                source.setData(2, recordNum, (Object)recordName);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setChoiceCondition(String condition) {
    }

    public void setChoiceConditionLen(String length) {
        if (length != null) {
            this.fFlatFileInfo.setRecordClassifierEnd(Integer.parseInt(length.trim()));
        }
        this.fFlatFileInfo.setRecordClassifierStart(0);
    }

    public void setChoiceConditionTerminatedBy(String terminatedBy) {
        if (terminatedBy != null) {
            this.fFlatFileInfo.setDelimiter(terminatedBy);
        }
    }

    public void setChoiceValue(int recordNum, String choiceValue) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
            dataSource.setData(1, 0, (Object)"C1");
            dataSource.setData(2, 0, (Object)"string");
            dataSource.setData(3, 0, (Object)("" + choiceValue.length()));
            dataSource.setData(4, 0, (Object)"1");
            dataSource.setData(5, 0, (Object)("" + choiceValue.length()));
            if (this.fFlatFileInfo.isDelimitedFile()) {
                String showDelim = this.convertDelimiterToDisplayString(this.fFlatFileInfo.getDelimiter());
                dataSource.setData(6, 0, (Object)showDelim);
            }
        }
        if (choiceValue != null) {
            SortableTwoDModel source = this.fFlatFileInfo.getRecordClassifierDs();
            source.setData(1, recordNum, (Object)choiceValue);
        }
    }

    public void setRecordDelimiter(String delimiter) {
        if (delimiter != null) {
            if (delimiter.equals(EOL)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(true);
            } else if (delimiter.equals(EOF)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(false);
            } else {
                this.fFlatFileInfo.setRecordTerminator(delimiter);
            }
        }
    }

    public void setFieldName(int recordNum, int fieldNum, String fieldName) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++fieldNum;
        }
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(1, fieldNum, (Object)fieldName);
    }

    public void setFieldType(int recordNum, int fieldNum, String fieldType) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++fieldNum;
        }
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        dataSource.setData(2, fieldNum, (Object)fieldType);
    }

    public void setFieldLength(int recordNum, int fieldNum, String len) {
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++fieldNum;
        }
        if (len != null) {
            ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
            dataSource.setData(3, fieldNum, (Object)len);
            int start_col = 0;
            int end_col = 0;
            if (fieldNum == 0) {
                start_col = 1;
                end_col = Integer.parseInt(len);
            } else {
                String prevEndLen = (String)dataSource.getData(5, fieldNum - 1);
                if (prevEndLen != null) {
                    start_col = Integer.parseInt(prevEndLen) + 1;
                    end_col = Integer.parseInt(prevEndLen) + Integer.parseInt(len);
                }
            }
            dataSource.setData(4, fieldNum, (Object)("" + start_col));
            dataSource.setData(5, fieldNum, (Object)("" + end_col));
        }
    }

    public void setFieldTerminator(int recordNum, int fieldNum, String terminatedBy) {
        if (terminatedBy == null) {
            return;
        }
        if (terminatedBy != null && this._fieldDelimiter.equals("")) {
            this._fieldDelimiter = terminatedBy;
            this.fFlatFileInfo.setDelimiter(terminatedBy);
        }
        ArrayTwoDModel dataSource = this.fFlatFileInfo.getFieldPropertiesDs((String)this._localRecordVector.elementAt(recordNum));
        int fieldCount = dataSource.getRowCount();
        if (this.fFlatFileInfo.isMultiRecord()) {
            ++fieldNum;
        }
        if (fieldNum == fieldCount - 1 && terminatedBy != null) {
            if (terminatedBy.equals(EOL)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(true);
            } else if (terminatedBy.equals(EOF)) {
                this.fFlatFileInfo.setRecordTerminator("\\n");
                this.fFlatFileInfo.setRecordTerminatorEOL(false);
            } else {
                this.fFlatFileInfo.setRecordTerminator(terminatedBy);
            }
        }
        String showDelim = this.convertDelimiterToDisplayString(terminatedBy);
        dataSource.setData(6, fieldNum, (Object)showDelim);
    }

    public void setNamespace(String namespace) {
        if (namespace != null) {
            this.fFlatFileInfo.setNamespace(namespace);
        }
    }

    public void setNxsdEncoding(String encoding) {
        if (encoding != null) {
            this.fFlatFileInfo.setNxsdEncoding(encoding);
        }
    }

    public void setHeaderLines(int headers) {
        if (headers > -1) {
            this.fFlatFileInfo.setSkipRecords(headers);
        }
    }

    public void setFieldQuotedBy(int record, int fieldNum, String quotedBy) {
        if (quotedBy != null) {
            this.fFlatFileInfo.setEnclosureLeft(quotedBy);
            this.fFlatFileInfo.setEnclosureRight(quotedBy);
        } else {
            this.fFlatFileInfo.setEnclosureLeft("");
            this.fFlatFileInfo.setEnclosureRight("");
        }
    }

    private String convertDelimiterToDisplayString(String realDelim) {
        if (realDelim == null) {
            return "";
        }
        String showDelim = realDelim;
        showDelim = realDelim.equals("  ") ? NLSUtils.getNLSString("DA_delimitedColDelimiterWhiteSpace_FlatFile") : (realDelim.equals(",") ? NLSUtils.getNLSString("DA_delimitedColDelimiterComma_FlatFile") : (realDelim.equals(";") ? NLSUtils.getNLSString("DA_delimitedColDelimiterSemicolon_FlatFile") : (realDelim.equals("\\t") ? NLSUtils.getNLSString("DA_delimitedColDelimiterTab_FlatFile") : (realDelim.equals(" ") ? NLSUtils.getNLSString("DA_delimitedColDelimiterSpace_FlatFile") : (realDelim.equals("\\n") || realDelim.equals("\\r\\n") ? EOL : realDelim)))));
        return showDelim;
    }
}

