/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.Vector;
import javax.swing.JFrame;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.DSConverter;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public abstract class InvokeNxsdWizard {
    private NxsdFileInfo _context;

    public static NxsdFileInfo runWizard(Frame frame, String directoryName) {
        return InvokeNxsdWizard.runWizard(frame, directoryName, false);
    }

    public static NxsdFileInfo runWizard(Frame frame, String directoryName, String serviceName, boolean dtdMode) {
        NxsdFileInfo fileInfo = new NxsdFileInfo();
        fileInfo._directoryName = directoryName;
        fileInfo._dtdOnly = dtdMode;
        fileInfo._serviceName = serviceName;
        FlatFileWizard flatFileWizard = new FlatFileWizard(frame, fileInfo);
        if (flatFileWizard.init()) {
            FlatFileInfo ffi = flatFileWizard.getFlatFileInfo();
            fileInfo._targetNamespace = ffi.getNamespace();
            fileInfo._isNxsdRelative = true;
            fileInfo._rootElement = ffi.isSingleInstance() ? ffi.getSingleRecordName() : ffi.getRootElement();
            return fileInfo;
        }
        return null;
    }

    public static NxsdFileInfo runWizard(Frame frame, String directoryName, boolean dtdMode) {
        NxsdFileInfo fileInfo = new NxsdFileInfo();
        fileInfo._directoryName = directoryName;
        fileInfo._dtdOnly = dtdMode;
        FlatFileWizard flatFileWizard = new FlatFileWizard(frame, fileInfo);
        if (flatFileWizard.init()) {
            FlatFileInfo ffi = flatFileWizard.getFlatFileInfo();
            fileInfo._targetNamespace = ffi.getNamespace();
            fileInfo._isNxsdRelative = true;
            fileInfo._rootElement = ffi.isSingleInstance() ? ffi.getSingleRecordName() : ffi.getRootElement();
            return fileInfo;
        }
        return null;
    }

    public static NxsdFileInfo runWizard(Frame frame, String directoryName, String editNxsdFileName) {
        NxsdFileInfo fileInfo = new NxsdFileInfo();
        fileInfo._directoryName = directoryName;
        fileInfo._nxsdFileName = editNxsdFileName;
        FlatFileWizard flatFileWizard = new FlatFileWizard(frame, fileInfo);
        try {
            InvokeNxsdWizard.checkSuitableNxsd(directoryName, editNxsdFileName);
        }
        catch (FlatFileValidationException fe) {
            fe.showError(frame, null);
            return null;
        }
        if (flatFileWizard.init()) {
            FlatFileInfo ffi = flatFileWizard.getFlatFileInfo();
            fileInfo._targetNamespace = ffi.getNamespace();
            fileInfo._isNxsdRelative = true;
            fileInfo._rootElement = ffi.isSingleInstance() ? ffi.getSingleRecordName() : ffi.getRootElement();
            return fileInfo;
        }
        return null;
    }

    private static void checkSuitableNxsd(String directoryName, String fileName) throws FlatFileValidationException {
        StringBuffer nxsdAsString = new StringBuffer();
        Vector rootElementList = new Vector();
        String fullFileName = directoryName + File.separator + fileName;
        try {
            FileInputStream in_stream = new FileInputStream(fullFileName);
            InputStreamReader r = new InputStreamReader((InputStream)in_stream, System.getProperty("file.encoding"));
            BufferedReader in = new BufferedReader(r);
            int ch = in.read();
            while (ch != -1) {
                nxsdAsString.append((char)ch);
                ch = in.read();
            }
            if (nxsdAsString.indexOf("nxsd:version=\"NXSD\"") == -1) {
                throw new FlatFileValidationException(NLSUtils.getNLSString("CT_cannotEdit_API34", new String[]{""}));
            }
            rootElementList = new DSConverter().getRootElementList(fullFileName);
            if (rootElementList != null) {
                if (rootElementList.size() > 1) {
                    throw new FlatFileValidationException(NLSUtils.getNLSString("CT_cannotEditMultipleRoots_API41"));
                }
                if (rootElementList.size() == 0) {
                    throw new FlatFileValidationException(NLSUtils.getNLSString("CT_editNxsdRootElementMissing_API1"));
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new FlatFileValidationException(NLSUtils.getNLSString("CT_editNxsdFileNameMissing_API2", new String[]{fileName}));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static NxsdFileInfo runWizard(Frame frame, String directoryName, Connection apps_dtdMode_connection_parm) {
        NxsdFileInfo fileInfo = new NxsdFileInfo();
        fileInfo._directoryName = directoryName;
        fileInfo._dtdOnly = true;
        fileInfo._connection = apps_dtdMode_connection_parm;
        FlatFileWizard flatFileWizard = new FlatFileWizard(frame, fileInfo);
        if (flatFileWizard.init()) {
            FlatFileInfo ffi = flatFileWizard.getFlatFileInfo();
            fileInfo._targetNamespace = ffi.getNamespace();
            fileInfo._isNxsdRelative = true;
            fileInfo._rootElement = ffi.isSingleInstance() ? ffi.getSingleRecordName() : ffi.getRootElement();
            return fileInfo;
        }
        return null;
    }

    public static void main(String[] args) {
        NxsdFileInfo nxsdFileInfo;
        JFrame frame = new JFrame();
        frame.setSize(100, 100);
        frame.setTitle("Test");
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        String projectDir = "c:\\wizard";
        String strDtdMode = "";
        if (args != null && args.length > 0) {
            projectDir = args[0];
        }
        if (args != null && args.length > 1) {
            strDtdMode = args[1];
        }
        boolean bDtdMode = false;
        if (strDtdMode != null && strDtdMode.equalsIgnoreCase("Yes")) {
            bDtdMode = true;
        }
        if ((nxsdFileInfo = InvokeNxsdWizard.runWizard(frame, projectDir, "inbound_service", false)) != null) {
            DebugUtility.debug("ran");
            DebugUtility.debug(nxsdFileInfo._directoryName);
            DebugUtility.debug(nxsdFileInfo.getNxsdFileName());
            DebugUtility.debug(nxsdFileInfo.getRootElement());
            DebugUtility.debug(nxsdFileInfo.getTargetNamespace());
        } else {
            DebugUtility.debug("cancelled");
        }
    }
}

