/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JTextArea;
import oracle.bali.ewt.event.ListenerManager;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileScroller;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;

public class FlatFileTextArea
extends JTextArea
implements FlatFileRulerListener {
    private int _yPoint = 0;
    public Vector _lines = new Vector();
    private ListenerManager _listenerManager = new ListenerManager();
    private EWTScrollPane _EWTScrollPane;
    private FlatFileScroller _scroller;

    protected int getNoWrapColumnCount() {
        return 2000;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Color defColor = g.getColor();
        g.setColor(Color.DARK_GRAY);
        for (int i = 0; i < this._lines.size(); ++i) {
            int markerPosition = (Integer)this._lines.elementAt(i);
            if (this._yPoint < 100) {
                g.drawLine(markerPosition, this._yPoint, markerPosition, this._yPoint + 1000);
                g.drawLine(markerPosition, this._yPoint, markerPosition, Integer.MAX_VALUE);
                continue;
            }
            g.drawLine(markerPosition, this._yPoint - 100, markerPosition, this._yPoint + 1000);
        }
        g.setColor(defColor);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        super.processKeyEvent(e);
        int code = e.getKeyCode();
        if (code == 39 || code == 37) {
            int pos = this._EWTScrollPane.getX();
            this._scroller.setCurrPosition(pos);
        }
    }

    @Override
    public void rulerDragged(FlatFileRulerEvent e) {
        int i;
        int currPosition = e.getCurrPosition();
        int newPosition = e.getNewPosition();
        int scrollPosition = e.getScrollPosition();
        boolean found = false;
        for (i = 0; i < this._lines.size(); ++i) {
            if ((Integer)this._lines.elementAt(i) != currPosition) continue;
            found = true;
            break;
        }
        if (found) {
            this._lines.removeElementAt(i);
        } else {
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int charSize = fm.charWidth('1');
            found = false;
            for (i = 0; i < this._lines.size(); ++i) {
                if (currPosition > (Integer)this._lines.elementAt(i) + charSize / 2 - 1 || currPosition < (Integer)this._lines.elementAt(i) - charSize / 2 - 1) continue;
                found = true;
                currPosition = (Integer)this._lines.elementAt(i);
                break;
            }
            if (found) {
                this._lines.removeElementAt(i);
            } else {
                DebugUtility.debug("no such line.");
            }
        }
        this._lines.addElement(new Integer(newPosition));
        this.repaint();
    }

    @Override
    public void rulerSet(FlatFileRulerEvent e) {
        int markerPosition = e.getCurrPosition();
        int scrollPosition = e.getScrollPosition();
        this._lines.addElement(new Integer(markerPosition));
        this.repaint();
    }

    @Override
    public void rulerDeleted(FlatFileRulerEvent e) {
        int i;
        int markerPosition = e.getCurrPosition();
        int scrollPosition = e.getScrollPosition();
        boolean found = false;
        for (i = 0; i < this._lines.size(); ++i) {
            if ((Integer)this._lines.elementAt(i) != markerPosition) continue;
            found = true;
            break;
        }
        if (found) {
            this._lines.removeElementAt(i);
        } else {
            DebugUtility.debug("not found.");
            Font f = this.getFont();
            FontMetrics fm = this.getFontMetrics(f);
            int charSize = fm.charWidth('1');
            found = false;
            for (i = 0; i < this._lines.size(); ++i) {
                if (markerPosition > (Integer)this._lines.elementAt(i) + charSize / 2 - 1 || markerPosition < (Integer)this._lines.elementAt(i) - charSize / 2 - 1) continue;
                found = true;
                markerPosition = (Integer)this._lines.elementAt(i);
                break;
            }
            if (found) {
                this._lines.removeElementAt(i);
            } else {
                DebugUtility.debug("no such line.");
            }
        }
        this.repaint();
    }

    public void setScrollPosition(int yPoint) {
        this._yPoint = yPoint;
        if (this._yPoint < 100) {
            this._yPoint = 0;
        }
    }

    public void sortMarkers() {
        for (int i = 0; i < this._lines.size() - 1; ++i) {
            for (int j = i + 1; j < this._lines.size(); ++j) {
                if ((Integer)this._lines.elementAt(i) <= (Integer)this._lines.elementAt(j)) continue;
                Integer temp = (Integer)this._lines.elementAt(i);
                this._lines.setElementAt(this._lines.elementAt(j), i);
                this._lines.setElementAt(temp, j);
            }
        }
    }

    public void setScrollBox(EWTScrollPane EWTScrollPane2) {
        this._EWTScrollPane = EWTScrollPane2;
    }

    public void setScroller(FlatFileScroller scroller) {
        this._scroller = scroller;
    }
}

