/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.TextFieldInputHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerEvent;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileRulerListener;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WhAlert;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleRecordClassifierPanel
extends WizardPanel
implements FlatFileRulerListener,
TableEditListener {
    private MultiLineLabel tempLabel;
    private Integer begMark = new Integer(0);
    private Integer endMark = new Integer(0);
    private boolean deletingMark = false;
    private JLabel _classifierColNumLbl;
    private NumberTextField _classifierColNum;
    private JLabel _classifierBegColNumLbl;
    private NumberTextField _classifierBegColNum;
    private int _classifierBegColNumSave;
    private JLabel _classifierEndColNumLbl;
    private NumberTextField _classifierEndColNum;
    private int _classifierEndColNumSave;
    private TextFieldInputHandler _recordList;
    private SortableTwoDModel _valueGridDs;
    private SpreadTable _valueGrid;
    private JScrollPane _valueGridScrollBox;
    private JButton _newButton;
    private boolean _newButtPressed = false;
    private JButton _deleteButton;
    private JButton _deleteAllButton;
    private TextFieldInputHandler _valueHandler;
    private CellInputHandler _selectionHandler;
    private int _selectedRows = 0;
    private WizardPage _wizardPage;
    private FlatFileDisplayGizmo _dataGizmo;
    private FlatFileInfo _ff_info;
    private JButton _scanButton;
    private DocumentListener _endColDocumentListener;
    private boolean _isEndClassifierValueChanged = false;
    private WizardPage fWizardPage;

    FlatFileSampleRecordClassifierPanel(WBTranslatable h) {
        super(h);
    }

    private void _debug(String msg) {
        DebugUtility.debug(msg);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wizardPage = wp;
        this.setLayout(new GridBagLayout());
        Insets stdInsets = new Insets(3, 3, 3, 3);
        this.tempLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("RC_recClassIntro_FlatFile"));
        FlatFileSampleRecordClassifierPanel.addComponent(this, (Component)this.tempLabel, 0, 0, 3, 1, 1.0, 0.0, 18, 2, stdInsets);
        JPanel aboveTopPanel = new JPanel(new GridBagLayout());
        FlatFileSampleRecordClassifierPanel.addComponent(this, aboveTopPanel, 0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1));
        JPanel positionPanel = new JPanel();
        positionPanel.setLayout(new FlowLayout(0));
        GridBagConstraints constraints = new GridBagConstraints();
        Insets insets = new Insets(1, 0, 1, 1);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 18;
        constraints.insets = insets;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        aboveTopPanel.add((Component)positionPanel, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 4, 10, 1));
        this._classifierColNumLbl = new JLabel(this.translate("RC_recClassClassifierColNum_FlatFile"));
        positionPanel.add(this._classifierColNumLbl);
        this._classifierColNum = new NumberTextField((Number)new Integer(0), 5);
        this._classifierColNum.setEditable(false);
        this._classifierColNumLbl.setLabelFor((Component)this._classifierColNum);
        positionPanel.add((Component)this._classifierColNum);
        ActionListener classifierColNumListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.classifierColNumValueChanged(FlatFileSampleRecordClassifierPanel.this._classifierColNum.getText());
            }
        };
        this._classifierColNum.addActionListener(classifierColNumListener);
        this._classifierBegColNumLbl = new JLabel(this.translate("RC_recClassClassifierBegColNum_FlatFile"));
        positionPanel.add(this._classifierBegColNumLbl);
        this._classifierBegColNum = new NumberTextField((Number)new Integer(0), 5);
        this._classifierBegColNum.setEditable(false);
        this._classifierBegColNumLbl.setLabelFor((Component)this._classifierBegColNum);
        ActionListener classifierBegColNumListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.classifierBegColNumValueChanged(FlatFileSampleRecordClassifierPanel.this._classifierBegColNum.getText());
            }
        };
        this._classifierBegColNum.addActionListener(classifierBegColNumListener);
        positionPanel.add((Component)this._classifierBegColNum);
        this._classifierEndColNumLbl = new JLabel(this.translate("RC_recClassClassifierEndColNum_FlatFile"));
        this._classifierEndColNumLbl.setToolTipText(this.translate("RC_EndPos_tooltip"));
        CommonUtils.setMnemonicAndAccelerator(this._classifierEndColNumLbl, NLSUtils.getNLSString("RC_recClassClassifierEndColNum_FlatFile"));
        positionPanel.add(this._classifierEndColNumLbl);
        this._classifierEndColNum = new NumberTextField((Number)new Integer(0), 5);
        this._classifierEndColNum.setSigned(false);
        this._classifierEndColNumLbl.setLabelFor((Component)this._classifierEndColNum);
        ActionListener classifierEndColNumListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.classifierEndColNumValueChanged(FlatFileSampleRecordClassifierPanel.this._classifierEndColNum.getText());
            }
        };
        this._classifierEndColNum.setToolTipText(this.translate("RC_EndPos_tooltip"));
        this._classifierEndColNum.addActionListener(classifierEndColNumListener);
        this._endColDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleRecordClassifierPanel.this.classifierEndColNumValueChanged(FlatFileSampleRecordClassifierPanel.this._classifierEndColNum.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleRecordClassifierPanel.this.classifierEndColNumValueChanged(FlatFileSampleRecordClassifierPanel.this._classifierEndColNum.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleRecordClassifierPanel.this.classifierEndColNumValueChanged(FlatFileSampleRecordClassifierPanel.this._classifierEndColNum.getText());
            }
        };
        this._classifierEndColNum.getDocument().addDocumentListener(this._endColDocumentListener);
        positionPanel.add((Component)this._classifierEndColNum);
        this._scanButton = new JButton(this.translate("RC_recClassScanButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._scanButton, NLSUtils.getNLSString("RC_recClassScanButton_FlatFile"));
        ActionListener scanButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.scanButtonPressed();
            }
        };
        this._scanButton.addActionListener(scanButtonListener);
        buttonPanel.add(this._scanButton);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new GridLayout());
        FlatFileSampleRecordClassifierPanel.addComponent(this, middlePanel, 1, 2, 3, 1, 0.0, 0.5, 17, 1, stdInsets);
        JPanel valuePanel = new JPanel();
        valuePanel.setLayout(new BorderLayout());
        middlePanel.add(valuePanel);
        this._valueGridDs = new SortableTwoDModel(3, 0);
        this._valueGrid = new SpreadTable((TwoDModel)this._valueGridDs, null, null);
        Grid grid = this._valueGrid.getGrid();
        if (grid != null) {
            grid.setName("ClassiferValueGrid");
        }
        this._valueGridScrollBox = new JScrollPane((Component)this._valueGrid, 20, 30);
        valuePanel.add((Component)this._valueGridScrollBox, "Center");
        this._newButton = new JButton(this.translate("RC_recClassNewButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._newButton, NLSUtils.getNLSString("RC_recClassNewButton_FlatFile"));
        buttonPanel.add(this._newButton);
        ActionListener newButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.newButtonPressed();
            }
        };
        this._newButton.addActionListener(newButtonListener);
        this._deleteButton = new JButton(this.translate("RC_recClassDeleteButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._deleteButton, NLSUtils.getNLSString("RC_recClassDeleteButton_FlatFile"));
        buttonPanel.add(this._deleteButton);
        ActionListener deleteButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.deleteButtonPressed();
            }
        };
        this._deleteButton.addActionListener(deleteButtonListener);
        this._deleteButton.setEnabled(false);
        this._deleteAllButton = new JButton(this.translate("RC_recClassDeleteAllButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._deleteAllButton, NLSUtils.getNLSString("RC_recClassDeleteAllButton_FlatFile"));
        buttonPanel.add(this._deleteAllButton);
        constraints.gridx = 0;
        constraints.gridy = 1;
        aboveTopPanel.add((Component)buttonPanel, constraints);
        ActionListener deleteAllButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleRecordClassifierPanel.this.deleteAllButtonPressed();
            }
        };
        this._deleteAllButton.addActionListener(deleteAllButtonListener);
        this._deleteAllButton.setEnabled(false);
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSampleRecordClassifierPanel.addComponent(this, gizmoPanel, 0, 3, 0, 0, 0.0, 0.5, 17, 1, stdInsets);
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        this._dataGizmo.getWidthsTextField().setEditable(false);
        this._dataGizmo.getRuler().setToolTipText(this.translate("RC_rulerDontUse_tooltip"));
        FlatFileSampleRecordClassifierPanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, stdInsets);
        this._dataGizmo.addRulerListener(this);
        this._dataGizmo.allowDataColumnSelection(true);
        FocusListener reverseFocusDeleteControl = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                FlatFileSampleRecordClassifierPanel.this._deleteButton.setEnabled(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (FlatFileSampleRecordClassifierPanel.this._valueGridDs.getRowCount() > 0) {
                    FlatFileSampleRecordClassifierPanel.this._deleteButton.setEnabled(true);
                }
            }
        };
    }

    @Override
    public Component getFirstSelectableComponent() {
        if (this._ff_info.isDelimitedFile()) {
            return this._scanButton;
        }
        return this._classifierEndColNum;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws FlatFileValidationException {
        try {
            DebugUtility.debug((Object)this._ff_info, "FlatFileSampleRecordClassifierPanel validate ");
            if (this._ff_info.isDelimitedFile()) {
                this._ff_info.setRecordClassifierStart(this._classifierBegColNumSave);
            } else {
                this._ff_info.setRecordClassifierStart(this._classifierBegColNumSave + 1);
                if (this._classifierEndColNumSave == 0 || this._classifierEndColNumSave < this._classifierBegColNumSave) {
                    this._classifierEndColNumSave = this._classifierBegColNumSave;
                }
                this._ff_info.setRecordClassifierEnd(this._classifierEndColNumSave);
            }
            this._ff_info.validateRecords();
            Vector<String> all_types = new Vector<String>();
            for (int i = 0; i < this._valueGridDs.getRowCount(); ++i) {
                String recTypeValue = (String)this._valueGridDs.getData(1, i);
                if (all_types.contains(recTypeValue)) {
                    String[] args = new String[]{(String)this._valueGridDs.getData(1, i)};
                    throw new FlatFileValidationException(this.translate("RC_recClassDuplicateValue_API23", args));
                }
                all_types.add(recTypeValue);
            }
            Vector<String> all_names = new Vector<String>();
            for (int i = 0; i < this._valueGridDs.getRowCount(); ++i) {
                String recTypeName = (String)this._valueGridDs.getData(2, i);
                if (recTypeName.length() == 0) {
                    throw new FlatFileValidationException(this.translate("RC_recClassNoName_API31"));
                }
                ArrayTwoDModel display_data = this._ff_info.getFormattedColumnDataSource(recTypeName);
                if (display_data.getRowCount() < 1) {
                    String recIdentifier = (String)this._valueGridDs.getData(1, i);
                    if (recIdentifier.equals("")) {
                        recIdentifier = "''";
                    }
                    throw new FlatFileValidationException(this.translate("RC_conditionValueDoesWrong_API49", new String[]{recIdentifier}));
                }
                if (all_names.contains(recTypeName)) {
                    String[] args = new String[]{recTypeName};
                    throw new FlatFileValidationException(this.translate("RC_recClassDuplicateName_API20", args));
                }
                all_names.add(recTypeName);
            }
            this._ff_info.setRecordsToProcessRemain(-1);
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String getHelpTopicName() {
        if (this._ff_info.isDelimitedFile()) {
            return "flatfile_delim_mult_rectype";
        }
        return "flatfile_fixed_mult_rectype";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        this._ff_info = (FlatFileInfo)info;
        DebugUtility.debug((Object)this._ff_info, "FlatFileSampleRecordClassifierPanel initialize ");
        if (!this._ff_info.isStandaloneTesting()) {
            if (this._ff_info.isDelimitedFile()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)((ImageWizardPage)this.getWizardPage()).getContent(), "bpmjdev_adp_wiz_nfb_del_rectype");
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)((ImageWizardPage)this.getWizardPage()).getContent(), "bpmjdev_adp_wiz_nfb_fl_rectype");
            }
        }
        FlatFileWizard ffWizard = this._ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        this._wizardPage.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        if (!this._ff_info.isDelimitedFile()) {
            this._wizardPage.setPageTitle(this.translate("RC_recClassPageTitleFixed_FlatFile"));
            DebugUtility.debug(this.translate("RC_recClassPageTitleFixed_FlatFile").toUpperCase());
            this.tempLabel.setText(this.translate("RC_recClassIntro2_FlatFile"));
        } else {
            this._wizardPage.setPageTitle(this.translate("RC_recClassPageTitleDelim_FlatFile"));
            DebugUtility.debug(this.translate("RC_recClassPageTitleDelim_FlatFile").toUpperCase());
            this.tempLabel.setText(this.translate("RC_recClassIntro_FlatFile"));
        }
        if (this._ff_info.isDelimitedFile()) {
            this._dataGizmo.setType(3);
            this._classifierColNumLbl.setVisible(false);
            this._classifierColNum.setVisible(false);
            this._classifierBegColNumLbl.setVisible(false);
            this._classifierBegColNum.setVisible(false);
            this._classifierEndColNumLbl.setVisible(false);
            this._classifierEndColNum.setVisible(false);
            this._classifierBegColNumSave = 1;
            this._classifierColNum.setNumber((Number)new Integer(1));
        } else {
            this._dataGizmo.setType(2);
            this._classifierColNumLbl.setVisible(false);
            this._classifierColNum.setVisible(false);
            this._classifierBegColNumLbl.setVisible(false);
            this._classifierBegColNum.setVisible(false);
            this._classifierEndColNumLbl.setVisible(true);
            this._classifierEndColNum.setVisible(true);
            this._classifierBegColNumSave = 0;
            this._classifierBegColNum.setNumber((Number)new Integer(this._classifierBegColNumSave));
            this._classifierEndColNumSave = this._ff_info.getRecordClassifierEnd();
            this._classifierEndColNum.getDocument().removeDocumentListener(this._endColDocumentListener);
            if (this._classifierEndColNumSave != 0) {
                this._classifierEndColNum.setNumber((Number)new Integer(this._classifierEndColNumSave));
            } else {
                this._classifierEndColNum.setText("");
                this._scanButton.setEnabled(false);
            }
            this._classifierEndColNum.getDocument().addDocumentListener(this._endColDocumentListener);
        }
        Object[] columnHeaders = new String[]{"   ", this.translate("RC_recClassValueGridValue_FlatFile"), this.translate("RC_recClassValueGridRecordName_FlatFile")};
        ArrayOneDModel columnHeadersDs = new ArrayOneDModel(columnHeaders);
        this._valueGridDs = this._ff_info.getRecordClassifierDs();
        this._valueGrid.setModels((TwoDModel)this._valueGridDs, (OneDModel)columnHeadersDs, null);
        for (int col = 3; col < this._valueGridDs.getColumnCount(); ++col) {
            this._valueGrid.getGrid().setColumnVisible(col, false);
        }
        this._valueGrid.setColumnWidth(0, 20);
        Font currFont = this._valueGrid.getFont();
        FontMetrics currFontMetrics = this._valueGrid.getFontMetrics(currFont);
        int charSize = currFontMetrics.charWidth('W');
        int columnWidth = this.translate("RC_recClassValueGridValue_FlatFile").length() * charSize + 10;
        this._valueGrid.setColumnWidth(1, columnWidth);
        int colSize = ((String)columnHeaders[1]).length() * charSize;
        this._valueGrid.setColumnWidth(1, colSize);
        int tableWidth = this._valueGrid.getWidth();
        colSize = tableWidth > colSize + 20 ? tableWidth - (colSize + 20) : ((String)columnHeaders[2]).length() * charSize + 10;
        this._valueGrid.setColumnWidth(2, colSize);
        this._selectionHandler = BooleanInputHandler.getCellInputHandler();
        this._valueGrid.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this._valueGrid.getGrid().setColumnCellInputHandler(0, this._selectionHandler);
        this._valueHandler = (TextFieldInputHandler)TextFieldInputHandler.getCellInputHandler();
        if (!this._ff_info.isDelimitedFile()) {
            this.setClassifierMaxChars();
        }
        this._valueGrid.getGrid().setColumnCellInputHandler(1, (CellInputHandler)this._valueHandler);
        this._recordList = (TextFieldInputHandler)TextFieldInputHandler.getCellInputHandler();
        this._valueGrid.getGrid().setColumnCellInputHandler(2, (CellInputHandler)this._recordList);
        this._valueGrid.addEditListener((TableEditListener)this);
        this._dataGizmo.refreshContents(this._ff_info);
        if (this._ff_info.isDelimitedFile()) {
            this._dataGizmo.selectColumn(this._classifierBegColNumSave - 1);
        }
        SortableTwoDModel recClassifiers = this._ff_info.getRecordClassifierDs();
        if (this._ff_info.isDelimitedFile() && !this._ff_info.isEditingNXSD() && recClassifiers.getRowCount() == 0) {
            this.scanButtonPressed();
        }
        if (this._ff_info.isFixedLength() && this._classifierEndColNum.getText().equals("")) {
            this._wizardPage.setCanAdvance(false);
        }
    }

    private void setClassifierValues(String[] newValues) {
        int rowCount = this._valueGridDs.getRowCount();
        this._valueGridDs.removeRows(0, rowCount);
        this._valueGridDs.addRows(0, newValues.length);
        String[] record_names = new String[newValues.length];
        for (int i = 0; i < newValues.length; ++i) {
            this._valueGridDs.setData(1, i, (Object)newValues[i]);
            record_names[i] = this.translate("RC_recClassPrefixForGeneratedColNames") + (i + 1);
            this._valueGridDs.setData(2, i, (Object)record_names[i]);
        }
        this._deleteAllButton.setEnabled(true);
        this._isEndClassifierValueChanged = false;
    }

    private void appendClassifierValues(String[] newValues) {
        int i;
        int rowCount = this._valueGridDs.getRowCount();
        Vector<Object> curValues = new Vector<Object>(rowCount);
        for (i = 0; i < rowCount; ++i) {
            curValues.addElement(this._valueGridDs.getData(1, i));
        }
        for (i = 0; i < newValues.length; ++i) {
            if (curValues.contains(newValues[i])) continue;
            curValues.addElement(newValues[i]);
            this._valueGridDs.addRows(rowCount, 1);
            this._valueGridDs.setData(1, rowCount, (Object)newValues[i]);
            this._valueGridDs.setData(2, rowCount, (Object)"");
            ++rowCount;
        }
    }

    private void classifierColNumValueChanged(String newText) {
        int newValue = 0;
        if (newText != null && newText.length() != 0) {
            newValue = Integer.parseInt(newText);
        }
        if (this._classifierBegColNumSave != newValue) {
            int caretPos = this._classifierColNum.getCaretPosition();
            this._classifierBegColNumSave = newValue;
            this._ff_info.setRecordClassifierStart(newValue);
            if (this._dataGizmo != null) {
                this._dataGizmo.selectColumn(newValue - 1);
            }
            this._classifierColNum.setCaretPosition(caretPos);
        }
    }

    private void classifierBegColNumValueChanged(String newText) {
        int newValue = 0;
        if (newText != null && newText.length() != 0) {
            newValue = Integer.parseInt(newText);
        }
        if (this._classifierBegColNumSave != newValue) {
            this._classifierBegColNumSave = newValue;
            this.setClassifierMaxChars();
        }
    }

    private void classifierEndColNumValueChanged(String newText) {
        int newValue = 0;
        if (newText != null && newText.length() != 0 && Integer.parseInt(newText) > 0) {
            newValue = Integer.parseInt(newText);
            this._scanButton.setEnabled(true);
            this._isEndClassifierValueChanged = true;
        } else {
            this._scanButton.setEnabled(false);
            this._wizardPage.setCanAdvance(false);
            this._isEndClassifierValueChanged = false;
        }
        if (this._classifierEndColNumSave != newValue) {
            this._classifierEndColNumSave = newValue;
            this.setClassifierMaxChars();
            this._wizardPage.setCanAdvance(false);
        }
    }

    private void setClassifierMaxChars() {
        JTextField valueTxt = this._valueHandler.getJTextField();
        if (this._classifierEndColNumSave == 0 || this._classifierEndColNumSave < this._classifierBegColNumSave) {
            this._classifierEndColNumSave = this._classifierBegColNumSave;
        }
        int maxChars = this._classifierEndColNumSave - this._classifierBegColNumSave + 1;
    }

    private void newButtonPressed() {
        int newRow = this._valueGridDs.getRowCount();
        this._valueGridDs.addRows(newRow, 1);
        this._valueGrid.getGrid().startCellEdit(1, newRow);
        this._valueGridDs.setData(1, newRow, (Object)"");
        this._valueGridDs.setData(2, newRow, (Object)"");
        this._deleteAllButton.setEnabled(true);
        this._newButtPressed = true;
        this._valueGrid.getGrid().startCellEdit(1, newRow);
        this._wizardPage.setCanAdvance(true);
    }

    private void deleteButtonPressed() {
        String selected = "";
        int rowCount = this._valueGridDs.getRowCount();
        if (rowCount > 0) {
            for (int i = 0; i < rowCount; ++i) {
                Object obj = this._valueGridDs.getData(0, i);
                if (obj == null || obj.toString() != "true") continue;
                this._valueGridDs.removeRows(i, 1);
                --rowCount;
                --i;
            }
        }
        this._selectedRows = 0;
        this._deleteButton.setEnabled(false);
        rowCount = this._valueGridDs.getRowCount();
        if (rowCount == 0) {
            this._wizardPage.setCanAdvance(false);
        }
    }

    private void deleteAllButtonPressed() {
        int rowCount = this._valueGridDs.getRowCount();
        this._valueGridDs.removeRows(0, rowCount);
        this._deleteButton.setEnabled(false);
        this._deleteAllButton.setEnabled(false);
        this._selectedRows = 0;
        this._wizardPage.setCanAdvance(false);
    }

    private void scanButtonPressed() {
        this._wizardPage.setCanAdvance(true);
        if (this._ff_info.isDelimitedFile()) {
            if (this._classifierBegColNumSave != 0) {
                this.setClassifierValues(this._ff_info.getUniqueValues(this._classifierBegColNumSave));
            }
        } else if (this._classifierBegColNumSave >= 0) {
            if (this._classifierEndColNumSave == 0 || this._classifierEndColNumSave < this._classifierBegColNumSave) {
                this._classifierEndColNumSave = this._classifierBegColNumSave + 1;
            }
            if (this._classifierEndColNum.getText() == null || this._classifierEndColNum.getText().length() == 0 || Integer.parseInt(this._classifierEndColNum.getText()) < this._classifierBegColNumSave) {
                this._classifierEndColNum.setNumber((Number)new Integer(this._classifierEndColNumSave));
            }
            if (this._valueGridDs.getRowCount() == 0) {
                this.setClassifierValues(this._ff_info.getUniqueValues(this._classifierBegColNumSave, this._classifierEndColNumSave));
            }
            if (this._valueGridDs.getRowCount() > 0 && this._isEndClassifierValueChanged) {
                WhAlert alert = new WhAlert((Dialog)CommonUtils.getParentFrameOrDialog(this), this.translate("RC_recClassScanAlertMessage"), 2, 8);
                alert.setCenterOver((Dialog)CommonUtils.getParentFrameOrDialog(this));
                alert.setTitle(this.translate("GN_warning_title"));
                alert.runAlert();
                this.setClassifierValues(this._ff_info.getUniqueValues(this._classifierBegColNumSave, this._classifierEndColNumSave));
            }
        }
        if (this._valueGridDs.getRowCount() > 0) {
            this._deleteAllButton.setEnabled(true);
        }
        this.addScannedRecordsToHash();
    }

    private void addScannedRecordsToHash() {
        SortableTwoDModel recClassifiers = this._ff_info.getRecordClassifierDs();
        if (recClassifiers != null) {
            String aRecord = "";
            if (this._ff_info.isDelimitedFile()) {
                this._ff_info.setRecordClassifierStart(this._classifierBegColNumSave);
            } else {
                this._ff_info.setRecordClassifierStart(this._classifierBegColNumSave + 1);
                if (this._classifierEndColNumSave == 0 || this._classifierEndColNumSave < this._classifierBegColNumSave) {
                    this._classifierEndColNumSave = this._classifierBegColNumSave;
                }
                this._ff_info.setRecordClassifierEnd(this._classifierEndColNumSave);
            }
            for (int i = 0; i < recClassifiers.getRowCount(); ++i) {
                aRecord = (String)recClassifiers.getData(2, i);
                if (aRecord == null || aRecord.trim().equals("")) continue;
                this._ff_info.getFieldPropertiesDs(aRecord);
            }
        }
    }

    public void cellEdited(TableEvent e) {
        DebugUtility.debug("CELL_EDITED");
        int col = e.getColumn();
        int row = e.getRow();
        if (col == 0 && !this._newButtPressed) {
            Object obj = this._valueGridDs.getData(0, row);
            if (obj != null) {
                this._selectedRows = obj.toString() == "true" ? ++this._selectedRows : --this._selectedRows;
            }
            if (this._selectedRows > 0) {
                this._deleteButton.setEnabled(true);
            } else {
                this._deleteButton.setEnabled(false);
            }
        }
        if (col == 2) {
            String data = (String)this._valueGridDs.getData(col, row);
        }
        this._newButtPressed = false;
    }

    public void cellEditing(TableEvent e) {
        DebugUtility.debug("CELL_EDITING");
    }

    @Override
    public void rulerDragged(FlatFileRulerEvent e) {
        this.processRulerChange();
    }

    @Override
    public void rulerSet(FlatFileRulerEvent e) {
        this.processRulerChange();
    }

    @Override
    public void rulerDeleted(FlatFileRulerEvent e) {
        this.processRulerChange();
    }

    private void processRulerChange() {
        int[] markers = this._dataGizmo.getMarkedColumns();
        if (markers.length > 1) {
            WhAlert alert = new WhAlert((Dialog)CommonUtils.getParentFrameOrDialog(this), this.translate("RC_recClassWarnMarkers_API25"), 2, 8);
            alert.setCenterOver((Dialog)CommonUtils.getParentFrameOrDialog(this));
            alert.setTitle(this.translate("GN_warning_title"));
        } else {
            if (markers.length > 0) {
                this.endMark = new Integer(markers[0]);
            }
            if (this.endMark != 0) {
                this._classifierEndColNum.setNumber((Number)this.endMark);
                this.classifierEndColNumValueChanged(this.endMark.toString());
            }
        }
    }

    public void columnSelecting(TableEvent p0) {
        DebugUtility.debug("CELL_SELECTING");
    }

    public void columnSelected(TableEvent p0) {
        DebugUtility.debug("CELL_SELECTED");
    }

    public void columnDeselecting(TableEvent p0) {
        DebugUtility.debug("CELL_DESELECTING");
    }

    public void columnDeselected(TableEvent p0) {
        DebugUtility.debug("CELL_DESELECTED");
    }

    @Override
    public WizardPage getWizardPage() {
        return this.fWizardPage;
    }

    @Override
    public void setWizardPage(WizardPage page) {
        this.fWizardPage = page;
    }
}

