/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileFieldProperties;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSamplePropertiesPanel
extends WizardPanel {
    private FlatFileInfo _ff_info;
    private FlatFileFieldProperties _fieldProperties;
    private JPanel _nextRecTypeButtonPanel;
    private JButton _nextRecTypeButton;
    private FlatFileDisplayGizmo _dataGizmo;
    private WBTranslatable _translator;
    private JCheckBox _promptCb;
    private JLabel _screenLabel;
    public boolean processed = false;
    private WizardPage fWizardPage;

    FlatFileSamplePropertiesPanel(WBTranslatable h) {
        super(h);
        this._translator = h;
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this.setLayout(new GridBagLayout());
        Insets stdInsets = new Insets(3, 3, 3, 3);
        this._screenLabel = new JLabel(this.translate("FP_propsIntro_FlatFile"));
        FlatFileSamplePropertiesPanel.addComponent(this, this._screenLabel, 0, 0, 1, 1, 1.0, 0.0, 17, 1, stdInsets);
        this._promptCb = new JCheckBox(this.translate("GN_displayUseFirstRowPrompt_FlatFile"), false);
        CommonUtils.setMnemonicAndAccelerator(this._promptCb, NLSUtils.getNLSString("GN_displayUseFirstRowPrompt_FlatFile"));
        this._promptCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FlatFileSamplePropertiesPanel.this.useFirstRowAsFieldNames(e.getStateChange() == 1);
            }
        });
        FlatFileSamplePropertiesPanel.addComponent(this, this._promptCb, 0, 1, 1, 1, 1.0, 0.0, 17, 1, stdInsets);
        this._fieldProperties = new FlatFileFieldProperties(this._translator);
        this._fieldProperties.buildFieldProperties();
        FlatFileSamplePropertiesPanel.addComponent(this, this._fieldProperties, 0, 2, 1, 1, 1.0, 0.6, 17, 1, stdInsets);
        JComboBox _recordList = this._fieldProperties.getRecordList();
        _recordList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSamplePropertiesPanel.this.processRefreshGizmo();
                }
            }
        });
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSamplePropertiesPanel.addComponent(this, gizmoPanel, 0, 3, 1, 1, 0.0, 0.4, 10, 1, stdInsets);
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        this._dataGizmo.addPromptListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FlatFileSamplePropertiesPanel.this.useFirstRowAsFieldNames(e.getStateChange() == 1);
            }
        });
        this._fieldProperties.setDataGizmo(this._dataGizmo);
        FlatFileSamplePropertiesPanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, stdInsets);
        this._nextRecTypeButton = this._fieldProperties.getNextRecTypeButton();
        ActionListener nextRecTypeButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSamplePropertiesPanel.this.processRefreshGizmo();
            }
        };
        this._nextRecTypeButton.addActionListener(nextRecTypeButtonListener);
        this.revalidate();
        this.repaint();
    }

    @Override
    public Component getFirstSelectableComponent() {
        if (this._ff_info.isMultiRecord()) {
            return this._fieldProperties.getRecordList();
        }
        return this._fieldProperties.getFieldGrid();
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        try {
            this._fieldProperties.validateFields();
            DebugUtility.debug((Object)this._ff_info, "FlatFileSamplePropertiesPanel validate ");
            String nxsdString = ((FlatFileInfo)info).generateNXSD();
            this._ff_info.setModifiedNXSD(nxsdString);
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            throw e;
        }
    }

    @Override
    public String getHelpTopicName() {
        if (this._ff_info.isDelimitedFile() && !this._ff_info.isMultiRecord()) {
            return "flatfile_delim_single_prop";
        }
        if (this._ff_info.isDelimitedFile() && this._ff_info.isMultiRecord()) {
            return "flatfile_delim_mult_prop";
        }
        if (!this._ff_info.isDelimitedFile() && !this._ff_info.isMultiRecord()) {
            return "flatfile_fixed_single_prop";
        }
        return "flatfile_fixed_mult_prop";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        this._ff_info = (FlatFileInfo)info;
        if (!this._ff_info.isStandaloneTesting()) {
            if (this._ff_info.isDelimitedFile()) {
                HelpSystem.getHelpSystem().registerTopic((JComponent)((ImageWizardPage)this.getWizardPage()).getContent(), "bpmjdev_adp_wiz_nfb_props");
            } else {
                HelpSystem.getHelpSystem().registerTopic((JComponent)((ImageWizardPage)this.getWizardPage()).getContent(), "bpmjdev_adp_wiz_nfb_fl_props");
            }
        }
        DebugUtility.debug((Object)this._ff_info, "FlatFileSamplePropertiesPanel initialize ");
        this._fieldProperties.initializeFrom(this._ff_info);
        FlatFileWizard ffWizard = this._ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("FP_propsPageTitle_FlatFile"));
        DebugUtility.debug(this.translate("FP_propsPageTitle_FlatFile").toUpperCase());
        ItemListener[] ils = CommonUtils.removeCheckboxItemListener(this._promptCb);
        if (this._ff_info.isMultiRecord()) {
            this._promptCb.setVisible(false);
        } else {
            this._promptCb.setVisible(true);
            if (this._ff_info.useFirstRowAsFieldNames()) {
                this._promptCb.setSelected(true);
            } else {
                this._promptCb.setSelected(false);
            }
        }
        CommonUtils.addCheckboxItemListener(this._promptCb, ils);
        if (this._ff_info.isMultiRecord()) {
            this._screenLabel.setText(this.translate("FP_propsIntro_FlatFileMultiRecord"));
            this._nextRecTypeButton.setVisible(true);
        } else {
            this._screenLabel.setText(this.translate("FP_propsIntro_FlatFile"));
            this._nextRecTypeButton.setVisible(true);
        }
        if (this._fieldProperties.getRecordCount() != 0) {
            this._dataGizmo.refreshContents(this._ff_info, this._fieldProperties.getRecordSelected());
        } else {
            this._dataGizmo.refreshContents(this._ff_info);
        }
    }

    private void processRefreshGizmo() {
        DebugUtility.debug("FlatFileSamplePropertiesPanel: processRefreshGizmo record = " + this._fieldProperties.getRecordSelected());
        this._dataGizmo.refreshContents(this._ff_info, this._fieldProperties.getRecordSelected());
    }

    private void useFirstRowAsFieldNames(boolean value) {
        int skip = this._ff_info.getSkipRecords();
        int remaining_lines = this._ff_info.getFormattedColumnDataSource(null).getRowCount();
        if (value && remaining_lines < 2) {
            this._promptCb.setSelected(false);
            FlatFileValidationException e = new FlatFileValidationException(this.translate("PP_firstRowHeader_API45"));
            e.showError(this.getParentFrame(), this);
            return;
        }
        if (value) {
            this._ff_info.useFirstRowAsFieldNames(value);
            this._ff_info.setSkipRecords(skip + 1);
        } else {
            this._ff_info.setSkipRecords(skip - 1);
            this._ff_info.useFirstRowAsFieldNames(value);
        }
        this._dataGizmo.refreshContents(this._ff_info, null);
    }

    @Override
    public WizardPage getWizardPage() {
        return this.fWizardPage;
    }

    @Override
    public void setWizardPage(WizardPage page) {
        this.fWizardPage = page;
    }
}

