/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleNamePanel
extends WizardPanel {
    private FlatFileInfo ff_info;
    private JLabel _nameFileNameIntro;
    private JLabel _nameFileStructureNameLbl;
    private JTextField _nameFileStructureName;
    private JLabel _nameCharacterSetLbl;
    private JComboBox _nameCharacterSetLw;
    private NumberTextField _numRowsToProcess;
    private int _numRowsToProcessSave;
    private NumericSpinBox _numRowsToSkip;
    private int _numRowsToSkipSave;
    private NumberTextField _numDataRowsToProcess;
    private JCheckBox _allDataRowsCb;
    private JCheckBox _everythingCb;
    private WizardPage _wp;
    private FlatFileDisplayGizmo _dataGizmo;
    private JButton _fileBrowseButton;

    FlatFileSampleNamePanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 2);
        this._nameFileNameIntro = new JLabel(this.translate("NM_nameIntro_FlatFile"));
        FlatFileSampleNamePanel.addComponent(this, this._nameFileNameIntro, 0, 0, 1, 1, 1.0, 0.0, 18, 1, new Insets(3, 3, 3, 3));
        JPanel nameFileNamePanel = new JPanel();
        nameFileNamePanel.setLayout(new GridBagLayout());
        FlatFileSampleNamePanel.addComponent(this, nameFileNamePanel, 0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 3, 3, 5));
        JPanel nameCharacterSetPanel = new JPanel();
        nameCharacterSetPanel.setLayout(new GridBagLayout());
        FlatFileSampleNamePanel.addComponent(this, nameCharacterSetPanel, 0, 2, 1, 1, 1.0, 0.3, 18, 2, new Insets(1, 3, 3, 5), 0, 20);
        this._nameFileStructureNameLbl = new JLabel(this.translate("GN_nameFileStructureName_FlatFile"));
        FlatFileSampleNamePanel.addComponent(nameFileNamePanel, this._nameFileStructureNameLbl, 0, 0, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameFileStructureName = new JTextField();
        this._nameFileStructureName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleNamePanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleNamePanel.this.handlePageAdvance();
            }
        });
        KeyAdapter fileNameListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 10 || code == 9) && code == 10) {
                    e.consume();
                }
            }
        };
        this._nameFileStructureName.addKeyListener(fileNameListener);
        this._nameFileStructureName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField field = (JTextField)e.getSource();
                String fileName = field.getText();
                if (fileName == null || fileName.equals("") || FlatFileSampleNamePanel.this.ff_info.getFileStructureName().equals(fileName)) {
                    return;
                }
                FlatFileSampleNamePanel.this._nameFileStructureName.setText(fileName);
                FlatFileSampleNamePanel.this.handlePageAdvance();
                try {
                    FlatFileSampleNamePanel.this.ff_info.setFileStructureName(fileName);
                }
                catch (FlatFileValidationException ex) {
                    FlatFileSampleNamePanel.this.showThisError(ex);
                }
                FlatFileSampleNamePanel.this.initializeFrom(FlatFileSampleNamePanel.this.ff_info);
                FlatFileSampleNamePanel.this.nameCharacterSetStateChanged();
            }
        });
        this._nameFileStructureNameLbl.setLabelFor(this._nameFileStructureName);
        CommonUtils.setMnemonicAndAccelerator(this._nameFileStructureNameLbl, NLSUtils.getNLSString("GN_nameFileStructureName_FlatFile"));
        int fieldWidth = new Float(240.0).intValue();
        this._nameFileStructureName.setPreferredSize(new Dimension(fieldWidth, 20));
        FlatFileSampleNamePanel.addComponent(nameFileNamePanel, this._nameFileStructureName, 1, 0, 1, 1, 1.0, 0.0, 17, 2, cmpInsets);
        this._fileBrowseButton = new JButton(this.translate("GN_browseButton"));
        this._fileBrowseButton.setToolTipText(this.translate("NM_FileBrowse_toolTip"));
        this._fileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser;
                String prjDir = ((FlatFileSampleNamePanel)FlatFileSampleNamePanel.this).ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                if (prjDir == null) {
                    prjDir = "";
                }
                if ((chooser = FlatFileSampleNamePanel.this.ff_info.getFileChooser()) == null) {
                    chooser = new JFileChooser(prjDir);
                    chooser.setDialogTitle(FlatFileSampleNamePanel.this.translate("NM_flatFileDialog_title"));
                }
                int returnVal = chooser.showOpenDialog(FlatFileSampleNamePanel.this.getParentFrame());
                FlatFileSampleNamePanel.this.ff_info.setFileChooser(chooser);
                String fileName = "";
                String directory = "";
                if (returnVal != 0) {
                    return;
                }
                fileName = chooser.getSelectedFile().getName();
                directory = chooser.getSelectedFile().getParent() + File.separator;
                if (directory != null && fileName != null) {
                    FlatFileSampleNamePanel.this._nameFileStructureName.setText(directory + fileName);
                    FlatFileSampleNamePanel.this.handlePageAdvance();
                    try {
                        FlatFileSampleNamePanel.this.ff_info.setFileStructureName(directory + fileName);
                    }
                    catch (FlatFileValidationException ex) {
                        FlatFileSampleNamePanel.this.showThisError(ex);
                    }
                    FlatFileSampleNamePanel.this.initializeFrom(FlatFileSampleNamePanel.this.ff_info);
                    FlatFileSampleNamePanel.this.nameCharacterSetStateChanged();
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileBrowseButton, NLSUtils.getNLSString("GN_browseButton"));
        FlatFileSampleNamePanel.addComponent(nameFileNamePanel, this._fileBrowseButton, 2, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        this._nameCharacterSetLbl = new JLabel(this.translate("GN_nameCharacterSet_FlatFile"));
        this._nameCharacterSetLbl.setToolTipText(this.translate("NM_characterSet_tooltip"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, this._nameCharacterSetLbl, 0, 3, 1, 1, 0.0, 0.0, 17, 2, cmpInsets);
        this._nameCharacterSetLw = new JComboBox();
        this._nameCharacterSetLw.setToolTipText(this.translate("NM_characterSet_tooltip"));
        this._nameCharacterSetLbl.setLabelFor(this._nameCharacterSetLw);
        CommonUtils.setMnemonicAndAccelerator(this._nameCharacterSetLbl, NLSUtils.getNLSString("GN_nameCharacterSet_FlatFile"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, this._nameCharacterSetLw, 1, 3, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        ItemListener _nameCharacterSetListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSampleNamePanel.this.nameCharacterSetStateChanged();
                }
            }
        };
        this._nameCharacterSetLw.addItemListener(_nameCharacterSetListener);
        JLabel numRowsToProcessLabel = new JLabel(this.translate("NM_nameNumRowsToProcess_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(numRowsToProcessLabel, NLSUtils.getNLSString("NM_nameNumRowsToProcess_FlatFile"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, numRowsToProcessLabel, 0, 1, 1, 1, 0.0, 0.0, 17, 2, cmpInsets);
        this._numRowsToProcess = new NumberTextField(4);
        this._numRowsToProcess.setSigned(false);
        this._numRowsToProcess.setDecimal(false);
        numRowsToProcessLabel.setLabelFor((Component)this._numRowsToProcess);
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, (Component)this._numRowsToProcess, 1, 1, 1, 1, 0.3, 0.1, 17, 2, cmpInsets);
        this._numRowsToProcess.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleNamePanel.this.numberRowsChanged(FlatFileSampleNamePanel.this._numRowsToProcess.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleNamePanel.this.numberRowsChanged(FlatFileSampleNamePanel.this._numRowsToProcess.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this._numRowsToProcess.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        numRowsToProcessLabel.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        this._everythingCb = new JCheckBox(this.translate("sampleEverything_label"));
        this._everythingCb.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        CommonUtils.setMnemonicAndAccelerator(this._everythingCb, NLSUtils.getNLSString("sampleEverything_label"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, this._everythingCb, 2, 1, 1, 1, 0.3, 0.1, 17, 0, cmpInsets);
        this._everythingCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleNamePanel.this.sampleEverything(true);
                }
                if (2 == e.getStateChange()) {
                    FlatFileSampleNamePanel.this.sampleEverything(false);
                }
            }
        });
        JLabel numDataRowsToProcessLabel = new JLabel(this.translate("NM_nameNumDataRowsToProcess_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(numDataRowsToProcessLabel, NLSUtils.getNLSString("NM_nameNumDataRowsToProcess_FlatFile"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, numDataRowsToProcessLabel, 0, 2, 1, 1, 0.0, 0.0, 17, 2, cmpInsets);
        this._numDataRowsToProcess = new NumberTextField(4);
        this._numDataRowsToProcess.setSigned(false);
        this._numDataRowsToProcess.setDecimal(false);
        numDataRowsToProcessLabel.setLabelFor((Component)this._numDataRowsToProcess);
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, (Component)this._numDataRowsToProcess, 1, 2, 1, 1, 0.3, 0.1, 17, 2, cmpInsets);
        this._numDataRowsToProcess.setToolTipText(this.translate("NM_dataRowsToProcessToolTip"));
        numDataRowsToProcessLabel.setToolTipText(this.translate("NM_dataRowsToProcessToolTip"));
        this._allDataRowsCb = new JCheckBox(this.translate("sampleEverything_label"));
        this._allDataRowsCb.setToolTipText(this.translate("NM_rowsToSampleToolTip"));
        CommonUtils.setMnemonicAndAccelerator(this._allDataRowsCb, NLSUtils.getNLSString("sampleEverything_label"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, this._allDataRowsCb, 2, 2, 1, 1, 0.3, 0.1, 17, 0, cmpInsets);
        this._allDataRowsCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleNamePanel.this._numDataRowsToProcess.setEditable(false);
                }
                if (2 == e.getStateChange()) {
                    FlatFileSampleNamePanel.this._numDataRowsToProcess.setEditable(true);
                }
            }
        });
        this._allDataRowsCb.setSelected(true);
        this._numDataRowsToProcess.setEditable(false);
        JLabel numRowsToSkipLabel = new JLabel(this.translate("NM_fileOrgNumRowsToSkip_FlatFile"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, numRowsToSkipLabel, 0, 0, 1, 1, 0.2, 0.2, 17, 0, cmpInsets);
        this._numRowsToSkip = new NumericSpinBox(0, 1000);
        numRowsToSkipLabel.setLabelFor((Component)this._numRowsToSkip);
        numRowsToSkipLabel.setToolTipText(this.translate("NM_skipRowsTooltip"));
        ChangeListener skipRowsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FlatFileSampleNamePanel.this.skipRowsChanged(FlatFileSampleNamePanel.this._numRowsToSkip.getIntValue());
            }
        };
        CommonUtils.setMnemonicAndAccelerator(numRowsToSkipLabel, NLSUtils.getNLSString("NM_fileOrgNumRowsToSkip_FlatFile"));
        this._numRowsToSkip.addChangeListener(skipRowsListener);
        KeyAdapter skipRowsKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if (code == 10) {
                    e.consume();
                }
            }
        };
        this._numRowsToSkip.addKeyListener((KeyListener)skipRowsKeyListener);
        this._numRowsToSkip.setToolTipText(this.translate("NM_skipRowsTooltip"));
        FlatFileSampleNamePanel.addComponent(nameCharacterSetPanel, (Component)this._numRowsToSkip, 1, 0, 1, 1, 0.2, 0.2, 17, 0, cmpInsets);
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSampleNamePanel.addComponent(this, gizmoPanel, 0, 3, 0, 0, 1.0, 0.7, 18, 1, pnlInsets);
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        FlatFileSampleNamePanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, cmpInsets);
    }

    private void skipRowsChanged(int newNumber) {
        if (this._numRowsToSkipSave != newNumber) {
            if ((this.ff_info.isSingleInstance() || !this.ff_info.isMultiRecord()) && this.ff_info.useFirstRowAsFieldNames()) {
                this.ff_info.setSkipRecords(this.ff_info.getSkipRecords() - 1);
                this.ff_info.useFirstRowAsFieldNamesEdit(false);
                this.ff_info.useFirstRowAsFieldNames(false);
            }
            this._numRowsToSkipSave = newNumber;
            this.ff_info.setSkipRecords(this._numRowsToSkipSave);
            if (!this.ff_info.isEditingNXSD()) {
                this.ff_info.clearRecords();
            }
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void sampleEverything(boolean value) {
        this.ff_info.setSampleEverything(value);
        this._numRowsToProcess.setEditable(!value);
        if (!value) {
            this.numberRowsChanged(this._numRowsToProcess.getText());
        } else {
            this.ff_info.resyncToData();
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void numberRowsChanged(String newTxt) {
        int newInt = 0;
        if (newTxt != null && newTxt.length() != 0 && this._numRowsToProcessSave != (newInt = Integer.parseInt(newTxt))) {
            if ((this.ff_info.isSingleInstance() || !this.ff_info.isMultiRecord()) && this.ff_info.useFirstRowAsFieldNames()) {
                this.ff_info.setSkipRecords(this.ff_info.getSkipRecords() - 1);
                this.ff_info.useFirstRowAsFieldNamesEdit(false);
                this.ff_info.useFirstRowAsFieldNames(false);
            }
            if (newTxt != null && newTxt.length() != 0) {
                newInt = Integer.parseInt(newTxt);
            }
            this._numRowsToProcessSave = newInt;
            this.ff_info.setSampleRecords(this._numRowsToProcessSave);
            this.ff_info.resyncToData();
            this._dataGizmo.refreshContents(this.ff_info);
        }
    }

    private void showThisError(WizardPanelValidationException e) {
        e.showError(this.getParentFrame(), this);
    }

    private void handlePageAdvance() {
        String sampleFileName;
        String string = sampleFileName = this._nameFileStructureName.getText() != null ? this._nameFileStructureName.getText().trim() : "";
        if (sampleFileName.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._wp.setCanAdvance(true);
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._nameFileStructureName;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        FlatFileInfo ff_info = (FlatFileInfo)info;
        String fileName = this._nameFileStructureName.getText();
        if (!this._allDataRowsCb.isSelected() && !this._numDataRowsToProcess.getText().equals("")) {
            ff_info.setProcessRows(Integer.parseInt(this._numDataRowsToProcess.getText()));
        } else {
            ff_info.setProcessRows(0);
        }
        if (!ff_info.isEditingNXSD()) {
            ff_info.setNxsdEncoding(ff_info.getDefaultCoding());
        }
        try {
            ff_info.setFileStructureName(fileName);
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            this._nameFileStructureName.requestFocus();
            throw e;
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        int numprocessrows;
        int i;
        int i2;
        String sampleFileName;
        this.ff_info = (FlatFileInfo)info;
        DebugUtility.debug((Object)this.ff_info, " FlatFileSampleNamePanel initialize");
        String string = sampleFileName = this.ff_info.getFileStructureName() != null ? this.ff_info.getFileStructureName().trim() : "";
        if (sampleFileName.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._wp.setCanAdvance(true);
        }
        this._nameFileStructureName.setText(sampleFileName);
        if (this.ff_info.isEditingNXSD()) {
            this._nameFileStructureName.setEditable(false);
            this._fileBrowseButton.setEnabled(false);
        } else {
            this._nameFileStructureName.setEditable(true);
            this._fileBrowseButton.setEnabled(true);
        }
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("NM_nameTitle_FileDescr_FlatFile"));
        DebugUtility.debug(this.translate("NM_nameTitle_FileDescr_FlatFile").toUpperCase());
        ActionListener[] als = this._nameCharacterSetLw.getActionListeners();
        ItemListener[] ils = this._nameCharacterSetLw.getItemListeners();
        for (i2 = 0; i2 < als.length; ++i2) {
            this._nameCharacterSetLw.removeActionListener(als[i2]);
        }
        for (i2 = 0; i2 < ils.length; ++i2) {
            this._nameCharacterSetLw.removeItemListener(ils[i2]);
        }
        if (this._nameCharacterSetLw.getItemCount() == 0) {
            for (i2 = 0; i2 < this.ff_info.getCharacterSetList().length; ++i2) {
                String item = this.ff_info.getCharacterSetList()[i2];
                this._nameCharacterSetLw.addItem(item);
            }
        }
        String defaultCoding = this.ff_info.getDefaultCoding();
        this._nameCharacterSetLw.setSelectedItem(defaultCoding);
        for (i = 0; i < als.length; ++i) {
            this._nameCharacterSetLw.addActionListener(als[i]);
        }
        for (i = 0; i < ils.length; ++i) {
            this._nameCharacterSetLw.addItemListener(ils[i]);
        }
        this._numRowsToProcessSave = this.ff_info.getSampleRecords();
        if (!this.ff_info.isSampleEverything()) {
            this._numRowsToProcess.setNumber((Number)new Integer(this._numRowsToProcessSave));
        }
        if ((numprocessrows = this.ff_info.getProcessRows()) > 0) {
            this._numDataRowsToProcess.setNumber((Number)numprocessrows);
            this._allDataRowsCb.setSelected(false);
        }
        this._nameCharacterSetLw.invalidate();
        this._numRowsToSkipSave = this.ff_info.getSkipRecords();
        this._numRowsToSkip.setIntValue(this._numRowsToSkipSave);
        String fileName = this.ff_info.getFileStructureName();
        this._nameFileStructureName.setText(fileName);
        try {
            this._dataGizmo.refreshContents(this.ff_info);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void nameCharacterSetStateChanged() {
        this.ff_info.setDefaultCoding((String)this._nameCharacterSetLw.getSelectedItem());
        this.ff_info.clearRecords();
        this.ff_info.resyncToData();
        this._dataGizmo.refreshContents(this.ff_info);
    }
}

