/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.javatools.editor.BasicEditorPane;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NXSDTestDialog;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WhAlert;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;

public class FlatFileSampleNXSDPanel
extends WizardPanel
implements Observer {
    private static int _SEQ = 1;
    private FlatFileInfo _ff_info;
    private BasicEditorPane _textArea;
    private JScrollPane _JScrollPane;
    private JButton _saveButton;
    private JButton _testButton;
    private String _nxsdFileName;
    private String _nxsdString;
    private JTextField _optionalJustFileName;
    private JLabel _pathNameLabel;
    private MultiLineLabel _introLabel;
    private JLabel _fileNameLabel;
    private int _nxsdFileSeqSave = 0;
    private boolean m_schemaValidation = false;

    FlatFileSampleNXSDPanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 2);
        this._textArea = new BasicEditorPane();
        this._textArea.setLanguageSupport("dummy.xml");
        this._textArea.setBaseFont("Dialog", 11);
        this._JScrollPane = new JScrollPane((Component)this._textArea, 20, 30);
        JPanel nxsdPanel = new JPanel();
        nxsdPanel.setLayout(new GridBagLayout());
        this._introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("NX_nxsdIntro_FlatFile"));
        FlatFileSampleNXSDPanel.addComponent(this, (Component)this._introLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(3, 3, 3, 3));
        FlatFileSampleNXSDPanel.addComponent(this, nxsdPanel, 0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(1, 3, 3, 5));
        FlatFileSampleNXSDPanel.addComponent(nxsdPanel, this._JScrollPane, 0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(1, 3, 3, 5));
        this._saveButton = new JButton(this.translate("NX_title_SaveButton"));
        this._saveButton.setVisible(false);
        this._saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileDialog fd = new FileDialog(FlatFileSampleNXSDPanel.this.getParentFrame(), FlatFileSampleNXSDPanel.this.translate("NX_flatFileDialog_titleSaveNXSD"), 1);
                fd.setVisible(true);
                String fileName = fd.getFile();
                String directoryReturned = fd.getDirectory();
                if (directoryReturned != null && fileName != null) {
                    FlatFileSampleNXSDPanel.this.setNXSDFileInfo(directoryReturned, fileName);
                }
            }
        });
        this._testButton = new JButton(this.translate("CX_NXSDTestDialogFieldLabel_Test"));
        this._testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleNXSDPanel.this.launchTestDialog();
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._testButton, NLSUtils.getNLSString("CX_NXSDTestDialogFieldLabel_Test"));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        FlatFileSampleNXSDPanel.addComponent(nxsdPanel, buttonPanel, 0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 1, 1, 1));
        this._optionalJustFileName = new JTextField(40);
        this._pathNameLabel = new JLabel(this.translate("NX_nxsdJustFileName_label"));
        FlatFileSampleNXSDPanel.addComponent(buttonPanel, this._pathNameLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(1, 1, 1, 1));
        JPanel onlyFileNamePanel = new JPanel(new GridBagLayout());
        FlatFileSampleNXSDPanel.addComponent(buttonPanel, onlyFileNamePanel, 0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1));
        this._fileNameLabel = new JLabel(this.translate("NX_fileNameLabel"));
        CommonUtils.setMnemonicAndAccelerator(this._fileNameLabel, NLSUtils.getNLSString("NX_fileNameLabel"));
        this._fileNameLabel.setLabelFor(this._optionalJustFileName);
        FlatFileSampleNXSDPanel.addComponent(onlyFileNamePanel, this._fileNameLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0));
        FlatFileSampleNXSDPanel.addComponent(onlyFileNamePanel, this._optionalJustFileName, 1, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 1, 1));
        FlatFileSampleNXSDPanel.addComponent(buttonPanel, this._saveButton, 0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1));
        FlatFileSampleNXSDPanel.addComponent(buttonPanel, this._testButton, 0, 2, 1, 1, 1.0, 1.0, 13, 0, new Insets(1, 1, 1, 1));
    }

    private void setNXSDFileInfo(String directoryReturned, String fileName) {
        NxsdFileInfo nxsdFileInfo = this._ff_info.getFlatFileWizard().getNxsdFileInfo();
        if (nxsdFileInfo != null) {
            nxsdFileInfo._directoryName = directoryReturned;
            nxsdFileInfo._nxsdFileName = fileName;
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._optionalJustFileName;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        try {
            String newline;
            FlatFileInfo _ff_info = (FlatFileInfo)info;
            String modifiedNXSD = this._textArea.getText();
            String string = newline = System.getProperty("line.separator") != null ? System.getProperty("line.separator") : "";
            if (modifiedNXSD.indexOf(_ff_info.getFileStructureName()) == -1) {
                modifiedNXSD = modifiedNXSD + newline + "<!--NXSDWIZ:" + _ff_info.getFileStructureName() + ":-->";
                modifiedNXSD = modifiedNXSD + newline + "<!--USE-HEADER:" + _ff_info.useFirstRowAsFieldNames() + ":-->";
            }
            String defaultEncoding = _ff_info.getDefaultCoding();
            defaultEncoding = "UTF-8";
            String newEncoding = CommonUtils.getNewEncoding(modifiedNXSD);
            _ff_info.setNxsdEncoding(newEncoding);
            try {
                if (!newEncoding.equals(defaultEncoding)) {
                    // empty if block
                }
                StringReader nxsdReader = new StringReader(modifiedNXSD);
                XMLSchema tryBuildingSchema = new XSDBuilder().build((Reader)nxsdReader, null);
            }
            catch (XSDException e) {
                newline = System.getProperty("line.separator");
                String msg = e.getMessage();
                if (newline != null) {
                    msg = newline + newline + msg;
                }
                if (this.m_schemaValidation) {
                    throw new FlatFileValidationException(this.translate("NX_xsdInvalidAfterEdit_API40", new String[]{msg}));
                }
                System.out.println("ERROR: Please correct the generated schema as it is invalid. " + msg);
            }
            _ff_info.setModifiedNXSD(modifiedNXSD);
            String optionalNxsdFileName = this._optionalJustFileName.getText();
            try {
                optionalNxsdFileName = URLEncoder.encode(optionalNxsdFileName, "UTF-8").replaceAll("%", "-");
            }
            catch (Exception ex) {
                // empty catch block
            }
            String directory = _ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
            if (directory == null || directory.trim().equals("")) {
                throw new FlatFileValidationException(this.translate("NX_standaloneCaseFileNameNotSpecified_API47"));
            }
            if (optionalNxsdFileName != null && !optionalNxsdFileName.trim().equals("")) {
                this.validateNxsdFileName(optionalNxsdFileName);
                String completeFileName = directory + File.separator + optionalNxsdFileName;
                if (new File(completeFileName).exists()) {
                    WhAlert alert = new WhAlert((Dialog)CommonUtils.getParentFrameOrDialog(this), this.translate("NX_fileExists_warn", new String[]{completeFileName}), 2, 24);
                    alert.setCenterOver((Dialog)CommonUtils.getParentFrameOrDialog(this));
                    alert.setTitle(this.translate("GN_warning_title"));
                    switch (alert.runAlert()) {
                        case 8: {
                            break;
                        }
                        case 16: {
                            throw new FlatFileValidationException(this.translate("NX_fileExists_inform"));
                        }
                    }
                }
                _ff_info.getFlatFileWizard().getNxsdFileInfo()._nxsdFileName = optionalNxsdFileName;
            }
        }
        catch (FlatFileValidationException fe) {
            fe.showError(f, this);
            throw fe;
        }
    }

    private void validateNxsdFileName(String relativeFileName) throws FlatFileValidationException {
        String slashStyle = File.separator;
        int slashPos = relativeFileName.indexOf(slashStyle);
        if (slashPos == -1) {
            slashStyle = slashStyle.equals("\\") ? "/" : "\\";
            slashPos = relativeFileName.indexOf(slashStyle);
        }
        if (slashPos != -1) {
            String msg = this.translate("NX_invalidNxsdFileName_API3", new String[]{relativeFileName});
            throw new FlatFileValidationException(msg);
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        String simpleString;
        this._ff_info = (FlatFileInfo)info;
        if (this._ff_info.isDTD()) {
            this._testButton.setEnabled(false);
        }
        FlatFileWizard ffWizard = this._ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("NX_nxsdPageTitle_FlatFile"));
        DebugUtility.debug(this.translate("NX_nxsdPageTitle_FlatFile").toUpperCase());
        this._nxsdString = simpleString = this._ff_info.getModifiedNXSD();
        this._textArea.setText(this._nxsdString);
        String directory = "";
        NxsdFileInfo nxsdFileInfo = this._ff_info.getFlatFileWizard().getNxsdFileInfo();
        if (nxsdFileInfo._dtdOnly) {
            this._introLabel.setText(this.translate("NX_nxsdIntro_FlatFile_dtdOnly"));
        }
        if (nxsdFileInfo != null && nxsdFileInfo._directoryName != null && !nxsdFileInfo._directoryName.trim().equals("")) {
            directory = nxsdFileInfo._directoryName;
            String displayPath = "";
            if (directory != null) {
                displayPath = CommonUtils.shortenLongPath(directory);
            }
            if (nxsdFileInfo._dtdOnly) {
                this._pathNameLabel.setText(this.translate("NX_nxsdJustFileName_label_dtdOnly", new String[]{displayPath}));
                this._pathNameLabel.setToolTipText(this.translate("NX_nxsdJustFileName_label_dtdOnly", new String[]{directory}));
            } else {
                this._pathNameLabel.setText(this.translate("NX_nxsdJustFileName_label", new String[]{displayPath}));
                this._pathNameLabel.setToolTipText(this.translate("NX_nxsdJustFileName_label", new String[]{directory}));
            }
            String fileName = this._ff_info.getFlatFileWizard().getNxsdFileInfo()._nxsdFileName;
            if (fileName == null || fileName.equals("")) {
                fileName = this._ff_info.getFileStructureName();
                File file = new File(fileName);
                int dotIndex = (fileName = file.getName()).lastIndexOf(".");
                if (dotIndex != -1) {
                    fileName = fileName.substring(0, dotIndex);
                }
                String fileNameSave = fileName;
                if (this._nxsdFileSeqSave == 0) {
                    this._nxsdFileSeqSave = this.getNextSeq();
                }
                fileName = fileName + "_" + this._nxsdFileSeqSave + ".xsd";
                String completeFileName = directory + File.separator + fileName;
                while (new File(completeFileName).exists()) {
                    this._nxsdFileSeqSave = this.getNextSeq();
                    fileName = fileNameSave + "_" + this._nxsdFileSeqSave + ".xsd";
                    completeFileName = directory + File.separator + fileName;
                }
            } else {
                int dot;
                int slash = fileName.lastIndexOf(File.separator);
                if (slash != -1) {
                    fileName = fileName.substring(slash + 1);
                }
                if ((dot = fileName.lastIndexOf(".")) == -1) {
                    fileName = fileName + ".xsd";
                }
            }
            try {
                this._optionalJustFileName.setText(URLEncoder.encode(fileName, "UTF-8").replaceAll("%", "-"));
            }
            catch (Exception ex) {}
        } else if (directory == null || directory.trim().equals("")) {
            this._saveButton.setVisible(true);
            this._pathNameLabel.setVisible(false);
            this._optionalJustFileName.setVisible(false);
            this._pathNameLabel.setVisible(false);
            this._fileNameLabel.setVisible(false);
        }
    }

    private synchronized int getNextSeq() {
        return _SEQ++;
    }

    private void launchTestDialog() {
        NXSDTestDialog testDialog = new NXSDTestDialog(UIHelper.getFrame((Component)this));
        testDialog.display(this._ff_info, this._textArea.getText());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof FlatFileInfo) {
            String simpleString;
            this._nxsdString = simpleString = ((FlatFileInfo)o).getModifiedNXSD();
            this._textArea.setText(this._nxsdString);
        }
    }
}

