/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;

public class FlatFileSampleFinishPanel
extends WizardPanel {
    private static int _SEQ = 1;
    private FlatFileInfo _ff_info;
    private String _nxsdFileName;
    private MultiLineLabel _informLabel;
    private MultiLineLabel _introLabel;

    FlatFileSampleFinishPanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        wp.setLabel(this.translate("FN_finishTitle_FlatFile"));
        this.setLayout(new GridBagLayout());
        JPanel finishPanel = new JPanel(new GridBagLayout());
        FlatFileSampleFinishPanel.addComponent(this, finishPanel, 0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(3, 3, 3, 3));
        this._introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("FN_finishIntro_FlatFile"));
        Font currentFont = new Font("SansSerif", 0, 18);
        this._introLabel.setFont(currentFont);
        FlatFileSampleFinishPanel.addComponent(finishPanel, (Component)this._introLabel, 0, 0, 1, 1, 1.0, 0.7, 18, 2, new Insets(3, 3, 3, 3));
        this._informLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("FN_informUser_savedNxsd", new String[]{"", ""}));
        FlatFileSampleFinishPanel.addComponent(finishPanel, (Component)this._informLabel, 0, 1, 1, 1, 0.0, 0.3, 18, 1, new Insets(3, 3, 3, 3));
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._informLabel;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        FlatFileInfo _ff_info = (FlatFileInfo)info;
        this.saveNXSD();
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        this._ff_info = (FlatFileInfo)info;
        String directory = "";
        NxsdFileInfo nxsdFileInfo = this._ff_info.getFlatFileWizard().getNxsdFileInfo();
        DebugUtility.debug("Finish Page".toUpperCase());
        if (nxsdFileInfo._dtdOnly) {
            this._introLabel.setText(this.translate("FN_finishIntro_FlatFile_dtdOnly"));
        }
        directory = nxsdFileInfo._directoryName;
        String fileName = this._ff_info.getFlatFileWizard().getNxsdFileInfo()._nxsdFileName;
        if (fileName == null || fileName.equals("")) {
            int dotIndex;
            fileName = this._ff_info.getFileStructureName();
            int index = fileName.lastIndexOf(System.getProperty("file.separator"));
            if (index != -1) {
                fileName = fileName.substring(index + 1);
            }
            if ((dotIndex = fileName.lastIndexOf(".")) != -1) {
                fileName = fileName.substring(0, dotIndex);
            }
            fileName = fileName + "_" + this.getNextSeq() + ".xsd";
        } else {
            int dot;
            int slash = fileName.lastIndexOf(File.separator);
            if (slash != -1) {
                fileName = fileName.substring(slash + 1);
            }
            if ((dot = fileName.lastIndexOf(".")) == -1) {
                fileName = fileName + ".xsd";
            }
        }
        this._nxsdFileName = fileName;
        String label = "";
        String toolTipLabel = "";
        String displayPath = "";
        if (directory != null) {
            displayPath = CommonUtils.shortenLongPath(directory);
        }
        if (nxsdFileInfo._dtdOnly) {
            label = this.translate("FN_informUser_savedNxsd_dtdOnly", new String[]{fileName, displayPath});
            toolTipLabel = this.translate("FN_informUser_savedNxsd_dtdOnly", new String[]{fileName, directory});
        } else {
            label = this.translate("FN_informUser_savedNxsd", new String[]{fileName, displayPath});
            toolTipLabel = this.translate("FN_informUser_savedNxsd", new String[]{fileName, directory});
        }
        this._informLabel.setText(label);
        this._informLabel.setToolTipText(toolTipLabel);
    }

    private synchronized int getNextSeq() {
        return _SEQ++;
    }

    private void saveNXSD() {
        NxsdFileInfo nxsdFileInfo = this._ff_info.getFlatFileWizard().getNxsdFileInfo();
        String directory = nxsdFileInfo._directoryName;
        String completeFileName = directory + System.getProperty("file.separator") + this._nxsdFileName;
        this._ff_info.setNXSDFileName(completeFileName);
        nxsdFileInfo._nxsdFileName = this._nxsdFileName;
        nxsdFileInfo._isNxsdRelative = true;
        this.saveNXSD(completeFileName);
    }

    private boolean saveNXSD(String fileUri) {
        String simpleString = this._ff_info.getModifiedNXSD();
        String encoding = this._ff_info.getNxsdEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        boolean success = false;
        try {
            FileOutputStream out_stream = new FileOutputStream(fileUri);
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)out_stream, encoding);
            BufferedWriter writer = new BufferedWriter(outWriter);
            writer.write(simpleString);
            writer.flush();
            writer.close();
            outWriter.close();
            out_stream.close();
            success = true;
        }
        catch (Exception e) {
            DebugUtility.debug("FinishPanel: saveNXSD path: " + fileUri + " " + e.getMessage());
        }
        return success;
    }
}

