/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDelimitedAttribPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleFileFormatDefinitionPanel
extends WizardPanel {
    private FlatFileInfo ff_info;
    private JLabel _recordEndAtLabel;
    private JComboBox _recordEndAt;
    private String _recordEndAtSave;
    private FlatFileDisplayGizmo _dataGizmo;
    private JPanel _delimitedAttribPanel;
    private FlatFileDelimitedAttribPanel _delim_attribs;
    private WizardPage _wp;

    FlatFileSampleFileFormatDefinitionPanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 0);
        JPanel delimited_panel = new JPanel();
        delimited_panel.setLayout(new GridBagLayout());
        FlatFileSampleFileFormatDefinitionPanel.addComponent(this, delimited_panel, 0, 0, 1, 1, 1.0, 0.0, 17, 0, pnlInsets);
        this._recordEndAtLabel = new JLabel(this.translate("DA_recOrgRecordsEndAt_FlatFile"));
        this._recordEndAt = new JComboBox();
        this._recordEndAt.setEditable(true);
        this._recordEndAtLabel.setLabelFor(this._recordEndAt);
        this._recordEndAt.addItem(this.translate("FD_RecordTerminatorEOL_FlatFile"));
        this._recordEndAt.addItem(this.translate("FD_RecordTerminatorEOF_FlatFile"));
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridBagLayout());
        CommonUtils.setMnemonicAndAccelerator(this._recordEndAtLabel, NLSUtils.getNLSString("DA_recOrgRecordsEndAt_FlatFile"));
        FlatFileSampleFileFormatDefinitionPanel.addComponent(innerPanel, this._recordEndAtLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 3, 2));
        FlatFileSampleFileFormatDefinitionPanel.addComponent(innerPanel, this._recordEndAt, 1, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 3, 3, 3));
        ItemListener recordEndAtChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSampleFileFormatDefinitionPanel.this.recordEndAtChanged((String)FlatFileSampleFileFormatDefinitionPanel.this._recordEndAt.getSelectedItem());
                }
            }
        };
        this._recordEndAt.addItemListener(recordEndAtChangedListener);
        KeyAdapter recordEndAtListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 10 || code == 9) && code == 10) {
                    e.consume();
                }
            }
        };
        this._recordEndAt.addKeyListener(recordEndAtListener);
        FlatFileSampleFileFormatDefinitionPanel.addComponent(delimited_panel, innerPanel, 0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 3, 3, 3));
        this._delim_attribs = new FlatFileDelimitedAttribPanel(this.getTranslatable(), wp);
        this._delim_attribs.initWizardLayout();
        FlatFileSampleFileFormatDefinitionPanel.addComponent(this, this._delim_attribs, 0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 3, 3, 3));
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSampleFileFormatDefinitionPanel.addComponent(this, gizmoPanel, 0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(30, 3, 3, 3));
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        FlatFileSampleFileFormatDefinitionPanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, cmpInsets);
    }

    private void recordEndAtChanged(String newTxt) {
        if (newTxt.equals(this.translate("FD_RecordTerminatorEOL_FlatFile"))) {
            newTxt = "\\n";
            this.ff_info.setRecordTerminatorEOL(true);
        } else if (newTxt.equals(this.translate("FD_RecordTerminatorEOF_FlatFile"))) {
            newTxt = "\\n";
            this.ff_info.setRecordTerminatorEOL(false);
        }
        if (this._recordEndAtSave != newTxt) {
            this._recordEndAtSave = newTxt;
            this.addValueToComboBox(this._recordEndAt, this._recordEndAtSave);
            this.ff_info.isRecordSize(false);
            this.ff_info.setRecordTerminator(this._recordEndAtSave);
            this.ff_info.clearRecords();
            this._dataGizmo.refreshContents(this.ff_info);
        }
        this.ff_info.updateLastFieldTerminator(null);
    }

    private void addValueToComboBox(JComboBox comboBox, String newValue) {
        boolean found = false;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (newValue.equals("\\n") || newValue.equals("\\r\\n")) {
                found = true;
                break;
            }
            if (newValue.compareTo(comboBox.getItemAt(i).toString()) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            comboBox.addItem(newValue);
            ItemListener[] ils = CommonUtils.removeComboItemListener(comboBox);
            comboBox.setSelectedItem(newValue);
            CommonUtils.addComboItemListener(comboBox, ils);
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._recordEndAt;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        FlatFileInfo ff_info = (FlatFileInfo)info;
        try {
            if (ff_info.isDelimitedFile()) {
                this._delim_attribs.validatePanel();
            }
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            this._delim_attribs.requestFocusOnDelimiter();
            throw e;
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_setup";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        this.ff_info = (FlatFileInfo)info;
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("FD_formatDefPageTitle_FlatFile"));
        DebugUtility.debug(this.translate("FD_formatDefPageTitle_FlatFile").toUpperCase());
        if (!this.ff_info.isSingleInstance()) {
            ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordEndAt);
            this._recordEndAtLabel.setVisible(true);
            this._recordEndAt.setVisible(true);
            String recordTerminator = this.ff_info.getRecordTerminator();
            if (this.ff_info.isEditingNXSD() && !recordTerminator.equals("\\n") && !recordTerminator.equals("\\r\\n")) {
                this._recordEndAt.addItem(recordTerminator);
            }
            if (recordTerminator.equals("\\n") || recordTerminator.equals("\\r\\n")) {
                if (this.ff_info.isRecordTerminatorEOL()) {
                    this._recordEndAt.setSelectedItem(this.translate("FD_RecordTerminatorEOL_FlatFile"));
                } else {
                    this._recordEndAt.setSelectedItem(this.translate("FD_RecordTerminatorEOF_FlatFile"));
                }
            } else {
                this._recordEndAt.setSelectedItem(recordTerminator);
            }
            CommonUtils.addComboItemListener(this._recordEndAt, ils);
        } else {
            this._recordEndAtLabel.setVisible(false);
            this._recordEndAt.setVisible(false);
        }
        if (this.ff_info.isDelimitedFile()) {
            this.delimitedAttribsSetEnabled(true);
        } else {
            this.delimitedAttribsSetEnabled(false);
        }
        this._delim_attribs.initializeFrom(this.ff_info);
        this._delim_attribs.setDataGizmo(this._dataGizmo);
        this._dataGizmo.refreshContents(this.ff_info);
    }

    private JPanel createDelimitedAttribPanel() {
        JPanel attrib_panel = new JPanel();
        attrib_panel.setLayout(new GridBagLayout());
        Insets stdInsets = new Insets(1, 1, 2, 3);
        this._delim_attribs = new FlatFileDelimitedAttribPanel(this.getTranslatable(), this._wp);
        this._delim_attribs.initWizardLayout();
        FlatFileSampleFileFormatDefinitionPanel.addComponent(attrib_panel, this._delim_attribs, 0, 0, 1, 1, 0.0, 0.0, 17, 2, stdInsets);
        return attrib_panel;
    }

    private void delimitedAttribsSetEnabled(boolean enabled) {
        this._delim_attribs.setAttributesEnabled(enabled);
        this.validate();
    }
}

