/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.common.ui.NCNameField;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleElementPanel
extends WizardPanel {
    private JLabel _namespaceLabel;
    private JTextField _namespaceField;
    private JLabel _descriptionLabel;
    private JLabel _singleTypeLabel;
    private NCNameField _singleTypeField;
    private JLabel _containerNameLabel;
    private NCNameField _containerNameField;
    WizardPage _wp;
    private FlatFileDisplayGizmo _dataGizmo;
    private FlatFileInfo _ff_info;

    FlatFileSampleElementPanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 10, 0, 3);
        JLabel screenLbl = new JLabel(this.translate("EP_screenDescription_label"));
        FlatFileSampleElementPanel.addComponent(this, screenLbl, 0, 0, 1, 1, 0.0, 0.0, 18, 0, insets);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        FlatFileSampleElementPanel.addComponent(this, panel, 0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(1, 1, 0, 3));
        JPanel namespacePanel = new JPanel();
        namespacePanel.setLayout(new GridBagLayout());
        FlatFileSampleElementPanel.addComponent(panel, namespacePanel, 0, 0, 1, 1, 1.0, 1.0, 18, 2, insets);
        this._namespaceLabel = new JLabel(this.translate("GN_namespace_label"));
        CommonUtils.setMnemonicAndAccelerator(this._namespaceLabel, NLSUtils.getNLSString("GN_namespace_label"));
        this._namespaceLabel.setToolTipText(this.translate("FO_namespaceSample_TooTip"));
        FlatFileSampleElementPanel.addComponent(namespacePanel, this._namespaceLabel, 0, 0, 1, 1, 0.0, 0.0, 17, 0, insets);
        this._namespaceField = new JTextField(40);
        this._namespaceLabel.setLabelFor(this._namespaceField);
        FlatFileSampleElementPanel.addComponent(namespacePanel, this._namespaceField, 1, 0, 1, 1, 1.0, 0.0, 17, 1, insets);
        this._namespaceField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }
        });
        this._namespaceField.setToolTipText(this.translate("FO_namespaceSample_TooTip"));
        String label = this.translate("EP_describeElementLabel");
        this._descriptionLabel = new JLabel(label);
        FlatFileSampleElementPanel.addComponent(panel, this._descriptionLabel, 0, 1, 1, 1, 1.0, 1.0, 18, 2, insets);
        JPanel elementPanel = new JPanel();
        elementPanel.setLayout(new GridBagLayout());
        FlatFileSampleElementPanel.addComponent(panel, elementPanel, 0, 2, 1, 1, 1.0, 1.0, 18, 2, insets);
        this._containerNameLabel = new JLabel(this.translate("FO_multiRecordContainer_label"));
        CommonUtils.setMnemonicAndAccelerator(this._containerNameLabel, NLSUtils.getNLSString("FO_multiRecordContainer_label"));
        FlatFileSampleElementPanel.addComponent(elementPanel, this._containerNameLabel, 0, 0, 1, 1, 0.0, 0.0, 18, 0, insets);
        this._containerNameField = new NCNameField(40);
        this._containerNameLabel.setToolTipText(this.translate("EP_containerName_tooltip"));
        this._containerNameField.setToolTipText(this.translate("EP_containerName_tooltip"));
        this._containerNameLabel.setLabelFor((Component)this._containerNameField);
        FlatFileSampleElementPanel.addComponent(elementPanel, (Component)this._containerNameField, 1, 0, 1, 1, 1.0, 0.0, 17, 1, insets);
        this._containerNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }
        });
        this._singleTypeLabel = new JLabel(this.translate("FO_fileRecordOrgMultiple_recordNameLbl"));
        CommonUtils.setMnemonicAndAccelerator(this._singleTypeLabel, NLSUtils.getNLSString("FO_fileRecordOrgMultiple_recordNameLbl"));
        FlatFileSampleElementPanel.addComponent(elementPanel, this._singleTypeLabel, 0, 1, 1, 1, 0.0, 0.0, 18, 0, insets);
        this._singleTypeField = new NCNameField(40);
        this._singleTypeLabel.setToolTipText(this.translate("EP_elementName_tooltip"));
        this._singleTypeField.setToolTipText(this.translate("EP_elementName_tooltip"));
        this._singleTypeLabel.setLabelFor((Component)this._singleTypeField);
        FlatFileSampleElementPanel.addComponent(elementPanel, (Component)this._singleTypeField, 1, 1, 1, 1, 1.0, 0.0, 17, 1, insets);
        this._singleTypeField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleElementPanel.this.handlePageAdvance();
            }
        });
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSampleElementPanel.addComponent(this, gizmoPanel, 0, 2, 0, 0, 1.0, 1.0, 18, 1, new Insets(10, 3, 3, 3));
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        FlatFileSampleElementPanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, insets);
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._namespaceField;
    }

    private void handlePageAdvance() {
        String containerName = "";
        String elementName = "";
        String namespace = this._namespaceField.getText().trim();
        boolean allowAdvance = false;
        if (this._ff_info.isSingleInstance()) {
            elementName = this._singleTypeField.getText().trim();
            allowAdvance = !elementName.equals("") && !namespace.equals("");
        } else {
            containerName = this._containerNameField.getText().trim();
            allowAdvance = this._ff_info.isMultiRecord() ? !containerName.equals("") && !namespace.equals("") : !(elementName = this._singleTypeField.getText().trim()).equals("") && !containerName.equals("") && !namespace.equals("");
        }
        if (allowAdvance) {
            this._wp.setCanAdvance(true);
        } else {
            this._wp.setCanAdvance(false);
        }
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        this._ff_info = (FlatFileInfo)info;
        try {
            String namespace;
            String string = namespace = this._namespaceField.getText() != null ? this._namespaceField.getText().trim() : "";
            if (namespace.lastIndexOf("/") == namespace.length() - 1) {
                namespace = namespace.substring(0, namespace.length() - 1);
            }
            if (namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions") || namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd")) {
                throw new FlatFileValidationException(this.translate("EP_Invalid_namespace_API44", new String[]{namespace}));
            }
            this._ff_info.setNamespace(namespace);
            if (this._ff_info.isSingleInstance()) {
                String recordName = this._singleTypeField.getText();
                if (recordName == null || recordName.trim().equals("")) {
                    throw new FlatFileValidationException(this.translate("FO_recNameMissingOneRec_API4"));
                }
                this._ff_info.setSingleRecordName(this._singleTypeField.getText());
            } else {
                String rootElement = this._containerNameField.getText();
                if (rootElement == null || rootElement.trim().equals("")) {
                    throw new FlatFileValidationException(this.translate("FO_recNameMissingMultipleRec_API5"));
                }
                this._ff_info.setRootElement(rootElement);
                if (!this._ff_info.isMultiRecord()) {
                    String recordName = this._singleTypeField.getText();
                    if (recordName == null || recordName.trim().equals("")) {
                        throw new FlatFileValidationException(this.translate("FO_recNameMissingSingleTypeRec_API6"));
                    }
                    this._ff_info.setSingleRecordName(recordName);
                }
            }
        }
        catch (FlatFileValidationException fe) {
            fe.showError(f, this);
            if (this._ff_info.isSingleInstance()) {
                this._singleTypeField.requestFocus();
            } else {
                String rootElement = this._containerNameField.getText();
                if (rootElement == null || rootElement.trim().equals("")) {
                    this._containerNameField.requestFocus();
                } else if (!this._ff_info.isMultiRecord()) {
                    this._singleTypeField.requestFocus();
                }
            }
            throw fe;
        }
    }

    @Override
    public String getHelpTopicName() {
        return "";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        String prevNS;
        this._ff_info = (FlatFileInfo)info;
        FlatFileWizard ffWizard = this._ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("EP_elementNames_FlatFile"));
        DebugUtility.debug(this.translate("EP_elementNames_FlatFile").toUpperCase());
        String string = prevNS = this._ff_info.getNamespace() != null ? this._ff_info.getNamespace().trim() : "";
        if (prevNS.equals("")) {
            NxsdFileInfo nxsdFileInfo = ffWizard.getNxsdFileInfo();
            String serviceName = nxsdFileInfo._serviceName;
            try {
                if (serviceName != null) {
                    serviceName = URLEncoder.encode(serviceName, "UTF8");
                    serviceName = serviceName.replace('%', '-');
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            prevNS = "http://TargetNamespace.com/ServiceName";
            if (serviceName != null && !serviceName.equals("")) {
                prevNS = prevNS.replaceAll("ServiceName", serviceName);
            }
            this._namespaceField.setText(prevNS);
        } else {
            this._namespaceField.setText(prevNS);
        }
        if (this._ff_info.isSingleInstance()) {
            String prevSingleRoot;
            String string2 = prevSingleRoot = this._ff_info.getSingleRecordName() != null ? this._ff_info.getSingleRecordName().trim() : "";
            if (!prevSingleRoot.equals("")) {
                this._singleTypeField.setText(prevSingleRoot);
                wp.setCanAdvance(true);
            } else {
                this._singleTypeField.setText("");
                wp.setCanAdvance(false);
            }
            this._containerNameLabel.setVisible(false);
            this._containerNameField.setVisible(false);
            this._singleTypeLabel.setVisible(true);
            this._singleTypeField.setVisible(true);
        } else {
            String prevContainer;
            this._containerNameLabel.setVisible(true);
            this._containerNameField.setVisible(true);
            String string3 = prevContainer = this._ff_info.getRootElement() != null ? this._ff_info.getRootElement().trim() : "";
            if (prevContainer.trim().equals("")) {
                this._containerNameField.setText(this.translate("GN_containerNameDefault"));
            } else {
                this._containerNameField.setText(prevContainer);
            }
            if (this._ff_info.isMultiRecord()) {
                this._singleTypeField.setVisible(false);
                this._singleTypeLabel.setVisible(false);
                wp.setCanAdvance(true);
            } else {
                this._singleTypeField.setVisible(true);
                this._singleTypeLabel.setVisible(true);
                String prevSingleRoot = this._ff_info.getSingleRecordName() != null ? this._ff_info.getSingleRecordName().trim() : "";
                this._singleTypeField.setText(prevSingleRoot);
                if (!prevSingleRoot.trim().equals("")) {
                    wp.setCanAdvance(true);
                } else {
                    wp.setCanAdvance(false);
                }
            }
        }
        this._dataGizmo.refreshContents(this._ff_info);
    }
}

