/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.sql.Connection;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.DtdInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.apps.common.metadata.SelectedCols;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import org.w3c.dom.NamedNodeMap;

public class FlatFileSampleDTDDescriptionPanel
extends WizardPanel {
    private FlatFileInfo ff_info;
    private MultiLineLabel _nameFileNameIntro;
    private JLabel _nameFileStructureNameLbl;
    private JLabel _nameFileStructureNameAppsLbl;
    private JTextField _nameFileStructureName;
    private JButton _fileBrowseButton;
    private JLabel _namespaceLbl;
    private JTextField _nameNamespaceField;
    private JLabel _nameRootElementLbl;
    private WizardPage _wp;
    private DtdInfo dtdinfo;
    private boolean isIRepEnabled = false;
    private JComboBox _nameRootElementChoice;
    private FlatFileDisplayGizmo _dataGizmo;

    FlatFileSampleDTDDescriptionPanel(WBTranslatable h) {
        super(h);
    }

    FlatFileSampleDTDDescriptionPanel(WBTranslatable h, DtdInfo dtdInfo) {
        super(h);
        this.dtdinfo = dtdInfo;
        this.isIRepEnabled = true;
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(2, 5, 2, 0);
        JPanel nameFileNamePanel = new JPanel();
        nameFileNamePanel.setLayout(new GridBagLayout());
        this._nameFileNameIntro = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("DT_nameIntro_DTDFile"));
        FlatFileSampleDTDDescriptionPanel.addComponent(this, (Component)this._nameFileNameIntro, 0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 3, 3, 3));
        this._nameFileStructureNameLbl = new JLabel(this.translate("GN_nameFileStructureName_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._nameFileStructureNameLbl, NLSUtils.getNLSString("GN_nameFileStructureName_FlatFile"));
        this._nameFileStructureName = new JTextField();
        int fieldWidth = new Float(240.0).intValue();
        this._nameFileStructureName.setPreferredSize(new Dimension(fieldWidth, 20));
        this._nameFileStructureName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
            }
        });
        this._nameFileStructureName.setEditable(false);
        this._nameFileStructureName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                String fileName = FlatFileSampleDTDDescriptionPanel.this._nameFileStructureName.getText();
                if (fileName == null || fileName.equals("") || FlatFileSampleDTDDescriptionPanel.this.ff_info.getFileStructureName().equals(fileName)) {
                    return;
                }
                try {
                    FlatFileSampleDTDDescriptionPanel.this.ff_info.setFileStructureName(fileName);
                    FlatFileSampleDTDDescriptionPanel.this.populateRootElementChoice();
                    FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
                }
                catch (FlatFileValidationException ex) {
                    FlatFileSampleDTDDescriptionPanel.this.showThisError(ex);
                }
                FlatFileSampleDTDDescriptionPanel.this.initializeFrom(FlatFileSampleDTDDescriptionPanel.this.ff_info);
            }
        });
        this._nameFileStructureNameLbl.setLabelFor(this._nameFileStructureName);
        this._fileBrowseButton = new JButton(this.translate("GN_browseButton"));
        this._fileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Connection connection = ((FlatFileSampleDTDDescriptionPanel)FlatFileSampleDTDDescriptionPanel.this).ff_info.getFlatFileWizard().getNxsdFileInfo()._connection;
                if (connection != null) {
                    SelectedCols selectedCol = new SelectedCols();
                    DtdInfo dtdInfo = selectedCol.getDtdInfo();
                    if (dtdInfo == null) {
                        return;
                    }
                    String dtdname = dtdInfo.fileName;
                    StringBuffer dtdbuf = new StringBuffer(dtdInfo.payload);
                    FlatFileSampleDTDDescriptionPanel.this.populateRootElementChoiceAppsDTD(dtdbuf);
                    FlatFileSampleDTDDescriptionPanel.this.ff_info.setAppsDTD(dtdbuf);
                    try {
                        FlatFileSampleDTDDescriptionPanel.this.ff_info.setFileStructureName(dtdname);
                    }
                    catch (FlatFileValidationException ep) {
                        ep.printStackTrace();
                    }
                    FlatFileSampleDTDDescriptionPanel.this._nameFileStructureName.setText(dtdname);
                    FlatFileSampleDTDDescriptionPanel.this._nameRootElementChoice.setSelectedItem(dtdInfo.rootElement);
                    FlatFileSampleDTDDescriptionPanel.this._dataGizmo.refreshContents(FlatFileSampleDTDDescriptionPanel.this.ff_info);
                    FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
                } else {
                    String prjDir = ((FlatFileSampleDTDDescriptionPanel)FlatFileSampleDTDDescriptionPanel.this).ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                    if (prjDir == null) {
                        prjDir = "";
                    }
                    JFileChooser chooser = new JFileChooser(prjDir);
                    chooser.setDialogTitle(FlatFileSampleDTDDescriptionPanel.this.translate("DT_dtdFileDialog_title"));
                    int returnVal = chooser.showOpenDialog(FlatFileSampleDTDDescriptionPanel.this.getParentFrame());
                    String fileName = "";
                    String directory = "";
                    if (returnVal != 0) {
                        return;
                    }
                    fileName = chooser.getSelectedFile().getName();
                    directory = chooser.getSelectedFile().getParent() + File.separator;
                    if (directory != null && fileName != null) {
                        FlatFileSampleDTDDescriptionPanel.this._nameFileStructureName.setText(directory + fileName);
                        try {
                            FlatFileSampleDTDDescriptionPanel.this.ff_info.setFileStructureName(directory + fileName);
                            FlatFileSampleDTDDescriptionPanel.this.populateRootElementChoice();
                            FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
                        }
                        catch (FlatFileValidationException ex) {
                            FlatFileSampleDTDDescriptionPanel.this.showThisError(ex);
                        }
                        FlatFileSampleDTDDescriptionPanel.this.initializeFrom(FlatFileSampleDTDDescriptionPanel.this.ff_info);
                    }
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileBrowseButton, NLSUtils.getNLSString("GN_browseButton"));
        this._nameFileStructureNameAppsLbl = new JLabel(this.translate("DT_appsDTDLabel"));
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._nameFileStructureNameAppsLbl, 0, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        this._nameFileStructureNameAppsLbl.setVisible(false);
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._nameFileStructureNameLbl, 0, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._nameFileStructureName, 1, 0, 1, 1, 1.0, 0.0, 17, 2, cmpInsets);
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._fileBrowseButton, 2, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        this._namespaceLbl = new JLabel(this.translate("GN_namespace_label"));
        CommonUtils.setMnemonicAndAccelerator(this._namespaceLbl, NLSUtils.getNLSString("GN_namespace_label"));
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._namespaceLbl, 0, 1, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameNamespaceField = new JTextField();
        fieldWidth = new Float(240.0).intValue();
        this._nameNamespaceField.setPreferredSize(new Dimension(fieldWidth, 20));
        this._nameNamespaceField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
            }
        });
        this._namespaceLbl.setLabelFor(this._nameNamespaceField);
        this._namespaceLbl.setToolTipText(this.translate("CB_namespace_tooltip"));
        this._nameNamespaceField.setToolTipText(this.translate("CB_namespace_tooltip"));
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._nameNamespaceField, 1, 1, 1, 1, 1.0, 0.0, 17, 2, cmpInsets);
        this._nameRootElementLbl = new JLabel(this.translate("GN_rootElement_label"));
        CommonUtils.setMnemonicAndAccelerator(this._nameRootElementLbl, NLSUtils.getNLSString("GN_rootElement_label"));
        this._nameRootElementLbl.setToolTipText(this.translate("DT_rootElementTooltip"));
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._nameRootElementLbl, 0, 2, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameRootElementChoice = new JComboBox();
        this._nameRootElementChoice.setEditable(true);
        this._nameRootElementLbl.setLabelFor(this._nameRootElementChoice);
        this._nameRootElementChoice.setToolTipText(this.translate("DT_rootElementTooltip"));
        this._nameRootElementChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSampleDTDDescriptionPanel.this.handlePageAdvance();
                }
            }
        });
        KeyAdapter recordEndAtListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 10 || code == 9) && code == 10) {
                    e.consume();
                }
            }
        };
        this._nameRootElementChoice.addKeyListener(recordEndAtListener);
        this._nameRootElementChoice.setPreferredSize(new Dimension(100, 20));
        FlatFileSampleDTDDescriptionPanel.addComponent(nameFileNamePanel, this._nameRootElementChoice, 1, 2, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        FlatFileSampleDTDDescriptionPanel.addComponent(this, nameFileNamePanel, 0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(10, 3, 0, 0));
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSampleDTDDescriptionPanel.addComponent(this, gizmoPanel, 0, 2, 0, 0, 1.0, 1.0, 17, 1, pnlInsets);
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        FlatFileSampleDTDDescriptionPanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, cmpInsets);
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._nameFileStructureName;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        FlatFileInfo ff_info = (FlatFileInfo)info;
        String fileName = this._nameFileStructureName.getText();
        String rootElement = (String)this._nameRootElementChoice.getSelectedItem();
        try {
            String namespace;
            ff_info.setFileStructureName(fileName);
            String string = namespace = this._nameNamespaceField.getText() != null ? this._nameNamespaceField.getText().trim() : "";
            if (namespace.lastIndexOf("/") == namespace.length() - 1) {
                namespace = namespace.substring(0, namespace.length() - 1);
            }
            if (namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions") || namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd")) {
                throw new FlatFileValidationException(this.translate("EP_Invalid_namespace_API44", new String[]{namespace}));
            }
            ff_info.setNamespace(namespace);
            if (rootElement == null || rootElement.trim().equals("")) {
                throw new FlatFileValidationException(this.translate("DT_rootElementMissing_API35"));
            }
            ff_info.setRootElement(rootElement);
            ff_info.setModifiedNXSD(ff_info.generateNXSD());
        }
        catch (FlatFileValidationException e) {
            e.showError(f, this);
            this._nameRootElementChoice.requestFocus();
            throw e;
        }
    }

    private void showThisError(WizardPanelValidationException e) {
        e.showError(this.getParentFrame(), this);
    }

    private void handlePageAdvance() {
        String rootElement;
        String sampleFileName = this._nameFileStructureName.getText() != null ? this._nameFileStructureName.getText().trim() : "";
        String namespace = this._nameNamespaceField.getText() != null ? this._nameNamespaceField.getText().trim() : "";
        String string = rootElement = this._nameRootElementChoice.getSelectedItem() != null ? ((String)this._nameRootElementChoice.getSelectedItem()).trim() : "";
        if (sampleFileName.equals("") || namespace.equals("") || rootElement.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._wp.setCanAdvance(true);
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        String prevNS;
        this.ff_info = (FlatFileInfo)info;
        this.ff_info.setSkipRecords(0);
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("DT_namePageTitle_DTDFile"));
        DebugUtility.debug(this.translate("DT_namePageTitle_DTDFile").toUpperCase());
        String string = prevNS = this.ff_info.getNamespace() != null ? this.ff_info.getNamespace().trim() : "";
        if (prevNS.equals("")) {
            NxsdFileInfo nxsdFileInfo = ffWizard.getNxsdFileInfo();
            String serviceName = nxsdFileInfo._serviceName;
            prevNS = "http://TargetNamespace.com/ServiceName";
            if (serviceName != null && !serviceName.equals("")) {
                try {
                    serviceName = URLEncoder.encode(serviceName, "UTF-8").replaceAll("%", "-");
                }
                catch (Exception ex) {
                    // empty catch block
                }
                prevNS = prevNS.replaceAll("ServiceName", serviceName);
            }
        }
        this._nameNamespaceField.setText(prevNS);
        if (this.ff_info.getFlatFileWizard().getNxsdFileInfo()._connection != null) {
            this._nameFileStructureName.setEditable(false);
            this._nameFileStructureNameLbl.setVisible(false);
            this._nameFileStructureNameAppsLbl.setVisible(true);
        } else {
            this._nameFileStructureName.setEditable(true);
            this._nameFileStructureNameLbl.setVisible(true);
            this._nameFileStructureNameAppsLbl.setVisible(false);
        }
        String fileName = this.ff_info.getFileStructureName();
        this._nameFileStructureName.setText(fileName);
        this.handlePageAdvance();
        try {
            this._dataGizmo.refreshContents(this.ff_info);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void populateRootElementChoice() {
        this._nameRootElementChoice.removeAllItems();
        Vector elementList = new Vector();
        elementList = this.getDTDElements();
        if (elementList.size() < 1) {
            JOptionPane.showMessageDialog(this, this.translate("DT_invalidDTDFileNoElementsFound_API48"), this.translate("GN_error_title"), 0);
        }
        Object[] elemArray = elementList.toArray();
        for (int i = 0; i < elemArray.length; ++i) {
            this._nameRootElementChoice.addItem((String)elemArray[i]);
        }
    }

    private void populateRootElementChoiceAppsDTD(StringBuffer sb) {
        this._nameRootElementChoice.removeAllItems();
        Vector elementList = new Vector();
        elementList = this.getDTDElementsSB(sb);
        Object[] elemArray = elementList.toArray();
        for (int i = 0; i < elemArray.length; ++i) {
            this._nameRootElementChoice.addItem((String)elemArray[i]);
        }
    }

    private Vector getDTDElementsSB(StringBuffer sb) {
        Vector<String> elementList = new Vector<String>();
        StringTokenizer st = null;
        StringTokenizer line_ST = new StringTokenizer(sb.toString(), "<!");
        int count = 1;
        String sFirstTag = "";
        String sSecondTag = "";
        block0: while (line_ST.hasMoreTokens()) {
            count = 1;
            String strLine = line_ST.nextToken();
            st = new StringTokenizer(strLine);
            while (st.hasMoreElements()) {
                String currentItem = (String)st.nextElement();
                if (count == 1) {
                    sFirstTag = currentItem;
                }
                if (count == 2) {
                    sSecondTag = currentItem;
                    if (sFirstTag.equals("ELEMENT")) {
                        elementList.add(sSecondTag);
                        sFirstTag = "";
                        sSecondTag = "";
                        continue block0;
                    }
                }
                if (++count <= 2) continue;
                sFirstTag = "";
                sSecondTag = "";
                continue block0;
            }
        }
        return elementList;
    }

    private Vector getDTDElements() {
        Vector<String> elementList = new Vector<String>();
        Object st = null;
        String fileName = this.ff_info.getFileStructureName();
        String strLine = "";
        StringBuffer sb = new StringBuffer();
        if (fileName != null) {
            try {
                DOMParser domparser = new DOMParser();
                domparser.parseDTD((InputStream)new FileInputStream(fileName), null);
                DTD dtd = domparser.getDoctype();
                NamedNodeMap elements = dtd.getElementDecls();
                for (int i = 0; i < elements.getLength(); ++i) {
                    elementList.add(elements.item(i).getNodeName());
                }
                Collections.sort(elementList);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return elementList;
    }

    public void setDtdInfo() {
        if (this.dtdinfo != null) {
            String dtdname = this.dtdinfo.fileName;
            StringBuffer dtdbuf = new StringBuffer(this.dtdinfo.payload);
            this.populateRootElementChoiceAppsDTD(dtdbuf);
            this.ff_info.setAppsDTD(dtdbuf);
            try {
                this.ff_info.setFileStructureName(dtdname);
            }
            catch (FlatFileValidationException ep) {
                ep.printStackTrace();
            }
            this._nameFileStructureName.setText(dtdname);
            this._nameRootElementChoice.setSelectedItem(this.dtdinfo.rootElement);
            this._dataGizmo.refreshContents(this.ff_info);
            this.handlePageAdvance();
        }
    }
}

