/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.help.HelpSystem;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WhAlert;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleColumnDefPanel
extends WizardPanel {
    private WizardPage _wizardPage;
    private MultiLineLabel _introLabel;
    private JPanel _recordNamePanel;
    private JComboBox _recordNameChoice;
    private JPanel _nextRecordPanel;
    private JLabel _recTypesRemainLbl;
    private FlatFileDisplayGizmo _dataGizmo;
    private FlatFileInfo _ff_info;
    private String _currentRecordName = null;
    private int[] _startingColumnMarks;
    private int _recordsToProcessRemain;
    private int _numRecords = 1;
    private Vector _processedRecords = new Vector();

    FlatFileSampleColumnDefPanel(WBTranslatable h) {
        super(h);
        this._startingColumnMarks = new int[0];
    }

    private void _debug(String msg) {
        if (this._debug_on) {
            DebugUtility.debug(msg);
        }
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wizardPage = wp;
        this.setLayout(new GridBagLayout());
        Insets stdInsets = new Insets(3, 3, 3, 3);
        this._introLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), "");
        FlatFileSampleColumnDefPanel.addComponent(this, (Component)this._introLabel, 0, 0, 2, 1, 1.0, 0.0, 18, 1, stdInsets);
        this._recordNamePanel = new JPanel();
        this._recordNamePanel.setLayout(new FlowLayout(0, 3, 3));
        FlatFileSampleColumnDefPanel.addComponent(this, this._recordNamePanel, 0, 1, 2, 1, 0.0, 0.0, 17, 1, stdInsets);
        JLabel tempLbl = new JLabel(this.translate("CD_columnDefRecordName_FlatFile"));
        this._recordNamePanel.add(tempLbl);
        this._recordNameChoice = new JComboBox();
        this._recordNamePanel.add(this._recordNameChoice);
        tempLbl.setLabelFor(this._recordNameChoice);
        CommonUtils.setMnemonicAndAccelerator(tempLbl, NLSUtils.getNLSString("CD_columnDefRecordName_FlatFile"));
        this._recordNameChoice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSampleColumnDefPanel.this.processRecordSelection();
                }
            }
        });
        this._nextRecordPanel = new JPanel();
        this._nextRecordPanel.setLayout(new GridBagLayout());
        FlatFileSampleColumnDefPanel.addComponent(this, this._nextRecordPanel, 0, 2, 2, 1, 1.0, 0.0, 17, 1, new Insets(15, 3, 10, 3));
        this._recTypesRemainLbl = new JLabel(this.translate("CD_columnDefRecordTypesRemainLbl_FlatFile"));
        FlatFileSampleColumnDefPanel.addComponent(this._nextRecordPanel, this._recTypesRemainLbl, 0, 0, 1, 1, 0.5, 0.0, 17, 2, new Insets(0, 0, 0, 0));
        JButton _nextRecTypeButton = new JButton(this.translate("CD_columnDefNextRecordTypeButton_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(_nextRecTypeButton, NLSUtils.getNLSString("CD_columnDefNextRecordTypeButton_FlatFile"));
        this._recordNamePanel.add(_nextRecTypeButton);
        ActionListener nextRecTypeButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleColumnDefPanel.this.nextRecordSelection();
            }
        };
        _nextRecTypeButton.addActionListener(nextRecTypeButtonListener);
        JPanel rulerPanel = new JPanel(new GridBagLayout());
        JLabel createMarkerLbl = new JLabel(this.translate("CD_createRuler_toolTip"));
        JLabel removeMarkerLbl = new JLabel(this.translate("CD_removeRuler_toolTip"));
        JLabel moveMarkerLbl = new JLabel(this.translate("CD_moveRuler_toolTip"));
        FlatFileSampleColumnDefPanel.addComponent(rulerPanel, createMarkerLbl, 0, 0, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 0, 0, 0));
        FlatFileSampleColumnDefPanel.addComponent(rulerPanel, removeMarkerLbl, 0, 1, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 0, 0, 0));
        FlatFileSampleColumnDefPanel.addComponent(rulerPanel, moveMarkerLbl, 0, 2, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 0, 0, 0));
        FlatFileSampleColumnDefPanel.addComponent(this, rulerPanel, 0, 3, 1, 1, 0.5, 0.0, 18, 0, new Insets(0, 0, 0, 0));
        this._dataGizmo = new FlatFileDisplayGizmo(2, this);
        FlatFileSampleColumnDefPanel.addComponent(this, this._dataGizmo, 0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 3, 3, 3));
    }

    @Override
    public Component getFirstSelectableComponent() {
        if (this._ff_info == null) {
            return null;
        }
        if (this._ff_info.isMultiRecord()) {
            return this._recordNameChoice;
        }
        if (this._dataGizmo != null) {
            if (this._dataGizmo.getType() == 2) {
                return this._dataGizmo.getWidthsTextField();
            }
        }
        return this._dataGizmo;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws FlatFileValidationException {
        this._dataGizmo.updateMarks();
        this.processRecordSelection();
        this._ff_info.setRecordsToProcessRemain(this._recordsToProcessRemain);
        if (this._ff_info.isMultiRecord()) {
            if (this._recordsToProcessRemain > 0) {
                WhAlert alert = new WhAlert((Dialog)CommonUtils.getParentFrameOrDialog(this), this.translate("CD_columnDefErrMissingColumns_API32"), 2, 24);
                alert.setCenterOver((Dialog)CommonUtils.getParentFrameOrDialog(this));
                alert.setTitle(this.translate("GN_warning_title"));
                switch (alert.runAlert()) {
                    case 8: {
                        break;
                    }
                    case 16: {
                        FlatFileValidationException fe = new FlatFileValidationException(this.translate("CD_columnDefErrMissingColumns_solution"));
                        fe.showError(f, this);
                        throw fe;
                    }
                }
            }
            String[] recordNames = this._ff_info.getRecordList();
            String recordName = "";
            for (int i = 0; i < recordNames.length; ++i) {
                int firstPos;
                recordName = recordNames[i];
                this._startingColumnMarks = this._ff_info.getColumnMarkers(recordName);
                if (this._startingColumnMarks.length <= 0 || (firstPos = this._ff_info.getRecordClassifierEnd()) == this._startingColumnMarks[0]) continue;
                FlatFileValidationException fe = new FlatFileValidationException(this.translate("CD_wrongFieldLength_API42", new String[]{"" + firstPos, recordName}));
                fe.showError(f, this);
                throw fe;
            }
        }
    }

    @Override
    public String getHelpTopicName() {
        if (this._ff_info.isMultiRecord()) {
            return "flatfile_fixed_mult_col";
        }
        return "flatfile_single_col";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        this._ff_info = (FlatFileInfo)info;
        FlatFileWizard ffWizard = this._ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        pageCount -= 2;
        int pageIndex = ffWizard.getCurrentPageIndex();
        if (this._ff_info.isMultiRecord()) {
            int i;
            this._wizardPage.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + pageCount}));
            this._wizardPage.setPageTitle(this.translate("CD_columnDefPageTitleMulti_FlatFile"));
            DebugUtility.debug(this.translate("CD_columnDefPageTitleMulti_FlatFile").toUpperCase());
            this._recordNameChoice.removeAllItems();
            String[] record_list = this._ff_info.getRecordList();
            this._numRecords = record_list.length;
            ItemListener[] ils = CommonUtils.removeComboItemListener(this._recordNameChoice);
            for (i = 0; i < this._numRecords; ++i) {
                this._recordNameChoice.addItem(record_list[i]);
            }
            CommonUtils.addComboItemListener(this._recordNameChoice, ils);
            this._recordNamePanel.setVisible(true);
            this._recordNamePanel.invalidate();
            this._introLabel.setText(this.translate("CD_columnDefIntroMulti_FlatFile"));
            this._currentRecordName = record_list[0];
            this._processedRecords.add(this._currentRecordName);
            this._recordsToProcessRemain = this._ff_info.getRecordsToProcessRemain();
            if (this._recordsToProcessRemain == -1) {
                this._processedRecords.clear();
                this._processedRecords.add(this._currentRecordName);
                this._recordsToProcessRemain = this._numRecords - 1;
            }
            this._nextRecordPanel.setVisible(true);
            this._nextRecordPanel.invalidate();
            this._recTypesRemainLbl.setText(this._recordsToProcessRemain + "  " + this.translate("CD_columnDefRecordTypesRemainLbl_FlatFile"));
            this._dataGizmo.refreshContents(this._ff_info, this._currentRecordName);
            for (i = 0; i < record_list.length; ++i) {
                int[] markers = this._ff_info.getColumnMarkers(record_list[i]);
                if (markers.length != 1) continue;
                markers = new int[]{this._ff_info.getRecordClassifierEnd(), markers[0]};
                this._ff_info.setColumnStartPositions(record_list[i], markers);
            }
            this._startingColumnMarks = this._ff_info.getColumnMarkers(this._currentRecordName);
            this._dataGizmo.refreshContents(this._ff_info, this._currentRecordName);
            this._dataGizmo.setMarkedColumns(this._startingColumnMarks);
        } else {
            this._currentRecordName = null;
            this._startingColumnMarks = this._ff_info.getColumnMarkers(this._currentRecordName);
            this._wizardPage.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + pageCount}));
            if (this._ff_info.isSingleInstance()) {
                this._wizardPage.setPageTitle(this.translate("CD_columnDefPageTitleSingle_FlatFile"));
                DebugUtility.debug(this.translate("CD_columnDefPageTitleSingle_FlatFile").toUpperCase());
                this._introLabel.setText(this.translate("CD_columnDefIntroSingle_FlatFile"));
                if (!this._ff_info.isStandaloneTesting()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)this._wizardPage.getContent(), "bpmjdev_adp_wiz_nfb_field_len_one_record");
                }
            } else {
                this._wizardPage.setPageTitle(this.translate("CD_columnDefPageTitleMulti_FlatFile"));
                DebugUtility.debug(this.translate("CD_columnDefPageTitleMulti_FlatFile").toUpperCase());
                this._introLabel.setText(this.translate("CD_columnDefIntroMulti_FlatFile"));
                if (!this._ff_info.isStandaloneTesting()) {
                    HelpSystem.getHelpSystem().registerTopic((JComponent)this._wizardPage.getContent(), "bpmjdev_adp_wiz_nfb_field_len_diff_records");
                }
            }
            this._recordNamePanel.setVisible(false);
            this._nextRecordPanel.setVisible(false);
            if (this._ff_info.isEditingNXSD()) {
                this._currentRecordName = null;
                this._dataGizmo.refreshContents(this._ff_info, this._currentRecordName);
            } else {
                this._dataGizmo.refreshContents(this._ff_info);
            }
        }
    }

    private void processRecordSelection() {
        int[] marks = this._dataGizmo.getMarkedColumns();
        this._debug("marks at: ");
        for (int i = 0; i < marks.length; ++i) {
            this._debug("  " + marks[i]);
        }
        boolean marks_have_changed = marks.length == 0 || marks.length != this._startingColumnMarks.length;
        for (int i = 0; !marks_have_changed && i < marks.length; ++i) {
            marks_have_changed = marks[i] != this._startingColumnMarks[i];
        }
        if (marks_have_changed) {
            this._ff_info.setColumnStartPositions(this._currentRecordName, marks);
            this._startingColumnMarks = marks;
        }
        if (this._ff_info.isMultiRecord()) {
            if (this._currentRecordName != null && !this._currentRecordName.equals(this._recordNameChoice.getSelectedItem())) {
                this._currentRecordName = (String)this._recordNameChoice.getSelectedItem();
                this._startingColumnMarks = this._ff_info.getColumnMarkers(this._currentRecordName);
                this._dataGizmo.refreshContents(this._ff_info, this._currentRecordName);
                this._dataGizmo.setMarkedColumns(this._startingColumnMarks);
                if (!this._processedRecords.contains(this._currentRecordName)) {
                    this._processedRecords.add(this._currentRecordName);
                    --this._recordsToProcessRemain;
                    this._ff_info.setRecordsToProcessRemain(this._recordsToProcessRemain);
                    this._recTypesRemainLbl.setText(this._recordsToProcessRemain + "  " + this.translate("CD_columnDefRecordTypesRemainLbl_FlatFile"));
                }
            }
        } else {
            int[] new_marks = this._ff_info.getColumnMarkers(this._currentRecordName);
            if (new_marks.length != this._startingColumnMarks.length) {
                this._dataGizmo.refreshContents(this._ff_info, this._currentRecordName);
                this._dataGizmo.setMarkedColumns(this._startingColumnMarks);
            }
        }
    }

    private void nextRecordSelection() {
        int idx;
        int[] marks = this._dataGizmo.getMarkedColumns();
        this._debug("marks at: ");
        for (int i = 0; i < marks.length; ++i) {
            this._debug("  " + marks[i]);
        }
        boolean marks_have_changed = marks.length == 0 || marks.length != this._startingColumnMarks.length;
        for (int i = 0; !marks_have_changed && i < marks.length; ++i) {
            marks_have_changed = marks[i] != this._startingColumnMarks[i];
        }
        if (marks_have_changed) {
            this._ff_info.setColumnStartPositions(this._currentRecordName, marks);
            this._startingColumnMarks = marks;
        }
        idx = (idx = this._recordNameChoice.getSelectedIndex()) == this._numRecords - 1 ? 0 : ++idx;
        this._recordNameChoice.setSelectedIndex(idx);
        this._currentRecordName = (String)this._recordNameChoice.getSelectedItem();
        if (!this._processedRecords.contains(this._currentRecordName)) {
            this._processedRecords.add(this._currentRecordName);
            --this._recordsToProcessRemain;
            this._ff_info.setRecordsToProcessRemain(this._recordsToProcessRemain);
            this._recTypesRemainLbl.setText(this._recordsToProcessRemain + "  " + this.translate("CD_columnDefRecordTypesRemainLbl_FlatFile"));
        }
        this._startingColumnMarks = this._ff_info.getColumnMarkers(this._currentRecordName);
        this._dataGizmo.refreshContents(this._ff_info, this._currentRecordName);
        this._dataGizmo.setMarkedColumns(this._startingColumnMarks);
        this._ff_info.setColumnStartPositions(this._currentRecordName, this._startingColumnMarks);
    }
}

