/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.net.URL;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.ide.Context;
import oracle.ide.net.URLFileSystem;
import oracle.tip.tools.ide.common.datasources.CompoundDataSource;
import oracle.tip.tools.ide.common.datasources.schema.ProjectSchemaDataSource;
import oracle.tip.tools.ide.common.typeexplorer.SchemaImportHandler;
import oracle.tip.tools.ide.common.typeexplorer.TypeChooser;
import oracle.tip.tools.ide.common.typeexplorer.TypeObject;
import oracle.tip.tools.ide.common.ui.UIHelper;
import oracle.tip.tools.ide.common.ui.treeexplorer.TreeExplorerDataSource;
import oracle.tip.tools.ide.pm.ide.bpel.jdeveloper.JDevBPELProject;
import oracle.tip.tools.ide.pm.modules.bizintegration.adapter.AdapterWizardSchemaImportHandler;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleChooseTypePanel
extends WizardPanel {
    private static final String HTTP_PREFIX = "http:";
    private FlatFileInfo ff_info;
    private ButtonGroup _creatOrEditCbGroup;
    private JRadioButton _createCb;
    private JRadioButton _editCb;
    private MultiLineLabel screenIntroLabel;
    private ButtonGroup _fileTypeCbGroup;
    private JRadioButton _fileDTDCb;
    private JRadioButton _fileCCBCb;
    private JRadioButton _fileDelimitedCb;
    private JRadioButton _fileComplexCb;
    private JRadioButton _fileFixedCb;
    private JButton _fileBrowseButton;
    private JLabel _nameNxsdFileNameLbl;
    private JTextField _nameNxsdFileName;
    private WizardPage _wp;
    private MultiLineLabel _fixedExplain;
    private MultiLineLabel _delimitedExplain;
    private MultiLineLabel _complexExplain;

    FlatFileSampleChooseTypePanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        wp.setLabel(this.translate("CT_nameChooseFileType_TitleNumbered"));
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(1, 1, 1, 1);
        JPanel createNewFilePanel = new JPanel();
        createNewFilePanel.setLayout(new GridBagLayout());
        FlatFileSampleChooseTypePanel.addComponent(this, createNewFilePanel, 0, 1, 1, 1, 1.0, 0.25, 18, 2, new Insets(20, 10, 1, 3));
        JPanel editFilePanel = new JPanel();
        editFilePanel.setLayout(new GridBagLayout());
        FlatFileSampleChooseTypePanel.addComponent(this, editFilePanel, 0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(3, 10, 3, 3));
        this._creatOrEditCbGroup = new ButtonGroup();
        this._createCb = new JRadioButton(this.translate("CT_createNewFileIntro"), true);
        this._creatOrEditCbGroup.add(this._createCb);
        CommonUtils.setMnemonicAndAccelerator(this._createCb, NLSUtils.getNLSString("CT_createNewFileIntro"));
        this._createCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleChooseTypePanel.this.enableCreateNewFilePanel(true);
                    FlatFileSampleChooseTypePanel.this.handlePageAdvance();
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        FlatFileSampleChooseTypePanel.addComponent(createNewFilePanel, this._createCb, 0, 0, 1, 1, 1.0, 0.0, 18, 1, cmpInsets);
        JPanel indentationPanel = new JPanel();
        indentationPanel.setLayout(new GridBagLayout());
        FlatFileSampleChooseTypePanel.addComponent(createNewFilePanel, indentationPanel, 0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 1, 3));
        JLabel chooseFileTypeLbl = new JLabel(this.translate("CT_chooseNewFileType"));
        chooseFileTypeLbl.setLabelFor(createNewFilePanel);
        FlatFileSampleChooseTypePanel.addComponent(indentationPanel, chooseFileTypeLbl, 0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 3, 3, 3));
        JPanel innerPanel = new JPanel(new GridBagLayout());
        this._fileTypeCbGroup = new ButtonGroup();
        FlatFileSampleChooseTypePanel.addComponent(indentationPanel, innerPanel, 0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 15, 3, 3));
        this._fileDelimitedCb = new JRadioButton(this.translate("CT_fileType_delimitedLabel") + " (" + this.translate("CT_fileType_delimitedExplainLabel") + ")", true);
        this._fileTypeCbGroup.add(this._fileDelimitedCb);
        this._fileDelimitedCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    // empty if block
                }
                CommonUtils.setMnemonicAndAccelerator(FlatFileSampleChooseTypePanel.this._fileDelimitedCb, NLSUtils.getNLSString("CT_fileType_delimitedLabel"));
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        FlatFileSampleChooseTypePanel.addComponent(innerPanel, this._fileDelimitedCb, 0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(1, 1, 1, 1));
        this._delimitedExplain = new MultiLineLabel(WordWrapper.getTextWrapper(), "(" + this.translate("CT_fileType_delimitedExplainLabel") + ")");
        this._delimitedExplain.setPreferredAspectRatio(0.0f);
        this._delimitedExplain.setPreferredRows(1);
        this._fileFixedCb = new JRadioButton(this.translate("CT_fileType_fixedLengthLabel") + " (" + this.translate("CT_fileType_fixedLengthExplainLabel") + ")", false);
        this._fileTypeCbGroup.add(this._fileFixedCb);
        this._fileFixedCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    // empty if block
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileFixedCb, NLSUtils.getNLSString("CT_fileType_fixedLengthLabel"));
        FlatFileSampleChooseTypePanel.addComponent(innerPanel, this._fileFixedCb, 0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 1, 1, 1));
        this._fixedExplain = new MultiLineLabel(WordWrapper.getTextWrapper(), "(" + this.translate("CT_fileType_fixedLengthExplainLabel") + ")");
        this._fixedExplain.setPreferredAspectRatio(0.0f);
        this._fixedExplain.setPreferredRows(1);
        this._fileComplexCb = new JRadioButton(this.translate("CT_fileType_complexLabel") + " (" + this.translate("CT_fileType_complexExplainLabel") + ")", true);
        this._fileTypeCbGroup.add(this._fileComplexCb);
        this._fileComplexCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleChooseTypePanel.this.ff_info.isComplexFile(true);
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileComplexCb, NLSUtils.getNLSString("CT_fileType_complexLabel"));
        FlatFileSampleChooseTypePanel.addComponent(innerPanel, this._fileComplexCb, 0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 1, 1, 1));
        this._complexExplain = new MultiLineLabel(WordWrapper.getTextWrapper(), "(" + this.translate("CT_fileType_complexExplainLabel") + ")");
        this._complexExplain.setPreferredAspectRatio(0.0f);
        this._complexExplain.setPreferredRows(1);
        this._fileDTDCb = new JRadioButton(this.translate("DT_fileType_dtdLabel"), false);
        this._fileTypeCbGroup.add(this._fileDTDCb);
        this._fileDTDCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    // empty if block
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileDTDCb, NLSUtils.getNLSString("DT_fileType_dtdLabel"));
        FlatFileSampleChooseTypePanel.addComponent(innerPanel, this._fileDTDCb, 0, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 1, 1, 1));
        this._fileCCBCb = new JRadioButton(this.translate("CT_fileType_ccbLabel"), false);
        this._fileTypeCbGroup.add(this._fileCCBCb);
        this._fileCCBCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    // empty if block
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._fileCCBCb, NLSUtils.getNLSString("CT_fileType_ccbLabel"));
        FlatFileSampleChooseTypePanel.addComponent(innerPanel, this._fileCCBCb, 0, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 1, 1, 1));
        this._editCb = new JRadioButton(this.translate("CT_editExistingFileIntro"), true);
        this._creatOrEditCbGroup.add(this._editCb);
        this._editCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleChooseTypePanel.this.enableCreateNewFilePanel(false);
                    FlatFileSampleChooseTypePanel.this.handlePageAdvance();
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        CommonUtils.setMnemonicAndAccelerator(this._editCb, NLSUtils.getNLSString("CT_editExistingFileIntro"));
        FlatFileSampleChooseTypePanel.addComponent(editFilePanel, this._editCb, 0, 0, 1, 1, 1.0, 0.0, 18, 1, cmpInsets);
        JPanel editInnerPanel = new JPanel(new GridBagLayout());
        FlatFileSampleChooseTypePanel.addComponent(editFilePanel, editInnerPanel, 0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 15, 1, 3));
        this._nameNxsdFileNameLbl = new JLabel(this.translate("CT_exisitingNxsdFile_label"));
        FlatFileSampleChooseTypePanel.addComponent(editInnerPanel, this._nameNxsdFileNameLbl, 0, 0, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameNxsdFileName = new JTextField();
        this._nameNxsdFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String fileName = FlatFileSampleChooseTypePanel.this._nameNxsdFileName.getText();
                if (new File(fileName).exists() && FlatFileSampleChooseTypePanel.this.ff_info.getRootElementList(fileName).size() == 1) {
                    FlatFileSampleChooseTypePanel.this.ff_info.chooseTypeInit();
                }
                FlatFileSampleChooseTypePanel.this.handlePageAdvance();
            }
        });
        this._nameNxsdFileName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleChooseTypePanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleChooseTypePanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleChooseTypePanel.this.handlePageAdvance();
            }
        });
        this._nameNxsdFileNameLbl.setLabelFor(this._nameNxsdFileName);
        FlatFileSampleChooseTypePanel.addComponent(editInnerPanel, this._nameNxsdFileName, 1, 0, 1, 1, 1.0, 1.0, 17, 2, cmpInsets);
        this._fileBrowseButton = new JButton(this.translate("GN_browseButton"));
        this._fileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FlatFileSampleChooseTypePanel.this.openTypeChooserOrFileDialog();
            }
        });
        this._nameNxsdFileNameLbl.setLabelFor(this._fileBrowseButton);
        CommonUtils.setMnemonicAndAccelerator(this._fileBrowseButton, NLSUtils.getNLSString("GN_browseButton"));
        FlatFileSampleChooseTypePanel.addComponent(editInnerPanel, this._fileBrowseButton, 2, 0, 1, 1, 0.5, 1.0, 17, 0, cmpInsets);
        JPanel dummyPanel = new JPanel();
        dummyPanel.setLayout(new GridBagLayout());
        FlatFileSampleChooseTypePanel.addComponent(this, dummyPanel, 0, 4, 0, 0, 1.0, 1.0, 17, 1, pnlInsets);
    }

    private void openTypeChooserOrFileDialog() {
        Context jdevcontext = null;
        Object editor = null;
        try {
            jdevcontext = Context.newIdeContext();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jdevcontext != null) {
            TypeChooser chooser = new TypeChooser(UIHelper.getFrame((Component)this));
            CompoundDataSource ds = new CompoundDataSource();
            ds.addDataSource((TreeExplorerDataSource)new ProjectSchemaDataSource(jdevcontext, false, true));
            chooser.getTypeExplorer().setSchemaImportHandler((SchemaImportHandler)new AdapterWizardSchemaImportHandler(new JDevBPELProject(jdevcontext.getProject())));
            int rcint = chooser.display((TreeExplorerDataSource)ds);
            if (rcint == 0) {
                TypeObject m_elementTypeObj = chooser.getTypeObject();
                URL fileUrl = (URL)m_elementTypeObj.getData("RESOURCE_URL_KEY");
                String file_type = (String)m_elementTypeObj.getData("FILE_TYPE_KEY");
                String file_name = null;
                file_name = fileUrl.toString().toLowerCase().startsWith(HTTP_PREFIX) ? fileUrl.toString() : URLFileSystem.getFileName((URL)fileUrl);
                this._nameNxsdFileName.setText(file_name);
                String prjDir = this.ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                if (prjDir.lastIndexOf(File.separator) != prjDir.length() - 1) {
                    prjDir = prjDir + File.separator;
                }
                if (this.ff_info.getRootElementList(prjDir + file_name).size() == 1) {
                    this.ff_info.chooseTypeInit();
                }
            }
        } else {
            String prjDir = this.ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
            JFileChooser chooser = new JFileChooser(prjDir);
            chooser.setDialogTitle(this.translate("CT_fileDialogTitle"));
            int returnVal = chooser.showOpenDialog(this.getParentFrame());
            String fileName = "";
            String directory = "";
            if (returnVal == 0) {
                fileName = chooser.getSelectedFile().getName();
                directory = chooser.getSelectedFile().getParent() + File.separator;
            }
            if (directory != null && fileName != null) {
                this._nameNxsdFileName.setText(fileName);
                File pickedFile = new File(directory + fileName);
                if (pickedFile.exists()) {
                    if (prjDir == null) {
                        prjDir = directory;
                        this.ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName = directory;
                    }
                    if (prjDir.lastIndexOf(File.separator) != prjDir.length() - 1) {
                        prjDir = prjDir + File.separator;
                    }
                    if (!directory.equals(prjDir)) {
                        this.copyFileToProjectDir(directory, prjDir, fileName);
                    }
                    if (this.ff_info.getRootElementList(prjDir + fileName).size() == 1) {
                        this.ff_info.chooseTypeInit();
                    }
                }
            }
        }
        this.handlePageAdvance();
    }

    private void copyFileToProjectDir(String directory, String prjDir, String fileName) {
        String fromFile = directory + fileName;
        if (prjDir.lastIndexOf(File.separator) != prjDir.length() - 1) {
            prjDir = prjDir + File.separator;
        }
        String toFile = prjDir + fileName;
        DebugUtility.debug("Choose Type:: copy file : " + fileName + " from " + directory + " to " + prjDir);
        try {
            String data = "";
            FileReader inputStream = new FileReader(fromFile);
            int ch = inputStream.read();
            while (ch != -1) {
                data = data + (char)ch;
                ch = inputStream.read();
            }
            inputStream.close();
            FileWriter outputStream = new FileWriter(toFile);
            outputStream.write(data);
            outputStream.close();
        }
        catch (Exception e) {
            DebugUtility.debug(e.getMessage());
        }
    }

    private void handlePageAdvance() {
        if (this._createCb.isSelected()) {
            this._wp.setCanAdvance(true);
        } else {
            String nxsdFile;
            String string = nxsdFile = this._nameNxsdFileName.getText() != null ? this._nameNxsdFileName.getText().trim() : "";
            if (nxsdFile.equals("")) {
                this._wp.setCanAdvance(false);
            } else {
                this._wp.setCanAdvance(true);
            }
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._fileDelimitedCb;
    }

    private void enableCreateNewFilePanel(boolean bEnable) {
        if (bEnable) {
            this._fileDTDCb.setEnabled(true);
            this._fileCCBCb.setEnabled(true);
            this._fileDelimitedCb.setEnabled(true);
            this._fileComplexCb.setEnabled(true);
            this._fileFixedCb.setEnabled(true);
            this._fileBrowseButton.setEnabled(false);
            this._nameNxsdFileName.setEditable(false);
            this._nameNxsdFileName.setEnabled(false);
            this._fixedExplain.setEnabled(true);
            this._delimitedExplain.setEnabled(true);
            this._complexExplain.setEnabled(true);
        } else {
            this._fileDTDCb.setEnabled(false);
            this._fileCCBCb.setEnabled(false);
            this._fileDelimitedCb.setEnabled(false);
            this._fileComplexCb.setEnabled(false);
            this._fileFixedCb.setEnabled(false);
            this._fileBrowseButton.setEnabled(true);
            this._nameNxsdFileName.setEditable(true);
            this._nameNxsdFileName.setEnabled(true);
            this._fixedExplain.setEnabled(false);
            this._delimitedExplain.setEnabled(false);
            this._complexExplain.setEnabled(false);
        }
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        block21: {
            FlatFileInfo ff_info = (FlatFileInfo)info;
            Vector rootElementList = null;
            try {
                String fileName;
                if (this._createCb.isSelected()) {
                    ff_info.isEditingNXSD(false);
                    if (this._fileDelimitedCb.isSelected()) {
                        ff_info.isDelimitedFile(true);
                    } else if (this._fileFixedCb.isSelected()) {
                        ff_info.isFixedLengthFile(true);
                    } else if (this._fileComplexCb.isSelected()) {
                        ff_info.isComplexFile(true);
                    } else if (this._fileDTDCb.isSelected()) {
                        ff_info.isDTDFile(true);
                    } else {
                        ff_info.isCCBFile(true);
                    }
                    break block21;
                }
                String relativeFileName = this._nameNxsdFileName.getText();
                String prjDir = ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                if (prjDir.lastIndexOf(File.separator) != prjDir.length() - 1) {
                    prjDir = prjDir + File.separator;
                }
                if ((fileName = prjDir + relativeFileName) == null || fileName.trim().equals("")) {
                    throw new FlatFileValidationException(this.translate("CT_editNxsdFileNameMissing_API2", new String[]{fileName}));
                }
                File nxsdFile = new File(fileName);
                if (!nxsdFile.exists()) {
                    if (relativeFileName.indexOf(File.separator) != -1) {
                        throw new FlatFileValidationException(this.translate("CT_fileNameNotRelative_API46", new String[]{relativeFileName}));
                    }
                    throw new FlatFileValidationException(this.translate("CT_editNxsdFileNameMissing_API2", new String[]{fileName}));
                }
                rootElementList = ff_info.getRootElementList(fileName);
                String rootElement = "";
                if (rootElementList != null) {
                    if (rootElementList.size() > 1) {
                        throw new FlatFileValidationException(this.translate("CT_cannotEditMultipleRoots_API41"));
                    }
                    if (rootElementList.size() == 0) {
                        throw new FlatFileValidationException(this.translate("CT_editNxsdRootElementMissing_API1"));
                    }
                    rootElement = (String)rootElementList.elementAt(0);
                }
                if (rootElement == null || rootElement.trim().equals("")) {
                    throw new FlatFileValidationException(this.translate("CT_editNxsdRootElementMissing_API1"));
                }
                ff_info.setRootElement(rootElement);
                ff_info.isEditingNXSD(true);
                ff_info.setNXSDFileName(fileName);
                ff_info.getFlatFileWizard().getNxsdFileInfo()._nxsdFileName = relativeFileName;
                ff_info = ff_info.updateWithExistingNxsd(ff_info, fileName, rootElement);
                try {
                    FileInputStream in_stream = new FileInputStream(ff_info.getFileStructureName());
                }
                catch (FileNotFoundException e) {
                    throw new FlatFileValidationException(this.translate("CT_SampleFileNotFound"));
                }
            }
            catch (FlatFileValidationException fe) {
                fe.showError(f, this);
                throw fe;
            }
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        this.ff_info = (FlatFileInfo)info;
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        wp.setPageTitle(this.translate("CT_nameChooseFileType_PageTitle"));
        DebugUtility.debug(this.translate("CT_nameChooseFileType_PageTitle").toUpperCase());
        if (this.ff_info.isEditingNXSD()) {
            this._editCb.setSelected(true);
            this._createCb.setSelected(false);
            this.enableCreateNewFilePanel(false);
            String relativeName = ffWizard.getNxsdFileInfo()._nxsdFileName;
            if (relativeName != null && !relativeName.equals("")) {
                this._nameNxsdFileName.setText(relativeName);
                this.handlePageAdvance();
            }
        } else {
            this._createCb.setSelected(true);
            this._editCb.setSelected(false);
            this.enableCreateNewFilePanel(true);
            if (this.ff_info.isDelimitedFile()) {
                this._fileDelimitedCb.setSelected(true);
            } else if (this.ff_info.isDTD()) {
                this._fileDTDCb.setSelected(true);
            } else if (this.ff_info.isCCB()) {
                this._fileCCBCb.setSelected(true);
            } else if (this.ff_info.isComplexFile()) {
                this._fileComplexCb.setSelected(true);
            } else {
                this._fileFixedCb.setSelected(true);
            }
        }
    }
}

