/*
 * Decompiled with CFR 0.152.
 */
package oracle.tip.tools.ide.pm.modules.bizintegration.nxsd;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.CommonUtils;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileDisplayGizmo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.FlatFileWizard;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.NxsdFileInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WBTranslatable;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardInfo;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanel;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.WizardPanelValidationException;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.DebugUtility;
import oracle.tip.tools.ide.pm.modules.bizintegration.nxsd.util.NLSUtils;

public class FlatFileSampleCCBDescriptionPanel
extends WizardPanel {
    private FlatFileInfo ff_info;
    private MultiLineLabel _nameFileNameIntro;
    private JLabel _nameFileStructureNameLbl;
    private JTextField _nameFileStructureName;
    private JLabel _nameNamespaceLbl;
    private JTextField _nameNamespaceField;
    private JLabel _nameRootElementLbl;
    private JTextField _nameRootElementField;
    private JLabel _nameCharacterSetLbl;
    private JComboBox _nameCharacterSetLw;
    private String _recordEndAtSave;
    private JLabel _recordEndAtLabel;
    private JRadioButton _recordEndAtCb;
    private JComboBox _recordEndAt;
    private ButtonGroup _byteOrderCbGroup;
    private JRadioButton _byteOrderLittleEndCb;
    private JRadioButton _byteOrderBigEndCb;
    private FlatFileDisplayGizmo _dataGizmo;
    private WizardPage _wp;

    FlatFileSampleCCBDescriptionPanel(WBTranslatable h) {
        super(h);
    }

    @Override
    public void buildPanel(WizardPage wp) {
        this._wp = wp;
        this.setLayout(new GridBagLayout());
        Insets pnlInsets = new Insets(3, 3, 3, 3);
        Insets cmpInsets = new Insets(6, 6, 2, 0);
        JPanel nameFileNamePanel = new JPanel();
        nameFileNamePanel.setLayout(new GridBagLayout());
        this._nameFileNameIntro = new MultiLineLabel(WordWrapper.getTextWrapper(), this.translate("CB_nameIntro_CCBFile"));
        FlatFileSampleCCBDescriptionPanel.addComponent(this, (Component)this._nameFileNameIntro, 0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3));
        FlatFileSampleCCBDescriptionPanel.addComponent(this, nameFileNamePanel, 0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 3, 3, 50));
        this._nameFileStructureNameLbl = new JLabel(this.translate("GN_nameFileStructureName_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._nameFileStructureNameLbl, NLSUtils.getNLSString("GN_nameFileStructureName_FlatFile"));
        this._nameFileStructureName = new JTextField();
        this._nameFileStructureName.setPreferredSize(new Dimension(180, 18));
        this._nameFileStructureName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }
        });
        this._nameFileStructureName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField field = (JTextField)e.getSource();
                String fileName = field.getText();
                if (fileName == null || fileName.equals("") || FlatFileSampleCCBDescriptionPanel.this.ff_info.getFileStructureName().equals(fileName)) {
                    return;
                }
                FlatFileSampleCCBDescriptionPanel.this._nameFileStructureName.setText(fileName);
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
                try {
                    FlatFileSampleCCBDescriptionPanel.this.ff_info.setFileStructureName(fileName);
                }
                catch (FlatFileValidationException ex) {
                    FlatFileSampleCCBDescriptionPanel.this.showThisError(ex);
                }
                FlatFileSampleCCBDescriptionPanel.this.initializeFrom(FlatFileSampleCCBDescriptionPanel.this.ff_info);
            }
        });
        this._nameFileStructureNameLbl.setLabelFor(this._nameFileStructureName);
        JButton fileBrowseButton = new JButton(this.translate("GN_browseButton"));
        CommonUtils.setMnemonicAndAccelerator(fileBrowseButton, NLSUtils.getNLSString("GN_browseButton"));
        fileBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String prjDir = ((FlatFileSampleCCBDescriptionPanel)FlatFileSampleCCBDescriptionPanel.this).ff_info.getFlatFileWizard().getNxsdFileInfo()._directoryName;
                if (prjDir == null) {
                    prjDir = "";
                }
                JFileChooser chooser = new JFileChooser(prjDir);
                chooser.setDialogTitle(FlatFileSampleCCBDescriptionPanel.this.translate("CB_ccbDialog_title"));
                int returnVal = chooser.showOpenDialog(FlatFileSampleCCBDescriptionPanel.this.getParentFrame());
                String fileName = "";
                String directory = "";
                if (returnVal != 0) {
                    return;
                }
                fileName = chooser.getSelectedFile().getName();
                directory = chooser.getSelectedFile().getParent() + File.separator;
                if (directory != null && fileName != null) {
                    FlatFileSampleCCBDescriptionPanel.this._nameFileStructureName.setText(directory + fileName);
                    FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
                    try {
                        FlatFileSampleCCBDescriptionPanel.this.ff_info.setFileStructureName(directory + fileName);
                    }
                    catch (FlatFileValidationException ex) {
                        FlatFileSampleCCBDescriptionPanel.this.showThisError(ex);
                    }
                    FlatFileSampleCCBDescriptionPanel.this.initializeFrom(FlatFileSampleCCBDescriptionPanel.this.ff_info);
                }
            }
        });
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameFileStructureNameLbl, 0, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameFileStructureName, 1, 0, 1, 1, 1.0, 0.0, 17, 2, cmpInsets);
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, fileBrowseButton, 2, 0, 1, 1, 1.0, 0.0, 17, 0, cmpInsets);
        this._nameNamespaceLbl = new JLabel(this.translate("GN_namespace_label"));
        CommonUtils.setMnemonicAndAccelerator(this._nameNamespaceLbl, NLSUtils.getNLSString("GN_namespace_label"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameNamespaceLbl, 0, 1, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameNamespaceField = new JTextField(40);
        this._nameNamespaceField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }
        });
        this._nameNamespaceLbl.setLabelFor(this._nameNamespaceField);
        this._nameNamespaceLbl.setToolTipText(this.translate("CB_namespace_tooltip"));
        this._nameNamespaceField.setToolTipText(this.translate("CB_namespace_tooltip"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameNamespaceField, 1, 1, 2, 1, 1.0, 0.0, 17, 1, cmpInsets);
        this._nameRootElementLbl = new JLabel(this.translate("GN_rootElement_label"));
        CommonUtils.setMnemonicAndAccelerator(this._nameRootElementLbl, NLSUtils.getNLSString("GN_rootElement_label"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameRootElementLbl, 0, 2, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameRootElementField = new JTextField(40);
        this._nameRootElementField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlatFileSampleCCBDescriptionPanel.this.handlePageAdvance();
            }
        });
        this._nameRootElementLbl.setLabelFor(this._nameRootElementField);
        this._nameRootElementLbl.setToolTipText(this.translate("CB_rootElement_tooltip"));
        this._nameRootElementField.setToolTipText(this.translate("CB_rootElement_tooltip"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameRootElementField, 1, 2, 1, 1, 1.0, 0.0, 17, 1, cmpInsets);
        this._nameCharacterSetLbl = new JLabel(this.translate("GN_nameCharacterSet_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._nameCharacterSetLbl, NLSUtils.getNLSString("GN_nameCharacterSet_FlatFile"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameCharacterSetLbl, 0, 3, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._nameCharacterSetLw = new JComboBox();
        this._nameCharacterSetLw.setToolTipText(this.translate("CB_characterset_tooltip"));
        this._nameCharacterSetLbl.setToolTipText(this.translate("CB_characterset_tooltip"));
        this._nameCharacterSetLbl.setLabelFor(this._nameCharacterSetLw);
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._nameCharacterSetLw, 1, 3, 1, 1, 1.0, 0.0, 17, 2, cmpInsets);
        ItemListener _nameCharacterSetListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSampleCCBDescriptionPanel.this.nameCharacterSetStateChanged();
                }
            }
        };
        this._nameCharacterSetLw.addItemListener(_nameCharacterSetListener);
        JLabel byteOrderLabel = new JLabel(this.translate("CB_byteOrder_label"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, byteOrderLabel, 0, 4, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._byteOrderCbGroup = new ButtonGroup();
        this._byteOrderLittleEndCb = new JRadioButton(this.translate("CB_byteOrder_littleEndianLabel"), false);
        this._byteOrderCbGroup.add(this._byteOrderLittleEndCb);
        CommonUtils.setMnemonicAndAccelerator(this._byteOrderLittleEndCb, NLSUtils.getNLSString("CB_byteOrder_littleEndianLabel"));
        this._byteOrderLittleEndCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleCCBDescriptionPanel.this.ff_info.isLittleEndian(true);
                    FlatFileSampleCCBDescriptionPanel.this.ff_info.isBigEndian(false);
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        this._byteOrderLittleEndCb.setToolTipText(this.translate("CB_littleEnd_toolTip"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._byteOrderLittleEndCb, 1, 4, 1, 1, 1.0, 1.0, 17, 0, cmpInsets);
        this._byteOrderBigEndCb = new JRadioButton(this.translate("CB_byteOrder_bigEndianLabel"), true);
        this._byteOrderCbGroup.add(this._byteOrderBigEndCb);
        this._byteOrderBigEndCb.setToolTipText(this.translate("CB_bigEnd_toolTip"));
        CommonUtils.setMnemonicAndAccelerator(this._byteOrderBigEndCb, NLSUtils.getNLSString("CB_byteOrder_bigEndianLabel"));
        this._byteOrderBigEndCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (1 == e.getStateChange()) {
                    FlatFileSampleCCBDescriptionPanel.this.ff_info.isLittleEndian(false);
                    FlatFileSampleCCBDescriptionPanel.this.ff_info.isBigEndian(true);
                }
                if (2 == e.getStateChange()) {
                    // empty if block
                }
            }
        });
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._byteOrderBigEndCb, 2, 4, 1, 1, 1.0, 1.0, 17, 0, cmpInsets);
        this._recordEndAtLabel = new JLabel(this.translate("CB_recOrgRecordsEndAt_FlatFile"));
        CommonUtils.setMnemonicAndAccelerator(this._recordEndAtLabel, NLSUtils.getNLSString("CB_recOrgRecordsEndAt_FlatFile"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._recordEndAtLabel, 0, 7, 1, 1, 0.0, 0.0, 17, 0, cmpInsets);
        this._recordEndAt = new JComboBox();
        this._recordEndAt.setEditable(true);
        this._recordEndAtLabel.setLabelFor(this._recordEndAt);
        this._recordEndAt.addItem("none");
        this._recordEndAt.addItem(this.translate("FD_RecordTerminatorEOL_FlatFile"));
        FlatFileSampleCCBDescriptionPanel.addComponent(nameFileNamePanel, this._recordEndAt, 1, 7, 1, 1, 0.5, 0.0, 18, 2, cmpInsets);
        ItemListener recordEndAtChangedListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    FlatFileSampleCCBDescriptionPanel.this.recordEndAtChanged((String)FlatFileSampleCCBDescriptionPanel.this._recordEndAt.getSelectedItem());
                }
            }
        };
        this._recordEndAt.addItemListener(recordEndAtChangedListener);
        KeyAdapter recordEndAtListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                if ((code == 10 || code == 9) && code == 10) {
                    e.consume();
                }
            }
        };
        this._recordEndAt.addKeyListener(recordEndAtListener);
        JPanel gizmoPanel = new JPanel();
        gizmoPanel.setLayout(new GridBagLayout());
        FlatFileSampleCCBDescriptionPanel.addComponent(this, gizmoPanel, 0, 4, 0, 0, 1.0, 1.0, 17, 1, pnlInsets);
        this._dataGizmo = new FlatFileDisplayGizmo(3, this);
        FlatFileSampleCCBDescriptionPanel.addComponent(gizmoPanel, this._dataGizmo, 0, 0, 1, 1, 1.0, 1.0, 17, 1, cmpInsets);
    }

    private void recordEndAtChanged(String newTxt) {
        if (newTxt.equals(this.translate("FD_RecordTerminatorEOL_FlatFile"))) {
            newTxt = "\\n";
            this.ff_info.setRecordTerminatorEOL(true);
        } else if (newTxt.equals(this.translate("FD_RecordTerminatorEOF_FlatFile"))) {
            newTxt = "\\n";
            this.ff_info.setRecordTerminatorEOL(false);
        }
        if (this._recordEndAtSave != newTxt) {
            this._recordEndAtSave = newTxt;
            this.addValueToJComboBox(this._recordEndAt, this._recordEndAtSave);
            this.ff_info.isRecordSize(false);
            this.ff_info.setCcbRecordDelimiter(this._recordEndAtSave);
            this.ff_info.clearRecords();
        }
    }

    private void showThisError(WizardPanelValidationException e) {
        e.showError(this.getParentFrame(), this);
    }

    private void handlePageAdvance() {
        String rootElement;
        String sampleFileName = this._nameFileStructureName.getText() != null ? this._nameFileStructureName.getText().trim() : "";
        String namespace = this._nameNamespaceField.getText() != null ? this._nameNamespaceField.getText().trim() : "";
        String string = rootElement = this._nameRootElementField.getText() != null ? this._nameRootElementField.getText().trim() : "";
        if (sampleFileName.equals("") || namespace.equals("") || rootElement.equals("")) {
            this._wp.setCanAdvance(false);
        } else {
            this._wp.setCanAdvance(true);
        }
    }

    private void addValueToJComboBox(JComboBox comboBox, String newValue) {
        boolean found = false;
        for (int i = 0; i < comboBox.getItemCount(); ++i) {
            if (newValue.equals("\\n") || newValue.equals("\\r\\n") || newValue.equals("\\r")) {
                found = true;
                break;
            }
            if (newValue.compareTo((String)comboBox.getItemAt(i)) != 0) continue;
            found = true;
            break;
        }
        if (!found) {
            comboBox.addItem(newValue);
            ItemListener[] ils = CommonUtils.removeComboItemListener(comboBox);
            comboBox.setSelectedItem(newValue);
            CommonUtils.addComboItemListener(comboBox, ils);
        }
    }

    @Override
    public Component getFirstSelectableComponent() {
        return this._nameFileStructureName;
    }

    @Override
    public void validate(WizardInfo info, Frame f) throws WizardPanelValidationException {
        FlatFileInfo ff_info = (FlatFileInfo)info;
        String fileName = this._nameFileStructureName.getText();
        String rootElement = this._nameRootElementField.getText();
        String characterSet = (String)this._nameCharacterSetLw.getSelectedItem();
        boolean littleEndian = false;
        String namespace = this._nameNamespaceField.getText() != null ? this._nameNamespaceField.getText().trim() : "";
        littleEndian = this._byteOrderLittleEndCb.isSelected();
        try {
            if (namespace.lastIndexOf("/") == namespace.length() - 1) {
                namespace = namespace.substring(0, namespace.length() - 1);
            }
            if (namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd/extensions") || namespace.equals("http://xmlns.oracle.com/pcbpel/nxsd")) {
                throw new FlatFileValidationException(this.translate("EP_Invalid_namespace_API44", new String[]{namespace}));
            }
            ff_info.setFileStructureName(fileName);
            ff_info.setNamespace(namespace);
            if (rootElement == null || rootElement.trim().equals("")) {
                throw new FlatFileValidationException(this.translate("DT_rootElementMissing_API35"));
            }
            ff_info.setRootElement(rootElement);
            ff_info.setCcbEncoding(characterSet);
            ff_info.isLittleEndian(littleEndian);
            ff_info.setModifiedNXSD(ff_info.generateNXSD());
        }
        catch (FlatFileValidationException e) {
            String msg = e.getMessage();
            if (msg == null || msg.trim().equals("")) {
                e = new FlatFileValidationException(this.translate("CB_genericError_API36"));
            }
            e.showError(f, this);
            this._nameFileStructureName.requestFocus();
            throw e;
        }
    }

    @Override
    public String getHelpTopicName() {
        return "flatfile_name";
    }

    @Override
    public void initializeFrom(WizardInfo info) {
        String ccbDelimiter;
        String prevNS;
        this.ff_info = (FlatFileInfo)info;
        FlatFileWizard ffWizard = this.ff_info.getFlatFileWizard();
        int pageCount = ffWizard.getPageCount();
        int pageIndex = ffWizard.getCurrentPageIndex();
        WizardPage wp = ffWizard.getSelectedPage();
        wp.setPageTitle(this.translate("CB_namePageTitle_CCBFile"));
        wp.setLabel(this.translate("NX_pageTitle_FlatFile", new String[]{"" + pageIndex, "" + (pageCount -= 2)}));
        DebugUtility.debug(this.translate("CB_namePageTitle_CCBFile").toUpperCase());
        String string = prevNS = this.ff_info.getNamespace() != null ? this.ff_info.getNamespace().trim() : "";
        if (prevNS.equals("")) {
            NxsdFileInfo nxsdFileInfo = ffWizard.getNxsdFileInfo();
            String serviceName = nxsdFileInfo._serviceName;
            prevNS = "http://TargetNamespace.com/ServiceName";
            if (serviceName != null && !serviceName.equals("")) {
                prevNS = prevNS.replaceAll("ServiceName", serviceName);
            }
            this._nameNamespaceField.setText(prevNS);
        } else {
            this._nameNamespaceField.setText(prevNS);
        }
        this._nameFileStructureName.setText(this.ff_info.getFileStructureName());
        String rootElement = this.ff_info.getRootElement();
        if (rootElement == null || rootElement.equals("")) {
            this._nameRootElementField.setText(this.translate("GN_containerNameDefault"));
        } else {
            this._nameRootElementField.setText(rootElement);
        }
        if (this.ff_info.isLittleEndian()) {
            this._byteOrderBigEndCb.setSelected(false);
            this._byteOrderLittleEndCb.setSelected(true);
        } else {
            this._byteOrderBigEndCb.setSelected(true);
            this._byteOrderLittleEndCb.setSelected(false);
        }
        ItemListener[] ils = CommonUtils.removeComboItemListener(this._nameCharacterSetLw);
        if (this._nameCharacterSetLw.getItemCount() == 0) {
            for (int i = 0; i < this.ff_info.getCharacterSetList().length; ++i) {
                String item = this.ff_info.getCharacterSetList()[i];
                this._nameCharacterSetLw.addItem(item);
            }
        }
        String defaultCoding = this.ff_info.getCcbEncoding();
        this._nameCharacterSetLw.setSelectedItem(defaultCoding);
        this._nameCharacterSetLw.invalidate();
        CommonUtils.addComboItemListener(this._nameCharacterSetLw, ils);
        String string2 = ccbDelimiter = this.ff_info.getCcbRecordDelimiter() != null ? this.ff_info.getCcbRecordDelimiter() : "";
        if (!ccbDelimiter.equals("")) {
            if (this.ff_info.isEditingNXSD() && !ccbDelimiter.equals("\\n") && !ccbDelimiter.equals("\\r\\n")) {
                this._recordEndAt.addItem(ccbDelimiter);
            }
            if (ccbDelimiter.equals("\\n") || ccbDelimiter.equals("\\r\\n")) {
                if (this.ff_info.isRecordTerminatorEOL()) {
                    this._recordEndAt.setSelectedItem(this.translate("FD_RecordTerminatorEOL_FlatFile"));
                } else {
                    this._recordEndAt.setSelectedItem(this.translate("FD_RecordTerminatorEOF_FlatFile"));
                }
            } else {
                this._recordEndAt.setSelectedItem(ccbDelimiter);
            }
        }
        String fileName = this.ff_info.getFileStructureName();
        this.handlePageAdvance();
        try {
            this._dataGizmo.refreshContents(this.ff_info);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void nameCharacterSetStateChanged() {
        this.ff_info.setCcbEncoding((String)this._nameCharacterSetLw.getSelectedItem());
        this._dataGizmo.refreshContents(this.ff_info);
    }
}

